/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.plugin.blackhole.BlackHolePlugin;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.spi.Plugin;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.sql.TestTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
final class TestIcebergLocalConcurrentWrites
extends AbstractTestQueryFramework {
    TestIcebergLocalConcurrentWrites() {
    }

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = IcebergQueryRunner.builder().build();
        queryRunner.installPlugin((Plugin)new BlackHolePlugin());
        queryRunner.createCatalog("blackhole", "blackhole");
        return queryRunner;
    }

    @RepeatedTest(value=3)
    void testConcurrentInserts() throws Exception {
        this.testConcurrentInserts(false);
        this.testConcurrentInserts(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentInserts(boolean partitioned) throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_inserts_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a INT, part INT) " + (partitioned ? " WITH (partitioning = ARRAY['part'])" : ""));
        try {
            executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (1, 10)");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (11, 20)");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (21, 30)");
                return null;
            }).build()).forEach(MoreFutures::getDone);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (1, 10), (11, 20), (21, 30)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    @RepeatedTest(value=3)
    void testConcurrentInsertsSelectingFromTheSameTable() throws Exception {
        this.testConcurrentInsertsSelectingFromTheSameTable(true);
        this.testConcurrentInsertsSelectingFromTheSameTable(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentInsertsSelectingFromTheSameTable(boolean partitioned) throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_inserts_select_from_same_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part) " + (partitioned ? " WITH (partitioning = ARRAY['part'])" : "") + "  AS VALUES (0, 10)", 1L);
        try {
            List futures = (List)IntStream.range(0, threads).mapToObj(n -> executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " SELECT COUNT(*), 10 AS part FROM " + tableName);
                return true;
            })).collect(ImmutableList.toImmutableList());
            long successfulInsertsCount = futures.stream().map(MoreFutures::getFutureValue).filter(success -> success).count();
            Assertions.assertThat((long)successfulInsertsCount).isEqualTo(3L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (0, 10), (1, 10), (1, 10), (1, 10)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    @RepeatedTest(value=3)
    void testConcurrentInsertsSelectingFromTheSameVersionedTable() throws Exception {
        this.testConcurrentInsertsSelectingFromTheSameVersionedTable(true);
        this.testConcurrentInsertsSelectingFromTheSameVersionedTable(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentInsertsSelectingFromTheSameVersionedTable(boolean partitioned) throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_inserts_select_from_same_versioned_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part) " + (partitioned ? " WITH (partitioning = ARRAY['part'])" : "") + "  AS VALUES (0, 'a')", 1L);
        long currentSnapshotId = this.getCurrentSnapshotId(tableName);
        try {
            executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " SELECT 1, 'b' AS part FROM " + tableName + " FOR VERSION AS OF " + currentSnapshotId);
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " SELECT 2, 'c' AS part FROM " + tableName + " FOR VERSION AS OF " + currentSnapshotId);
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " SELECT 3, 'd' AS part FROM " + tableName + " FOR VERSION AS OF " + currentSnapshotId);
                return null;
            }).build()).forEach(MoreFutures::getDone);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (0, 'a'), (1, 'b'), (2, 'c'), (3, 'd')");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    void testConcurrentDelete() throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_deletes_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part)  WITH (partitioning = ARRAY['part']) AS VALUES (1, 10), (11, 20), (21, 30), (31, 40)", 4L);
        try {
            executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("DELETE FROM " + tableName + " WHERE part = 10");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("DELETE FROM " + tableName + " WHERE part = 20");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("DELETE FROM " + tableName + " WHERE part = 30");
                return null;
            }).build()).forEach(MoreFutures::getDone);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (31, 40)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    void testConcurrentDeleteFromTheSamePartition() throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_delete_from_same_partition_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part) WITH (partitioning = ARRAY['part']) AS VALUES (0, 10), (11, 20), (22, 30)", 3L);
        try {
            List futures = (List)IntStream.range(0, threads).mapToObj(threadNumber -> executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("DELETE FROM " + tableName + "  WHERE part = 10");
                return true;
            })).collect(ImmutableList.toImmutableList());
            long successfulDeletesCount = futures.stream().map(MoreFutures::getFutureValue).filter(success -> success).count();
            Assertions.assertThat((long)successfulDeletesCount).isEqualTo(3L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (11, 20), (22, 30)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    void testConcurrentTruncate() throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_truncate_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part) WITH (partitioning = ARRAY['part']) AS VALUES (0, 10), (11, 20), (22, 30)", 3L);
        try {
            List futures = (List)IntStream.range(0, threads).mapToObj(n -> executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("TRUNCATE TABLE " + tableName);
                return true;
            })).collect(ImmutableList.toImmutableList());
            long successfulTruncatesCount = futures.stream().map(MoreFutures::getFutureValue).filter(success -> success).count();
            Assertions.assertThat((long)successfulTruncatesCount).isEqualTo(3L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).returnsEmptyResult();
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    void testConcurrentTruncateAndInserts() throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_truncate_and_inserts_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part)  WITH (partitioning = ARRAY['part']) AS VALUES (1, 10), (11, 20)", 2L);
        try {
            executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("TRUNCATE TABLE " + tableName);
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (21, 30)");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (31, 40)");
                return null;
            }).build()).forEach(MoreFutures::getDone);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (21, 30), (31, 40)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    @RepeatedTest(value=3)
    void testConcurrentNonOverlappingUpdate() throws Exception {
        this.testConcurrentNonOverlappingUpdate(this.getSession());
        this.testConcurrentNonOverlappingUpdate(this.withFileBasedConflictDetectionDisabledSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentNonOverlappingUpdate(Session session) throws InterruptedException {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_non_overlapping_updates_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part)  WITH (partitioning = ARRAY['part']) AS VALUES (1, 10), (11, 20), (21, NULL), (31, 40)", 4L);
        try {
            executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute(session, "UPDATE " + tableName + " SET a = a + 1 WHERE part = 10");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute(session, "UPDATE " + tableName + " SET a = a + 1  WHERE part = 20");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute(session, "UPDATE " + tableName + " SET a = a + 1  WHERE part IS NULL");
                return null;
            }).build()).forEach(MoreFutures::getDone);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (2, 10), (12, 20), (22, NULL), (31, 40)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    void testConcurrentNonOverlappingUpdateMultipleDataFiles() throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_non_overlapping_updates_table_" + TestingNames.randomNameSuffix();
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty("iceberg", "target_max_file_size", "1kB").build();
        this.assertUpdate("CREATE TABLE " + tableName + " (a BIGINT, part BIGINT) WITH (partitioning = ARRAY['part'])");
        this.assertUpdate(session, " INSERT INTO " + tableName + " SELECT * FROM (select * from UNNEST(SEQUENCE(1, 10000)) AS t(a)) CROSS JOIN (select * from UNNEST(SEQUENCE(1, 3)) AS t(part))", 30000L);
        long expectedDataSum = (Long)this.computeScalar("SELECT sum(a + 1) FROM " + tableName);
        try {
            executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute(session, "UPDATE " + tableName + " SET a = a + 1 WHERE part = 1");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute(session, "UPDATE " + tableName + " SET a = a + 1  WHERE part = 2");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute(session, "UPDATE " + tableName + " SET a = a + 1  WHERE part = 3");
                return null;
            }).build()).forEach(MoreFutures::getDone);
            Assertions.assertThat((long)((Long)this.computeScalar("SELECT SUM(a) FROM " + tableName))).isEqualTo(expectedDataSum);
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    @RepeatedTest(value=3)
    void testConcurrentOverlappingUpdate() throws Exception {
        this.testConcurrentOverlappingUpdate(false);
        this.testConcurrentOverlappingUpdate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testConcurrentOverlappingUpdate(boolean partitioned) throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_overlapping_updates_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part) " + (partitioned ? " WITH (partitioning = ARRAY['part'])" : "") + " AS VALUES (1, 10), (11, 20), (21, NULL), (31, 40)", 4L);
        try {
            List futures = (List)IntStream.range(0, threads).mapToObj(n -> executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                try {
                    this.getQueryRunner().execute("UPDATE " + tableName + " SET a = a + 1 WHERE a > 11");
                    return true;
                }
                catch (Exception e) {
                    RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause((Throwable)e);
                    try {
                        Assertions.assertThat((Throwable)trinoException).hasMessageMatching("Failed to commit the transaction during write.*|Failed to commit during write.*");
                    }
                    catch (Throwable verifyFailure) {
                        if (verifyFailure != e) {
                            verifyFailure.addSuppressed(e);
                        }
                        throw verifyFailure;
                    }
                    return false;
                }
            })).collect(ImmutableList.toImmutableList());
            long successes = futures.stream().map(future -> (Boolean)MoreFutures.tryGetFutureValue((Future)future, (int)10, (TimeUnit)TimeUnit.SECONDS).orElseThrow(() -> new RuntimeException("Wait timed out"))).filter(success -> success).count();
            Assertions.assertThat((long)successes).isGreaterThanOrEqualTo(1L);
            switch ((int)successes) {
                case 1: {
                    ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (1, 10), (11, 20), (22, NULL), (32, 40)");
                    return;
                }
                case 2: {
                    ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (1, 10), (11, 20), (23, NULL), (33, 40)");
                    return;
                }
                case 3: {
                    ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (1, 10), (11, 20), (24, NULL), (34, 40)");
                    return;
                }
            }
            return;
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    @RepeatedTest(value=3)
    void testConcurrentNonOverlappingUpdateOnNestedPartition() throws Exception {
        this.testConcurrentNonOverlappingUpdateOnNestedPartition(this.getSession());
        this.testConcurrentNonOverlappingUpdateOnNestedPartition(this.withFileBasedConflictDetectionDisabledSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentNonOverlappingUpdateOnNestedPartition(Session session) throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_non_overlapping_updates_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a int, parent ROW(child int))  WITH (partitioning = ARRAY['\"parent.child\"'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW(10)), (11, ROW(20)), (21, ROW(NULL)), (31, ROW(40))", 4L);
        try {
            executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute(session, "UPDATE " + tableName + " SET a = a + 1 WHERE parent.child = 10");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute(session, "UPDATE " + tableName + " SET a = a + 1  WHERE parent.child = 20");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute(session, "UPDATE " + tableName + " SET a = a + 1  WHERE parent.child IS NULL");
                return null;
            }).build()).forEach(MoreFutures::getDone);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a, parent.child FROM " + tableName))).matches("VALUES (2, 10), (12, 20), (22, NULL), (31, 40)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    void testConcurrentDeleteAndInserts() throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_delete_and_inserts_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part)  WITH (partitioning = ARRAY['part']) AS VALUES (1, 10), (11, 20)", 2L);
        try {
            List futures = (List)executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                try {
                    this.getQueryRunner().execute("DELETE FROM " + tableName + " WHERE a > 10");
                    return true;
                }
                catch (Exception e) {
                    RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause((Throwable)e);
                    try {
                        Assertions.assertThat((Throwable)trinoException).hasMessageMatching("Failed to commit the transaction during write.*|Failed to commit during write.*");
                    }
                    catch (Throwable verifyFailure) {
                        if (verifyFailure != e) {
                            verifyFailure.addSuppressed(e);
                        }
                        throw verifyFailure;
                    }
                    return false;
                }
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (8, 10)");
                return true;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (21, 30)");
                return true;
            }).build()).stream().collect(ImmutableList.toImmutableList());
            long successfulWrites = futures.stream().map(future -> (Boolean)MoreFutures.tryGetFutureValue((Future)future, (int)10, (TimeUnit)TimeUnit.SECONDS).orElseThrow(() -> new RuntimeException("Wait timed out"))).filter(success -> success).count();
            Assertions.assertThat((long)successfulWrites).isGreaterThanOrEqualTo(2L);
            if (successfulWrites == 2L) {
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (1, 10), (8, 10), (11, 20), (21, 30)");
            } else {
                MaterializedResult expected1 = this.computeActual("VALUES (1, 10), (8, 10)");
                MaterializedResult expected2 = this.computeActual("VALUES (1, 10), (8, 10), (21, 30)");
                Assertions.assertThat((Iterable)this.computeActual("SELECT * FROM " + tableName + " ORDER BY a")).isIn(new Object[]{expected1, expected2});
            }
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    void testConcurrentUpdateAndInserts() throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_update_and_inserts_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part)  WITH (partitioning = ARRAY['part']) AS VALUES (1, 10), (11, 20)", 2L);
        try {
            List futures = (List)executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                try {
                    this.getQueryRunner().execute("UPDATE " + tableName + " SET a = a + 1");
                    return true;
                }
                catch (Exception e) {
                    RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause((Throwable)e);
                    try {
                        Assertions.assertThat((Throwable)trinoException).hasMessageMatching("Failed to commit the transaction during write.*|Failed to commit during write.*");
                    }
                    catch (Throwable verifyFailure) {
                        if (verifyFailure != e) {
                            verifyFailure.addSuppressed(e);
                        }
                        throw verifyFailure;
                    }
                    return false;
                }
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                Thread.sleep(1000L);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (13, 20)");
                return true;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                Thread.sleep(1000L);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (21, 30)");
                return true;
            }).build()).stream().collect(ImmutableList.toImmutableList());
            long successfulWrites = futures.stream().map(future -> (Boolean)MoreFutures.tryGetFutureValue((Future)future, (int)10, (TimeUnit)TimeUnit.SECONDS).orElseThrow(() -> new RuntimeException("Wait timed out"))).filter(success -> success).count();
            Assertions.assertThat((long)successfulWrites).isGreaterThanOrEqualTo(2L);
            if (successfulWrites == 2L) {
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (1, 10), (11, 20), (13, 20), (21, 30)");
            } else {
                MaterializedResult expected1 = this.computeActual("VALUES (2, 10), (12, 20), (13, 20), (21, 30)");
                MaterializedResult expected2 = this.computeActual("VALUES (2, 10), (12, 20), (14, 20), (22, 30)");
                Assertions.assertThat((Iterable)this.computeActual("SELECT * FROM " + tableName + " ORDER BY a")).isIn(new Object[]{expected1, expected2});
            }
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    public void testConcurrentMerge() throws Exception {
        int threads = 4;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_merges_table_" + TestingNames.randomNameSuffix();
        String sourceTableName = "test_concurrent_merges_source_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + sourceTableName + "  (a, part, string_rep)  AS SELECT *, format('a%spart%s', a, part) FROM (select * from UNNEST(SEQUENCE(1, 2000)) AS t(a)) CROSS JOIN (select * from UNNEST(SEQUENCE(1, 2000)) AS t(part))", 4000000L);
        this.assertUpdate("INSERT INTO " + sourceTableName + " VALUES (42, NULL, 'a42partNULL')", 1L);
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part)  WITH (partitioning = ARRAY['part']) AS VALUES (1, 10), (11, 20), (21, 30), (31, 40), (41, NULL)", 5L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (22, 30)", 1L);
        try {
            executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("MERGE INTO %s t USING (select a, part from %s where string_rep LIKE '%%a12part20') AS s\nON (FALSE)\nWHEN NOT MATCHED THEN INSERT (a, part) VALUES(s.a, s.part)\n".formatted(tableName, sourceTableName));
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("MERGE INTO %s t USING (select a, part from %s where string_rep LIKE '%%a42partNULL') AS s\nON (FALSE)\nWHEN NOT MATCHED THEN INSERT (a, part) VALUES(s.a, s.part)\n".formatted(tableName, sourceTableName));
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("MERGE INTO %s t USING (VALUES (21, 30)) AS s(a, part)\nON (t.part = s.part)\nWHEN MATCHED THEN DELETE\n".formatted(tableName));
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("MERGE INTO %s t USING (VALUES (32, 40)) AS s(a, part)\nON (t.part = s.part)\nWHEN MATCHED THEN UPDATE SET a = s.a\n".formatted(tableName));
                return null;
            }).build()).forEach(MoreFutures::getDone);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (1, 10), (11, 20), (12, 20), (32, 40), (41, NULL), (42, NULL)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    void testConcurrentMergeAndInserts() throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_merge_and_inserts_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part)  WITH (partitioning = ARRAY['part']) AS VALUES (1, 10), (11, 20)", 2L);
        try {
            List futures = (List)executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                try {
                    this.getQueryRunner().execute("MERGE INTO %s t USING (VALUES (11, 20), (8, 10), (21, 30)) AS s(a, part)\n  ON (t.a = s.a AND t.part = s.part)\n    WHEN MATCHED THEN DELETE\n".formatted(tableName));
                    return true;
                }
                catch (Exception e) {
                    RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause((Throwable)e);
                    try {
                        Assertions.assertThat((Throwable)trinoException).hasMessageMatching("Failed to commit the transaction during write.*|Failed to commit during write.*");
                    }
                    catch (Throwable verifyFailure) {
                        if (verifyFailure != e) {
                            verifyFailure.addSuppressed(e);
                        }
                        throw verifyFailure;
                    }
                    return false;
                }
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (8, 10)");
                return true;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (21, 30)");
                return true;
            }).build()).stream().collect(ImmutableList.toImmutableList());
            long successfulWrites = futures.stream().map(future -> (Boolean)MoreFutures.tryGetFutureValue((Future)future, (int)10, (TimeUnit)TimeUnit.SECONDS).orElseThrow(() -> new RuntimeException("Wait timed out"))).filter(success -> success).count();
            Assertions.assertThat((long)successfulWrites).isGreaterThanOrEqualTo(2L);
            if (successfulWrites == 2L) {
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (1, 10), (11, 20), (8, 10), (21, 30)");
            } else {
                MaterializedResult expected1 = this.computeActual("VALUES (1, 10)");
                MaterializedResult expected2 = this.computeActual("VALUES (1, 10), (8, 10), (21, 30)");
                Assertions.assertThat((Iterable)this.computeActual("SELECT * FROM " + tableName + " ORDER BY a")).isIn(new Object[]{expected1, expected2});
            }
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    void testConcurrentDeleteAndDeletePushdownAndInsert() throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String tableName = "test_concurrent_delete_and_inserts_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, part)  WITH (partitioning = ARRAY['part']) AS VALUES (1, 10), (11, 20), (21, 30)", 3L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, 10)", 1L);
        try {
            executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("DELETE FROM " + tableName + " WHERE part = 10 AND a IN (1, 2)");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("INSERT INTO " + tableName + " SELECT a + 1, part FROM " + tableName + " WHERE part = 20");
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.getQueryRunner().execute("DELETE FROM " + tableName + " WHERE part = 30");
                return null;
            }).build()).forEach(MoreFutures::getDone);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (11, 20), (12, 20)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    void testConcurrentUpdateWithPartitionTransformation() throws Exception {
        int threads = 4;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        ImmutableList rows = ImmutableList.of((Object)"('A', DATE '2024-01-01')", (Object)"('B', DATE '2024-02-02')", (Object)"('C', DATE '2024-03-03')", (Object)"('D', DATE '2024-04-04')");
        ImmutableList partitions = ImmutableList.of((Object)"DATE '2024-01-01'", (Object)"DATE '2024-02-02'", (Object)"DATE '2024-03-03'", (Object)"DATE '2024-04-04'");
        try (TestTable table = this.newTrinoTable("test_concurrent_update_partition_transform_table_", "(data varchar, part date) with (partitioning = array['month(part)'])");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)rows), 4L);
            List futures = (List)IntStream.range(0, threads).mapToObj(arg_0 -> this.lambda$testConcurrentUpdateWithPartitionTransformation$0(executor, barrier, tableName, (List)partitions, arg_0)).collect(ImmutableList.toImmutableList());
            futures.forEach(future -> {
                Optional value = MoreFutures.tryGetFutureValue((Future)future, (int)20, (TimeUnit)TimeUnit.SECONDS);
                Preconditions.checkState((boolean)value.isPresent(), (Object)"Task did not complete in time");
                boolean updateSuccessful = (Boolean)value.get();
                Preconditions.checkState((boolean)updateSuccessful, (Object)"Task did not complete successfully");
            });
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT data, part FROM " + tableName))).skippingTypesCheck().matches("VALUES ('AA', DATE '2024-01-01'), ('BB', DATE '2024-02-02'), ('CC', DATE '2024-03-03'), ('DD', DATE '2024-04-04')");
        }
        finally {
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    void testConcurrentUpdateWithNestedPartitionTransformation() throws Exception {
        int threads = 4;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        ImmutableList rows = ImmutableList.of((Object)"('A', ROW(DATE '2024-01-01'))", (Object)"('B', ROW(DATE '2024-02-02'))", (Object)"('C', ROW(DATE '2024-03-03'))", (Object)"('D', ROW(DATE '2024-04-04'))");
        ImmutableList partitions = ImmutableList.of((Object)"DATE '2024-01-01'", (Object)"DATE '2024-02-02'", (Object)"DATE '2024-03-03'", (Object)"DATE '2024-04-04'");
        try (TestTable table = this.newTrinoTable("test_concurrent_update_partition_transform_table_", "(data varchar, parent ROW (part date)) with (partitioning = array['month(\"parent.part\")'])");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)rows), 4L);
            List futures = (List)IntStream.range(0, threads).mapToObj(arg_0 -> this.lambda$testConcurrentUpdateWithNestedPartitionTransformation$0(executor, barrier, tableName, (List)partitions, arg_0)).collect(ImmutableList.toImmutableList());
            futures.forEach(future -> {
                Optional value = MoreFutures.tryGetFutureValue((Future)future, (int)20, (TimeUnit)TimeUnit.SECONDS);
                Preconditions.checkState((boolean)value.isPresent(), (Object)"Task did not complete in time");
                boolean updateSuccessful = (Boolean)value.get();
                Preconditions.checkState((boolean)updateSuccessful, (Object)"Task did not complete successfully");
            });
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT data, parent.part FROM " + tableName))).skippingTypesCheck().matches("VALUES ('AA', DATE '2024-01-01'), ('BB', DATE '2024-02-02'), ('CC', DATE '2024-03-03'), ('DD', DATE '2024-04-04')");
        }
        finally {
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    void testConcurrentUpdateWithMultiplePartitionTransformation() throws Exception {
        int threads = 4;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        ImmutableList rows = ImmutableList.of((Object)"('A', TIMESTAMP '2024-01-01 01:01', 1, 'aaa')", (Object)"('B', TIMESTAMP '2024-01-01 02:02', 1, 'aab')", (Object)"('C', TIMESTAMP '2024-01-01 03:03', 1, 'aac')", (Object)"('D', TIMESTAMP '2024-01-01 04:04', 1, 'aad')");
        ImmutableList partitions1 = ImmutableList.of((Object)"TIMESTAMP '2024-01-01 01:01'", (Object)"TIMESTAMP '2024-01-01 02:02'", (Object)"TIMESTAMP '2024-01-01 03:03'", (Object)"TIMESTAMP '2024-01-01 04:04'");
        ImmutableList partitions2 = ImmutableList.of((Object)"1", (Object)"1", (Object)"1", (Object)"1");
        ImmutableList partitions3 = ImmutableList.of((Object)"'aaa'", (Object)"'aab'", (Object)"'aac'", (Object)"'aad'");
        try (TestTable table = this.newTrinoTable("test_concurrent_update_multiple_partition_transform_table_", "(data varchar, part1 timestamp, part2 int, part3 varchar) with (partitioning = array['hour(part1)', 'bucket(part2, 10)', 'truncate(part3, 2)'])");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)rows), 4L);
            List futures = (List)IntStream.range(0, threads).mapToObj(arg_0 -> this.lambda$testConcurrentUpdateWithMultiplePartitionTransformation$0(executor, barrier, tableName, (List)partitions1, (List)partitions2, (List)partitions3, arg_0)).collect(ImmutableList.toImmutableList());
            futures.forEach(future -> {
                Optional value = MoreFutures.tryGetFutureValue((Future)future, (int)20, (TimeUnit)TimeUnit.SECONDS);
                Preconditions.checkState((boolean)value.isPresent(), (Object)"Task did not complete in time");
                boolean updateSuccessful = (Boolean)value.get();
                Preconditions.checkState((boolean)updateSuccessful, (Object)"Task did not complete successfully");
            });
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT data, part1, part2, part3 FROM " + tableName))).skippingTypesCheck().matches("VALUES ('AA', TIMESTAMP '2024-01-01 01:01', 1, 'aaa'), ('BB', TIMESTAMP '2024-01-01 02:02', 1, 'aab'), ('CC', TIMESTAMP '2024-01-01 03:03', 1, 'aac'), ('DD', TIMESTAMP '2024-01-01 04:04', 1, 'aad')");
        }
        finally {
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    void testConcurrentUpdateWithOverlappingPartitionTransformation() throws Exception {
        int threads = 4;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        ImmutableList rows = ImmutableList.of((Object)"('A', DATE '2024-01-01')", (Object)"('B', DATE '2024-01-02')", (Object)"('C', DATE '2024-03-03')", (Object)"('D', DATE '2024-04-04')");
        ImmutableList partitions = ImmutableList.of((Object)"DATE '2024-01-01'", (Object)"DATE '2024-01-02'", (Object)"DATE '2024-03-03'", (Object)"DATE '2024-04-04'");
        try (TestTable table = this.newTrinoTable("test_concurrent_update_overlapping_partition_transform_table_", "(data varchar, part date) with (partitioning = array['month(part)'])");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)rows), 4L);
            List futures = (List)IntStream.range(0, threads).mapToObj(arg_0 -> this.lambda$testConcurrentUpdateWithOverlappingPartitionTransformation$0(executor, barrier, tableName, (List)partitions, arg_0)).collect(ImmutableList.toImmutableList());
            long successfulWrites = futures.stream().map(future -> (Boolean)MoreFutures.tryGetFutureValue((Future)future, (int)10, (TimeUnit)TimeUnit.SECONDS).orElseThrow(() -> new RuntimeException("Wait timed out"))).filter(success -> success).count();
            Assertions.assertThat((long)successfulWrites).isEqualTo(3L);
            MaterializedResult expected1 = this.computeActual("VALUES (VARCHAR 'AA', DATE '2024-01-01'), ('B', DATE '2024-01-02'), ('CC', DATE '2024-03-03'), ('DD', DATE '2024-04-04')");
            MaterializedResult expected2 = this.computeActual("VALUES (VARCHAR 'A', DATE '2024-01-01'), ('BB', DATE '2024-01-02'), ('CC', DATE '2024-03-03'), ('DD', DATE '2024-04-04')");
            Assertions.assertThat((Iterable)this.computeActual("SELECT data, part FROM " + tableName + " ORDER BY data")).isIn(new Object[]{expected1, expected2});
        }
        finally {
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    void testConcurrentUpdateWithEnforcedAndUnenforcedPartitions() throws Exception {
        int threads = 4;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        ImmutableList rows = ImmutableList.of((Object)"('A', 'a', DATE '2024-01-01')", (Object)"('B', 'b', DATE '2024-02-02')", (Object)"('C', 'c',  DATE '2024-03-03')", (Object)"('D', 'd', DATE '2024-04-04')");
        ImmutableList partitions1 = ImmutableList.of((Object)"'a'", (Object)"'b'", (Object)"'c'", (Object)"'d'");
        ImmutableList partitions2 = ImmutableList.of((Object)"DATE '2024-01-01'", (Object)"DATE '2024-02-02'", (Object)"DATE '2024-03-03'", (Object)"DATE '2024-04-04'");
        try (TestTable table = this.newTrinoTable("test_concurrent_update_enforced_unenforced_partition_transform_table_", "(data varchar, part1 varchar, part2 date) with (partitioning = array['part1', 'month(part2)'])");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)rows), 4L);
            List futures = (List)IntStream.range(0, threads).mapToObj(arg_0 -> this.lambda$testConcurrentUpdateWithEnforcedAndUnenforcedPartitions$0(executor, barrier, tableName, (List)partitions1, (List)partitions2, arg_0)).collect(ImmutableList.toImmutableList());
            futures.forEach(future -> {
                Optional value = MoreFutures.tryGetFutureValue((Future)future, (int)20, (TimeUnit)TimeUnit.SECONDS);
                Preconditions.checkState((boolean)value.isPresent(), (Object)"Task did not complete in time");
                boolean updateSuccessful = (Boolean)value.get();
                Preconditions.checkState((boolean)updateSuccessful, (Object)"Task did not complete successfully");
            });
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT data, part1, part2 FROM " + tableName))).skippingTypesCheck().matches("VALUES ('AA', 'a', DATE '2024-01-01'), ('BB', 'b', DATE '2024-02-02'), ('CC', 'c', DATE '2024-03-03'), ('DD', 'd', DATE '2024-04-04')");
        }
        finally {
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    @Test
    public void testOptimizeDuringWriteOperations() throws Exception {
        this.runOptimizeDuringWriteOperations(true);
        this.runOptimizeDuringWriteOperations(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOptimizeDuringWriteOperations(boolean useSmallFiles) throws Exception {
        int threads = 5;
        int deletionThreads = threads - 1;
        int rows = 12;
        int rowsPerThread = rows / deletionThreads;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        String blackholeTable = "blackhole_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE blackhole.default.%s (a INT, b INT) WITH (split_count = 1, pages_per_split = 1, rows_per_page = 1, page_processing_delay = '3s')".formatted(blackholeTable));
        try (TestTable table = this.newTrinoTable("test_optimize_during_write_operations", "(int_col INT)");){
            String tableName = table.getName();
            if (useSmallFiles) {
                for (int i = 0; i < rows; ++i) {
                    this.assertUpdate(String.format("INSERT INTO %s VALUES %s", tableName, i), 1L);
                }
            } else {
                String values = IntStream.range(0, rows).mapToObj(String::valueOf).collect(Collectors.joining(", "));
                this.assertUpdate(String.format("INSERT INTO %s VALUES %s", tableName, values), rows);
            }
            List deletionFutures = (List)IntStream.range(0, deletionThreads).mapToObj(threadNumber -> executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                ArrayList<Boolean> successfulDeletes = new ArrayList<Boolean>();
                for (int i = 0; i < rowsPerThread; ++i) {
                    try {
                        int rowNumber = threadNumber * rowsPerThread + i;
                        this.getQueryRunner().execute(String.format("DELETE FROM %s WHERE int_col = %s OR ((SELECT count(*) FROM blackhole.default.%s) > 42)", tableName, rowNumber, blackholeTable));
                        successfulDeletes.add(true);
                        continue;
                    }
                    catch (RuntimeException e) {
                        successfulDeletes.add(false);
                    }
                }
                return successfulDeletes;
            })).collect(ImmutableList.toImmutableList());
            Future<?> optimizeFuture = executor.submit(() -> {
                try {
                    barrier.await(10L, TimeUnit.SECONDS);
                    Thread.sleep(50L);
                    this.assertUpdate("ALTER TABLE %s EXECUTE optimize".formatted(tableName));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            ArrayList<String> expectedValues = new ArrayList<String>();
            for (int threadNumber2 = 0; threadNumber2 < deletionThreads; ++threadNumber2) {
                List deleteOutcomes = (List)((Future)deletionFutures.get(threadNumber2)).get();
                Verify.verify((deleteOutcomes.size() == rowsPerThread ? 1 : 0) != 0);
                for (int rowNumber = 0; rowNumber < rowsPerThread; ++rowNumber) {
                    boolean successfulDelete = (Boolean)deleteOutcomes.get(rowNumber);
                    if (successfulDelete) continue;
                    expectedValues.add(String.valueOf(threadNumber2 * rowsPerThread + rowNumber));
                }
            }
            optimizeFuture.get();
            Assertions.assertThat((int)expectedValues.size()).isGreaterThan(0).isLessThan(rows);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES " + String.join((CharSequence)", ", expectedValues));
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    @RepeatedTest(value=3)
    void testConcurrentOverlappingOptimize() throws Exception {
        this.testConcurrentOverlappingOptimize(true);
        this.testConcurrentOverlappingOptimize(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentOverlappingOptimize(boolean partitioned) throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try (TestTable table = this.newTrinoTable("test_concurrent_non_overlapping_optimize_table_", "(a INT, part INT) " + (partitioned ? " WITH (partitioning = ARRAY['part'])" : ""));){
            ImmutableList.Builder expectedValues = ImmutableList.builder();
            for (int i = 0; i < 10; ++i) {
                String values = String.format("(%1$d, 10), (%1$d, 20), (%1$d, NULL), (%1$d, 40)", i);
                expectedValues.add((Object)values);
                this.assertUpdate(String.format("INSERT INTO %s VALUES %s", table.getName(), values), 4L);
            }
            List futures = (List)IntStream.range(0, threads).mapToObj(n -> executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                try {
                    this.getQueryRunner().execute("ALTER TABLE %s EXECUTE optimize".formatted(table.getName()));
                    return true;
                }
                catch (Exception e) {
                    RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause((Throwable)e);
                    try {
                        Assertions.assertThat((Throwable)trinoException).hasMessageMatching("Failed to commit the transaction during optimize.*|Failed to commit during optimize.*");
                    }
                    catch (Throwable verifyFailure) {
                        if (verifyFailure != e) {
                            verifyFailure.addSuppressed(e);
                        }
                        throw verifyFailure;
                    }
                    return false;
                }
            })).collect(ImmutableList.toImmutableList());
            long successes = futures.stream().map(future -> (Boolean)MoreFutures.tryGetFutureValue((Future)future, (int)10, (TimeUnit)TimeUnit.SECONDS).orElseThrow(() -> new RuntimeException("Wait timed out"))).filter(success -> success).count();
            Assertions.assertThat((long)successes).isGreaterThanOrEqualTo(1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)expectedValues.build()));
        }
        finally {
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=3)
    void testConcurrentNonOverlappingOptimize() throws Exception {
        int threads = 3;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try (TestTable table = this.newTrinoTable("test_concurrent_non_overlapping_optimize_table_", "(a INT, part INT) WITH (partitioning = ARRAY['part']) ");){
            ImmutableList.Builder expectedValues = ImmutableList.builder();
            for (int i = 0; i < 10; ++i) {
                String values = String.format("(%1$d, 10), (%1$d, 20), (%1$d, NULL), (%1$d, 40)", i);
                expectedValues.add((Object)values);
                this.assertUpdate(String.format("INSERT INTO %s VALUES %s", table.getName(), values), 4L);
            }
            executor.invokeAll(ImmutableList.builder().add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.assertUpdate("ALTER TABLE %s EXECUTE optimize WHERE part = 10".formatted(table.getName()));
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.assertUpdate("ALTER TABLE %s EXECUTE optimize WHERE part = 20".formatted(table.getName()));
                return null;
            }).add(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.assertUpdate("ALTER TABLE %s EXECUTE optimize WHERE part IS NULL".formatted(table.getName()));
                return null;
            }).build()).forEach(MoreFutures::getDone);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)expectedValues.build()));
        }
        finally {
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    private long getCurrentSnapshotId(String tableName) {
        return (Long)this.computeScalar("SELECT snapshot_id FROM \"" + tableName + "$snapshots\" ORDER BY committed_at DESC FETCH FIRST 1 ROW WITH TIES");
    }

    private Session withFileBasedConflictDetectionDisabledSession() {
        return Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "file_based_conflict_detection_enabled", "false").build();
    }

    private /* synthetic */ Future lambda$testConcurrentUpdateWithEnforcedAndUnenforcedPartitions$0(ExecutorService executor, CyclicBarrier barrier, String tableName, List partitions1, List partitions2, int threadNumber) {
        return executor.submit(() -> {
            barrier.await(10L, TimeUnit.SECONDS);
            this.getQueryRunner().execute(String.format("UPDATE %s SET data = data || data WHERE part1 = %s AND part2 = %s", tableName, partitions1.get(threadNumber), partitions2.get(threadNumber)));
            return true;
        });
    }

    private /* synthetic */ Future lambda$testConcurrentUpdateWithOverlappingPartitionTransformation$0(ExecutorService executor, CyclicBarrier barrier, String tableName, List partitions, int threadNumber) {
        return executor.submit(() -> {
            barrier.await(10L, TimeUnit.SECONDS);
            try {
                this.getQueryRunner().execute(String.format("UPDATE %s SET data = data || data WHERE part = %s", tableName, partitions.get(threadNumber)));
                return true;
            }
            catch (Exception e) {
                RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause((Throwable)e);
                try {
                    Assertions.assertThat((Throwable)trinoException).hasMessageMatching("Failed to commit the transaction during write.*|Failed to commit during write.*");
                }
                catch (Throwable verifyFailure) {
                    if (verifyFailure != e) {
                        verifyFailure.addSuppressed(e);
                    }
                    throw verifyFailure;
                }
                return false;
            }
        });
    }

    private /* synthetic */ Future lambda$testConcurrentUpdateWithMultiplePartitionTransformation$0(ExecutorService executor, CyclicBarrier barrier, String tableName, List partitions1, List partitions2, List partitions3, int threadNumber) {
        return executor.submit(() -> {
            barrier.await(10L, TimeUnit.SECONDS);
            this.getQueryRunner().execute(String.format("UPDATE %s SET data = data || data WHERE part1 = %s AND part2 = %s AND part3 = %s", tableName, partitions1.get(threadNumber), partitions2.get(threadNumber), partitions3.get(threadNumber)));
            return true;
        });
    }

    private /* synthetic */ Future lambda$testConcurrentUpdateWithNestedPartitionTransformation$0(ExecutorService executor, CyclicBarrier barrier, String tableName, List partitions, int threadNumber) {
        return executor.submit(() -> {
            barrier.await(10L, TimeUnit.SECONDS);
            this.getQueryRunner().execute(String.format("UPDATE %s SET data = data || data WHERE parent.part = %s", tableName, partitions.get(threadNumber)));
            return true;
        });
    }

    private /* synthetic */ Future lambda$testConcurrentUpdateWithPartitionTransformation$0(ExecutorService executor, CyclicBarrier barrier, String tableName, List partitions, int threadNumber) {
        return executor.submit(() -> {
            barrier.await(10L, TimeUnit.SECONDS);
            this.getQueryRunner().execute(String.format("UPDATE %s SET data = data || data WHERE part = %s", tableName, partitions.get(threadNumber)));
            return true;
        });
    }
}

