/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.Session;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.Table;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.iceberg.BaseIcebergMaterializedViewTest;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.spi.Plugin;
import io.trino.sql.query.QueryAssertions;
import io.trino.sql.tree.ExplainType;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIcebergMaterializedView
extends BaseIcebergMaterializedViewTest {
    private Session secondIceberg;
    private HiveMetastore metastore;

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = IcebergQueryRunner.builder().build();
        try {
            this.metastore = IcebergTestUtils.getHiveMetastore((QueryRunner)queryRunner);
            queryRunner.createCatalog("iceberg2", "iceberg", Map.of("iceberg.catalog.type", "TESTING_FILE_METASTORE", "hive.metastore.catalog.dir", queryRunner.getCoordinator().getBaseDataDir().resolve("iceberg2-catalog").toString(), "iceberg.hive-catalog-name", "hive", "fs.hadoop.enabled", "true"));
            this.secondIceberg = Session.builder((Session)queryRunner.getDefaultSession()).setCatalog("iceberg2").build();
            queryRunner.createCatalog("iceberg_legacy_mv", "iceberg", Map.of("iceberg.catalog.type", "TESTING_FILE_METASTORE", "hive.metastore.catalog.dir", queryRunner.getCoordinator().getBaseDataDir().resolve("iceberg_data").toString(), "iceberg.hive-catalog-name", "hive", "iceberg.materialized-views.hide-storage-table", "false", "fs.hadoop.enabled", "true"));
            queryRunner.execute(this.secondIceberg, "CREATE SCHEMA " + (String)this.secondIceberg.getSchema().orElseThrow());
            queryRunner.installPlugin((Plugin)TestIcebergMaterializedView.createMockConnectorPlugin());
            queryRunner.createCatalog("mock", "mock");
        }
        catch (Throwable e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
        return queryRunner;
    }

    @Override
    protected String getSchemaDirectory() {
        return "local:///tpch";
    }

    @Override
    protected String getStorageMetadataLocation(String materializedViewName) {
        Table table = (Table)this.metastore.getTable("tpch", materializedViewName).orElseThrow();
        return (String)table.getParameters().get("metadata_location");
    }

    @Test
    public void testTwoIcebergCatalogs() {
        Session defaultIceberg = this.getSession();
        String createTable = "CREATE TABLE common_base_table AS SELECT 10 value";
        this.assertUpdate(this.secondIceberg, createTable, 1L);
        this.assertUpdate(defaultIceberg, createTable, 1L);
        this.assertUpdate(defaultIceberg, "CREATE MATERIALIZED VIEW iceberg.tpch.mv_on_iceberg2\nAS SELECT sum(value) AS s FROM iceberg2.tpch.common_base_table\n");
        Assertions.assertThat((String)this.getExplainPlan("TABLE mv_on_iceberg2", ExplainType.Type.IO)).contains(new CharSequence[]{"\"table\" : \"common_base_table\""});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE mv_on_iceberg2"))).matches("VALUES BIGINT '10'");
        this.assertUpdate(defaultIceberg, "REFRESH MATERIALIZED VIEW mv_on_iceberg2", 1L);
        ((AbstractStringAssert)Assertions.assertThat((String)this.getExplainPlan("TABLE mv_on_iceberg2", ExplainType.Type.IO)).contains(new CharSequence[]{"\"table\" : \"mv_on_iceberg2$materialized_view_storage"})).doesNotContain(new CharSequence[]{"common_base_table"});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE mv_on_iceberg2"))).matches("VALUES BIGINT '10'");
        this.assertUpdate(this.secondIceberg, "INSERT INTO common_base_table VALUES 7", 1L);
        ((AbstractStringAssert)Assertions.assertThat((String)this.getExplainPlan("TABLE mv_on_iceberg2", ExplainType.Type.IO)).contains(new CharSequence[]{"\"table\" : \"mv_on_iceberg2$materialized_view_storage"})).doesNotContain(new CharSequence[]{"common_base_table"});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE mv_on_iceberg2"))).matches("VALUES BIGINT '10'");
        this.assertUpdate(defaultIceberg, "REFRESH MATERIALIZED VIEW mv_on_iceberg2", 1L);
        ((AbstractStringAssert)Assertions.assertThat((String)this.getExplainPlan("TABLE mv_on_iceberg2", ExplainType.Type.IO)).contains(new CharSequence[]{"\"table\" : \"mv_on_iceberg2$materialized_view_storage"})).doesNotContain(new CharSequence[]{"common_base_table"});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE mv_on_iceberg2"))).matches("VALUES BIGINT '17'");
        this.assertUpdate(this.secondIceberg, "DROP TABLE common_base_table");
        this.assertUpdate(defaultIceberg, "DROP TABLE common_base_table");
        this.assertUpdate("DROP MATERIALIZED VIEW mv_on_iceberg2");
    }
}

