/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.util.concurrent.MoreExecutors;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.TrinoViewHiveMetastore;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.file.FileMetastoreTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.hms.TrinoHiveCatalog;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.TypeManager;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import org.apache.iceberg.BaseTable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIcebergMergeAppend
extends AbstractTestQueryFramework {
    private TrinoCatalog trinoCatalog;
    private IcebergTableOperationsProvider tableOperationsProvider;

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = IcebergQueryRunner.builder().build();
        HiveMetastore metastore = IcebergTestUtils.getHiveMetastore((QueryRunner)queryRunner);
        CachingHiveMetastore cachingHiveMetastore = CachingHiveMetastore.createPerTransactionCache((HiveMetastore)metastore, (long)1000L);
        TrinoFileSystemFactory fileSystemFactory = IcebergTestUtils.getFileSystemFactory((QueryRunner)queryRunner);
        this.tableOperationsProvider = new FileMetastoreTableOperationsProvider(fileSystemFactory);
        this.trinoCatalog = new TrinoHiveCatalog(new CatalogName("catalog"), cachingHiveMetastore, new TrinoViewHiveMetastore((HiveMetastore)cachingHiveMetastore, false, "trino-version", "test"), fileSystemFactory, (TypeManager)new TestingTypeManager(), this.tableOperationsProvider, false, false, false, new IcebergConfig().isHideMaterializedViewStorageTable(), MoreExecutors.directExecutor());
        return queryRunner;
    }

    @Test
    public void testInsertWithAppend() {
        this.assertUpdate("CREATE TABLE table_to_insert (_bigint BIGINT, _varchar VARCHAR)");
        BaseTable table = IcebergUtil.loadIcebergTable((TrinoCatalog)this.trinoCatalog, (IcebergTableOperationsProvider)this.tableOperationsProvider, (ConnectorSession)IcebergTestUtils.SESSION, (SchemaTableName)new SchemaTableName("tpch", "table_to_insert"));
        table.updateProperties().set("commit.manifest.min-count-to-merge", "2").commit();
        this.assertUpdate("INSERT INTO table_to_insert VALUES (1, 'a'), (2, 'b'), (3, 'c')", 3L);
        MaterializedResult result = this.computeActual("select * from \"table_to_insert$manifests\"");
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        this.assertUpdate("INSERT INTO table_to_insert VALUES (4, 'd')", 1L);
        result = this.computeActual("select * from \"table_to_insert$manifests\"");
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
    }
}

