/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.hive.TestingHiveUtils;
import io.trino.plugin.iceberg.TestingIcebergPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SelectedRole;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIcebergMetadataListing
extends AbstractTestQueryFramework {
    private HiveMetastore metastore;

    protected QueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().setIdentity(Identity.forUser((String)"hive").withConnectorRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).build();
        File baseDir = queryRunner.getCoordinator().getBaseDataDir().resolve("iceberg_data").toFile();
        queryRunner.installPlugin((Plugin)new TestingIcebergPlugin(baseDir.toPath()));
        queryRunner.createCatalog("iceberg", "iceberg");
        queryRunner.installPlugin((Plugin)new TestingHivePlugin(baseDir.toPath()));
        queryRunner.createCatalog("hive", "hive", (Map)ImmutableMap.of((Object)"hive.security", (Object)"sql-standard"));
        this.metastore = ((HiveMetastoreFactory)TestingHiveUtils.getConnectorService((QueryRunner)queryRunner, HiveMetastoreFactory.class)).createMetastore(Optional.empty());
        return queryRunner;
    }

    @BeforeAll
    public void setUp() {
        this.assertQuerySucceeds("CREATE SCHEMA hive.test_schema");
        this.assertQuerySucceeds("CREATE TABLE iceberg.test_schema.iceberg_table1 (_string VARCHAR, _integer INTEGER)");
        this.assertQuerySucceeds("CREATE TABLE iceberg.test_schema.iceberg_table2 (_double DOUBLE) WITH (partitioning = ARRAY['_double'])");
        this.assertQuerySucceeds("CREATE MATERIALIZED VIEW iceberg.test_schema.iceberg_materialized_view AS SELECT * FROM iceberg.test_schema.iceberg_table1");
        this.assertQuerySucceeds("CREATE VIEW iceberg.test_schema.iceberg_view AS SELECT * FROM iceberg.test_schema.iceberg_table1");
        this.assertQuerySucceeds("CREATE TABLE hive.test_schema.hive_table (_double DOUBLE)");
        this.assertQuerySucceeds("CREATE VIEW hive.test_schema.hive_view AS SELECT * FROM hive.test_schema.hive_table");
    }

    @AfterAll
    public void tearDown() {
        this.assertQuerySucceeds("DROP TABLE IF EXISTS hive.test_schema.hive_table");
        this.assertQuerySucceeds("DROP VIEW IF EXISTS hive.test_schema.hive_view");
        this.assertQuerySucceeds("DROP VIEW IF EXISTS iceberg.test_schema.iceberg_view");
        this.assertQuerySucceeds("DROP MATERIALIZED VIEW IF EXISTS iceberg.test_schema.iceberg_materialized_view");
        this.assertQuerySucceeds("DROP TABLE IF EXISTS iceberg.test_schema.iceberg_table2");
        this.assertQuerySucceeds("DROP TABLE IF EXISTS iceberg.test_schema.iceberg_table1");
        this.assertQuerySucceeds("DROP SCHEMA IF EXISTS hive.test_schema");
    }

    @Test
    public void testTableListing() {
        Assertions.assertThat((List)this.metastore.getTables("test_schema")).extracting(table -> table.tableName().getTableName()).containsExactlyInAnyOrder((Object[])new String[]{"iceberg_table1", "iceberg_table2", "iceberg_materialized_view", "iceberg_view", "hive_table", "hive_view"});
        this.assertQuery("SHOW TABLES FROM iceberg.test_schema", "VALUES 'iceberg_table1', 'iceberg_table2', 'iceberg_materialized_view', 'iceberg_view', 'hive_table', 'hive_view'");
    }

    @Test
    public void testTableColumnListing() {
        this.assertQuery("SELECT table_name, column_name FROM iceberg.information_schema.columns WHERE table_schema = 'test_schema'", "VALUES ('iceberg_table1', '_string'), ('iceberg_table1', '_integer'), ('iceberg_table2', '_double'), ('iceberg_materialized_view', '_string'), ('iceberg_materialized_view', '_integer'), ('iceberg_view', '_string'), ('iceberg_view', '_integer'), ('hive_view', '_double')");
    }

    @Test
    public void testTableDescribing() {
        this.assertQuery("DESCRIBE iceberg.test_schema.iceberg_table1", "VALUES ('_string', 'varchar', '', ''), ('_integer', 'integer', '', '')");
    }

    @Test
    public void testTableValidation() {
        this.assertQuerySucceeds("SELECT * FROM iceberg.test_schema.iceberg_table1");
        this.assertQueryFails("SELECT * FROM iceberg.test_schema.hive_table", "Not an Iceberg table: test_schema.hive_table");
    }
}

