/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import io.trino.Session;
import io.trino.plugin.hive.metastore.MetastoreInvocations;
import io.trino.plugin.hive.metastore.MetastoreMethod;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.TableType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestIcebergMetastoreAccessOperations
extends AbstractTestQueryFramework {
    private static final int MAX_PREFIXES_COUNT = 10;

    protected QueryRunner createQueryRunner() throws Exception {
        return ((IcebergQueryRunner.Builder)IcebergQueryRunner.builder().addCoordinatorProperty("optimizer.experimental-max-prefetched-information-schema-prefixes", Integer.toString(10))).build();
    }

    @Test
    public void testUse() {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String schema = (String)this.getSession().getSchema().orElseThrow();
        Session session = Session.builder((Session)this.getSession()).setCatalog(Optional.empty()).setSchema(Optional.empty()).build();
        this.assertMetastoreInvocations(session, "USE %s.%s".formatted(catalog, schema), (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).build());
    }

    @Test
    public void testCreateTable() {
        this.assertMetastoreInvocations("CREATE TABLE test_create (id VARCHAR, age INT)", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.CREATE_TABLE).add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testCreateOrReplaceTable() {
        this.assertMetastoreInvocations("CREATE OR REPLACE TABLE test_create_or_replace (id VARCHAR, age INT)", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.CREATE_TABLE).add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.GET_TABLE).build());
        this.assertMetastoreInvocations("CREATE OR REPLACE TABLE test_create_or_replace (id VARCHAR, age INT)", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.REPLACE_TABLE).add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testCreateTableAsSelect() {
        this.assertMetastoreInvocations(TestIcebergMetastoreAccessOperations.withStatsOnWrite(this.getSession(), false), "CREATE TABLE test_ctas AS SELECT 1 AS age", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.CREATE_TABLE).add((Object)MetastoreMethod.GET_TABLE).build());
        this.assertMetastoreInvocations(TestIcebergMetastoreAccessOperations.withStatsOnWrite(this.getSession(), true), "CREATE TABLE test_ctas_with_stats AS SELECT 1 AS age", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.CREATE_TABLE).addCopies((Object)MetastoreMethod.GET_TABLE, 4).add((Object)MetastoreMethod.REPLACE_TABLE).build());
    }

    @Test
    public void testCreateOrReplaceTableAsSelect() {
        this.assertMetastoreInvocations("CREATE OR REPLACE TABLE test_cortas AS SELECT 1 AS age", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.CREATE_TABLE).addCopies((Object)MetastoreMethod.GET_TABLE, 4).add((Object)MetastoreMethod.REPLACE_TABLE).build());
        this.assertMetastoreInvocations("CREATE OR REPLACE TABLE test_cortas AS SELECT 1 AS age", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).addCopies((Object)MetastoreMethod.GET_TABLE, 3).addCopies((Object)MetastoreMethod.REPLACE_TABLE, 2).build());
    }

    @Test
    public void testSelect() {
        this.assertUpdate("CREATE TABLE test_select_from (id VARCHAR, age INT)");
        this.assertMetastoreInvocations("SELECT * FROM test_select_from", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testSelectWithFilter() {
        this.assertUpdate("CREATE TABLE test_select_from_where AS SELECT 2 as age", 1L);
        this.assertMetastoreInvocations("SELECT * FROM test_select_from_where WHERE age = 2", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testSelectFromView() {
        this.assertUpdate("CREATE TABLE test_select_view_table (id VARCHAR, age INT)");
        this.assertUpdate("CREATE VIEW test_select_view_view AS SELECT id, age FROM test_select_view_table");
        this.assertMetastoreInvocations("SELECT * FROM test_select_view_view", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 2).build());
    }

    @Test
    public void testSelectFromViewWithFilter() {
        this.assertUpdate("CREATE TABLE test_select_view_where_table AS SELECT 2 as age", 1L);
        this.assertUpdate("CREATE VIEW test_select_view_where_view AS SELECT age FROM test_select_view_where_table");
        this.assertMetastoreInvocations("SELECT * FROM test_select_view_where_view WHERE age = 2", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 2).build());
    }

    @Test
    public void testSelectFromMaterializedView() {
        this.assertUpdate("CREATE TABLE test_select_mview_table (id VARCHAR, age INT)");
        this.assertUpdate("CREATE MATERIALIZED VIEW test_select_mview_view AS SELECT id, age FROM test_select_mview_table");
        this.assertMetastoreInvocations("SELECT * FROM test_select_mview_view", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 2).build());
    }

    @Test
    public void testSelectFromMaterializedViewWithFilter() {
        this.assertUpdate("CREATE TABLE test_select_mview_where_table AS SELECT 2 as age", 1L);
        this.assertUpdate("CREATE MATERIALIZED VIEW test_select_mview_where_view AS SELECT age FROM test_select_mview_where_table");
        this.assertMetastoreInvocations("SELECT * FROM test_select_mview_where_view WHERE age = 2", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 2).build());
    }

    @Test
    public void testRefreshMaterializedView() {
        this.assertUpdate("CREATE TABLE test_refresh_mview_table (id VARCHAR, age INT)");
        this.assertUpdate("CREATE MATERIALIZED VIEW test_refresh_mview_view AS SELECT id, age FROM test_refresh_mview_table");
        this.assertMetastoreInvocations("REFRESH MATERIALIZED VIEW test_refresh_mview_view", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 2).addCopies((Object)MetastoreMethod.REPLACE_TABLE, 1).build());
    }

    @Test
    public void testJoin() {
        this.assertUpdate("CREATE TABLE test_join_t1 AS SELECT 2 as age, 'id1' AS id", 1L);
        this.assertUpdate("CREATE TABLE test_join_t2 AS SELECT 'name1' as name, 'id1' AS id", 1L);
        this.assertMetastoreInvocations("SELECT name, age FROM test_join_t1 JOIN test_join_t2 ON test_join_t2.id = test_join_t1.id", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 2).build());
    }

    @Test
    public void testSelfJoin() {
        this.assertUpdate("CREATE TABLE test_self_join_table AS SELECT 2 as age, 0 parent, 3 AS id", 1L);
        this.assertMetastoreInvocations("SELECT child.age, parent.age FROM test_self_join_table child JOIN test_self_join_table parent ON child.parent = parent.id", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testExplainSelect() {
        this.assertUpdate("CREATE TABLE test_explain AS SELECT 2 as age", 1L);
        this.assertMetastoreInvocations("EXPLAIN SELECT * FROM test_explain", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testShowStatsForTable() {
        this.assertUpdate("CREATE TABLE test_show_stats AS SELECT 2 as age", 1L);
        this.assertMetastoreInvocations("SHOW STATS FOR test_show_stats", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testShowStatsForTableWithFilter() {
        this.assertUpdate("CREATE TABLE test_show_stats_with_filter AS SELECT 2 as age", 1L);
        this.assertMetastoreInvocations("SHOW STATS FOR (SELECT * FROM test_show_stats_with_filter where age >= 2)", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testSelectSystemTable() {
        this.assertUpdate("CREATE TABLE test_select_snapshots AS SELECT 2 AS age", 1L);
        this.assertMetastoreInvocations("SELECT * FROM \"test_select_snapshots$history\"", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 1).build());
        this.assertMetastoreInvocations("SELECT * FROM \"test_select_snapshots$metadata_log_entries\"", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
        this.assertMetastoreInvocations("SELECT * FROM \"test_select_snapshots$snapshots\"", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 1).build());
        this.assertMetastoreInvocations("SELECT * FROM \"test_select_snapshots$all_manifests\"", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 1).build());
        this.assertMetastoreInvocations("SELECT * FROM \"test_select_snapshots$manifests\"", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 1).build());
        this.assertMetastoreInvocations("SELECT * FROM \"test_select_snapshots$partitions\"", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 1).build());
        this.assertMetastoreInvocations("SELECT * FROM \"test_select_snapshots$files\"", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 1).build());
        this.assertMetastoreInvocations("SELECT * FROM \"test_select_snapshots$all_entries\"", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 1).build());
        this.assertMetastoreInvocations("SELECT * FROM \"test_select_snapshots$entries\"", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 1).build());
        this.assertMetastoreInvocations("SELECT * FROM \"test_select_snapshots$properties\"", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 1).build());
        this.assertQueryFails("SELECT * FROM \"test_select_snapshots$materialized_view_storage\"", "Table 'tpch.test_select_snapshots\\$materialized_view_storage' not found");
        Assertions.assertThat((Object[])TableType.values()).containsExactly((Object[])new TableType[]{TableType.DATA, TableType.HISTORY, TableType.METADATA_LOG_ENTRIES, TableType.SNAPSHOTS, TableType.ALL_MANIFESTS, TableType.MANIFESTS, TableType.PARTITIONS, TableType.FILES, TableType.ALL_ENTRIES, TableType.ENTRIES, TableType.PROPERTIES, TableType.REFS, TableType.MATERIALIZED_VIEW_STORAGE});
    }

    @Test
    public void testUnregisterTable() {
        this.assertUpdate("CREATE TABLE test_unregister_table AS SELECT 2 as age", 1L);
        this.assertMetastoreInvocations("CALL system.unregister_table(CURRENT_SCHEMA, 'test_unregister_table')", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.DROP_TABLE).build());
    }

    @ParameterizedTest
    @MethodSource(value={"metadataQueriesTestTableCountDataProvider"})
    public void testInformationSchemaColumns(int tables) {
        int i;
        String schemaName = "test_i_s_columns_schema" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        Session session = Session.builder((Session)this.getSession()).setSchema(schemaName).build();
        for (i = 0; i < tables; ++i) {
            this.assertUpdate(session, "CREATE TABLE test_select_i_s_columns" + i + "(id varchar, age integer)");
            this.assertUpdate(session, "INSERT INTO test_select_i_s_columns" + i + " VALUES ('abc', 11)", 1L);
            this.assertUpdate(session, "INSERT INTO test_select_i_s_columns" + i + " VALUES ('xyz', 12)", 1L);
            this.assertUpdate(session, "CREATE TABLE test_other_select_i_s_columns" + i + "(id varchar, age integer)");
        }
        this.assertMetastoreInvocations(session, "SELECT * FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name LIKE 'test_select_i_s_columns%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLES).addCopies((Object)MetastoreMethod.GET_TABLE, tables * 2).build());
        this.assertMetastoreInvocations(session, "SELECT * FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name = 'test_select_i_s_columns0'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
        this.assertMetastoreInvocations(session, "DESCRIBE test_select_i_s_columns0", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.GET_TABLE).build());
        for (i = 0; i < tables; ++i) {
            this.assertUpdate(session, "DROP TABLE test_select_i_s_columns" + i);
            this.assertUpdate(session, "DROP TABLE test_other_select_i_s_columns" + i);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"metadataQueriesTestTableCountDataProvider"})
    public void testSystemMetadataTableComments(int tables) {
        int i;
        String schemaName = "test_s_m_table_comments" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        Session session = Session.builder((Session)this.getSession()).setSchema(schemaName).build();
        for (i = 0; i < tables; ++i) {
            this.assertUpdate(session, "CREATE TABLE test_select_s_m_t_comments" + i + "(id varchar, age integer)");
            this.assertUpdate(session, "INSERT INTO test_select_s_m_t_comments" + i + " VALUES ('abc', 11)", 1L);
            this.assertUpdate(session, "INSERT INTO test_select_s_m_t_comments" + i + " VALUES ('xyz', 12)", 1L);
            this.assertUpdate(session, "CREATE TABLE test_other_select_s_m_t_comments" + i + "(id varchar, age integer)");
        }
        this.assertMetastoreInvocations(session, "SELECT * FROM system.metadata.table_comments WHERE schema_name = CURRENT_SCHEMA AND table_name LIKE 'test_select_s_m_t_comments%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLES).addCopies((Object)MetastoreMethod.GET_TABLE, tables * 2).build());
        this.assertMetastoreInvocations(session, "SELECT * FROM system.metadata.table_comments WHERE schema_name IN (CURRENT_SCHEMA, 'non_existent') AND table_name LIKE 'test_select_s_m_t_comments%'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLES, 2).addCopies((Object)MetastoreMethod.GET_TABLE, tables * 2).build());
        this.assertMetastoreInvocations(session, "SELECT * FROM system.metadata.table_comments WHERE schema_name = CURRENT_SCHEMA AND table_name = 'test_select_s_m_t_comments0'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 1).build());
        for (i = 0; i < tables; ++i) {
            this.assertUpdate(session, "DROP TABLE test_select_s_m_t_comments" + i);
            this.assertUpdate(session, "DROP TABLE test_other_select_s_m_t_comments" + i);
        }
    }

    public Object[][] metadataQueriesTestTableCountDataProvider() {
        return new Object[][]{{3}, {10}, {13}};
    }

    @Test
    public void testSystemMetadataMaterializedViews() {
        String schemaName = "test_materialized_views_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        Session session = Session.builder((Session)this.getSession()).setSchema(schemaName).build();
        this.assertUpdate(session, "CREATE TABLE test_table1 AS SELECT 1 a", 1L);
        this.assertUpdate(session, "CREATE TABLE test_table2 AS SELECT 1 a", 1L);
        this.assertUpdate(session, "CREATE MATERIALIZED VIEW mv1 AS SELECT * FROM test_table1 JOIN test_table2 USING (a)");
        this.assertUpdate(session, "REFRESH MATERIALIZED VIEW mv1", 1L);
        this.assertUpdate(session, "CREATE MATERIALIZED VIEW mv2 AS SELECT count(*) c FROM test_table1 JOIN test_table2 USING (a)");
        this.assertUpdate(session, "REFRESH MATERIALIZED VIEW mv2", 1L);
        this.assertMetastoreInvocations(session, "SELECT * FROM system.metadata.materialized_views WHERE schema_name = CURRENT_SCHEMA", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLES).addCopies((Object)MetastoreMethod.GET_TABLE, 4).build());
        this.assertMetastoreInvocations(session, "SELECT schema_name, name FROM system.metadata.materialized_views WHERE schema_name = CURRENT_SCHEMA", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLES).build());
        this.assertMetastoreInvocations(session, "SELECT * FROM system.metadata.materialized_views WHERE schema_name IN (CURRENT_SCHEMA, 'non_existent')", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLES, 2).addCopies((Object)MetastoreMethod.GET_TABLE, 4).build());
        this.assertMetastoreInvocations(session, "SELECT * FROM system.metadata.materialized_views WHERE schema_name = CURRENT_SCHEMA AND name = 'mv1'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 3).build());
        this.assertMetastoreInvocations(session, "SELECT schema_name, name FROM system.metadata.materialized_views WHERE schema_name = CURRENT_SCHEMA AND name = 'mv1'", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
        this.assertUpdate("DROP SCHEMA " + schemaName + " CASCADE");
    }

    @Test
    public void testShowTables() {
        this.assertMetastoreInvocations("SHOW TABLES", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.GET_TABLES).build());
    }

    private void assertMetastoreInvocations(@Language(value="SQL") String query, Multiset<MetastoreMethod> expectedInvocations) {
        this.assertMetastoreInvocations(this.getSession(), query, expectedInvocations);
    }

    private void assertMetastoreInvocations(Session session, @Language(value="SQL") String query, Multiset<MetastoreMethod> expectedInvocations) {
        MetastoreInvocations.assertMetastoreInvocationsForQuery((QueryRunner)this.getDistributedQueryRunner(), (Session)session, (String)query, expectedInvocations);
    }

    private static Session withStatsOnWrite(Session session, boolean enabled) {
        String catalog = (String)session.getCatalog().orElseThrow();
        return Session.builder((Session)session).setCatalogSessionProperty(catalog, "collect_extended_statistics_on_write", Boolean.toString(enabled)).build();
    }
}

