/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.trino.Session;
import io.trino.filesystem.Location;
import io.trino.plugin.iceberg.BaseIcebergConnectorTest;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.SchemaInitializer;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.containers.Minio;
import io.trino.testing.sql.TestTable;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestIcebergMinioOrcConnectorTest
extends BaseIcebergConnectorTest {
    private final String bucketName = "test-iceberg-orc-" + TestingNames.randomNameSuffix();

    public TestIcebergMinioOrcConnectorTest() {
        super(IcebergFileFormat.ORC);
    }

    @Override
    protected QueryRunner createQueryRunner() throws Exception {
        Minio minio = (Minio)this.closeAfterClass((AutoCloseable)Minio.builder().build());
        minio.start();
        minio.createBucket(this.bucketName);
        return IcebergQueryRunner.builder().setIcebergProperties((Map<String, String>)ImmutableMap.builder().put((Object)"iceberg.file-format", (Object)this.format.name()).put((Object)"fs.hadoop.enabled", (Object)"true").put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)minio.getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").put((Object)"s3.streaming.part-size", (Object)"5MB").put((Object)"s3.max-connections", (Object)"8").put((Object)"iceberg.register-table-procedure.enabled", (Object)"true").put((Object)"iceberg.allowed-extra-properties", (Object)"extra.property.one,extra.property.two,extra.property.three").put((Object)"iceberg.writer-sort-buffer-size", (Object)"1MB").buildOrThrow()).setSchemaInitializer(SchemaInitializer.builder().withSchemaName("tpch").withClonedTpchTables(REQUIRED_TPCH_TABLES).withSchemaProperties(Map.of("location", "'s3://" + this.bucketName + "/iceberg_data/tpch'")).build()).build();
    }

    @Override
    protected boolean supportsIcebergFileStatistics(String typeName) {
        return !typeName.equalsIgnoreCase("varbinary") && !typeName.equalsIgnoreCase("uuid");
    }

    @Override
    protected boolean supportsRowGroupStatistics(String typeName) {
        return !typeName.equalsIgnoreCase("varbinary");
    }

    @Override
    protected boolean isFileSorted(String path, String sortColumnName) {
        return IcebergTestUtils.checkOrcFileSorting(this.fileSystem, Location.of((String)path), sortColumnName);
    }

    protected boolean supportsPhysicalPushdown() {
        return false;
    }

    @Test
    public void testTinyintType() throws Exception {
        this.testReadSingleIntegerColumnOrcFile("single-tinyint-column.orc", 127);
    }

    @Test
    public void testSmallintType() throws Exception {
        this.testReadSingleIntegerColumnOrcFile("single-smallint-column.orc", Short.MAX_VALUE);
    }

    private void testReadSingleIntegerColumnOrcFile(String orcFileResourceName, int expectedValue) throws Exception {
        Preconditions.checkArgument((expectedValue != 0 ? 1 : 0) != 0);
        try (TestTable table = this.newTrinoTable("test_read_as_integer", "(\"_col0\") AS VALUES 0, NULL");){
            String orcFilePath = (String)this.computeScalar(String.format("SELECT DISTINCT file_path FROM \"%s$files\"", table.getName()));
            byte[] orcFileData = Resources.toByteArray((URL)Resources.getResource((String)orcFileResourceName));
            this.fileSystem.newOutputFile(Location.of((String)orcFilePath)).createOrOverwrite(orcFileData);
            this.fileSystem.deleteFiles(List.of(Location.of((String)orcFilePath.replaceAll("/([^/]*)$", ".$1.crc"))));
            Session ignoreFileSizeFromMetadata = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "use_file_size_from_metadata", "false").build();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(ignoreFileSizeFromMetadata, "TABLE " + table.getName()))).matches("VALUES NULL, " + expectedValue);
        }
    }

    @Test
    public void testTimeType() {
        try (TestTable table = this.newTrinoTable("test_time", "(col time(6))");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (TIME '13:30:00'), (TIME '14:30:00'), (NULL)", 3L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES '13:30:00', '14:30:00', NULL");
            this.assertQuery("SHOW STATS FOR " + table.getName(), "VALUES\n('col', null, 2.0, 0.33333333333, null, null, null),\n(null, null, null, null, 3, null, null)\n");
        }
    }

    @Override
    protected Optional<BaseIcebergConnectorTest.TypeCoercionTestSetup> filterTypeCoercionOnCreateTableAsSelectProvider(BaseIcebergConnectorTest.TypeCoercionTestSetup setup) {
        if (setup.sourceValueLiteral().equals("TIMESTAMP '1969-12-31 23:59:59.999999499999'")) {
            return Optional.of(setup.withNewValueLiteral("TIMESTAMP '1970-01-01 00:00:00.999999'"));
        }
        if (setup.sourceValueLiteral().equals("TIMESTAMP '1969-12-31 23:59:59.9999994'")) {
            return Optional.of(setup.withNewValueLiteral("TIMESTAMP '1970-01-01 00:00:00.999999'"));
        }
        return Optional.of(setup);
    }
}

