/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.filesystem.Location;
import io.trino.plugin.iceberg.BaseIcebergMinioConnectorSmokeTest;
import io.trino.plugin.iceberg.IcebergTestUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.iceberg.FileFormat;
import org.junit.jupiter.api.AfterAll;

public class TestIcebergMinioParquetCachingConnectorSmokeTest
extends BaseIcebergMinioConnectorSmokeTest {
    private final Path cacheDirectory;
    private final Closer closer = Closer.create();

    TestIcebergMinioParquetCachingConnectorSmokeTest() throws IOException {
        super(FileFormat.PARQUET);
        this.cacheDirectory = Files.createTempDirectory("cache", new FileAttribute[0]);
        this.closer.register(() -> MoreFiles.deleteRecursively((Path)this.cacheDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
    }

    @AfterAll
    public void tearDown() throws Exception {
        this.closer.close();
    }

    @Override
    public Map<String, String> getAdditionalIcebergProperties() {
        return ImmutableMap.builder().put((Object)"fs.cache.enabled", (Object)"true").put((Object)"fs.cache.directories", (Object)this.cacheDirectory.toAbsolutePath().toString()).put((Object)"fs.cache.max-sizes", (Object)"100MB").buildOrThrow();
    }

    @Override
    protected boolean isFileSorted(Location path, String sortColumnName) {
        return IcebergTestUtils.checkParquetFileSorting(this.fileSystem.newInputFile(path), sortColumnName);
    }
}

