/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.Location;
import io.trino.plugin.iceberg.BaseIcebergConnectorSmokeTest;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.SchemaInitializer;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.containers.MotoContainer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.iceberg.FileFormat;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.GlueClientBuilder;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestIcebergMotoConnectorSmokeTest
extends BaseIcebergConnectorSmokeTest {
    private final String bucketName = "test-iceberg-" + TestingNames.randomNameSuffix();
    private final String schemaName = "test_iceberg_smoke_" + TestingNames.randomNameSuffix();
    private GlueClient glueClient;

    public TestIcebergMotoConnectorSmokeTest() {
        super(FileFormat.PARQUET);
    }

    protected QueryRunner createQueryRunner() throws Exception {
        MotoContainer moto = (MotoContainer)this.closeAfterClass((AutoCloseable)new MotoContainer());
        moto.start();
        moto.createBucket(this.bucketName);
        this.glueClient = (GlueClient)this.closeAfterClass((AutoCloseable)((GlueClient)((GlueClientBuilder)GlueClient.builder().applyMutation(arg_0 -> ((MotoContainer)moto).updateClient(arg_0))).build()));
        return IcebergQueryRunner.builder().setIcebergProperties((Map<String, String>)ImmutableMap.builder().put((Object)"iceberg.file-format", (Object)this.format.name()).put((Object)"iceberg.catalog.type", (Object)"glue").put((Object)"hive.metastore.glue.region", (Object)"us-east-1").put((Object)"hive.metastore.glue.endpoint-url", (Object)moto.getEndpoint().toString()).put((Object)"hive.metastore.glue.aws-access-key", (Object)"accesskey").put((Object)"hive.metastore.glue.aws-secret-key", (Object)"secretkey").put((Object)"hive.metastore.glue.default-warehouse-dir", (Object)"s3://%s/".formatted(this.bucketName)).put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)moto.getEndpoint().toString()).put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.path-style-access", (Object)"true").put((Object)"iceberg.register-table-procedure.enabled", (Object)"true").put((Object)"iceberg.allowed-extra-properties", (Object)"write.metadata.delete-after-commit.enabled,write.metadata.previous-versions-max").buildOrThrow()).setSchemaInitializer(SchemaInitializer.builder().withSchemaName(this.schemaName).withClonedTpchTables(REQUIRED_TPCH_TABLES).withSchemaProperties(Map.of("location", "'s3://%s/%s/'".formatted(this.bucketName, this.schemaName))).build()).build();
    }

    @Override
    protected void deleteDirectory(String location) {
        try {
            this.fileSystem.deleteDirectory(Location.of((String)location));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected boolean isFileSorted(Location path, String sortColumnName) {
        return IcebergTestUtils.checkParquetFileSorting(this.fileSystem.newInputFile(path), sortColumnName);
    }

    @Override
    protected void dropTableFromMetastore(String tableName) {
        this.glueClient.deleteTable(x -> x.databaseName(this.schemaName).name(tableName));
    }

    @Override
    protected String getMetadataLocation(String tableName) {
        return (String)this.glueClient.getTable(x -> x.databaseName(this.schemaName).name(tableName)).table().parameters().get("metadata_location");
    }

    @Override
    protected String schemaPath() {
        return "s3://%s/%s".formatted(this.bucketName, this.schemaName);
    }

    @Override
    protected boolean locationExists(String location) {
        try {
            return this.fileSystem.directoryExists(Location.of((String)location)).orElse(false);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    @Test
    @Disabled(value="Moto is not concurrency safe")
    public void testDeleteRowsConcurrently() {
    }

    @Test
    public void testRenameSchema() {
        Assertions.assertThatThrownBy(() -> super.testRenameSchema()).hasStackTraceContaining("renameNamespace is not supported for Iceberg Glue catalogs");
    }
}

