/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.testing.TempFile;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.filesystem.local.LocalInputFile;
import io.trino.filesystem.local.LocalOutputFile;
import io.trino.metadata.TableHandle;
import io.trino.orc.OrcDataSink;
import io.trino.orc.OrcWriteValidation;
import io.trino.orc.OrcWriter;
import io.trino.orc.OrcWriterOptions;
import io.trino.orc.OrcWriterStats;
import io.trino.orc.OutputStreamOrcDataSink;
import io.trino.orc.metadata.CompressionKind;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergFileSystemFactory;
import io.trino.plugin.iceberg.IcebergPageSourceProviderFactory;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergSplit;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.TableType;
import io.trino.plugin.iceberg.catalog.rest.DefaultIcebergFileSystemFactory;
import io.trino.plugin.iceberg.util.OrcTypeConverter;
import io.trino.spi.Page;
import io.trino.spi.SplitWeight;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingHandles;
import io.trino.type.InternalTypeManager;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIcebergNodeLocalDynamicSplitPruning {
    private static final OrcReaderConfig ORC_READER_CONFIG = new OrcReaderConfig();
    private static final OrcWriterConfig ORC_WRITER_CONFIG = new OrcWriterConfig();
    private static final ParquetReaderConfig PARQUET_READER_CONFIG = new ParquetReaderConfig();
    private static final ParquetWriterConfig PARQUET_WRITER_CONFIG = new ParquetWriterConfig();

    @Test
    public void testDynamicSplitPruningOnUnpartitionedTable() throws IOException {
        String tableName = "unpartitioned_table";
        String keyColumnName = "a_integer";
        ColumnIdentity keyColumnIdentity = new ColumnIdentity(1, keyColumnName, ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        IcebergColumnHandle keyColumnHandle = new IcebergColumnHandle(keyColumnIdentity, (io.trino.spi.type.Type)IntegerType.INTEGER, (List)ImmutableList.of(), (io.trino.spi.type.Type)IntegerType.INTEGER, true, Optional.empty());
        int keyColumnValue = 42;
        String dataColumnName = "a_varchar";
        ColumnIdentity dataColumnIdentity = new ColumnIdentity(2, dataColumnName, ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        IcebergColumnHandle dataColumnHandle = new IcebergColumnHandle(dataColumnIdentity, (io.trino.spi.type.Type)VarcharType.VARCHAR, (List)ImmutableList.of(), (io.trino.spi.type.Type)VarcharType.VARCHAR, true, Optional.empty());
        String dataColumnValue = "hello world";
        Schema tableSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)keyColumnIdentity.getId(), (String)keyColumnName, (Type)Types.IntegerType.get()), Types.NestedField.optional((int)dataColumnIdentity.getId(), (String)dataColumnName, (Type)Types.StringType.get())});
        IcebergConfig icebergConfig = new IcebergConfig();
        HiveTransactionHandle transaction = new HiveTransactionHandle(false);
        try (TempFile file = new TempFile();){
            SourcePage page;
            Files.delete(file.path());
            LocalOutputFile outputFile = new LocalOutputFile(file.file());
            LocalInputFile inputFile = new LocalInputFile(file.file());
            ImmutableList columnNames = ImmutableList.of((Object)keyColumnName, (Object)dataColumnName);
            ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR);
            try (OrcWriter writer = new OrcWriter((OrcDataSink)OutputStreamOrcDataSink.create((TrinoOutputFile)outputFile), (List)columnNames, (List)types, OrcTypeConverter.toOrcType((Schema)tableSchema), CompressionKind.NONE, new OrcWriterOptions(), (Map)ImmutableMap.of(), true, OrcWriteValidation.OrcWriteValidationMode.BOTH, new OrcWriterStats());){
                BlockBuilder keyBuilder = IntegerType.INTEGER.createFixedSizeBlockBuilder(1);
                IntegerType.INTEGER.writeLong(keyBuilder, (long)keyColumnValue);
                VariableWidthBlockBuilder dataBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1);
                VarcharType.VARCHAR.writeString((BlockBuilder)dataBuilder, dataColumnValue);
                writer.write(new Page(new Block[]{keyBuilder.build(), dataBuilder.build()}));
            }
            IcebergSplit split = new IcebergSplit(inputFile.toString(), 0L, inputFile.length(), inputFile.length(), -1L, IcebergFileFormat.ORC, PartitionSpecParser.toJson((PartitionSpec)PartitionSpec.unpartitioned()), PartitionData.toJson((StructLike)new PartitionData(new Object[0])), (List)ImmutableList.of(), SplitWeight.standard(), TupleDomain.all(), (Map)ImmutableMap.of(), 0L);
            String tablePath = inputFile.location().fileName();
            TableHandle tableHandle = new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new IcebergTableHandle(CatalogHandle.fromId((String)"iceberg:NORMAL:v12345"), "test_schema", tableName, TableType.DATA, Optional.empty(), SchemaParser.toJson((Schema)tableSchema), Optional.of(PartitionSpecParser.toJson((PartitionSpec)PartitionSpec.unpartitioned())), 2, TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)keyColumnHandle, (Object)Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)keyColumnValue))), TupleDomain.all(), OptionalLong.empty(), (Set)ImmutableSet.of((Object)keyColumnHandle), Optional.empty(), tablePath, (Map)ImmutableMap.of(), Optional.empty(), false, Optional.empty(), (Set)ImmutableSet.of(), Optional.of(false)), (ConnectorTransactionHandle)transaction);
            TupleDomain splitPruningPredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)keyColumnHandle, (Object)Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)1L)));
            try (ConnectorPageSource emptyPageSource = TestIcebergNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, icebergConfig, split, tableHandle, (List<ColumnHandle>)ImmutableList.of((Object)keyColumnHandle, (Object)dataColumnHandle), TestIcebergNodeLocalDynamicSplitPruning.getDynamicFilter((TupleDomain<ColumnHandle>)splitPruningPredicate));){
                Assertions.assertThat((Object)emptyPageSource.getNextSourcePage()).isNull();
            }
            TupleDomain nonSelectivePredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)keyColumnHandle, (Object)Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)keyColumnValue)));
            try (ConnectorPageSource nonEmptyPageSource = TestIcebergNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, icebergConfig, split, tableHandle, (List<ColumnHandle>)ImmutableList.of((Object)keyColumnHandle, (Object)dataColumnHandle), TestIcebergNodeLocalDynamicSplitPruning.getDynamicFilter((TupleDomain<ColumnHandle>)nonSelectivePredicate));){
                page = nonEmptyPageSource.getNextSourcePage();
                Assertions.assertThat((Object)page).isNotNull();
                Assertions.assertThat((int)page.getPositionCount()).isEqualTo(1);
                Assertions.assertThat((int)IntegerType.INTEGER.getInt(page.getBlock(0), 0)).isEqualTo(keyColumnValue);
                Assertions.assertThat((String)VarcharType.VARCHAR.getSlice(page.getBlock(1), 0).toStringUtf8()).isEqualTo(dataColumnValue);
            }
            split = new IcebergSplit(inputFile.toString(), 0L, inputFile.length(), inputFile.length(), -1L, IcebergFileFormat.ORC, PartitionSpecParser.toJson((PartitionSpec)PartitionSpec.unpartitioned()), PartitionData.toJson((StructLike)new PartitionData(new Object[0])), (List)ImmutableList.of(), SplitWeight.standard(), TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)keyColumnHandle, (Object)Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)keyColumnValue))), (Map)ImmutableMap.of(), 0L);
            tableHandle = new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new IcebergTableHandle(CatalogHandle.fromId((String)"iceberg:NORMAL:v12345"), "test_schema", tableName, TableType.DATA, Optional.empty(), SchemaParser.toJson((Schema)tableSchema), Optional.of(PartitionSpecParser.toJson((PartitionSpec)PartitionSpec.unpartitioned())), 2, TupleDomain.all(), TupleDomain.all(), OptionalLong.empty(), (Set)ImmutableSet.of((Object)keyColumnHandle), Optional.empty(), tablePath, (Map)ImmutableMap.of(), Optional.empty(), false, Optional.empty(), (Set)ImmutableSet.of(), Optional.of(false)), (ConnectorTransactionHandle)transaction);
            try (ConnectorPageSource emptyPageSource = TestIcebergNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, icebergConfig, split, tableHandle, (List<ColumnHandle>)ImmutableList.of((Object)keyColumnHandle, (Object)dataColumnHandle), TestIcebergNodeLocalDynamicSplitPruning.getDynamicFilter((TupleDomain<ColumnHandle>)splitPruningPredicate));){
                Assertions.assertThat((Object)emptyPageSource.getNextSourcePage()).isNull();
            }
            nonEmptyPageSource = TestIcebergNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, icebergConfig, split, tableHandle, (List<ColumnHandle>)ImmutableList.of((Object)keyColumnHandle, (Object)dataColumnHandle), TestIcebergNodeLocalDynamicSplitPruning.getDynamicFilter((TupleDomain<ColumnHandle>)nonSelectivePredicate));
            try {
                page = nonEmptyPageSource.getNextSourcePage();
                Assertions.assertThat((Object)page).isNotNull();
                Assertions.assertThat((int)page.getPositionCount()).isEqualTo(1);
                Assertions.assertThat((int)IntegerType.INTEGER.getInt(page.getBlock(0), 0)).isEqualTo(keyColumnValue);
                Assertions.assertThat((String)VarcharType.VARCHAR.getSlice(page.getBlock(1), 0).toStringUtf8()).isEqualTo(dataColumnValue);
            }
            finally {
                if (nonEmptyPageSource != null) {
                    nonEmptyPageSource.close();
                }
            }
        }
    }

    @Test
    public void testDynamicSplitPruningWithExplicitPartitionFilter() throws IOException {
        String tableName = "sales_table";
        String dateColumnName = "date";
        ColumnIdentity dateColumnIdentity = new ColumnIdentity(1, dateColumnName, ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        IcebergColumnHandle dateColumnHandle = new IcebergColumnHandle(dateColumnIdentity, (io.trino.spi.type.Type)DateType.DATE, (List)ImmutableList.of(), (io.trino.spi.type.Type)DateType.DATE, true, Optional.empty());
        long dateColumnValue = LocalDate.of(2023, 1, 10).toEpochDay();
        String receiptColumnName = "receipt";
        ColumnIdentity receiptColumnIdentity = new ColumnIdentity(2, receiptColumnName, ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        IcebergColumnHandle receiptColumnHandle = new IcebergColumnHandle(receiptColumnIdentity, (io.trino.spi.type.Type)VarcharType.VARCHAR, (List)ImmutableList.of(), (io.trino.spi.type.Type)VarcharType.VARCHAR, true, Optional.empty());
        String receiptColumnValue = "#12345";
        String amountColumnName = "amount";
        ColumnIdentity amountColumnIdentity = new ColumnIdentity(3, amountColumnName, ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        DecimalType amountColumnType = DecimalType.createDecimalType((int)10, (int)2);
        IcebergColumnHandle amountColumnHandle = new IcebergColumnHandle(amountColumnIdentity, (io.trino.spi.type.Type)amountColumnType, (List)ImmutableList.of(), (io.trino.spi.type.Type)amountColumnType, true, Optional.empty());
        BigDecimal amountColumnValue = new BigDecimal("1234567.65");
        Schema tableSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)dateColumnIdentity.getId(), (String)dateColumnName, (Type)Types.DateType.get()), Types.NestedField.optional((int)receiptColumnIdentity.getId(), (String)receiptColumnName, (Type)Types.StringType.get()), Types.NestedField.optional((int)amountColumnIdentity.getId(), (String)amountColumnName, (Type)Types.DecimalType.of((int)10, (int)2))});
        PartitionSpec partitionSpec = PartitionSpec.builderFor((Schema)tableSchema).identity(dateColumnName).build();
        IcebergConfig icebergConfig = new IcebergConfig();
        HiveTransactionHandle transaction = new HiveTransactionHandle(false);
        try (TempFile file = new TempFile();){
            Files.delete(file.path());
            LocalOutputFile outputFile = new LocalOutputFile(file.file());
            LocalInputFile inputFile = new LocalInputFile(file.file());
            ImmutableList columnNames = ImmutableList.of((Object)dateColumnName, (Object)receiptColumnName, (Object)amountColumnName);
            ImmutableList types = ImmutableList.of((Object)DateType.DATE, (Object)VarcharType.VARCHAR, (Object)amountColumnType);
            try (OrcWriter writer = new OrcWriter((OrcDataSink)OutputStreamOrcDataSink.create((TrinoOutputFile)outputFile), (List)columnNames, (List)types, OrcTypeConverter.toOrcType((Schema)tableSchema), CompressionKind.NONE, new OrcWriterOptions(), (Map)ImmutableMap.of(), true, OrcWriteValidation.OrcWriteValidationMode.BOTH, new OrcWriterStats());){
                BlockBuilder dateBuilder = DateType.DATE.createFixedSizeBlockBuilder(1);
                DateType.DATE.writeLong(dateBuilder, dateColumnValue);
                VariableWidthBlockBuilder receiptBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1);
                VarcharType.VARCHAR.writeString((BlockBuilder)receiptBuilder, receiptColumnValue);
                BlockBuilder amountBuilder = amountColumnType.createFixedSizeBlockBuilder(1);
                Decimals.writeShortDecimal((BlockBuilder)amountBuilder, (long)amountColumnValue.unscaledValue().longValueExact());
                writer.write(new Page(new Block[]{dateBuilder.build(), receiptBuilder.build(), amountBuilder.build()}));
            }
            IcebergSplit split = new IcebergSplit(inputFile.toString(), 0L, inputFile.length(), inputFile.length(), -1L, IcebergFileFormat.ORC, PartitionSpecParser.toJson((PartitionSpec)partitionSpec), PartitionData.toJson((StructLike)new PartitionData(new Object[]{dateColumnValue})), (List)ImmutableList.of(), SplitWeight.standard(), TupleDomain.all(), (Map)ImmutableMap.of(), 0L);
            String tablePath = inputFile.location().fileName();
            TableHandle tableHandle = new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new IcebergTableHandle(CatalogHandle.fromId((String)"iceberg:NORMAL:v12345"), "test_schema", tableName, TableType.DATA, Optional.empty(), SchemaParser.toJson((Schema)tableSchema), Optional.of(PartitionSpecParser.toJson((PartitionSpec)partitionSpec)), 2, TupleDomain.all(), TupleDomain.all(), OptionalLong.empty(), (Set)ImmutableSet.of((Object)dateColumnHandle), Optional.empty(), tablePath, (Map)ImmutableMap.of(), Optional.empty(), false, Optional.empty(), (Set)ImmutableSet.of(), Optional.of(false)), (ConnectorTransactionHandle)transaction);
            TupleDomain differentDatePredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)dateColumnHandle, (Object)Domain.singleValue((io.trino.spi.type.Type)DateType.DATE, (Object)LocalDate.of(2023, 2, 2).toEpochDay())));
            TupleDomain nonOverlappingDatePredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)dateColumnHandle, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((io.trino.spi.type.Type)DateType.DATE, (Object)LocalDate.of(2023, 2, 2).toEpochDay()), (Range[])new Range[0]), (boolean)true)));
            for (TupleDomain partitionPredicate : List.of(differentDatePredicate, nonOverlappingDatePredicate)) {
                ConnectorPageSource emptyPageSource = TestIcebergNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, icebergConfig, split, tableHandle, (List<ColumnHandle>)ImmutableList.of((Object)dateColumnHandle, (Object)receiptColumnHandle, (Object)amountColumnHandle), TestIcebergNodeLocalDynamicSplitPruning.getDynamicFilter((TupleDomain<ColumnHandle>)partitionPredicate));
                try {
                    Assertions.assertThat((Object)emptyPageSource.getNextSourcePage()).isNull();
                }
                finally {
                    if (emptyPageSource == null) continue;
                    emptyPageSource.close();
                }
            }
            TupleDomain sameDatePredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)dateColumnHandle, (Object)Domain.singleValue((io.trino.spi.type.Type)DateType.DATE, (Object)dateColumnValue)));
            TupleDomain overlappingDatePredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)dateColumnHandle, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((io.trino.spi.type.Type)DateType.DATE, (Object)LocalDate.of(2023, 1, 1).toEpochDay(), (boolean)true, (Object)LocalDate.of(2023, 2, 1).toEpochDay(), (boolean)false), (Range[])new Range[0]), (boolean)true)));
            for (TupleDomain partitionPredicate : List.of(sameDatePredicate, overlappingDatePredicate)) {
                ConnectorPageSource nonEmptyPageSource = TestIcebergNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, icebergConfig, split, tableHandle, (List<ColumnHandle>)ImmutableList.of((Object)dateColumnHandle, (Object)receiptColumnHandle, (Object)amountColumnHandle), TestIcebergNodeLocalDynamicSplitPruning.getDynamicFilter((TupleDomain<ColumnHandle>)partitionPredicate));
                try {
                    SourcePage page = nonEmptyPageSource.getNextSourcePage();
                    Assertions.assertThat((Object)page).isNotNull();
                    Assertions.assertThat((int)page.getPositionCount()).isEqualTo(1);
                    Assertions.assertThat((int)IntegerType.INTEGER.getInt(page.getBlock(0), 0)).isEqualTo(dateColumnValue);
                    Assertions.assertThat((String)VarcharType.VARCHAR.getSlice(page.getBlock(1), 0).toStringUtf8()).isEqualTo(receiptColumnValue);
                    Assertions.assertThat((BigDecimal)((SqlDecimal)amountColumnType.getObjectValue(null, page.getBlock(2), 0)).toBigDecimal()).isEqualTo((Object)amountColumnValue);
                }
                finally {
                    if (nonEmptyPageSource == null) continue;
                    nonEmptyPageSource.close();
                }
            }
        }
    }

    @Test
    public void testDynamicSplitPruningWithExplicitPartitionFilterPartitionEvolution() throws IOException {
        String tableName = "sales_table";
        String yearColumnName = "year";
        ColumnIdentity yearColumnIdentity = new ColumnIdentity(1, yearColumnName, ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        IcebergColumnHandle yearColumnHandle = new IcebergColumnHandle(yearColumnIdentity, (io.trino.spi.type.Type)IntegerType.INTEGER, (List)ImmutableList.of(), (io.trino.spi.type.Type)IntegerType.INTEGER, true, Optional.empty());
        long yearColumnValue = 2023L;
        String monthColumnName = "month";
        ColumnIdentity monthColumnIdentity = new ColumnIdentity(2, monthColumnName, ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        IcebergColumnHandle monthColumnHandle = new IcebergColumnHandle(monthColumnIdentity, (io.trino.spi.type.Type)IntegerType.INTEGER, (List)ImmutableList.of(), (io.trino.spi.type.Type)IntegerType.INTEGER, true, Optional.empty());
        long monthColumnValue = 1L;
        String receiptColumnName = "receipt";
        ColumnIdentity receiptColumnIdentity = new ColumnIdentity(3, receiptColumnName, ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        IcebergColumnHandle receiptColumnHandle = new IcebergColumnHandle(receiptColumnIdentity, (io.trino.spi.type.Type)VarcharType.VARCHAR, (List)ImmutableList.of(), (io.trino.spi.type.Type)VarcharType.VARCHAR, true, Optional.empty());
        String receiptColumnValue = "#12345";
        String amountColumnName = "amount";
        ColumnIdentity amountColumnIdentity = new ColumnIdentity(4, amountColumnName, ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        DecimalType amountColumnType = DecimalType.createDecimalType((int)10, (int)2);
        IcebergColumnHandle amountColumnHandle = new IcebergColumnHandle(amountColumnIdentity, (io.trino.spi.type.Type)amountColumnType, (List)ImmutableList.of(), (io.trino.spi.type.Type)amountColumnType, true, Optional.empty());
        BigDecimal amountColumnValue = new BigDecimal("1234567.65");
        Schema tableSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)yearColumnIdentity.getId(), (String)yearColumnName, (Type)Types.IntegerType.get()), Types.NestedField.optional((int)monthColumnIdentity.getId(), (String)monthColumnName, (Type)Types.IntegerType.get()), Types.NestedField.optional((int)receiptColumnIdentity.getId(), (String)receiptColumnName, (Type)Types.StringType.get()), Types.NestedField.optional((int)amountColumnIdentity.getId(), (String)amountColumnName, (Type)Types.DecimalType.of((int)10, (int)2))});
        PartitionSpec partitionSpec = PartitionSpec.builderFor((Schema)tableSchema).identity(yearColumnName).build();
        IcebergConfig icebergConfig = new IcebergConfig();
        HiveTransactionHandle transaction = new HiveTransactionHandle(false);
        try (TempFile file = new TempFile();){
            Files.delete(file.path());
            LocalOutputFile outputFile = new LocalOutputFile(file.file());
            LocalInputFile inputFile = new LocalInputFile(file.file());
            ImmutableList columnNames = ImmutableList.of((Object)yearColumnName, (Object)monthColumnName, (Object)receiptColumnName, (Object)amountColumnName);
            ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR, (Object)amountColumnType);
            try (OrcWriter writer = new OrcWriter((OrcDataSink)OutputStreamOrcDataSink.create((TrinoOutputFile)outputFile), (List)columnNames, (List)types, OrcTypeConverter.toOrcType((Schema)tableSchema), CompressionKind.NONE, new OrcWriterOptions(), (Map)ImmutableMap.of(), true, OrcWriteValidation.OrcWriteValidationMode.BOTH, new OrcWriterStats());){
                BlockBuilder yearBuilder = IntegerType.INTEGER.createFixedSizeBlockBuilder(1);
                IntegerType.INTEGER.writeLong(yearBuilder, yearColumnValue);
                BlockBuilder monthBuilder = IntegerType.INTEGER.createFixedSizeBlockBuilder(1);
                IntegerType.INTEGER.writeLong(monthBuilder, monthColumnValue);
                VariableWidthBlockBuilder receiptBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1);
                VarcharType.VARCHAR.writeString((BlockBuilder)receiptBuilder, receiptColumnValue);
                BlockBuilder amountBuilder = amountColumnType.createFixedSizeBlockBuilder(1);
                Decimals.writeShortDecimal((BlockBuilder)amountBuilder, (long)amountColumnValue.unscaledValue().longValueExact());
                writer.write(new Page(new Block[]{yearBuilder.build(), monthBuilder.build(), receiptBuilder.build(), amountBuilder.build()}));
            }
            IcebergSplit split = new IcebergSplit(inputFile.toString(), 0L, inputFile.length(), inputFile.length(), -1L, IcebergFileFormat.ORC, PartitionSpecParser.toJson((PartitionSpec)partitionSpec), PartitionData.toJson((StructLike)new PartitionData(new Object[]{yearColumnValue})), (List)ImmutableList.of(), SplitWeight.standard(), TupleDomain.all(), (Map)ImmutableMap.of(), 0L);
            String tablePath = inputFile.location().fileName();
            TableHandle tableHandle = new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new IcebergTableHandle(CatalogHandle.fromId((String)"iceberg:NORMAL:v12345"), "test_schema", tableName, TableType.DATA, Optional.empty(), SchemaParser.toJson((Schema)tableSchema), Optional.of(PartitionSpecParser.toJson((PartitionSpec)partitionSpec)), 2, TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)yearColumnHandle, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)2023L, (boolean)true, (Object)2024L, (boolean)true), (Range[])new Range[0]), (boolean)true))), TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)monthColumnHandle, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)1L, (boolean)true, (Object)12L, (boolean)true), (Range[])new Range[0]), (boolean)true))), OptionalLong.empty(), (Set)ImmutableSet.of((Object)yearColumnHandle, (Object)monthColumnHandle, (Object)receiptColumnHandle, (Object)amountColumnHandle), Optional.empty(), tablePath, (Map)ImmutableMap.of(), Optional.empty(), false, Optional.empty(), (Set)ImmutableSet.of(), Optional.of(false)), (ConnectorTransactionHandle)transaction);
            TupleDomain differentYearPredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)yearColumnHandle, (Object)Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)2024L)));
            TupleDomain sameYearAndDifferentMonthPredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)yearColumnHandle, (Object)Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)2023L), (Object)monthColumnHandle, (Object)Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)2L)));
            for (TupleDomain partitionPredicate : List.of(differentYearPredicate, sameYearAndDifferentMonthPredicate)) {
                ConnectorPageSource emptyPageSource = TestIcebergNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, icebergConfig, split, tableHandle, (List<ColumnHandle>)ImmutableList.of((Object)yearColumnHandle, (Object)monthColumnHandle, (Object)receiptColumnHandle, (Object)amountColumnHandle), TestIcebergNodeLocalDynamicSplitPruning.getDynamicFilter((TupleDomain<ColumnHandle>)partitionPredicate));
                try {
                    Assertions.assertThat((Object)emptyPageSource.getNextSourcePage()).isNull();
                }
                finally {
                    if (emptyPageSource == null) continue;
                    emptyPageSource.close();
                }
            }
            TupleDomain sameYearPredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)yearColumnHandle, (Object)Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)2023L)));
            TupleDomain sameYearAndMonthPredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)yearColumnHandle, (Object)Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)2023L), (Object)monthColumnHandle, (Object)Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)1L)));
            for (TupleDomain partitionPredicate : List.of(sameYearPredicate, sameYearAndMonthPredicate)) {
                ConnectorPageSource nonEmptyPageSource = TestIcebergNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, icebergConfig, split, tableHandle, (List<ColumnHandle>)ImmutableList.of((Object)yearColumnHandle, (Object)monthColumnHandle, (Object)receiptColumnHandle, (Object)amountColumnHandle), TestIcebergNodeLocalDynamicSplitPruning.getDynamicFilter((TupleDomain<ColumnHandle>)partitionPredicate));
                try {
                    SourcePage page = nonEmptyPageSource.getNextSourcePage();
                    Assertions.assertThat((Object)page).isNotNull();
                    Assertions.assertThat((int)page.getPositionCount()).isEqualTo(1);
                    Assertions.assertThat((int)IntegerType.INTEGER.getInt(page.getBlock(0), 0)).isEqualTo(2023L);
                    Assertions.assertThat((int)IntegerType.INTEGER.getInt(page.getBlock(1), 0)).isEqualTo(1L);
                    Assertions.assertThat((String)VarcharType.VARCHAR.getSlice(page.getBlock(2), 0).toStringUtf8()).isEqualTo(receiptColumnValue);
                    Assertions.assertThat((BigDecimal)((SqlDecimal)amountColumnType.getObjectValue(null, page.getBlock(3), 0)).toBigDecimal()).isEqualTo((Object)amountColumnValue);
                }
                finally {
                    if (nonEmptyPageSource == null) continue;
                    nonEmptyPageSource.close();
                }
            }
        }
    }

    private static ConnectorPageSource createTestingPageSource(HiveTransactionHandle transaction, IcebergConfig icebergConfig, IcebergSplit split, TableHandle tableHandle, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        FileFormatDataSourceStats stats = new FileFormatDataSourceStats();
        IcebergPageSourceProviderFactory factory = new IcebergPageSourceProviderFactory((IcebergFileSystemFactory)new DefaultIcebergFileSystemFactory((TrinoFileSystemFactory)new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.HDFS_FILE_SYSTEM_STATS)), stats, ORC_READER_CONFIG, PARQUET_READER_CONFIG, InternalTypeManager.TESTING_TYPE_MANAGER);
        return factory.createPageSourceProvider().createPageSource((ConnectorTransactionHandle)transaction, (ConnectorSession)TestIcebergNodeLocalDynamicSplitPruning.getSession(icebergConfig), (ConnectorSplit)split, tableHandle.connectorHandle(), columns, dynamicFilter);
    }

    private static TestingConnectorSession getSession(IcebergConfig icebergConfig) {
        return TestingConnectorSession.builder().setPropertyMetadata(new IcebergSessionProperties(icebergConfig, ORC_READER_CONFIG, ORC_WRITER_CONFIG, PARQUET_READER_CONFIG, PARQUET_WRITER_CONFIG).getSessionProperties()).build();
    }

    private static DynamicFilter getDynamicFilter(final TupleDomain<ColumnHandle> tupleDomain) {
        return new DynamicFilter(){

            public Set<ColumnHandle> getColumnsCovered() {
                return tupleDomain.getDomains().map(Map::keySet).orElseGet(ImmutableSet::of);
            }

            public CompletableFuture<?> isBlocked() {
                return CompletableFuture.completedFuture(null);
            }

            public boolean isComplete() {
                return true;
            }

            public boolean isAwaitable() {
                return false;
            }

            public TupleDomain<ColumnHandle> getCurrentPredicate() {
                return tupleDomain;
            }
        };
    }
}

