/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.Session;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.TrinoViewHiveMetastore;
import io.trino.plugin.iceberg.DataFileRecord;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.TestingIcebergPlugin;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.file.FileMetastoreTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.hms.TrinoHiveCatalog;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.TypeManager;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.FileContent;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIcebergOrcMetricsCollection
extends AbstractTestQueryFramework {
    private TrinoCatalog trinoCatalog;
    private IcebergTableOperationsProvider tableOperationsProvider;

    protected QueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().setCatalog("iceberg").setSchema("test_schema").setSystemProperty("task_concurrency", "1").setSystemProperty("task_min_writer_count", "1").setSystemProperty("task_max_writer_count", "1").setSystemProperty("initial_splits_per_node", "1").setSystemProperty("max_drivers_per_task", "1").setCatalogSessionProperty("iceberg", "orc_string_statistics_limit", "2147483647B").build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).setWorkerCount(0).build();
        File baseDir = queryRunner.getCoordinator().getBaseDataDir().resolve("iceberg_data").toFile();
        queryRunner.installPlugin((Plugin)new TestingIcebergPlugin(baseDir.toPath()));
        queryRunner.createCatalog("iceberg", "iceberg", (Map)ImmutableMap.of((Object)"iceberg.file-format", (Object)"ORC"));
        TrinoFileSystemFactory fileSystemFactory = IcebergTestUtils.getFileSystemFactory((QueryRunner)queryRunner);
        this.tableOperationsProvider = new FileMetastoreTableOperationsProvider(fileSystemFactory);
        HiveMetastore metastore = IcebergTestUtils.getHiveMetastore((QueryRunner)queryRunner);
        CachingHiveMetastore cachingHiveMetastore = CachingHiveMetastore.createPerTransactionCache((HiveMetastore)metastore, (long)1000L);
        this.trinoCatalog = new TrinoHiveCatalog(new CatalogName("catalog"), cachingHiveMetastore, new TrinoViewHiveMetastore((HiveMetastore)cachingHiveMetastore, false, "trino-version", "test"), fileSystemFactory, (TypeManager)new TestingTypeManager(), this.tableOperationsProvider, false, false, false, new IcebergConfig().isHideMaterializedViewStorageTable(), MoreExecutors.directExecutor());
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog("tpch", "tpch");
        queryRunner.execute("CREATE SCHEMA test_schema");
        return queryRunner;
    }

    @Test
    public void testMetrics() {
        this.assertUpdate("create table no_metrics (c1 varchar, c2 varchar)");
        BaseTable table = IcebergUtil.loadIcebergTable((TrinoCatalog)this.trinoCatalog, (IcebergTableOperationsProvider)this.tableOperationsProvider, (ConnectorSession)IcebergTestUtils.SESSION, (SchemaTableName)new SchemaTableName("test_schema", "no_metrics"));
        table.updateProperties().set("write.metadata.metrics.default", "none").commit();
        this.assertUpdate("insert into no_metrics values ('abcd', 'a')", 1L);
        List materializedRows = this.computeActual("select * from \"no_metrics$files\"").getMaterializedRows();
        DataFileRecord datafile = DataFileRecord.toDataFileRecord((MaterializedRow)materializedRows.get(0));
        Assertions.assertThat((long)datafile.getRecordCount()).isEqualTo(1L);
        Assertions.assertThat(datafile.getValueCounts()).isNull();
        Assertions.assertThat(datafile.getNullValueCounts()).isNull();
        Assertions.assertThat(datafile.getUpperBounds()).isNull();
        Assertions.assertThat(datafile.getLowerBounds()).isNull();
        Assertions.assertThat(datafile.getColumnSizes()).isNull();
        this.assertUpdate("create table c1_metrics (c1 varchar, c2 varchar)");
        table = IcebergUtil.loadIcebergTable((TrinoCatalog)this.trinoCatalog, (IcebergTableOperationsProvider)this.tableOperationsProvider, (ConnectorSession)IcebergTestUtils.SESSION, (SchemaTableName)new SchemaTableName("test_schema", "c1_metrics"));
        table.updateProperties().set("write.metadata.metrics.default", "none").set("write.metadata.metrics.column.c1", "full").commit();
        this.assertUpdate("insert into c1_metrics values ('b', 'a')", 1L);
        materializedRows = this.computeActual("select * from \"c1_metrics$files\"").getMaterializedRows();
        datafile = DataFileRecord.toDataFileRecord((MaterializedRow)materializedRows.get(0));
        Assertions.assertThat((long)datafile.getRecordCount()).isEqualTo(1L);
        Assertions.assertThat(datafile.getValueCounts()).hasSize(1);
        Assertions.assertThat(datafile.getNullValueCounts()).hasSize(1);
        Assertions.assertThat(datafile.getUpperBounds()).hasSize(1);
        Assertions.assertThat(datafile.getLowerBounds()).hasSize(1);
        this.assertUpdate("create table c1_metrics_count (c1 varchar, c2 varchar)");
        table = IcebergUtil.loadIcebergTable((TrinoCatalog)this.trinoCatalog, (IcebergTableOperationsProvider)this.tableOperationsProvider, (ConnectorSession)IcebergTestUtils.SESSION, (SchemaTableName)new SchemaTableName("test_schema", "c1_metrics_count"));
        table.updateProperties().set("write.metadata.metrics.default", "none").set("write.metadata.metrics.column.c1", "counts").commit();
        this.assertUpdate("insert into c1_metrics_count values ('b', 'a')", 1L);
        materializedRows = this.computeActual("select * from \"c1_metrics_count$files\"").getMaterializedRows();
        datafile = DataFileRecord.toDataFileRecord((MaterializedRow)materializedRows.get(0));
        Assertions.assertThat((long)datafile.getRecordCount()).isEqualTo(1L);
        Assertions.assertThat(datafile.getValueCounts()).hasSize(1);
        Assertions.assertThat(datafile.getNullValueCounts()).hasSize(1);
        Assertions.assertThat(datafile.getUpperBounds()).isNull();
        Assertions.assertThat(datafile.getLowerBounds()).isNull();
        this.assertUpdate("create table c1_metrics_truncate (c1 varchar, c2 varchar)");
        table = IcebergUtil.loadIcebergTable((TrinoCatalog)this.trinoCatalog, (IcebergTableOperationsProvider)this.tableOperationsProvider, (ConnectorSession)IcebergTestUtils.SESSION, (SchemaTableName)new SchemaTableName("test_schema", "c1_metrics_truncate"));
        table.updateProperties().set("write.metadata.metrics.default", "none").set("write.metadata.metrics.column.c1", "truncate(10)").commit();
        this.assertUpdate("insert into c1_metrics_truncate values ('abcaabcaabcaabca', 'a')", 1L);
        materializedRows = this.computeActual("select * from \"c1_metrics_truncate$files\"").getMaterializedRows();
        datafile = DataFileRecord.toDataFileRecord((MaterializedRow)materializedRows.get(0));
        Assertions.assertThat((long)datafile.getRecordCount()).isEqualTo(1L);
        Assertions.assertThat(datafile.getValueCounts()).hasSize(1);
        Assertions.assertThat(datafile.getNullValueCounts()).hasSize(1);
        datafile.getUpperBounds().forEach((k, v) -> Assertions.assertThat((int)v.length()).isEqualTo(10));
        datafile.getLowerBounds().forEach((k, v) -> Assertions.assertThat((int)v.length()).isEqualTo(10));
        this.assertUpdate("create table c_metrics (c1 varchar, c2 varchar)");
        table = IcebergUtil.loadIcebergTable((TrinoCatalog)this.trinoCatalog, (IcebergTableOperationsProvider)this.tableOperationsProvider, (ConnectorSession)IcebergTestUtils.SESSION, (SchemaTableName)new SchemaTableName("test_schema", "c_metrics"));
        table.updateProperties().set("write.metadata.metrics.column.c1", "full").set("write.metadata.metrics.column.c2", "full").commit();
        this.assertUpdate("insert into c_metrics values ('b', 'a')", 1L);
        materializedRows = this.computeActual("select * from \"c_metrics$files\"").getMaterializedRows();
        datafile = DataFileRecord.toDataFileRecord((MaterializedRow)materializedRows.get(0));
        Assertions.assertThat((long)datafile.getRecordCount()).isEqualTo(1L);
        Assertions.assertThat(datafile.getValueCounts()).hasSize(2);
        Assertions.assertThat(datafile.getNullValueCounts()).hasSize(2);
        Assertions.assertThat(datafile.getUpperBounds()).hasSize(2);
        Assertions.assertThat(datafile.getLowerBounds()).hasSize(2);
        this.assertUpdate("create table metrics (c1 varchar, c2 varchar)");
        table = IcebergUtil.loadIcebergTable((TrinoCatalog)this.trinoCatalog, (IcebergTableOperationsProvider)this.tableOperationsProvider, (ConnectorSession)IcebergTestUtils.SESSION, (SchemaTableName)new SchemaTableName("test_schema", "metrics"));
        table.updateProperties().set("write.metadata.metrics.default", "full").commit();
        this.assertUpdate("insert into metrics values ('b', 'a')", 1L);
        materializedRows = this.computeActual("select * from \"metrics$files\"").getMaterializedRows();
        datafile = DataFileRecord.toDataFileRecord((MaterializedRow)materializedRows.get(0));
        Assertions.assertThat((long)datafile.getRecordCount()).isEqualTo(1L);
        Assertions.assertThat(datafile.getValueCounts()).hasSize(2);
        Assertions.assertThat(datafile.getNullValueCounts()).hasSize(2);
        Assertions.assertThat(datafile.getUpperBounds()).hasSize(2);
        Assertions.assertThat(datafile.getLowerBounds()).hasSize(2);
    }

    @Test
    public void testBasic() {
        this.assertUpdate("CREATE TABLE orders WITH (format = 'ORC') AS SELECT * FROM tpch.tiny.orders", 15000L);
        MaterializedResult materializedResult = this.computeActual("SELECT * FROM \"orders$files\"");
        Assertions.assertThat((int)materializedResult.getRowCount()).isEqualTo(1);
        DataFileRecord datafile = DataFileRecord.toDataFileRecord((MaterializedRow)materializedResult.getMaterializedRows().get(0));
        Assertions.assertThat((int)datafile.getContent()).isEqualTo(FileContent.DATA.id());
        Assertions.assertThat((String)datafile.getFileFormat()).isEqualTo("ORC");
        Assertions.assertThat((long)datafile.getRecordCount()).isEqualTo(15000L);
        datafile.getValueCounts().values().forEach(valueCount -> Assertions.assertThat((Long)valueCount).isEqualTo((Object)15000L));
        datafile.getNullValueCounts().values().forEach(nullValueCount -> Assertions.assertThat((Long)nullValueCount).isEqualTo((Object)0L));
        Assertions.assertThat(datafile.getNanValueCounts()).isNull();
        Map<Integer, String> lowerBounds = datafile.getLowerBounds();
        Assertions.assertThat(lowerBounds).containsEntry((Object)1, (Object)"1");
        Assertions.assertThat(lowerBounds).containsEntry((Object)2, (Object)"1");
        Assertions.assertThat(lowerBounds).containsEntry((Object)3, (Object)"F");
        Assertions.assertThat(lowerBounds).containsEntry((Object)4, (Object)"874.89");
        Assertions.assertThat(lowerBounds).containsEntry((Object)5, (Object)"1992-01-01");
        Assertions.assertThat(lowerBounds).containsEntry((Object)6, (Object)"1-URGENT");
        Assertions.assertThat(lowerBounds).containsEntry((Object)7, (Object)"Clerk#000000001");
        Assertions.assertThat(lowerBounds).containsEntry((Object)8, (Object)"0");
        Assertions.assertThat(lowerBounds).containsEntry((Object)9, (Object)" about the accou");
        Map<Integer, String> upperBounds = datafile.getUpperBounds();
        Assertions.assertThat(upperBounds).containsEntry((Object)1, (Object)"60000");
        Assertions.assertThat(upperBounds).containsEntry((Object)2, (Object)"1499");
        Assertions.assertThat(upperBounds).containsEntry((Object)3, (Object)"P");
        Assertions.assertThat(upperBounds).containsEntry((Object)4, (Object)"466001.28");
        Assertions.assertThat(upperBounds).containsEntry((Object)5, (Object)"1998-08-02");
        Assertions.assertThat(upperBounds).containsEntry((Object)6, (Object)"5-LOW");
        Assertions.assertThat(upperBounds).containsEntry((Object)7, (Object)"Clerk#000001000");
        Assertions.assertThat(upperBounds).containsEntry((Object)8, (Object)"0");
        Assertions.assertThat(upperBounds).containsEntry((Object)9, (Object)"zzle. carefully!");
        this.assertUpdate("DROP TABLE orders");
    }

    @Test
    public void testWithNulls() {
        this.assertUpdate("CREATE TABLE test_with_nulls (_integer INTEGER, _real REAL, _string VARCHAR, _timestamp TIMESTAMP(6))");
        this.assertUpdate("INSERT INTO test_with_nulls VALUES (7, 3.4, 'aaa', TIMESTAMP '2020-01-01 00:00:00.123456'),(3, 4.5, 'bbb', TIMESTAMP '2021-02-01 00:23:10.398102'),(4, null, 'ccc', null),(null, null, 'ddd', null)", 4L);
        MaterializedResult materializedResult = this.computeActual("SELECT * FROM \"test_with_nulls$files\"");
        Assertions.assertThat((int)materializedResult.getRowCount()).isEqualTo(1);
        DataFileRecord datafile = DataFileRecord.toDataFileRecord((MaterializedRow)materializedResult.getMaterializedRows().get(0));
        datafile.getValueCounts().values().forEach(valueCount -> Assertions.assertThat((Long)valueCount).isEqualTo((Object)4L));
        Assertions.assertThat(datafile.getNullValueCounts()).containsEntry((Object)1, (Object)1L);
        Assertions.assertThat(datafile.getNullValueCounts()).containsEntry((Object)2, (Object)2L);
        Assertions.assertThat(datafile.getNullValueCounts()).containsEntry((Object)3, (Object)0L);
        Assertions.assertThat(datafile.getNullValueCounts()).containsEntry((Object)4, (Object)2L);
        Assertions.assertThat(datafile.getLowerBounds()).containsEntry((Object)1, (Object)"3");
        Assertions.assertThat(datafile.getLowerBounds()).containsEntry((Object)2, (Object)"3.4");
        Assertions.assertThat(datafile.getLowerBounds()).containsEntry((Object)3, (Object)"aaa");
        Assertions.assertThat(datafile.getLowerBounds()).containsEntry((Object)4, (Object)"2020-01-01T00:00:00.123");
        this.assertUpdate("DROP TABLE test_with_nulls");
        this.assertUpdate("CREATE TABLE test_all_nulls (_integer INTEGER)");
        this.assertUpdate("INSERT INTO test_all_nulls VALUES null, null, null", 3L);
        materializedResult = this.computeActual("SELECT * FROM \"test_all_nulls$files\"");
        Assertions.assertThat((int)materializedResult.getRowCount()).isEqualTo(1);
        datafile = DataFileRecord.toDataFileRecord((MaterializedRow)materializedResult.getMaterializedRows().get(0));
        Assertions.assertThat(datafile.getValueCounts()).containsEntry((Object)1, (Object)3L);
        Assertions.assertThat(datafile.getNullValueCounts()).containsEntry((Object)1, (Object)3L);
        Assertions.assertThat(datafile.getLowerBounds()).isNull();
        Assertions.assertThat(datafile.getUpperBounds()).isNull();
        this.assertUpdate("DROP TABLE test_all_nulls");
    }

    @Test
    public void testWithNaNs() {
        this.assertUpdate("CREATE TABLE test_with_nans (_int INTEGER, _real REAL, _double DOUBLE)");
        this.assertUpdate("INSERT INTO test_with_nans VALUES (1, 1.1, 1.1), (2, nan(), 4.5), (3, 4.6, -nan())", 3L);
        MaterializedResult materializedResult = this.computeActual("SELECT * FROM \"test_with_nans$files\"");
        Assertions.assertThat((int)materializedResult.getRowCount()).isEqualTo(1);
        DataFileRecord datafile = DataFileRecord.toDataFileRecord((MaterializedRow)materializedResult.getMaterializedRows().get(0));
        datafile.getValueCounts().values().forEach(valueCount -> Assertions.assertThat((Long)valueCount).isEqualTo((Object)3L));
        Assertions.assertThat(datafile.getNanValueCounts()).hasSize(2);
        Assertions.assertThat(datafile.getNanValueCounts()).containsEntry((Object)2, (Object)1L);
        Assertions.assertThat(datafile.getNanValueCounts()).containsEntry((Object)3, (Object)1L);
        Assertions.assertThat((String)datafile.getLowerBounds().get(2)).isNull();
        Assertions.assertThat((String)datafile.getLowerBounds().get(3)).isNull();
        Assertions.assertThat((String)datafile.getUpperBounds().get(2)).isNull();
        Assertions.assertThat((String)datafile.getUpperBounds().get(3)).isNull();
        this.assertUpdate("DROP TABLE test_with_nans");
    }

    @Test
    public void testNestedTypes() {
        this.assertUpdate("CREATE TABLE test_nested_types (col1 INTEGER, col2 ROW (f1 INTEGER, f2 ARRAY(INTEGER), f3 DOUBLE))");
        this.assertUpdate("INSERT INTO test_nested_types VALUES (7, ROW(3, ARRAY[10, 11, 19], 1.9)), (-9, ROW(4, ARRAY[13, 16, 20], -2.9)), (8, ROW(0, ARRAY[14, 17, 21], 3.9)), (3, ROW(10, ARRAY[15, 18, 22], 4.9))", 4L);
        MaterializedResult materializedResult = this.computeActual("SELECT * FROM \"test_nested_types$files\"");
        Assertions.assertThat((int)materializedResult.getRowCount()).isEqualTo(1);
        DataFileRecord datafile = DataFileRecord.toDataFileRecord((MaterializedRow)materializedResult.getMaterializedRows().get(0));
        Map<Integer, String> lowerBounds = datafile.getLowerBounds();
        Map<Integer, String> upperBounds = datafile.getUpperBounds();
        Assertions.assertThat(lowerBounds).hasSize(3);
        Assertions.assertThat(upperBounds).hasSize(3);
        Assertions.assertThat(lowerBounds).containsEntry((Object)1, (Object)"-9");
        Assertions.assertThat(upperBounds).containsEntry((Object)1, (Object)"8");
        Assertions.assertThat(lowerBounds).containsEntry((Object)3, (Object)"0");
        Assertions.assertThat(upperBounds).containsEntry((Object)3, (Object)"10");
        Assertions.assertThat(lowerBounds).containsEntry((Object)5, (Object)"-2.9");
        Assertions.assertThat(upperBounds).containsEntry((Object)5, (Object)"4.9");
        this.assertUpdate("DROP TABLE test_nested_types");
    }

    @Test
    public void testWithTimestamps() {
        this.assertUpdate("CREATE TABLE test_timestamp (_timestamp TIMESTAMP(6)) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO test_timestamp VALUES(TIMESTAMP '2021-01-01 00:00:00.111111'), (TIMESTAMP '2021-01-01 00:00:00.222222'), (TIMESTAMP '2021-01-31 00:00:00.333333')", 3L);
        MaterializedResult materializedResult = this.computeActual("SELECT * FROM \"test_timestamp$files\"");
        Assertions.assertThat((int)materializedResult.getRowCount()).isEqualTo(1);
        DataFileRecord datafile = DataFileRecord.toDataFileRecord((MaterializedRow)materializedResult.getMaterializedRows().get(0));
        Assertions.assertThat((String)datafile.getFileFormat()).isEqualTo("ORC");
        Assertions.assertThat((long)datafile.getRecordCount()).isEqualTo(3L);
        datafile.getValueCounts().values().forEach(valueCount -> Assertions.assertThat((Long)valueCount).isEqualTo((Object)3L));
        datafile.getNullValueCounts().values().forEach(nullValueCount -> Assertions.assertThat((Long)nullValueCount).isEqualTo((Object)0L));
        Assertions.assertThat(datafile.getLowerBounds()).containsEntry((Object)1, (Object)"2021-01-01T00:00:00.111");
        this.assertQuery("SELECT min(_timestamp) FROM test_timestamp", "VALUES '2021-01-01 00:00:00.111111'");
        Assertions.assertThat(datafile.getUpperBounds()).containsEntry((Object)1, (Object)"2021-01-31T00:00:00.333999");
        this.assertQuery("SELECT max(_timestamp) FROM test_timestamp", "VALUES '2021-01-31 00:00:00.333333'");
        this.assertUpdate("DROP TABLE test_timestamp");
    }
}

