/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.testing.BaseOrcWithBloomFiltersTest;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.sql.TestTable;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;

public class TestIcebergOrcWithBloomFilters
extends BaseOrcWithBloomFiltersTest {
    protected QueryRunner createQueryRunner() throws Exception {
        return IcebergQueryRunner.builder().addIcebergProperty("iceberg.file-format", "ORC").addIcebergProperty("hive.orc.bloom-filters.enabled", "true").addIcebergProperty("hive.orc.default-bloom-filter-fpp", "0.001").build();
    }

    protected String getTableProperties(String bloomFilterColumnName, String bucketingColumnName) {
        return String.format("format = 'ORC', orc_bloom_filter_columns = ARRAY['%s'], partitioning = ARRAY['bucket(%s, 1)']", bloomFilterColumnName, bucketingColumnName);
    }

    @Test
    public void testBloomFilterPropertiesArePersistedDuringCreate() {
        String tableName = "test_metadata_write_properties_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + " (a bigint, b bigint, c bigint) WITH (format = 'orc',orc_bloom_filter_columns = array['a','b'],orc_bloom_filter_fpp = 0.1)");
        ((MapAssert)Assertions.assertThat(this.getTableProperties(tableName)).containsEntry((Object)"write.orc.bloom.filter.columns", (Object)"a,b")).containsEntry((Object)"write.orc.bloom.filter.fpp", (Object)"0.1");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + tableName))).contains(new CharSequence[]{"orc_bloom_filter_columns", "orc_bloom_filter_fpp"});
    }

    @Test
    void testBloomFilterPropertiesArePersistedDuringSetProperties() {
        String tableName = "test_metadata_write_properties_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + "(A bigint, b bigint, c bigint)");
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES orc_bloom_filter_columns = ARRAY['a','B']");
        Assertions.assertThat(this.getTableProperties(tableName)).containsEntry((Object)"write.orc.bloom.filter.columns", (Object)"a,b");
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES orc_bloom_filter_columns = ARRAY['a']");
        Assertions.assertThat(this.getTableProperties(tableName)).containsEntry((Object)"write.orc.bloom.filter.columns", (Object)"a");
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES orc_bloom_filter_columns = ARRAY[]");
        Assertions.assertThat(this.getTableProperties(tableName)).doesNotContainKey((Object)"write.orc.bloom.filter.columns");
    }

    @Test
    void testInvalidBloomFilterProperties() {
        String tableName = "test_invalid_bloom_filter_properties_" + TestingNames.randomNameSuffix();
        this.assertQueryFails("CREATE TABLE " + tableName + "(x int) WITH (orc_bloom_filter_columns = ARRAY['missing_column'])", "\\QOrc bloom filter columns [missing_column] not present in schema");
        this.assertQuerySucceeds("CREATE TABLE " + tableName + "(x array(integer))");
        this.assertQueryFails("ALTER TABLE " + tableName + " SET PROPERTIES orc_bloom_filter_columns = ARRAY['missing_column']", "\\QOrc bloom filter columns [missing_column] not present in schema");
    }

    @Test
    void testInvalidOrcBloomFilterPropertiesOnParquet() {
        try (TestTable table = this.newTrinoTable("test_orc_bloom_filter", "(x int) WITH (format = 'PARQUET')");){
            this.assertQueryFails("ALTER TABLE " + table.getName() + " SET PROPERTIES orc_bloom_filter_columns = ARRAY['x']", "Cannot specify orc_bloom_filter_columns table property for storage format: PARQUET");
        }
    }

    private Map<String, String> getTableProperties(String tableName) {
        return (Map)this.computeActual("SELECT key, value FROM \"" + tableName + "$properties\"").getMaterializedRows().stream().collect(ImmutableMap.toImmutableMap(row -> (String)row.getField(0), row -> (String)row.getField(1)));
    }
}

