/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.Session;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.testing.BaseComplexTypesPredicatePushDownTest;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import org.junit.jupiter.api.Test;

public class TestIcebergParquetComplexTypesPredicatePushDown
extends BaseComplexTypesPredicatePushDownTest {
    protected QueryRunner createQueryRunner() throws Exception {
        return IcebergQueryRunner.builder().addIcebergProperty("iceberg.file-format", "PARQUET").build();
    }

    protected final Session getSession() {
        return IcebergTestUtils.withSmallRowGroups(super.getSession());
    }

    @Test
    public void testIcebergParquetRowTypeRowGroupPruning() {
        String tableName = "test_nested_column_pruning_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (col1Row ROW(a BIGINT, b BIGINT), col2 BIGINT) WITH (sorted_by=ARRAY['col2'])");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM unnest(transform(SEQUENCE(1, 10000), x -> ROW(ROW(x*2, 100), x)))", 10000L);
        this.assertNoDataRead("SELECT * FROM " + tableName + " WHERE col1Row.a = 101");
        this.assertNoDataRead("SELECT * FROM " + tableName + " WHERE col1Row.a IS NULL");
        this.assertUpdate("DROP TABLE " + tableName);
    }
}

