/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.execution.QueryManagerConfig;
import io.trino.filesystem.Location;
import io.trino.operator.OperatorStats;
import io.trino.parquet.metadata.ParquetMetadata;
import io.trino.plugin.iceberg.BaseIcebergConnectorTest;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.testing.BaseConnectorTest;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.TestTable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIcebergParquetConnectorTest
extends BaseIcebergConnectorTest {
    public TestIcebergParquetConnectorTest() {
        super(IcebergFileFormat.PARQUET);
    }

    @Override
    protected boolean supportsIcebergFileStatistics(String typeName) {
        return true;
    }

    @Override
    protected boolean supportsRowGroupStatistics(String typeName) {
        return !typeName.equalsIgnoreCase("varbinary") && !typeName.equalsIgnoreCase("time") && !typeName.equalsIgnoreCase("time(6)") && !typeName.equalsIgnoreCase("timestamp(3) with time zone") && !typeName.equalsIgnoreCase("timestamp(6) with time zone");
    }

    @Test
    public void testRowGroupResetDictionary() {
        try (TestTable table = this.newTrinoTable("test_row_group_reset_dictionary", "(plain_col varchar, dict_col int)");){
            String tableName = table.getName();
            String values = IntStream.range(0, 100).mapToObj(i -> "('ABCDEFGHIJ" + i + "' , " + (i < 20 ? "1" : "null") + ")").collect(Collectors.joining(", "));
            this.assertUpdate(IcebergTestUtils.withSmallRowGroups(this.getSession()), "INSERT INTO " + tableName + " VALUES " + values, 100L);
            MaterializedResult result = this.getDistributedQueryRunner().execute("SELECT * FROM " + tableName);
            Assertions.assertThat((int)result.getRowCount()).isEqualTo(100);
        }
    }

    @Override
    protected Optional<BaseConnectorTest.SetColumnTypeSetup> filterSetColumnTypesDataProvider(BaseConnectorTest.SetColumnTypeSetup setup) {
        switch ("%s -> %s".formatted(setup.sourceColumnType(), setup.newColumnType())) {
            case "row(x integer) -> row(y integer)": {
                return Optional.of(setup.withNewValueLiteral("NULL"));
            }
        }
        return super.filterSetColumnTypesDataProvider(setup);
    }

    @Test
    public void testIgnoreParquetStatistics() {
        try (TestTable table = this.newTrinoTable("test_ignore_parquet_statistics", "WITH (sorted_by = ARRAY['custkey']) AS TABLE tpch.tiny.customer WITH NO DATA");){
            this.assertUpdate(IcebergTestUtils.withSmallRowGroups(this.getSession()), "INSERT INTO " + table.getName() + " TABLE tpch.tiny.customer", "VALUES 1500");
            String query = "SELECT * FROM " + table.getName() + " WHERE custkey = 100";
            DistributedQueryRunner queryRunner = this.getDistributedQueryRunner();
            QueryRunner.MaterializedResultWithPlan resultWithoutParquetStatistics = queryRunner.executeWithPlan(Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "parquet_ignore_statistics", "true").build(), query);
            OperatorStats queryStatsWithoutParquetStatistics = this.getOperatorStats(resultWithoutParquetStatistics.queryId());
            Assertions.assertThat((long)queryStatsWithoutParquetStatistics.getPhysicalInputPositions()).isGreaterThan(0L);
            QueryRunner.MaterializedResultWithPlan resultWithParquetStatistics = queryRunner.executeWithPlan(this.getSession(), query);
            OperatorStats queryStatsWithParquetStatistics = this.getOperatorStats(resultWithParquetStatistics.queryId());
            Assertions.assertThat((long)queryStatsWithParquetStatistics.getPhysicalInputPositions()).isGreaterThan(0L);
            Assertions.assertThat((long)queryStatsWithParquetStatistics.getPhysicalInputPositions()).isLessThan(queryStatsWithoutParquetStatistics.getPhysicalInputPositions());
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)resultWithParquetStatistics.result(), (Iterable)resultWithoutParquetStatistics.result());
        }
    }

    @Test
    public void testPushdownPredicateToParquetAfterColumnRename() {
        try (TestTable table = this.newTrinoTable("test_pushdown_predicate_statistics", "WITH (sorted_by = ARRAY['custkey']) AS TABLE tpch.tiny.customer WITH NO DATA");){
            this.assertUpdate(IcebergTestUtils.withSmallRowGroups(this.getSession()), "INSERT INTO " + table.getName() + " TABLE tpch.tiny.customer", "VALUES 1500");
            this.assertUpdate("ALTER TABLE " + table.getName() + " RENAME COLUMN custkey TO custkey1");
            DistributedQueryRunner queryRunner = this.getDistributedQueryRunner();
            QueryRunner.MaterializedResultWithPlan resultWithoutPredicate = queryRunner.executeWithPlan(this.getSession(), "TABLE " + table.getName());
            OperatorStats queryStatsWithoutPredicate = this.getOperatorStats(resultWithoutPredicate.queryId());
            Assertions.assertThat((long)queryStatsWithoutPredicate.getPhysicalInputPositions()).isGreaterThan(0L);
            Assertions.assertThat((Iterable)resultWithoutPredicate.result()).hasSize(1500);
            String selectiveQuery = "SELECT * FROM " + table.getName() + " WHERE custkey1 = 100";
            QueryRunner.MaterializedResultWithPlan selectiveQueryResult = queryRunner.executeWithPlan(this.getSession(), selectiveQuery);
            OperatorStats queryStatsSelectiveQuery = this.getOperatorStats(selectiveQueryResult.queryId());
            Assertions.assertThat((long)queryStatsSelectiveQuery.getPhysicalInputPositions()).isGreaterThan(0L);
            Assertions.assertThat((long)queryStatsSelectiveQuery.getPhysicalInputPositions()).isLessThan(queryStatsWithoutPredicate.getPhysicalInputPositions());
            Assertions.assertThat((Iterable)selectiveQueryResult.result()).hasSize(1);
        }
    }

    @Test
    void testTableChangesOnMultiRowGroups() throws Exception {
        try (TestTable table = this.newTrinoTable("test_table_changes_function_multi_row_groups_", "AS SELECT orderkey, partkey, suppkey FROM tpch.tiny.lineitem WITH NO DATA");){
            long initialSnapshot = this.getMostRecentSnapshotId(table.getName());
            this.assertUpdate(IcebergTestUtils.withSmallRowGroups(this.getSession()), "INSERT INTO %s SELECT orderkey, partkey, suppkey FROM tpch.tiny.lineitem".formatted(table.getName()), 60175L);
            long snapshotAfterInsert = this.getMostRecentSnapshotId(table.getName());
            DateTimeFormatter instantMillisFormatter = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSSVV").withZone(ZoneOffset.UTC);
            String snapshotAfterInsertTime = this.getSnapshotTime(table.getName(), snapshotAfterInsert).format(instantMillisFormatter);
            String filePath = this.getOnlyTableFilePath(table.getName());
            ParquetMetadata parquetMetadata = IcebergTestUtils.getParquetFileMetadata(this.fileSystem.newInputFile(Location.of((String)filePath)));
            int blocksSize = parquetMetadata.getBlocks().size();
            int splitBatchSize = new QueryManagerConfig().getScheduleSplitBatchSize();
            Assertions.assertThat((blocksSize > splitBatchSize && blocksSize % splitBatchSize != 0 ? 1 : 0) != 0).isTrue();
            this.assertQuery("SELECT orderkey, partkey, suppkey, _change_type, _change_version_id, to_iso8601(_change_timestamp), _change_ordinal\nFROM TABLE(system.table_changes(CURRENT_SCHEMA, '%s', %s, %s))\n".formatted(table.getName(), initialSnapshot, snapshotAfterInsert), "SELECT orderkey, partkey, suppkey, 'insert', %s, '%s', 0 FROM lineitem".formatted(snapshotAfterInsert, snapshotAfterInsertTime));
        }
    }

    private String getOnlyTableFilePath(String tableName) {
        return (String)Iterables.getOnlyElement((Iterable)this.getQueryRunner().execute(String.format("SELECT file_path FROM \"%s$files\"", tableName)).getOnlyColumnAsSet());
    }

    private long getMostRecentSnapshotId(String tableName) {
        return (Long)Iterables.getOnlyElement((Iterable)this.getQueryRunner().execute(String.format("SELECT snapshot_id FROM \"%s$snapshots\" ORDER BY committed_at DESC LIMIT 1", tableName)).getOnlyColumnAsSet());
    }

    private ZonedDateTime getSnapshotTime(String tableName, long snapshotId) {
        return (ZonedDateTime)Iterables.getOnlyElement((Iterable)this.getQueryRunner().execute(String.format("SELECT committed_at FROM \"%s$snapshots\" WHERE snapshot_id = %s", tableName, snapshotId)).getOnlyColumnAsSet());
    }

    @Override
    protected boolean isFileSorted(String path, String sortColumnName) {
        return IcebergTestUtils.checkParquetFileSorting(this.fileSystem.newInputFile(Location.of((String)path)), sortColumnName);
    }
}

