/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Joiner;
import io.trino.Session;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.Type;
import io.trino.testing.BaseTestParquetWithBloomFilters;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIcebergParquetWithBloomFilters
extends BaseTestParquetWithBloomFilters {
    protected QueryRunner createQueryRunner() throws Exception {
        return IcebergQueryRunner.builder().build();
    }

    protected CatalogSchemaTableName createParquetTableWithBloomFilter(String columnName, List<Integer> testValues) {
        String tableName = "parquet_with_bloom_filters_" + TestingNames.randomNameSuffix();
        CatalogSchemaTableName catalogSchemaTableName = new CatalogSchemaTableName("iceberg", new SchemaTableName("tpch", tableName));
        this.assertUpdate(String.format("CREATE TABLE %s WITH (format = 'PARQUET', parquet_bloom_filter_columns = ARRAY['%s']) AS SELECT * FROM (VALUES %s) t(%s)", catalogSchemaTableName, columnName, Joiner.on((String)", ").join(testValues), columnName), testValues.size());
        return catalogSchemaTableName;
    }

    @Test
    public void testBloomFilterPropertiesArePersistedDuringCreate() {
        String tableName = "test_metadata_write_properties_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + " (A bigint, b bigint, c bigint) WITH (format = 'parquet',parquet_bloom_filter_columns = array['a','B'])");
        this.verifyTableProperties(tableName);
    }

    @Test
    void testBloomFilterPropertiesArePersistedDuringSetProperties() {
        String tableName = "test_metadata_write_properties_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + "(A bigint, b bigint, c bigint)");
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES parquet_bloom_filter_columns = ARRAY['a','B']");
        this.verifyTableProperties(tableName);
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES parquet_bloom_filter_columns = ARRAY['a']");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + tableName))).contains(new CharSequence[]{"parquet_bloom_filter_columns = ARRAY['a']"});
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES parquet_bloom_filter_columns = ARRAY[]");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + tableName))).doesNotContain(new CharSequence[]{"parquet_bloom_filter_columns"});
    }

    @Test
    void testInvalidBloomFilterProperties() {
        String tableName = "test_invalid_bloom_filter_properties_" + TestingNames.randomNameSuffix();
        this.assertQueryFails("CREATE TABLE " + tableName + "(x int) WITH (parquet_bloom_filter_columns = ARRAY['missing_column'])", "Parquet Bloom filter column missing_column not present in schema");
        this.assertQueryFails("CREATE TABLE " + tableName + "(x array(int)) WITH (parquet_bloom_filter_columns = ARRAY['x'])", "\\QParquet Bloom filter column x has unsupported type array(integer)");
        this.assertQuerySucceeds("CREATE TABLE " + tableName + "(x array(integer))");
        this.assertQueryFails("ALTER TABLE " + tableName + " SET PROPERTIES parquet_bloom_filter_columns = ARRAY['missing_column']", "Parquet Bloom filter column missing_column not present in schema");
        this.assertQueryFails("ALTER TABLE " + tableName + " SET PROPERTIES parquet_bloom_filter_columns = ARRAY['x']", "\\QParquet Bloom filter column x has unsupported type array(integer)");
    }

    private void verifyTableProperties(String tableName) {
        MaterializedResult actualProperties = this.computeActual("SELECT * FROM \"" + tableName + "$properties\"");
        Assertions.assertThat((Iterable)actualProperties).isNotNull();
        MaterializedResult expectedProperties = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[0]).row(new Object[]{"write.parquet.bloom-filter-enabled.column.a", "true"}).row(new Object[]{"write.parquet.bloom-filter-enabled.column.b", "true"}).build();
        QueryAssertions.assertContains((MaterializedResult)actualProperties, (MaterializedResult)expectedProperties);
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + tableName))).contains(new CharSequence[]{"parquet_bloom_filter_columns"});
    }
}

