/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.Type;
import io.trino.testing.BaseTestParquetWithBloomFilters;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.containers.Minio;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIcebergParquetWithBloomFiltersMixedCase
extends BaseTestParquetWithBloomFilters {
    private static final String BUCKET_NAME = "test-bucket-mixed-case";
    private Minio minio;

    protected QueryRunner createQueryRunner() throws Exception {
        this.minio = (Minio)this.closeAfterClass((AutoCloseable)Minio.builder().build());
        this.minio.start();
        this.minio.createBucket(BUCKET_NAME);
        DistributedQueryRunner queryRunner = IcebergQueryRunner.builder().setIcebergProperties((Map<String, String>)ImmutableMap.builder().put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)this.minio.getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").put((Object)"iceberg.register-table-procedure.enabled", (Object)"true").buildOrThrow()).build();
        queryRunner.execute("CREATE SCHEMA IF NOT EXISTS iceberg.tpch");
        return queryRunner;
    }

    protected CatalogSchemaTableName createParquetTableWithBloomFilter(String columnName, List<Integer> testValues) {
        this.minio.copyResources("iceberg/mixed_case_bloom_filter", BUCKET_NAME, "mixed_case_bloom_filter");
        String tableName = "test_iceberg_write_mixed_case_bloom_filter" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", tableName, String.format("s3://%s/mixed_case_bloom_filter", BUCKET_NAME)));
        CatalogSchemaTableName catalogSchemaTableName = new CatalogSchemaTableName("iceberg", new SchemaTableName("tpch", tableName));
        this.assertUpdate(String.format("INSERT INTO %s SELECT * FROM (VALUES %s) t(%s)", catalogSchemaTableName, Joiner.on((String)", ").join(testValues), columnName), testValues.size());
        this.checkTableProperties(tableName);
        return catalogSchemaTableName;
    }

    private void checkTableProperties(String tableName) {
        MaterializedResult actualProperties = this.computeActual("SELECT * FROM \"" + tableName + "$properties\"");
        Assertions.assertThat((Iterable)actualProperties).isNotNull();
        MaterializedResult expectedProperties = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[0]).row(new Object[]{"write.parquet.bloom-filter-enabled.column.dataColumn", "true"}).build();
        QueryAssertions.assertContains((MaterializedResult)actualProperties, (MaterializedResult)expectedProperties);
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + tableName))).contains(new CharSequence[]{"parquet_bloom_filter_columns"});
    }

    @AfterAll
    public void destroy() throws Exception {
        this.minio = null;
    }
}

