/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.tpch.TpchTable;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIcebergPartitionEvolution
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return IcebergQueryRunner.builder().setInitialTables((Iterable<TpchTable<?>>)ImmutableList.of((Object)TpchTable.NATION)).build();
    }

    @Test
    public void testRemovePartitioning() {
        String tableName = "test_remove_partition_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (partitioning = ARRAY['regionkey', 'truncate(name, 1)']) AS SELECT * FROM nation WHERE nationkey < 10", 10L);
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES partitioning = ARRAY[]");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM nation WHERE nationkey >= 10", 15L);
        List files = this.computeActual("SELECT file_path, record_count FROM \"" + tableName + "$files\"").getMaterializedRows();
        List unpartitionedFiles = (List)files.stream().filter(file -> !((String)file.getField(0)).contains("regionkey=")).collect(ImmutableList.toImmutableList());
        List partitionedFiles = (List)files.stream().filter(file -> ((String)file.getField(0)).contains("regionkey=")).collect(ImmutableList.toImmutableList());
        int expectedFileCount = this.computeActual("SELECT DISTINCT regionkey, substring(name, 1, 1) FROM nation WHERE nationkey < 10").getRowCount();
        Assertions.assertThat((List)partitionedFiles).hasSize(expectedFileCount);
        Assertions.assertThat((long)partitionedFiles.stream().mapToLong(row -> (Long)row.getField(1)).sum()).isEqualTo(10L);
        Assertions.assertThat((List)unpartitionedFiles).hasSize(1);
        Assertions.assertThat((long)((Long)((MaterializedRow)unpartitionedFiles.get(0)).getField(1))).isEqualTo(15L);
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation");
        this.assertQuery("SELECT record_count, count(*) FROM \"" + tableName + "$partitions\" GROUP BY record_count", "VALUES (1, 8), (2, 1), (15, 1)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testAddPartitionColumn() {
        String tableName = "test_add_partition_column_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (partitioning = ARRAY['regionkey']) AS SELECT * FROM nation WHERE nationkey < 10", 10L);
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES partitioning = ARRAY['regionkey', 'truncate(name, 1)']");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM nation WHERE nationkey >= 10", 15L);
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue())).contains(new CharSequence[]{"partitioning = ARRAY['regionkey','truncate(name, 1)']"});
        List files = this.computeActual("SELECT file_path, record_count FROM \"" + tableName + "$files\"").getMaterializedRows();
        List initialFiles = (List)files.stream().filter(file -> !((String)file.getField(0)).contains("name_trunc")).collect(ImmutableList.toImmutableList());
        List partitionedFiles = (List)files.stream().filter(file -> ((String)file.getField(0)).contains("name_trunc")).collect(ImmutableList.toImmutableList());
        int expectedInitialFiles = Math.toIntExact((Long)this.computeActual("SELECT count(distinct regionkey) FROM nation WHERE nationkey < 10").getOnlyValue());
        Assertions.assertThat((List)initialFiles).hasSize(expectedInitialFiles);
        Assertions.assertThat((long)initialFiles.stream().mapToLong(row -> (Long)row.getField(1)).sum()).isEqualTo(10L);
        int expectedFinalFileCount = this.computeActual("SELECT DISTINCT regionkey, substring(name, 1, 1) FROM nation WHERE nationkey >= 10").getRowCount();
        Assertions.assertThat((List)partitionedFiles).hasSize(expectedFinalFileCount);
        Assertions.assertThat((long)partitionedFiles.stream().mapToLong(row -> (Long)row.getField(1)).sum()).isEqualTo(15L);
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (partitioning = ARRAY['truncate(name, 1)']) AS SELECT * FROM nation WHERE nationkey < 10", 10L);
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES partitioning = ARRAY['truncate(name, 1)', 'regionkey']");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM nation WHERE nationkey >= 10", 15L);
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue())).contains(new CharSequence[]{"partitioning = ARRAY['truncate(name, 1)','regionkey']"});
        files = this.computeActual("SELECT file_path, record_count FROM \"" + tableName + "$files\"").getMaterializedRows();
        initialFiles = (List)files.stream().filter(file -> !((String)file.getField(0)).contains("regionkey=")).collect(ImmutableList.toImmutableList());
        partitionedFiles = (List)files.stream().filter(file -> ((String)file.getField(0)).contains("regionkey=")).collect(ImmutableList.toImmutableList());
        expectedInitialFiles = this.computeActual("SELECT DISTINCT substring(name, 1, 1) FROM nation WHERE nationkey < 10").getRowCount();
        Assertions.assertThat((List)initialFiles).hasSize(expectedInitialFiles);
        Assertions.assertThat((long)initialFiles.stream().mapToLong(row -> (Long)row.getField(1)).sum()).isEqualTo(10L);
        expectedFinalFileCount = this.computeActual("SELECT DISTINCT regionkey, substring(name, 1, 1) FROM nation WHERE nationkey >= 10").getRowCount();
        Assertions.assertThat((List)partitionedFiles).hasSize(expectedFinalFileCount);
        Assertions.assertThat((long)partitionedFiles.stream().mapToLong(row -> (Long)row.getField(1)).sum()).isEqualTo(15L);
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testChangePartitionTransform() {
        String tableName = "test_change_partition_transform_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (ts, a) WITH (partitioning = ARRAY['year(ts)']) AS VALUES (TIMESTAMP '2021-01-01 01:01:01.111111', 1), (TIMESTAMP '2022-02-02 02:02:02.222222', 2), (TIMESTAMP '2023-03-03 03:03:03.333333', 3)", 3L);
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES partitioning = ARRAY['month(ts)']");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (TIMESTAMP '2024-04-04 04:04:04.444444', 4), (TIMESTAMP '2025-05-05 05:05:05.555555', 5)", 2L);
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue())).contains(new CharSequence[]{"partitioning = ARRAY['month(ts)']"});
        List files = this.computeActual("SELECT file_path, record_count FROM \"" + tableName + "$files\"").getMaterializedRows();
        List yearPartitionedFiles = (List)files.stream().filter(file -> {
            String filePath = (String)file.getField(0);
            return filePath.contains("ts_year") && !filePath.contains("ts_month");
        }).collect(ImmutableList.toImmutableList());
        List monthPartitionedFiles = (List)files.stream().filter(file -> {
            String filePath = (String)file.getField(0);
            return !filePath.contains("ts_year") && filePath.contains("ts_month");
        }).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((List)yearPartitionedFiles).hasSize(3);
        Assertions.assertThat((List)monthPartitionedFiles).hasSize(2);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testAddNestedPartitioning() {
        String tableName = "test_add_nested_partition_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id INT, district ROW(name VARCHAR), state ROW(name VARCHAR)) WITH (partitioning = ARRAY['\"state.name\"'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW('Patna'), ROW('BH')), (2, ROW('Gaya'), ROW('BH')), (3, ROW('Bengaluru'), ROW('KA')), (4, ROW('Mengaluru'), ROW('KA'))", 4L);
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES partitioning = ARRAY['\"state.name\"', '\"district.name\"']");
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue())).contains(new CharSequence[]{"partitioning = ARRAY['\"state.name\"','\"district.name\"']"});
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW('Patna'), ROW('BH')), (2, ROW('Patna'), ROW('BH')), (3, ROW('Bengaluru'), ROW('KA')), (4, ROW('Mengaluru'), ROW('KA'))", 4L);
        List files = this.computeActual("SELECT file_path, record_count FROM \"" + tableName + "$files\"").getMaterializedRows();
        List initialPartitionedFiles = (List)files.stream().filter(file -> !((String)file.getField(0)).contains("district.name=")).collect(ImmutableList.toImmutableList());
        List laterPartitionedFiles = (List)files.stream().filter(file -> ((String)file.getField(0)).contains("district.name=")).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((List)initialPartitionedFiles).hasSize(2);
        Assertions.assertThat((long)initialPartitionedFiles.stream().mapToLong(row -> (Long)row.getField(1)).sum()).isEqualTo(4L);
        Assertions.assertThat((List)laterPartitionedFiles).hasSize(3);
        Assertions.assertThat((long)laterPartitionedFiles.stream().mapToLong(row -> (Long)row.getField(1)).sum()).isEqualTo(4L);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testRemoveNestedPartitioning() {
        String tableName = "test_remove_nested_partition_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id INT, district ROW(name VARCHAR), state ROW(name VARCHAR)) WITH (partitioning = ARRAY['\"state.name\"'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW('Patna'), ROW('BH')), (2, ROW('Gaya'), ROW('BH')), (3, ROW('Bengaluru'), ROW('KA')), (4, ROW('Mengaluru'), ROW('KA'))", 4L);
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES partitioning = ARRAY[]");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW('Patna'), ROW('BH')), (2, ROW('Gaya'), ROW('BH')), (3, ROW('Bengaluru'), ROW('KA')), (4, ROW('Mengaluru'), ROW('KA'))", 4L);
        List files = this.computeActual("SELECT file_path, record_count FROM \"" + tableName + "$files\"").getMaterializedRows();
        List unpartitionedFiles = (List)files.stream().filter(file -> !((String)file.getField(0)).contains("state.name=")).collect(ImmutableList.toImmutableList());
        List partitionedFiles = (List)files.stream().filter(file -> ((String)file.getField(0)).contains("state.name=")).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((List)partitionedFiles).hasSize(2);
        Assertions.assertThat((long)partitionedFiles.stream().mapToLong(row -> (Long)row.getField(1)).sum()).isEqualTo(4L);
        Assertions.assertThat((List)unpartitionedFiles).hasSize(1);
        Assertions.assertThat((long)((Long)((MaterializedRow)unpartitionedFiles.get(0)).getField(1))).isEqualTo(4L);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testNestedFieldChangePartitionTransform() {
        String tableName = "test_nested_field_change_partition_transform_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (grandparent ROW(parent ROW(ts TIMESTAMP(6), a INT), b INT), c INT) WITH (partitioning = ARRAY['year(\"grandparent.parent.ts\")'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (ROW(ROW(TIMESTAMP '2021-01-01 01:01:01.111111', 1), 1), 1), (ROW(ROW(TIMESTAMP '2022-02-02 02:02:02.222222', 2), 2), 2), (ROW(ROW(TIMESTAMP '2023-03-03 03:03:03.333333', 3), 3), 3)", 3L);
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES partitioning = ARRAY['month(\"grandparent.parent.ts\")']");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (ROW(ROW(TIMESTAMP '2024-04-04 04:04:04.444444', 4), 4), 4), (ROW(ROW(TIMESTAMP '2025-05-05 05:05:05.555555', 5), 5), 5)", 2L);
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue())).contains(new CharSequence[]{"partitioning = ARRAY['month(\"grandparent.parent.ts\")']"});
        List files = this.computeActual("SELECT file_path, record_count FROM \"" + tableName + "$files\"").getMaterializedRows();
        List yearPartitionedFiles = (List)files.stream().filter(file -> {
            String filePath = (String)file.getField(0);
            return filePath.contains("grandparent.parent.ts_year=") && !filePath.contains("grandparent.parent.ts_month=");
        }).collect(ImmutableList.toImmutableList());
        List monthPartitionedFiles = (List)files.stream().filter(file -> {
            String filePath = (String)file.getField(0);
            return !filePath.contains("grandparent.parent.ts_year=") && filePath.contains("grandparent.parent.ts_month=");
        }).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((List)yearPartitionedFiles).hasSize(3);
        Assertions.assertThat((List)monthPartitionedFiles).hasSize(2);
        this.assertUpdate("DROP TABLE " + tableName);
    }
}

