/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.CreationException;
import io.airlift.bootstrap.ApplicationConfigurationException;
import io.trino.plugin.iceberg.IcebergPlugin;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.testing.TestingConnectorContext;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIcebergPlugin {
    @Test
    public void testCreateConnector() {
        ConnectorFactory factory = TestIcebergPlugin.getConnectorFactory();
        factory.create("test", Map.of("hive.metastore.uri", "thrift://foo:1234", "bootstrap.quiet", "true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testTestingFileMetastore() {
        ConnectorFactory factory = TestIcebergPlugin.getConnectorFactory();
        factory.create("test", Map.of("iceberg.catalog.type", "TESTING_FILE_METASTORE", "hive.metastore.catalog.dir", "/tmp", "bootstrap.quiet", "true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testThriftMetastore() {
        ConnectorFactory factory = TestIcebergPlugin.getConnectorFactory();
        factory.create("test", Map.of("iceberg.catalog.type", "HIVE_METASTORE", "hive.metastore.uri", "thrift://foo:1234", "bootstrap.quiet", "true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
        Assertions.assertThatThrownBy(() -> factory.create("test", Map.of("hive.metastore.uri", "thrift://foo:1234", "hive.metastore.glue.region", "us-east", "bootstrap.quiet", "true"), (ConnectorContext)new TestingConnectorContext())).hasMessageContaining("Configuration property 'hive.metastore.glue.region' was not used");
    }

    @Test
    public void testHiveMetastoreRejected() {
        ConnectorFactory factory = TestIcebergPlugin.getConnectorFactory();
        Assertions.assertThatThrownBy(() -> factory.create("test", Map.of("hive.metastore", "thrift", "hive.metastore.uri", "thrift://foo:1234", "bootstrap.quiet", "true"), (ConnectorContext)new TestingConnectorContext())).hasMessageContaining("Error: Configuration property 'hive.metastore' was not used");
    }

    @Test
    public void testGlueMetastore() {
        ConnectorFactory factory = TestIcebergPlugin.getConnectorFactory();
        factory.create("test", Map.of("iceberg.catalog.type", "glue", "hive.metastore.glue.region", "us-east-1", "bootstrap.quiet", "true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
        Assertions.assertThatThrownBy(() -> factory.create("test", Map.of("iceberg.catalog.type", "glue", "hive.metastore.uri", "thrift://foo:1234", "bootstrap.quiet", "true"), (ConnectorContext)new TestingConnectorContext())).hasMessageContaining("Error: Configuration property 'hive.metastore.uri' was not used");
        factory.create("test", Map.of("iceberg.catalog.type", "glue", "hive.metastore.glue.catalogid", "123", "hive.metastore.glue.region", "us-east-1", "bootstrap.quiet", "true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testAllowAllAccessControl() {
        ConnectorFactory connectorFactory = TestIcebergPlugin.getConnectorFactory();
        connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"iceberg.catalog.type", (Object)"HIVE_METASTORE").put((Object)"hive.metastore.uri", (Object)"thrift://foo:1234").put((Object)"iceberg.security", (Object)"allow-all").put((Object)"bootstrap.quiet", (Object)"true").buildOrThrow(), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testReadOnlyAllAccessControl() {
        ConnectorFactory connectorFactory = TestIcebergPlugin.getConnectorFactory();
        connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"iceberg.catalog.type", (Object)"HIVE_METASTORE").put((Object)"hive.metastore.uri", (Object)"thrift://foo:1234").put((Object)"iceberg.security", (Object)"read-only").put((Object)"bootstrap.quiet", (Object)"true").buildOrThrow(), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testSystemAccessControl() {
        ConnectorFactory connectorFactory = TestIcebergPlugin.getConnectorFactory();
        Connector connector = connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"iceberg.catalog.type", (Object)"HIVE_METASTORE").put((Object)"hive.metastore.uri", (Object)"thrift://foo:1234").put((Object)"iceberg.security", (Object)"system").put((Object)"bootstrap.quiet", (Object)"true").buildOrThrow(), (ConnectorContext)new TestingConnectorContext());
        Assertions.assertThatThrownBy(() -> ((Connector)connector).getAccessControl()).isInstanceOf(UnsupportedOperationException.class);
        connector.shutdown();
    }

    @Test
    public void testFileBasedAccessControl() throws Exception {
        ConnectorFactory connectorFactory = TestIcebergPlugin.getConnectorFactory();
        File tempFile = File.createTempFile("test-iceberg-plugin-access-control", ".json");
        tempFile.deleteOnExit();
        Files.writeString(tempFile.toPath(), (CharSequence)"{}", new OpenOption[0]);
        connectorFactory.create("test", (Map)ImmutableMap.builder().put((Object)"iceberg.catalog.type", (Object)"HIVE_METASTORE").put((Object)"hive.metastore.uri", (Object)"thrift://foo:1234").put((Object)"iceberg.security", (Object)"file").put((Object)"security.config-file", (Object)tempFile.getAbsolutePath()).put((Object)"bootstrap.quiet", (Object)"true").buildOrThrow(), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testIcebergPluginFailsWhenIncorrectPropertyProvided() {
        ConnectorFactory factory = TestIcebergPlugin.getConnectorFactory();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> factory.create("test", Map.of("iceberg.catalog.type", "HIVE_METASTORE", "hive.hive-views.enabled", "true", "hive.metastore.uri", "thrift://foo:1234", "bootstrap.quiet", "true"), (ConnectorContext)new TestingConnectorContext()).shutdown()).isInstanceOf(ApplicationConfigurationException.class)).hasMessageContaining("Configuration property 'hive.hive-views.enabled' was not used");
    }

    @Test
    public void testRestCatalog() {
        ConnectorFactory factory = TestIcebergPlugin.getConnectorFactory();
        factory.create("test", Map.of("iceberg.catalog.type", "rest", "iceberg.rest-catalog.uri", "https://foo:1234", "bootstrap.quiet", "true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testRestCatalogValidations() {
        ConnectorFactory factory = TestIcebergPlugin.getConnectorFactory();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> factory.create("test", Map.of("iceberg.catalog.type", "rest", "iceberg.register-table-procedure.enabled", "true", "iceberg.rest-catalog.uri", "https://foo:1234", "iceberg.rest-catalog.vended-credentials-enabled", "true", "bootstrap.quiet", "true"), (ConnectorContext)new TestingConnectorContext()).shutdown()).isInstanceOf(ApplicationConfigurationException.class)).hasMessageContaining("Using the `register_table` procedure with vended credentials is currently not supported");
    }

    @Test
    public void testJdbcCatalog() {
        ConnectorFactory factory = TestIcebergPlugin.getConnectorFactory();
        factory.create("test", Map.of("iceberg.catalog.type", "jdbc", "iceberg.jdbc-catalog.driver-class", "org.postgresql.Driver", "iceberg.jdbc-catalog.connection-url", "jdbc:postgresql://localhost:5432/test", "iceberg.jdbc-catalog.catalog-name", "test", "iceberg.jdbc-catalog.default-warehouse-dir", "s3://bucket", "bootstrap.quiet", "true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testNessieCatalog() {
        ConnectorFactory factory = TestIcebergPlugin.getConnectorFactory();
        factory.create("test", Map.of("iceberg.catalog.type", "nessie", "iceberg.nessie-catalog.default-warehouse-dir", "/tmp", "iceberg.nessie-catalog.uri", "http://foo:1234", "iceberg.nessie-catalog.client-api-version", "V1", "bootstrap.quiet", "true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testNessieCatalogWithBearerAuth() {
        ConnectorFactory factory = TestIcebergPlugin.getConnectorFactory();
        factory.create("test", Map.of("iceberg.catalog.type", "nessie", "iceberg.nessie-catalog.default-warehouse-dir", "/tmp", "iceberg.nessie-catalog.uri", "http://foo:1234", "iceberg.nessie-catalog.client-api-version", "V2", "iceberg.nessie-catalog.authentication.type", "BEARER", "iceberg.nessie-catalog.authentication.token", "someToken"), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testNessieCatalogWithNoAuthAndAccessToken() {
        ConnectorFactory factory = TestIcebergPlugin.getConnectorFactory();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> factory.create("test", Map.of("iceberg.catalog.type", "nessie", "iceberg.nessie-catalog.uri", "nessieUri", "iceberg.nessie-catalog.default-warehouse-dir", "/tmp", "iceberg.nessie-catalog.authentication.token", "someToken"), (ConnectorContext)new TestingConnectorContext()).shutdown()).isInstanceOf(ApplicationConfigurationException.class)).hasMessageContaining("'iceberg.nessie-catalog.authentication.token' must be configured only with 'iceberg.nessie-catalog.authentication.type' BEARER");
    }

    @Test
    public void testNessieCatalogWithNoAccessToken() {
        ConnectorFactory factory = TestIcebergPlugin.getConnectorFactory();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> factory.create("test", Map.of("iceberg.catalog.type", "nessie", "iceberg.nessie-catalog.uri", "nessieUri", "iceberg.nessie-catalog.default-warehouse-dir", "/tmp", "iceberg.nessie-catalog.authentication.type", "BEARER"), (ConnectorContext)new TestingConnectorContext()).shutdown()).isInstanceOf(ApplicationConfigurationException.class)).hasMessageContaining("'iceberg.nessie-catalog.authentication.token' must be configured with 'iceberg.nessie-catalog.authentication.type' BEARER");
    }

    @Test
    public void testNessieCatalogClientAPIVersion() {
        ConnectorFactory factory = TestIcebergPlugin.getConnectorFactory();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> factory.create("test", Map.of("iceberg.catalog.type", "nessie", "iceberg.nessie-catalog.uri", "http://foo:1234", "iceberg.nessie-catalog.default-warehouse-dir", "/tmp"), (ConnectorContext)new TestingConnectorContext()).shutdown()).isInstanceOf(CreationException.class)).hasMessageContaining("URI doesn't end with the version: http://foo:1234. Please configure `client-api-version` in the catalog properties explicitly.");
    }

    @Test
    public void testSnowflakeCatalog() {
        ConnectorFactory factory = TestIcebergPlugin.getConnectorFactory();
        factory.create("test", Map.of("iceberg.catalog.type", "snowflake", "iceberg.snowflake-catalog.account-uri", "jdbc:snowflake://sample.url", "iceberg.snowflake-catalog.user", "user", "iceberg.snowflake-catalog.password", "password", "iceberg.snowflake-catalog.database", "database"), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    private static ConnectorFactory getConnectorFactory() {
        return (ConnectorFactory)Iterables.getOnlyElement((Iterable)new IcebergPlugin().getConnectorFactories());
    }
}

