/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.inject.Module;
import io.trino.operator.RetryPolicy;
import io.trino.plugin.exchange.filesystem.FileSystemExchangePlugin;
import io.trino.plugin.exchange.filesystem.containers.MinioStorage;
import io.trino.plugin.iceberg.BaseIcebergFailureRecoveryTest;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.spi.Plugin;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestIcebergQueryFailureRecoveryTest
extends BaseIcebergFailureRecoveryTest {
    private MinioStorage minioStorage;

    protected TestIcebergQueryFailureRecoveryTest() {
        super(RetryPolicy.QUERY);
    }

    protected QueryRunner createQueryRunner(List<TpchTable<?>> requiredTpchTables, Map<String, String> configProperties, Map<String, String> coordinatorProperties, Module failureInjectionModule) throws Exception {
        this.minioStorage = (MinioStorage)this.closeAfterClass((AutoCloseable)new MinioStorage("test-exchange-spooling-" + TestingNames.randomNameSuffix()));
        this.minioStorage.start();
        return ((IcebergQueryRunner.Builder)((IcebergQueryRunner.Builder)((IcebergQueryRunner.Builder)((IcebergQueryRunner.Builder)IcebergQueryRunner.builder().setCoordinatorProperties(coordinatorProperties)).setExtraProperties(configProperties)).setAdditionalSetup(runner -> {
            runner.installPlugin((Plugin)new FileSystemExchangePlugin());
            runner.loadExchangeManager("filesystem", MinioStorage.getExchangeManagerProperties((MinioStorage)this.minioStorage));
        })).setAdditionalModule(failureInjectionModule)).setInitialTables(requiredTpchTables).build();
    }

    @AfterAll
    public void destroy() throws Exception {
        this.minioStorage = null;
    }
}

