/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIcebergReadVersionedTable
extends AbstractTestQueryFramework {
    private long v1SnapshotId;
    private long v1EpochMillis;
    private long v2SnapshotId;
    private long v2EpochMillis;
    private long incorrectSnapshotId;

    protected QueryRunner createQueryRunner() throws Exception {
        return IcebergQueryRunner.builder().build();
    }

    @BeforeAll
    public void setUp() throws InterruptedException {
        this.assertQuerySucceeds("CREATE TABLE test_iceberg_read_versioned_table(a_string varchar, an_integer integer)");
        this.assertQuerySucceeds("INSERT INTO test_iceberg_read_versioned_table VALUES ('a', 1)");
        this.v1SnapshotId = this.getLatestSnapshotId("test_iceberg_read_versioned_table");
        this.v1EpochMillis = this.getCommittedAtInEpochMilliSeconds("test_iceberg_read_versioned_table", this.v1SnapshotId);
        Thread.sleep(1L);
        this.assertQuerySucceeds("INSERT INTO test_iceberg_read_versioned_table VALUES ('b', 2)");
        this.v2SnapshotId = this.getLatestSnapshotId("test_iceberg_read_versioned_table");
        this.v2EpochMillis = this.getCommittedAtInEpochMilliSeconds("test_iceberg_read_versioned_table", this.v2SnapshotId);
        this.incorrectSnapshotId = this.v2SnapshotId + 1L;
    }

    @Test
    public void testSelectTableWithEndSnapshotId() {
        this.assertQuery("SELECT * FROM test_iceberg_read_versioned_table FOR VERSION AS OF " + this.v1SnapshotId, "VALUES ('a', 1)");
        this.assertQuery("SELECT * FROM test_iceberg_read_versioned_table FOR VERSION AS OF " + this.v2SnapshotId, "VALUES ('a', 1), ('b', 2)");
        this.assertQueryFails("SELECT * FROM test_iceberg_read_versioned_table FOR VERSION AS OF " + this.incorrectSnapshotId, "Iceberg snapshot ID does not exists: " + this.incorrectSnapshotId);
    }

    @Test
    public void testSelectTableWithEndShortTimestampWithTimezone() {
        this.assertQueryFails("SELECT * FROM test_iceberg_read_versioned_table FOR TIMESTAMP AS OF TIMESTAMP '1970-01-01 00:00:00.001000000 Z'", "\\QNo version history table tpch.\"test_iceberg_read_versioned_table\" at or before 1970-01-01T00:00:00.001Z");
        this.assertQuery("SELECT * FROM test_iceberg_read_versioned_table FOR TIMESTAMP AS OF " + TestIcebergReadVersionedTable.timestampLiteral(this.v1EpochMillis, 9), "VALUES ('a', 1)");
        this.assertQuery("SELECT * FROM test_iceberg_read_versioned_table FOR TIMESTAMP AS OF " + TestIcebergReadVersionedTable.timestampLiteral(this.v2EpochMillis, 9), "VALUES ('a', 1), ('b', 2)");
    }

    @Test
    public void testSelectTableWithEndLongTimestampWithTimezone() {
        this.assertQueryFails("SELECT * FROM test_iceberg_read_versioned_table FOR TIMESTAMP AS OF TIMESTAMP '1970-01-01 00:00:00.001000000 Z'", "\\QNo version history table tpch.\"test_iceberg_read_versioned_table\" at or before 1970-01-01T00:00:00.001Z");
        this.assertQuery("SELECT * FROM test_iceberg_read_versioned_table FOR TIMESTAMP AS OF " + TestIcebergReadVersionedTable.timestampLiteral(this.v1EpochMillis, 9), "VALUES ('a', 1)");
        this.assertQuery("SELECT * FROM test_iceberg_read_versioned_table FOR TIMESTAMP AS OF " + TestIcebergReadVersionedTable.timestampLiteral(this.v2EpochMillis, 9), "VALUES ('a', 1), ('b', 2)");
    }

    @Test
    public void testEndVersionInTableNameAndForClauseShouldFail() {
        this.assertQueryFails("SELECT * FROM \"test_iceberg_read_versioned_table@" + this.v1SnapshotId + "\" FOR VERSION AS OF " + this.v1SnapshotId, "line 1:15: Table 'iceberg.tpch.\"test_iceberg_read_versioned_table@%d\"' does not exist".formatted(this.v1SnapshotId));
        this.assertQueryFails("SELECT * FROM \"test_iceberg_read_versioned_table@" + this.v1SnapshotId + "\" FOR TIMESTAMP AS OF " + TestIcebergReadVersionedTable.timestampLiteral(this.v1EpochMillis, 9), "line 1:15: Table 'iceberg.tpch.\"test_iceberg_read_versioned_table@%d\"' does not exist".formatted(this.v1SnapshotId));
    }

    @Test
    public void testSystemTables() {
        this.assertQueryFails("SELECT * FROM \"test_iceberg_read_versioned_table$partitions\" FOR VERSION AS OF " + this.v1SnapshotId, "This connector does not support versioned tables");
    }

    private long getLatestSnapshotId(String tableName) {
        return (Long)this.computeScalar(String.format("SELECT snapshot_id FROM \"%s$snapshots\" ORDER BY committed_at DESC FETCH FIRST 1 ROW WITH TIES", tableName));
    }

    private long getCommittedAtInEpochMilliSeconds(String tableName, long snapshotId) {
        return ((ZonedDateTime)this.computeScalar(String.format("SELECT committed_at FROM \"%s$snapshots\" WHERE snapshot_id=%s", tableName, snapshotId))).toInstant().toEpochMilli();
    }

    private static String timestampLiteral(long epochMilliSeconds, int precision) {
        return DateTimeFormatter.ofPattern("'TIMESTAMP '''uuuu-MM-dd HH:mm:ss." + "S".repeat(precision) + " VV''").format(Instant.ofEpochMilli(epochMilliSeconds).atZone(ZoneOffset.UTC));
    }
}

