/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.spi.type.TimeZoneKey;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.containers.Minio;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIcebergReadVersionedTableByTemporal
extends AbstractTestQueryFramework {
    private static final String BUCKET_NAME = "test-bucket-time-travel";
    private Minio minio;

    protected QueryRunner createQueryRunner() throws Exception {
        this.minio = (Minio)this.closeAfterClass((AutoCloseable)Minio.builder().build());
        this.minio.start();
        this.minio.createBucket(BUCKET_NAME);
        DistributedQueryRunner queryRunner = IcebergQueryRunner.builder().setIcebergProperties((Map<String, String>)ImmutableMap.builder().put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)this.minio.getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").put((Object)"iceberg.register-table-procedure.enabled", (Object)"true").buildOrThrow()).build();
        queryRunner.execute("CREATE SCHEMA IF NOT EXISTS iceberg.tpch");
        return queryRunner;
    }

    @AfterAll
    public void destroy() throws Exception {
        this.minio = null;
    }

    @Test
    public void testSelectTableWithEndVersionAsTemporal() {
        String tableName = "test_iceberg_read_versioned_table_" + TestingNames.randomNameSuffix();
        this.minio.copyResources("iceberg/timetravel", BUCKET_NAME, "timetravel");
        this.assertUpdate(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", tableName, String.format("s3://%s/timetravel", BUCKET_NAME)));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES 1, 2, 3");
        Session utcSession = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.UTC_KEY).build();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(utcSession, "SELECT made_current_at FROM \"" + tableName + "$history\""))).matches("VALUES   TIMESTAMP '2023-06-30 05:01:46.265 UTC',   TIMESTAMP '2023-07-01 05:02:43.954 UTC',   TIMESTAMP '2023-07-02 05:03:39.586 UTC',   TIMESTAMP '2023-07-03 05:03:42.434 UTC'");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 4", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES 1, 2, 3, 4");
        Session viennaSession = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Europe/Vienna")).build();
        Session losAngelesSession = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"America/Los_Angeles")).build();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(viennaSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF DATE '2023-07-01'"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(losAngelesSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF DATE '2023-07-01'"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(viennaSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF DATE '2023-07-02'"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(losAngelesSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF DATE '2023-07-02'"))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(viennaSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF DATE '2023-07-03'"))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(losAngelesSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF DATE '2023-07-03'"))).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(viennaSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF DATE '2023-07-04'"))).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(losAngelesSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF DATE '2023-07-04'"))).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(viennaSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '2023-07-01 00:00:00'"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(utcSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '2023-07-01 05:02:43.953'"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(utcSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '2023-07-01 05:02:43.954'"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(viennaSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '2023-07-01 07:02:43.954'"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(losAngelesSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '2023-07-01 00:00:00.1'"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(viennaSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '2023-07-02 01:00:00.12'"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(losAngelesSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '2023-07-02 01:00:00.123'"))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(viennaSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '2023-07-03 02:00:00.123'"))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(losAngelesSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '2023-07-03 02:00:00.123456'"))).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(viennaSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '2023-07-04 03:00:00.123456789'"))).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(losAngelesSession, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '2023-07-04 03:00:00.123456789012'"))).matches("VALUES 1, 2, 3");
        this.assertUpdate("DROP TABLE " + tableName);
    }
}

