/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.Session;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.metastore.file.TestingFileHiveMetastore;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.TestingIcebergPlugin;
import io.trino.plugin.iceberg.catalog.file.TestingIcebergFileMetastoreCatalogModule;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class TestIcebergRegisterTableProcedure
extends AbstractTestQueryFramework {
    private HiveMetastore metastore;
    private File metastoreDir;
    private TrinoFileSystem fileSystem;
    private Path dataDir;

    protected QueryRunner createQueryRunner() throws Exception {
        this.metastoreDir = Files.createTempDirectory("test_iceberg_register_table", new FileAttribute[0]).toFile();
        this.metastoreDir.deleteOnExit();
        this.metastore = TestingFileHiveMetastore.createTestingFileHiveMetastore((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, (Location)Location.of((String)this.metastoreDir.getAbsolutePath()));
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)TestingSession.testSessionBuilder().setCatalog("iceberg").setSchema("tpch").build()).build();
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog("tpch", "tpch");
        this.dataDir = queryRunner.getCoordinator().getBaseDataDir().resolve("iceberg_data");
        queryRunner.installPlugin((Plugin)new TestingIcebergPlugin(this.dataDir, Optional.of(new TestingIcebergFileMetastoreCatalogModule(this.metastore))));
        queryRunner.createCatalog("iceberg", "iceberg", (Map)ImmutableMap.of((Object)"fs.hadoop.enabled", (Object)"true", (Object)"iceberg.register-table-procedure.enabled", (Object)"true"));
        queryRunner.execute("CREATE SCHEMA iceberg.tpch");
        return queryRunner;
    }

    @BeforeAll
    public void initFileSystem() {
        this.fileSystem = IcebergTestUtils.getFileSystemFactory((QueryRunner)this.getDistributedQueryRunner()).create(TestingConnectorSession.SESSION);
    }

    @AfterAll
    public void tearDown() throws IOException {
        MoreFiles.deleteRecursively((Path)this.metastoreDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @ParameterizedTest
    @EnumSource(value=IcebergFileFormat.class)
    public void testRegisterTableWithTableLocation(IcebergFileFormat icebergFileFormat) {
        String tableName = "test_register_table_with_table_location_" + icebergFileFormat.name().toLowerCase(Locale.ENGLISH) + "_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a int, b varchar, c boolean) with (format = '%s')", tableName, icebergFileFormat));
        this.assertUpdate(String.format("INSERT INTO %s values(1, 'INDIA', true)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s values(2, 'USA', false)", tableName), 1L);
        String tableLocation = this.getTableLocation(tableName);
        this.dropTableFromMetastore(tableName);
        this.assertUpdate("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s", tableName)))).matches("VALUES ROW(INT '1', VARCHAR 'INDIA', BOOLEAN 'true'), ROW(INT '2', VARCHAR 'USA', BOOLEAN 'false')");
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    @Test
    public void testRegisterTableTrailingSlash() {
        this.testRegisterTableTrailingSlash("test_dir", "test_dir");
        this.testRegisterTableTrailingSlash("test_dir", "test_dir/");
        this.testRegisterTableTrailingSlash("test_dir/", "test_dir");
        this.testRegisterTableTrailingSlash("test_dir/", "test_dir/");
    }

    private void testRegisterTableTrailingSlash(String tableDir, String registeredTableDir) {
        String tableName = "test_register_table_trailing_slash_" + TestingNames.randomNameSuffix();
        String tableLocation = String.format("%s/%s/%s", this.dataDir, tableName, tableDir);
        String registeredTableLocation = String.format("%s/%s/%s", this.dataDir, tableName, registeredTableDir);
        this.assertUpdate(String.format("CREATE TABLE %s (a int) WITH (location = '%s')", tableName, tableLocation));
        this.assertUpdate(String.format("INSERT INTO %s VALUES 1", tableName), 1L);
        this.dropTableFromMetastore(tableName);
        this.assertUpdate(String.format("CALL iceberg.system.register_table (CURRENT_SCHEMA, '%s', '%s')", tableName, registeredTableLocation));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @ParameterizedTest
    @EnumSource(value=IcebergFileFormat.class)
    public void testRegisterPartitionedTable(IcebergFileFormat icebergFileFormat) {
        String tableName = "test_register_partitioned_table_" + icebergFileFormat.name().toLowerCase(Locale.ENGLISH) + "_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (data int, part varchar) WITH (partitioning = ARRAY['part'], format = '" + String.valueOf(icebergFileFormat) + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 'a')", 1L);
        MaterializedResult partitions = this.computeActual(String.format("SELECT * FROM \"%s$partitions\"", tableName));
        Assertions.assertThat((List)partitions.getMaterializedRows()).hasSize(1);
        String tableLocation = this.getTableLocation(tableName);
        this.dropTableFromMetastore(tableName);
        this.assertUpdate("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "')");
        MaterializedResult partitionsAfterRegister = this.computeActual(String.format("SELECT * FROM \"%s$partitions\"", tableName));
        Assertions.assertThat((Iterable)partitions).isEqualTo((Object)partitionsAfterRegister);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @ParameterizedTest
    @EnumSource(value=IcebergFileFormat.class)
    public void testRegisterTableWithComments(IcebergFileFormat icebergFileFormat) {
        String tableName = "test_register_table_with_comments_" + icebergFileFormat.name().toLowerCase(Locale.ENGLISH) + "_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a int, b varchar, c boolean) with (format = '%s')", tableName, icebergFileFormat));
        this.assertUpdate(String.format("INSERT INTO %s values(1, 'INDIA', true)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s values(2, 'USA', false)", tableName), 1L);
        this.assertUpdate(String.format("COMMENT ON TABLE %s is 'my-table-comment'", tableName));
        this.assertUpdate(String.format("COMMENT ON COLUMN %s.a is 'a-comment'", tableName));
        this.assertUpdate(String.format("COMMENT ON COLUMN %s.b is 'b-comment'", tableName));
        this.assertUpdate(String.format("COMMENT ON COLUMN %s.c is 'c-comment'", tableName));
        String tableLocation = this.getTableLocation(tableName);
        this.dropTableFromMetastore(tableName);
        this.assertUpdate("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "')");
        Assertions.assertThat((String)this.getTableComment(tableName)).isEqualTo("my-table-comment");
        Assertions.assertThat((String)this.getColumnComment(tableName, "a")).isEqualTo("a-comment");
        Assertions.assertThat((String)this.getColumnComment(tableName, "b")).isEqualTo("b-comment");
        Assertions.assertThat((String)this.getColumnComment(tableName, "c")).isEqualTo("c-comment");
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    @ParameterizedTest
    @EnumSource(value=IcebergFileFormat.class)
    public void testRegisterTableWithShowCreateTable(IcebergFileFormat icebergFileFormat) {
        String tableName = "test_register_table_with_show_create_table_" + icebergFileFormat.name().toLowerCase(Locale.ENGLISH) + "_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a int, b varchar, c boolean) with (format = '%s')", tableName, icebergFileFormat));
        this.assertUpdate(String.format("INSERT INTO %s values(1, 'INDIA', true)", tableName), 1L);
        String tableLocation = this.getTableLocation(tableName);
        String showCreateTableOld = (String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue();
        this.dropTableFromMetastore(tableName);
        this.assertUpdate("CALL system.register_table (CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "')");
        String showCreateTableNew = (String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue();
        Assertions.assertThat((String)showCreateTableOld).isEqualTo(showCreateTableNew);
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    @ParameterizedTest
    @EnumSource(value=IcebergFileFormat.class)
    public void testRegisterTableWithReInsert(IcebergFileFormat icebergFileFormat) {
        String tableName = "test_register_table_with_re_insert_" + icebergFileFormat.name().toLowerCase(Locale.ENGLISH) + "_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a int, b varchar, c boolean) with (format = '%s')", tableName, icebergFileFormat));
        this.assertUpdate(String.format("INSERT INTO %s values(1, 'INDIA', true)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s values(2, 'USA', false)", tableName), 1L);
        String tableLocation = this.getTableLocation(tableName);
        this.dropTableFromMetastore(tableName);
        this.assertUpdate("CALL system.register_table (CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "')");
        this.assertUpdate(String.format("INSERT INTO %s values(3, 'POLAND', true)", tableName), 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s", tableName)))).matches("VALUES ROW(INT '1', VARCHAR 'INDIA', BOOLEAN 'true'), ROW(INT '2', VARCHAR 'USA', BOOLEAN 'false'), ROW(INT '3', VARCHAR 'POLAND', BOOLEAN 'true')");
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    @ParameterizedTest
    @EnumSource(value=IcebergFileFormat.class)
    public void testRegisterTableWithDroppedTable(IcebergFileFormat icebergFileFormat) {
        String tableName = "test_register_table_with_dropped_table_" + icebergFileFormat.name().toLowerCase(Locale.ENGLISH) + "_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a int, b varchar, c boolean) with (format = '%s')", tableName, icebergFileFormat));
        this.assertUpdate(String.format("INSERT INTO %s values(1, 'INDIA', true)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s values(2, 'USA', false)", tableName), 1L);
        String tableLocation = this.getTableLocation(tableName);
        String tableNameNew = tableName + "_new";
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
        this.assertQueryFails("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableNameNew + "', '" + tableLocation + "')", ".*No versioned metadata file exists at location.*");
    }

    @ParameterizedTest
    @EnumSource(value=IcebergFileFormat.class)
    public void testRegisterTableWithDifferentTableName(IcebergFileFormat icebergFileFormat) {
        String tableName = "test_register_table_with_different_table_name_old_" + icebergFileFormat.name().toLowerCase(Locale.ENGLISH) + "_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a int, b varchar, c boolean) with (format = '%s')", tableName, icebergFileFormat));
        this.assertUpdate(String.format("INSERT INTO %s values(1, 'INDIA', true)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s values(2, 'USA', false)", tableName), 1L);
        String tableLocation = this.getTableLocation(tableName);
        String tableNameNew = tableName + "_new";
        this.dropTableFromMetastore(tableName);
        this.assertUpdate("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableNameNew + "', '" + tableLocation + "')");
        this.assertUpdate(String.format("INSERT INTO %s values(3, 'POLAND', true)", tableNameNew), 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s", tableNameNew)))).matches("VALUES ROW(INT '1', VARCHAR 'INDIA', BOOLEAN 'true'), ROW(INT '2', VARCHAR 'USA', BOOLEAN 'false'), ROW(INT '3', VARCHAR 'POLAND', BOOLEAN 'true')");
        this.assertUpdate(String.format("DROP TABLE %s", tableNameNew));
    }

    @ParameterizedTest
    @EnumSource(value=IcebergFileFormat.class)
    public void testRegisterTableWithMetadataFile(IcebergFileFormat icebergFileFormat) {
        String tableName = "test_register_table_with_metadata_file_" + icebergFileFormat.name().toLowerCase(Locale.ENGLISH) + "_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a int, b varchar, c boolean) with (format = '%s')", tableName, icebergFileFormat));
        this.assertUpdate(String.format("INSERT INTO %s values(1, 'INDIA', true)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s values(2, 'USA', false)", tableName), 1L);
        String tableLocation = this.getTableLocation(tableName);
        String metadataLocation = IcebergUtil.getLatestMetadataLocation((TrinoFileSystem)this.fileSystem, (String)tableLocation);
        String metadataFileName = metadataLocation.substring(metadataLocation.lastIndexOf("/") + 1);
        this.dropTableFromMetastore(tableName);
        this.assertUpdate("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "', '" + metadataFileName + "')");
        this.assertUpdate(String.format("INSERT INTO %s values(3, 'POLAND', true)", tableName), 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s", tableName)))).matches("VALUES ROW(INT '1', VARCHAR 'INDIA', BOOLEAN 'true'), ROW(INT '2', VARCHAR 'USA', BOOLEAN 'false'), ROW(INT '3', VARCHAR 'POLAND', BOOLEAN 'true')");
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    @Test
    public void testRegisterTableWithNoMetadataFile() throws IOException {
        IcebergFileFormat icebergFileFormat = IcebergFileFormat.ORC;
        String tableName = "test_register_table_with_no_metadata_file_" + icebergFileFormat.name().toLowerCase(Locale.ENGLISH) + "_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a int, b varchar, c boolean) with (format = '%s')", tableName, icebergFileFormat));
        this.assertUpdate(String.format("INSERT INTO %s values(1, 'INDIA', true)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s values(2, 'USA', false)", tableName), 1L);
        String tableLocation = this.getTableLocation(tableName);
        String tableNameNew = tableName + "_new";
        MoreFiles.deleteRecursively((Path)Path.of(tableLocation, "metadata"), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        this.assertQueryFails("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableNameNew + "', '" + tableLocation + "')", ".*No versioned metadata file exists at location.*");
        this.dropTableFromMetastore(tableName);
        MoreFiles.deleteRecursively((Path)Path.of(tableLocation, new String[0]), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testRegisterTableWithInvalidMetadataFile() throws IOException {
        String tableName = "test_register_table_with_invalid_metadata_file_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a int, b varchar, c boolean)", tableName));
        this.assertUpdate(String.format("INSERT INTO %s values(1, 'INDIA', true)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s values(2, 'USA', false)", tableName), 1L);
        Location tableLocation = Location.of((String)this.getTableLocation(tableName));
        String tableNameNew = tableName + "_new";
        Location metadataDirectoryLocation = tableLocation.appendPath("metadata");
        FileIterator fileIterator = this.fileSystem.listFiles(metadataDirectoryLocation);
        String invalidMetadataFileName = "invalid-default.avro";
        while (fileIterator.hasNext()) {
            FileEntry fileEntry = fileIterator.next();
            if (!fileEntry.location().fileName().endsWith(".avro")) continue;
            invalidMetadataFileName = fileEntry.location().fileName();
            break;
        }
        this.assertQueryFails("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableNameNew + "', '" + String.valueOf(tableLocation) + "', '" + invalidMetadataFileName + "')", "Invalid metadata file: .*");
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    @Test
    public void testRegisterTableWithNonExistingTableLocation() {
        String tableName = "test_register_table_with_non_existing_table_location_" + TestingNames.randomNameSuffix();
        String tableLocation = "/test/iceberg/hive/warehouse/orders_5-581fad8517934af6be1857a903559d44";
        this.assertQueryFails("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "')", ".*No versioned metadata file exists at location.*");
    }

    @Test
    public void testRegisterTableWithNonExistingMetadataFile() {
        String tableName = "test_register_table_with_non_existing_metadata_file_" + TestingNames.randomNameSuffix();
        String nonExistingMetadataFileName = "00003-409702ba-4735-4645-8f14-09537cc0b2c8.metadata.json";
        String tableLocation = "/test/iceberg/hive/warehouse/orders_5-581fad8517934af6be1857a903559d44";
        this.assertQueryFails("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "', '" + nonExistingMetadataFileName + "')", "Metadata file does not exist: .*");
    }

    @Test
    public void testRegisterTableWithNonExistingSchema() {
        String tableLocation = "/test/iceberg/hive/orders_5-581fad8517934af6be1857a903559d44";
        this.assertQueryFails("CALL iceberg.system.register_table ('invalid_schema', 'test_table', '" + tableLocation + "')", ".*Schema '(.*)' does not exist.*");
    }

    @Test
    public void testRegisterTableWithExistingTable() {
        String tableName = "test_register_table_with_existing_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a int, b varchar, c boolean)");
        this.assertUpdate("INSERT INTO " + tableName + " values(1, 'INDIA', true)", 1L);
        String tableLocation = this.getTableLocation(tableName);
        this.assertQueryFails("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "')", ".*Table already exists.*");
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    @Test
    public void testRegisterTableWithInvalidURIScheme() {
        String tableName = "test_register_table_with_invalid_uri_scheme_" + TestingNames.randomNameSuffix();
        String nonExistedMetadataFileName = "00003-409702ba-4735-4645-8f14-09537cc0b2c8.metadata.json";
        String tableLocation = "invalid://hadoop-master:9000/test/iceberg/hive/orders_5-581fad8517934af6be1857a903559d44";
        this.assertQueryFails("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "', '" + nonExistedMetadataFileName + "')", ".*Invalid metadata file location: .*");
        this.assertQueryFails("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "')", ".*Failed checking table location: .*");
    }

    @Test
    public void testRegisterTableWithInvalidParameter() {
        String tableName = "test_register_table_with_invalid_parameter_" + TestingNames.randomNameSuffix();
        String tableLocation = "/test/iceberg/hive/table1/";
        this.assertQueryFails(String.format("CALL iceberg.system.register_table (CURRENT_SCHEMA, '%s')", tableName), ".*'TABLE_LOCATION' is missing.*");
        this.assertQueryFails("CALL iceberg.system.register_table (CURRENT_SCHEMA)", ".*'TABLE_NAME' is missing.*");
        this.assertQueryFails("CALL iceberg.system.register_table ()", ".*'SCHEMA_NAME' is missing.*");
        this.assertQueryFails("CALL iceberg.system.register_table (null, null, null)", ".*schema_name cannot be null or empty.*");
        this.assertQueryFails("CALL iceberg.system.register_table (CURRENT_SCHEMA, null, null)", ".*table_name cannot be null or empty.*");
        this.assertQueryFails("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableName + "', null)", ".*table_location cannot be null or empty.*");
        this.assertQueryFails("CALL iceberg.system.register_table ('', '" + tableName + "', '" + tableLocation + "')", ".*schema_name cannot be null or empty.*");
        this.assertQueryFails("CALL iceberg.system.register_table (CURRENT_SCHEMA, '', '" + tableLocation + "')", ".*table_name cannot be null or empty.*");
        this.assertQueryFails("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableName + "', '')", ".*table_location cannot be null or empty.*");
        this.assertQueryFails("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "', '')", ".*metadata_file_name cannot be empty when provided as an argument.*");
    }

    @Test
    public void testRegisterTableWithInvalidMetadataFileName() {
        String[] invalidMetadataFileNames;
        String tableName = "test_register_table_with_invalid_metadata_file_name_" + TestingNames.randomNameSuffix();
        String tableLocation = "/test/iceberg/hive";
        for (String invalidMetadataFileName : invalidMetadataFileNames = new String[]{"/", "../", "../../", "../../somefile.metadata.json"}) {
            this.assertQueryFails("CALL iceberg.system.register_table (CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "', '" + invalidMetadataFileName + "')", ".*is not a valid metadata file.*");
        }
    }

    @Test
    public void testRegisterHadoopTableAndRead() {
        String tempTableName = "temp_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tempTableName + " (id INT, name VARCHAR) WITH (format = 'ORC')");
        this.assertUpdate("INSERT INTO " + tempTableName + " values(1, 'INDIA')", 1L);
        String dataFilePath = (String)this.computeScalar("SELECT \"$path\" FROM " + tempTableName);
        String hadoopTableName = "hadoop_table_" + TestingNames.randomNameSuffix();
        String hadoopTableLocation = this.metastoreDir.getPath() + "/" + hadoopTableName;
        HadoopTables hadoopTables = new HadoopTables(new Configuration(false));
        Schema schema = new Schema((List)ImmutableList.of((Object)Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), (Object)Types.NestedField.optional((int)2, (String)"name", (Type)Types.StringType.get())));
        Table table = hadoopTables.create(schema, PartitionSpec.unpartitioned(), SortOrder.unsorted(), (Map)ImmutableMap.of((Object)"write.format.default", (Object)"ORC"), hadoopTableLocation);
        DataFile dataFile = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withFormat(FileFormat.ORC).withInputFile(org.apache.iceberg.Files.localInput((File)new File(dataFilePath))).withPath(dataFilePath).withRecordCount(1L).build();
        table.newFastAppend().appendFile(dataFile).commit();
        Assertions.assertThat((String)Location.of((String)IcebergUtil.getLatestMetadataLocation((TrinoFileSystem)this.fileSystem, (String)hadoopTableLocation)).fileName()).isEqualTo("v2.metadata.json");
        String registeredTableName = "registered_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')".formatted(registeredTableName, hadoopTableLocation));
        this.assertQuery("SELECT * FROM " + registeredTableName, "VALUES (1, 'INDIA')");
        this.assertUpdate("INSERT INTO " + registeredTableName + " VALUES (2, 'POLAND')", 1L);
        this.assertQuery("SELECT * FROM " + registeredTableName, "VALUES (1, 'INDIA'), (2, 'POLAND')");
        Assertions.assertThat((String)Location.of((String)IcebergUtil.getLatestMetadataLocation((TrinoFileSystem)this.fileSystem, (String)hadoopTableLocation)).fileName()).matches((CharSequence)"00003-.*\\.metadata\\.json");
        this.assertUpdate("DROP TABLE " + registeredTableName);
        this.assertUpdate("DROP TABLE " + tempTableName);
    }

    @Test
    void testRegisterTableAccessControl() {
        String tableName = "test_register_table_access_control_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 a", 1L);
        String tableLocation = this.getTableLocation(tableName);
        this.assertUpdate("CALL system.unregister_table(CURRENT_SCHEMA, '" + tableName + "')");
        this.assertAccessDenied("CALL system.register_table(CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "')", "Cannot create table .*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)tableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_TABLE)});
    }

    private String getTableLocation(String tableName) {
        Pattern locationPattern = Pattern.compile(".*location = '(.*?)'.*", 32);
        Matcher matcher = locationPattern.matcher((String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue());
        if (matcher.find()) {
            String location = matcher.group(1);
            Verify.verify((!matcher.find() ? 1 : 0) != 0, (String)"Unexpected second match", (Object[])new Object[0]);
            return location;
        }
        throw new IllegalStateException("Location not found in SHOW CREATE TABLE result");
    }

    private void dropTableFromMetastore(String tableName) {
        this.metastore.dropTable((String)this.getSession().getSchema().orElseThrow(), tableName, false);
        ((OptionalAssert)Assertions.assertThat((Optional)this.metastore.getTable((String)this.getSession().getSchema().orElseThrow(), tableName)).as("Table in metastore should be dropped", new Object[0])).isEmpty();
    }

    private String getColumnComment(String tableName, String columnName) {
        return (String)this.computeScalar("SELECT comment FROM information_schema.columns WHERE table_schema = '" + (String)this.getSession().getSchema().orElseThrow() + "' AND table_name = '" + tableName + "' AND column_name = '" + columnName + "'");
    }
}

