/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.Duration;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.cache.CachingHostAddressProvider;
import io.trino.filesystem.cache.DefaultCachingHostAddressProvider;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.TrinoViewHiveMetastore;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergFileSystemFactory;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergSplit;
import io.trino.plugin.iceberg.IcebergSplitSource;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.TableType;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.file.FileMetastoreTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.hms.TrinoHiveCatalog;
import io.trino.plugin.iceberg.catalog.rest.DefaultIcebergFileSystemFactory;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.plugin.iceberg.util.EqualityDeleteUtils;
import io.trino.spi.SplitWeight;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.TypeManager;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorSession;
import io.trino.tpch.TpchTable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Scan;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.metrics.InMemoryMetricsReporter;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIcebergSplitSource
extends AbstractTestQueryFramework {
    private static final ConnectorSession SESSION = TestingConnectorSession.builder().setPropertyMetadata(new IcebergSessionProperties(new IcebergConfig(), new OrcReaderConfig(), new OrcWriterConfig(), new ParquetReaderConfig(), new ParquetWriterConfig()).getSessionProperties()).build();
    private File metastoreDir;
    private TrinoFileSystemFactory fileSystemFactory;
    private TrinoCatalog catalog;

    protected QueryRunner createQueryRunner() throws Exception {
        File tempDir = Files.createTempDirectory("test_iceberg_split_source", new FileAttribute[0]).toFile();
        this.metastoreDir = new File(tempDir, "iceberg_data");
        DistributedQueryRunner queryRunner = IcebergQueryRunner.builder().setInitialTables(TpchTable.NATION).setMetastoreDirectory(this.metastoreDir).build();
        HiveMetastore metastore = IcebergTestUtils.getHiveMetastore((QueryRunner)queryRunner);
        this.fileSystemFactory = IcebergTestUtils.getFileSystemFactory((QueryRunner)queryRunner);
        CachingHiveMetastore cachingHiveMetastore = CachingHiveMetastore.createPerTransactionCache((HiveMetastore)metastore, (long)1000L);
        this.catalog = new TrinoHiveCatalog(new CatalogName("hive"), cachingHiveMetastore, new TrinoViewHiveMetastore((HiveMetastore)cachingHiveMetastore, false, "trino-version", "test"), this.fileSystemFactory, (TypeManager)new TestingTypeManager(), (IcebergTableOperationsProvider)new FileMetastoreTableOperationsProvider(this.fileSystemFactory), false, false, false, new IcebergConfig().isHideMaterializedViewStorageTable(), MoreExecutors.directExecutor());
        return queryRunner;
    }

    @AfterAll
    public void tearDown() throws IOException {
        MoreFiles.deleteRecursively((Path)this.metastoreDir.getParentFile().toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testIncompleteDynamicFilterTimeout() throws Exception {
        long startMillis = System.currentTimeMillis();
        SchemaTableName schemaTableName = new SchemaTableName("tpch", "nation");
        BaseTable nationTable = this.catalog.loadTable(SESSION, schemaTableName);
        IcebergTableHandle tableHandle = TestIcebergSplitSource.createTableHandle(schemaTableName, (Table)nationTable, (TupleDomain<IcebergColumnHandle>)TupleDomain.all());
        final CompletableFuture<Object> isBlocked = new CompletableFuture<Object>();
        try (IcebergSplitSource splitSource = new IcebergSplitSource((IcebergFileSystemFactory)new DefaultIcebergFileSystemFactory(this.fileSystemFactory), SESSION, tableHandle, (Table)nationTable, (Scan)nationTable.newScan(), Optional.empty(), new DynamicFilter(){

            public Set<ColumnHandle> getColumnsCovered() {
                return ImmutableSet.of();
            }

            public CompletableFuture<?> isBlocked() {
                return isBlocked;
            }

            public boolean isComplete() {
                return false;
            }

            public boolean isAwaitable() {
                return true;
            }

            public TupleDomain<ColumnHandle> getCurrentPredicate() {
                return TupleDomain.all();
            }
        }, new Duration(2.0, TimeUnit.SECONDS), Constraint.alwaysTrue(), (TypeManager)new TestingTypeManager(), false, new IcebergConfig().getMinimumAssignedSplitWeight(), (CachingHostAddressProvider)new DefaultCachingHostAddressProvider(), new InMemoryMetricsReporter(), MoreExecutors.newDirectExecutorService());){
            ImmutableList.Builder splits = ImmutableList.builder();
            while (!splitSource.isFinished()) {
                ((ConnectorSplitSource.ConnectorSplitBatch)splitSource.getNextBatch(100).get()).getSplits().stream().map(IcebergSplit.class::cast).forEach(arg_0 -> ((ImmutableList.Builder)splits).add(arg_0));
            }
            Assertions.assertThat((int)splits.build().size()).isGreaterThan(0);
            Assertions.assertThat((boolean)splitSource.isFinished()).isTrue();
            ((AbstractLongAssert)Assertions.assertThat((long)(System.currentTimeMillis() - startMillis)).as("IcebergSplitSource failed to wait for dynamicFilteringWaitTimeout", new Object[0])).isGreaterThanOrEqualTo(2000L);
        }
        finally {
            isBlocked.complete(null);
        }
    }

    @Test
    public void testFileStatisticsDomain() throws Exception {
        SchemaTableName schemaTableName = new SchemaTableName("tpch", "nation");
        BaseTable nationTable = this.catalog.loadTable(SESSION, schemaTableName);
        IcebergTableHandle tableHandle = TestIcebergSplitSource.createTableHandle(schemaTableName, (Table)nationTable, (TupleDomain<IcebergColumnHandle>)TupleDomain.all());
        IcebergSplit split = this.generateSplit((Table)nationTable, tableHandle, DynamicFilter.EMPTY);
        Assertions.assertThat((Object)split.getFileStatisticsDomain()).isEqualTo((Object)TupleDomain.all());
        IcebergColumnHandle nationKey = new IcebergColumnHandle(new ColumnIdentity(1, "nationkey", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of()), (io.trino.spi.type.Type)BigintType.BIGINT, (List)ImmutableList.of(), (io.trino.spi.type.Type)BigintType.BIGINT, true, Optional.empty());
        tableHandle = TestIcebergSplitSource.createTableHandle(schemaTableName, (Table)nationTable, (TupleDomain<IcebergColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)nationKey, (Object)NullableValue.of((io.trino.spi.type.Type)BigintType.BIGINT, (Object)1L))));
        split = this.generateSplit((Table)nationTable, tableHandle, DynamicFilter.EMPTY);
        Assertions.assertThat((Object)split.getFileStatisticsDomain()).isEqualTo((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)nationKey, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((io.trino.spi.type.Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)24L, (boolean)true), (Range[])new Range[0]), (boolean)false))));
        final IcebergColumnHandle regionKey = new IcebergColumnHandle(new ColumnIdentity(3, "regionkey", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of()), (io.trino.spi.type.Type)BigintType.BIGINT, (List)ImmutableList.of(), (io.trino.spi.type.Type)BigintType.BIGINT, true, Optional.empty());
        split = this.generateSplit((Table)nationTable, tableHandle, new DynamicFilter(){

            public Set<ColumnHandle> getColumnsCovered() {
                return ImmutableSet.of((Object)regionKey);
            }

            public CompletableFuture<?> isBlocked() {
                return NOT_BLOCKED;
            }

            public boolean isComplete() {
                return false;
            }

            public boolean isAwaitable() {
                return true;
            }

            public TupleDomain<ColumnHandle> getCurrentPredicate() {
                return TupleDomain.all();
            }
        });
        Assertions.assertThat((Object)split.getFileStatisticsDomain()).isEqualTo((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)nationKey, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((io.trino.spi.type.Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)24L, (boolean)true), (Range[])new Range[0]), (boolean)false), (Object)regionKey, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((io.trino.spi.type.Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)4L, (boolean)true), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    public void testBigintPartitionPruning() {
        IcebergColumnHandle bigintColumn = new IcebergColumnHandle(new ColumnIdentity(1, "name", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of()), (io.trino.spi.type.Type)BigintType.BIGINT, (List)ImmutableList.of(), (io.trino.spi.type.Type)BigintType.BIGINT, true, Optional.empty());
        Assertions.assertThat((boolean)IcebergSplitSource.partitionMatchesPredicate((Set)ImmutableSet.of((Object)bigintColumn), () -> ImmutableMap.of((Object)bigintColumn, (Object)NullableValue.of((io.trino.spi.type.Type)BigintType.BIGINT, (Object)1000L)), (TupleDomain)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)bigintColumn, (Object)NullableValue.of((io.trino.spi.type.Type)BigintType.BIGINT, (Object)100L))))).isFalse();
        Assertions.assertThat((boolean)IcebergSplitSource.partitionMatchesPredicate((Set)ImmutableSet.of((Object)bigintColumn), () -> ImmutableMap.of((Object)bigintColumn, (Object)NullableValue.of((io.trino.spi.type.Type)BigintType.BIGINT, (Object)1000L)), (TupleDomain)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)bigintColumn, (Object)NullableValue.of((io.trino.spi.type.Type)BigintType.BIGINT, (Object)1000L))))).isTrue();
        Assertions.assertThat((boolean)IcebergSplitSource.partitionMatchesPredicate((Set)ImmutableSet.of((Object)bigintColumn), () -> ImmutableMap.of((Object)bigintColumn, (Object)NullableValue.of((io.trino.spi.type.Type)BigintType.BIGINT, (Object)1000L)), (TupleDomain)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)bigintColumn, (Object)NullableValue.asNull((io.trino.spi.type.Type)BigintType.BIGINT))))).isFalse();
    }

    @Test
    public void testBigintStatisticsPruning() {
        IcebergColumnHandle bigintColumn = new IcebergColumnHandle(new ColumnIdentity(1, "name", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of()), (io.trino.spi.type.Type)BigintType.BIGINT, (List)ImmutableList.of(), (io.trino.spi.type.Type)BigintType.BIGINT, true, Optional.empty());
        ImmutableMap primitiveTypes = ImmutableMap.of((Object)1, (Object)Types.LongType.get());
        ImmutableMap lowerBound = ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.LongType.get(), (Object)1000L));
        ImmutableMap upperBound = ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.LongType.get(), (Object)2000L));
        TupleDomain domainLowerUpperBound = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)bigintColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((io.trino.spi.type.Type)BigintType.BIGINT, (Object)1000L, (boolean)true, (Object)2000L, (boolean)true), (Range[])new Range[0]), (boolean)false)));
        ImmutableList predicatedColumns = ImmutableList.of((Object)bigintColumn);
        Assertions.assertThat((Object)IcebergSplitSource.createFileStatisticsDomain((Map)primitiveTypes, (Map)lowerBound, (Map)upperBound, (Map)ImmutableMap.of((Object)1, (Object)0L), (List)predicatedColumns)).isEqualTo((Object)domainLowerUpperBound);
        TupleDomain domainLowerUpperBoundAllowNulls = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)bigintColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((io.trino.spi.type.Type)BigintType.BIGINT, (Object)1000L, (boolean)true, (Object)2000L, (boolean)true), (Range[])new Range[0]), (boolean)true)));
        Assertions.assertThat((Object)IcebergSplitSource.createFileStatisticsDomain((Map)primitiveTypes, (Map)lowerBound, (Map)upperBound, (Map)ImmutableMap.of((Object)1, (Object)1L), (List)predicatedColumns)).isEqualTo((Object)domainLowerUpperBoundAllowNulls);
    }

    @Test
    public void testNullStatisticsMaps() {
        IcebergColumnHandle bigintColumn = new IcebergColumnHandle(new ColumnIdentity(1, "name", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of()), (io.trino.spi.type.Type)BigintType.BIGINT, (List)ImmutableList.of(), (io.trino.spi.type.Type)BigintType.BIGINT, true, Optional.empty());
        ImmutableMap primitiveTypes = ImmutableMap.of((Object)1, (Object)Types.LongType.get());
        ImmutableMap lowerBound = ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.LongType.get(), (Object)-1000L));
        ImmutableMap upperBound = ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.LongType.get(), (Object)2000L));
        TupleDomain domainLessThanUpperBound = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)bigintColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((io.trino.spi.type.Type)BigintType.BIGINT, (Object)2000L), (Range[])new Range[0]), (boolean)false)));
        ImmutableList predicatedColumns = ImmutableList.of((Object)bigintColumn);
        Assertions.assertThat((Object)IcebergSplitSource.createFileStatisticsDomain((Map)primitiveTypes, null, (Map)upperBound, (Map)ImmutableMap.of((Object)1, (Object)0L), (List)predicatedColumns)).isEqualTo((Object)domainLessThanUpperBound);
        Assertions.assertThat((Object)IcebergSplitSource.createFileStatisticsDomain((Map)primitiveTypes, (Map)ImmutableMap.of(), (Map)upperBound, (Map)ImmutableMap.of((Object)1, (Object)0L), (List)predicatedColumns)).isEqualTo((Object)domainLessThanUpperBound);
        TupleDomain domainGreaterThanLessBound = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)bigintColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((io.trino.spi.type.Type)BigintType.BIGINT, (Object)-1000L), (Range[])new Range[0]), (boolean)false)));
        Assertions.assertThat((Object)IcebergSplitSource.createFileStatisticsDomain((Map)primitiveTypes, (Map)lowerBound, null, (Map)ImmutableMap.of((Object)1, (Object)0L), (List)predicatedColumns)).isEqualTo((Object)domainGreaterThanLessBound);
        Assertions.assertThat((Object)IcebergSplitSource.createFileStatisticsDomain((Map)primitiveTypes, (Map)lowerBound, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)1, (Object)0L), (List)predicatedColumns)).isEqualTo((Object)domainGreaterThanLessBound);
        Assertions.assertThat((Object)IcebergSplitSource.createFileStatisticsDomain((Map)primitiveTypes, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), null, (List)predicatedColumns)).isEqualTo((Object)TupleDomain.all());
        Assertions.assertThat((Object)IcebergSplitSource.createFileStatisticsDomain((Map)primitiveTypes, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (List)predicatedColumns)).isEqualTo((Object)TupleDomain.all());
        Assertions.assertThat((Object)IcebergSplitSource.createFileStatisticsDomain((Map)primitiveTypes, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)1, (Object)1L), (List)predicatedColumns)).isEqualTo((Object)TupleDomain.all());
        Assertions.assertThat((Object)IcebergSplitSource.createFileStatisticsDomain((Map)primitiveTypes, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)1, (Object)0L), (List)predicatedColumns)).isEqualTo((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)bigintColumn, (Object)Domain.notNull((io.trino.spi.type.Type)BigintType.BIGINT))));
    }

    @Test
    public void testSplitWeight() throws Exception {
        SchemaTableName schemaTableName = new SchemaTableName("tpch", "nation");
        BaseTable nationTable = this.catalog.loadTable(SESSION, schemaTableName);
        nationTable.updateProperties().set("read.split.target-size", "10000").commit();
        IcebergTableHandle tableHandle = TestIcebergSplitSource.createTableHandle(schemaTableName, (Table)nationTable, (TupleDomain<IcebergColumnHandle>)TupleDomain.all());
        IcebergSplit split = this.generateSplit((Table)nationTable, tableHandle, DynamicFilter.EMPTY);
        SplitWeight weightWithoutDelete = split.getSplitWeight();
        String dataFilePath = (String)this.computeActual("SELECT file_path FROM \"" + schemaTableName.getTableName() + "$files\" LIMIT 1").getOnlyValue();
        ForwardingFileIo fileIo = new ForwardingFileIo(this.fileSystemFactory.create(SESSION));
        PositionDeleteWriter writer = Parquet.writeDeletes((OutputFile)fileIo.newOutputFile("local:///delete_file_" + String.valueOf(UUID.randomUUID()))).createWriterFunc(GenericParquetWriter::create).forTable((Table)nationTable).overwrite().rowSchema(nationTable.schema()).withSpec(PartitionSpec.unpartitioned()).buildPositionWriter();
        PositionDelete positionDelete = PositionDelete.create();
        PositionDelete record = positionDelete.set((CharSequence)dataFilePath, 0L, (Object)GenericRecord.create((Schema)nationTable.schema()));
        try (PositionDeleteWriter ignored = writer;){
            writer.write(record);
        }
        nationTable.newRowDelta().addDeletes(writer.toDeleteFile()).commit();
        split = this.generateSplit((Table)nationTable, tableHandle, DynamicFilter.EMPTY);
        SplitWeight splitWeightWithPositionDelete = split.getSplitWeight();
        Assertions.assertThat((long)splitWeightWithPositionDelete.getRawValue()).isGreaterThan(weightWithoutDelete.getRawValue());
        EqualityDeleteUtils.writeEqualityDeleteForTable((Table)nationTable, this.fileSystemFactory, Optional.of(nationTable.spec()), Optional.of(new PartitionData((Object[])new Long[]{1L})), (Map<String, Object>)ImmutableMap.of((Object)"regionkey", (Object)1L), Optional.empty());
        split = this.generateSplit((Table)nationTable, tableHandle, DynamicFilter.EMPTY);
        Assertions.assertThat((long)split.getSplitWeight().getRawValue()).isGreaterThan(splitWeightWithPositionDelete.getRawValue());
    }

    private IcebergSplit generateSplit(Table nationTable, IcebergTableHandle tableHandle, DynamicFilter dynamicFilter) throws Exception {
        try (IcebergSplitSource splitSource = new IcebergSplitSource((IcebergFileSystemFactory)new DefaultIcebergFileSystemFactory(this.fileSystemFactory), SESSION, tableHandle, nationTable, (Scan)nationTable.newScan(), Optional.empty(), dynamicFilter, new Duration(0.0, TimeUnit.SECONDS), Constraint.alwaysTrue(), (TypeManager)new TestingTypeManager(), false, 0.0, (CachingHostAddressProvider)new DefaultCachingHostAddressProvider(), new InMemoryMetricsReporter(), MoreExecutors.newDirectExecutorService());){
            ImmutableList.Builder builder = ImmutableList.builder();
            while (!splitSource.isFinished()) {
                ((ConnectorSplitSource.ConnectorSplitBatch)splitSource.getNextBatch(100).get()).getSplits().stream().map(IcebergSplit.class::cast).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            }
            ImmutableList splits = builder.build();
            Assertions.assertThat((List)splits).hasSize(1);
            Assertions.assertThat((boolean)splitSource.isFinished()).isTrue();
            IcebergSplit icebergSplit = (IcebergSplit)splits.getFirst();
            return icebergSplit;
        }
    }

    private static IcebergTableHandle createTableHandle(SchemaTableName schemaTableName, Table nationTable, TupleDomain<IcebergColumnHandle> unenforcedPredicate) {
        return new IcebergTableHandle(CatalogHandle.fromId((String)"iceberg:NORMAL:v12345"), schemaTableName.getSchemaName(), schemaTableName.getTableName(), TableType.DATA, Optional.empty(), SchemaParser.toJson((Schema)nationTable.schema()), Optional.of(PartitionSpecParser.toJson((PartitionSpec)nationTable.spec())), 1, unenforcedPredicate, TupleDomain.all(), OptionalLong.empty(), (Set)ImmutableSet.of(), Optional.empty(), nationTable.location(), nationTable.properties(), Optional.empty(), false, Optional.empty(), (Set)ImmutableSet.of(), Optional.of(false));
    }
}

