/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.plugin.iceberg.IcebergTableName;
import io.trino.plugin.iceberg.TableType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIcebergTableName {
    @Test
    public void testParse() {
        TestIcebergTableName.assertParseNameAndType("abc", "abc", TableType.DATA);
        TestIcebergTableName.assertParseNameAndType("abc$history", "abc", TableType.HISTORY);
        TestIcebergTableName.assertParseNameAndType("abc$snapshots", "abc", TableType.SNAPSHOTS);
        TestIcebergTableName.assertInvalid("abc$data");
        TestIcebergTableName.assertInvalid("abc@123");
        TestIcebergTableName.assertInvalid("abc@xyz");
        TestIcebergTableName.assertInvalid("abc$what");
        TestIcebergTableName.assertInvalid("abc@123$data@456");
        TestIcebergTableName.assertInvalid("abc@123$snapshots");
        TestIcebergTableName.assertInvalid("abc$snapshots@456");
        TestIcebergTableName.assertInvalid("xyz$data@456");
        TestIcebergTableName.assertInvalid("abc$partitions@456");
        TestIcebergTableName.assertInvalid("abc$manifests@456");
    }

    @Test
    public void testIsDataTable() {
        Assertions.assertThat((boolean)IcebergTableName.isDataTable((String)"abc")).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IcebergTableName.isDataTable((String)"abc$data")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid Iceberg table name: abc$data");
        Assertions.assertThat((boolean)IcebergTableName.isDataTable((String)"abc$history")).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IcebergTableName.isDataTable((String)"abc$invalid")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid Iceberg table name: abc$invalid");
    }

    @Test
    public void testTableNameFrom() {
        Assertions.assertThat((String)IcebergTableName.tableNameFrom((String)"abc")).isEqualTo("abc");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IcebergTableName.tableNameFrom((String)"abc$data")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid Iceberg table name: abc$data");
        Assertions.assertThat((String)IcebergTableName.tableNameFrom((String)"abc$history")).isEqualTo("abc");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IcebergTableName.tableNameFrom((String)"abc$invalid")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid Iceberg table name: abc$invalid");
    }

    @Test
    public void testTableTypeFrom() {
        Assertions.assertThat((Comparable)IcebergTableName.tableTypeFrom((String)"abc")).isEqualTo((Object)TableType.DATA);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IcebergTableName.tableTypeFrom((String)"abc$data")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid Iceberg table name: abc$data");
        Assertions.assertThat((Comparable)IcebergTableName.tableTypeFrom((String)"abc$history")).isEqualTo((Object)TableType.HISTORY);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IcebergTableName.tableTypeFrom((String)"abc$invalid")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid Iceberg table name: abc$invalid");
    }

    @Test
    public void testTableNameWithType() {
        Assertions.assertThat((String)IcebergTableName.tableNameWithType((String)"abc", (TableType)TableType.DATA)).isEqualTo("abc$data");
        Assertions.assertThat((String)IcebergTableName.tableNameWithType((String)"abc", (TableType)TableType.HISTORY)).isEqualTo("abc$history");
    }

    private static void assertInvalid(String inputName) {
        Assertions.assertThat((boolean)IcebergTableName.isIcebergTableName((String)inputName)).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IcebergTableName.tableTypeFrom((String)inputName)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid Iceberg table name: " + inputName);
    }

    private static void assertParseNameAndType(String inputName, String tableName, TableType tableType) {
        Assertions.assertThat((boolean)IcebergTableName.isIcebergTableName((String)inputName)).isTrue();
        Assertions.assertThat((String)IcebergTableName.tableNameFrom((String)inputName)).isEqualTo(tableName);
        Assertions.assertThat((Comparable)IcebergTableName.tableTypeFrom((String)inputName)).isEqualTo((Object)tableType);
    }
}

