/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.Table;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.iceberg.DataFileRecord;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorSession;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestIcebergTableWithCustomLocation
extends AbstractTestQueryFramework {
    private HiveMetastore metastore;
    private TrinoFileSystem fileSystem;

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = IcebergQueryRunner.builder().setIcebergProperties(Map.of("iceberg.unique-table-location", "true")).build();
        this.metastore = IcebergTestUtils.getHiveMetastore((QueryRunner)queryRunner);
        return queryRunner;
    }

    @BeforeAll
    public void initFileSystem() {
        this.fileSystem = IcebergTestUtils.getFileSystemFactory((QueryRunner)this.getDistributedQueryRunner()).create(TestingConnectorSession.SESSION);
    }

    @Test
    public void testTableHasUuidSuffixInLocation() {
        String tableName = "table_with_uuid";
        this.assertQuerySucceeds(String.format("CREATE TABLE %s as select 1 as val", tableName));
        Optional table = this.metastore.getTable("tpch", tableName);
        ((OptionalAssert)Assertions.assertThat((Optional)table).as("Table should exist", new Object[0])).isPresent();
        String location = ((Table)table.get()).getStorage().getLocation();
        Assertions.assertThat((String)location).matches((CharSequence)String.format(".*%s-[0-9a-f]{32}", tableName));
    }

    @Test
    public void testCreateAndDrop() throws IOException {
        String tableName = "test_create_and_drop";
        this.assertQuerySucceeds(String.format("CREATE TABLE %s as select 1 as val", tableName));
        Table table = (Table)this.metastore.getTable("tpch", tableName).orElseThrow();
        Assertions.assertThat((String)table.getTableType()).isEqualTo(TableType.EXTERNAL_TABLE.name());
        Location tableLocation = Location.of((String)table.getStorage().getLocation());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.newInputFile(tableLocation).exists()).describedAs("The directory corresponding to the table storage location should exist", new Object[0])).isTrue();
        MaterializedResult materializedResult = this.computeActual("SELECT * FROM \"test_create_and_drop$files\"");
        Assertions.assertThat((int)materializedResult.getRowCount()).isEqualTo(1);
        DataFileRecord dataFile = DataFileRecord.toDataFileRecord((MaterializedRow)materializedResult.getMaterializedRows().get(0));
        Location dataFileLocation = Location.of((String)dataFile.getFilePath());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.newInputFile(dataFileLocation).exists()).describedAs("The data file should exist", new Object[0])).isTrue();
        this.assertQuerySucceeds(String.format("DROP TABLE %s", tableName));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.metastore.getTable("tpch", tableName).isPresent()).describedAs("Table should be dropped", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.newInputFile(dataFileLocation).exists()).describedAs("The data file should have been removed", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.newInputFile(tableLocation).exists()).describedAs("The directory corresponding to the dropped Iceberg table should not be removed because it may be shared with other tables", new Object[0])).isFalse();
    }

    @Test
    public void testCreateRenameDrop() {
        String tableName = "test_create_rename_drop";
        String renamedName = "test_create_rename_drop_renamed";
        this.assertQuerySucceeds(String.format("CREATE TABLE %s as select 1 as val", tableName));
        Optional table = this.metastore.getTable("tpch", tableName);
        ((OptionalAssert)Assertions.assertThat((Optional)table).as("Table should exist", new Object[0])).isPresent();
        String tableInitialLocation = ((Table)table.get()).getStorage().getLocation();
        this.assertQuerySucceeds(String.format("ALTER TABLE %s RENAME TO %s", tableName, renamedName));
        Optional renamedTable = this.metastore.getTable("tpch", renamedName);
        ((OptionalAssert)Assertions.assertThat((Optional)renamedTable).as("Table should exist", new Object[0])).isPresent();
        String renamedTableLocation = ((Table)renamedTable.get()).getStorage().getLocation();
        ((AbstractStringAssert)Assertions.assertThat((String)renamedTableLocation).describedAs("Location should not be changed", new Object[0])).isEqualTo(tableInitialLocation);
        this.assertQuerySucceeds(String.format("DROP TABLE %s", renamedName));
        ((OptionalAssert)Assertions.assertThat((Optional)this.metastore.getTable("tpch", tableName)).as("Initial table should not exist", new Object[0])).isEmpty();
        ((OptionalAssert)Assertions.assertThat((Optional)this.metastore.getTable("tpch", renamedName)).as("Renamed table should be dropped", new Object[0])).isEmpty();
    }

    @Test
    public void testCreateRenameCreate() {
        String tableName = "test_create_rename_create";
        String renamedName = "test_create_rename_create_renamed";
        this.assertQuerySucceeds(String.format("CREATE TABLE %s as select 1 as val", tableName));
        Optional table = this.metastore.getTable("tpch", tableName);
        ((OptionalAssert)Assertions.assertThat((Optional)table).as("Table should exist", new Object[0])).isPresent();
        String tableInitialLocation = ((Table)table.get()).getStorage().getLocation();
        this.assertQuerySucceeds(String.format("ALTER TABLE %s RENAME TO %s", tableName, renamedName));
        Optional renamedTable = this.metastore.getTable("tpch", renamedName);
        ((OptionalAssert)Assertions.assertThat((Optional)renamedTable).as("Table should exist", new Object[0])).isPresent();
        String renamedTableLocation = ((Table)renamedTable.get()).getStorage().getLocation();
        ((AbstractStringAssert)Assertions.assertThat((String)renamedTableLocation).describedAs("Location should not be changed", new Object[0])).isEqualTo(tableInitialLocation);
        this.assertQuerySucceeds(String.format("CREATE TABLE %s as select 1 as val", tableName));
        Optional recreatedTableWithInitialName = this.metastore.getTable("tpch", tableName);
        ((OptionalAssert)Assertions.assertThat((Optional)recreatedTableWithInitialName).as("Table should exist", new Object[0])).isPresent();
        String recreatedTableLocation = ((Table)recreatedTableWithInitialName.get()).getStorage().getLocation();
        ((AbstractStringAssert)Assertions.assertThat((String)tableInitialLocation).describedAs("Location should be different", new Object[0])).isNotEqualTo((Object)recreatedTableLocation);
    }
}

