/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.Table;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.iceberg.DataFileRecord;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingNames;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIcebergTableWithExternalLocation
extends AbstractTestQueryFramework {
    private HiveMetastore metastore;
    private TrinoFileSystem fileSystem;

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = IcebergQueryRunner.builder().build();
        this.metastore = IcebergTestUtils.getHiveMetastore((QueryRunner)queryRunner);
        return queryRunner;
    }

    @BeforeAll
    public void initFileSystem() {
        this.fileSystem = IcebergTestUtils.getFileSystemFactory((QueryRunner)this.getDistributedQueryRunner()).create(TestingConnectorSession.SESSION);
    }

    @Test
    public void testCreateAndDrop() throws IOException {
        String tableName = "test_table_external_create_and_drop";
        File tempDir = this.getDistributedQueryRunner().getCoordinator().getBaseDataDir().toFile();
        String tempDirPath = tempDir.toURI().toASCIIString() + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds(String.format("CREATE TABLE %s ( x bigint) WITH (location = '%s')", tableName, tempDirPath));
        this.assertQuerySucceeds(String.format("INSERT INTO %s VALUES (1), (2), (3)", tableName));
        Table table = (Table)this.metastore.getTable("tpch", tableName).orElseThrow();
        Assertions.assertThat((String)table.getTableType()).isEqualTo(TableType.EXTERNAL_TABLE.name());
        Location tableLocation = Location.of((String)table.getStorage().getLocation());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.newInputFile(tableLocation).exists()).describedAs("The directory corresponding to the table storage location should exist", new Object[0])).isTrue();
        MaterializedResult materializedResult = this.computeActual("SELECT * FROM \"test_table_external_create_and_drop$files\"");
        Assertions.assertThat((int)materializedResult.getRowCount()).isEqualTo(1);
        DataFileRecord dataFile = DataFileRecord.toDataFileRecord((MaterializedRow)materializedResult.getMaterializedRows().get(0));
        Location dataFileLocation = Location.of((String)dataFile.getFilePath());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.newInputFile(dataFileLocation).exists()).describedAs("The data file should exist", new Object[0])).isTrue();
        this.assertQuerySucceeds(String.format("DROP TABLE %s", tableName));
        ((OptionalAssert)Assertions.assertThat((Optional)this.metastore.getTable("tpch", tableName)).as("Table should be dropped", new Object[0])).isEmpty();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.newInputFile(dataFileLocation).exists()).describedAs("The data file should have been removed", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.newInputFile(tableLocation).exists()).describedAs("The directory corresponding to the dropped Iceberg table should be removed as we don't allow shared locations.", new Object[0])).isFalse();
    }
}

