/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.Table;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorSession;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class TestIcebergTableWithObjectStoreLayout
extends AbstractTestQueryFramework {
    private HiveMetastore metastore;
    private TrinoFileSystem fileSystem;

    TestIcebergTableWithObjectStoreLayout() {
    }

    protected DistributedQueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = IcebergQueryRunner.builder().addIcebergProperty("iceberg.object-store-layout.enabled", "true").build();
        this.metastore = IcebergTestUtils.getHiveMetastore((QueryRunner)queryRunner);
        this.fileSystem = IcebergTestUtils.getFileSystemFactory((QueryRunner)queryRunner).create(TestingConnectorSession.SESSION);
        return queryRunner;
    }

    @Test
    void testCreateTableWithDataLocation() throws Exception {
        this.assertQuerySucceeds("CREATE TABLE test_create_table_with_different_location WITH (data_location = 'local:///table-location/abc') AS SELECT 1 AS val");
        Table table = (Table)this.metastore.getTable("tpch", "test_create_table_with_different_location").orElseThrow();
        Assertions.assertThat((String)table.getTableType()).isEqualTo(TableType.EXTERNAL_TABLE.name());
        Location tableLocation = Location.of((String)table.getStorage().getLocation());
        Assertions.assertThat((boolean)this.fileSystem.newInputFile(tableLocation).exists()).isTrue();
        String filePath = (String)this.computeScalar("SELECT file_path FROM \"test_create_table_with_different_location$files\"");
        Location dataFileLocation = Location.of((String)filePath);
        Assertions.assertThat((boolean)this.fileSystem.newInputFile(dataFileLocation).exists()).isTrue();
        Assertions.assertThat((String)filePath).matches((CharSequence)"local:///table-location/abc/.{6}/tpch/test_create_table_with_different_location-.*/.*\\.parquet");
        this.assertQuerySucceeds("DROP TABLE test_create_table_with_different_location");
        Assertions.assertThat((Optional)this.metastore.getTable("tpch", "test_create_table_with_different_location")).isEmpty();
        Assertions.assertThat((boolean)this.fileSystem.newInputFile(dataFileLocation).exists()).isFalse();
        Assertions.assertThat((boolean)this.fileSystem.newInputFile(tableLocation).exists()).isFalse();
    }
}

