/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.spi.type.TypeManager;
import io.trino.type.InternalTypeManager;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Test;

public class TestIcebergUtil {
    @Test
    public void testParseVersion() {
        Assertions.assertThat((int)IcebergUtil.parseVersion((String)"00000-409702ba-4735-4645-8f14-09537cc0b2c8.metadata.json")).isEqualTo(0);
        Assertions.assertThat((int)IcebergUtil.parseVersion((String)"99999-409702ba-4735-4645-8f14-09537cc0b2c8.metadata.json")).isEqualTo(99999);
        Assertions.assertThat((int)IcebergUtil.parseVersion((String)"00010-409702ba-4735-4645-8f14-09537cc0b2c8.metadata.json")).isEqualTo(10);
        Assertions.assertThat((int)IcebergUtil.parseVersion((String)"00011-409702ba-4735-4645-8f14-09537cc0b2c8.metadata.json")).isEqualTo(11);
        Assertions.assertThat((int)IcebergUtil.parseVersion((String)"v0.metadata.json")).isEqualTo(0);
        Assertions.assertThat((int)IcebergUtil.parseVersion((String)"v10.metadata.json")).isEqualTo(10);
        Assertions.assertThat((int)IcebergUtil.parseVersion((String)"v99999.metadata.json")).isEqualTo(99999);
        Assertions.assertThat((int)IcebergUtil.parseVersion((String)"v0.gz.metadata.json")).isEqualTo(0);
        Assertions.assertThat((int)IcebergUtil.parseVersion((String)"v0.metadata.json.gz")).isEqualTo(0);
        Assertions.assertThatThrownBy(() -> IcebergUtil.parseVersion((String)"hdfs://hadoop-master:9000/user/hive/warehouse/orders_5-581fad8517934af6be1857a903559d44/metadata/00000-409702ba-4735-4645-8f14-09537cc0b2c8.metadata.json")).hasMessageMatching("Not a file name: .*");
        Assertions.assertThatThrownBy(() -> IcebergUtil.parseVersion((String)"orders_5_581fad8517934af6be1857a903559d44")).hasMessageMatching("Invalid metadata file name: .*");
        Assertions.assertThatThrownBy(() -> IcebergUtil.parseVersion((String)"metadata")).hasMessageMatching("Invalid metadata file name:.*");
        Assertions.assertThatThrownBy(() -> IcebergUtil.parseVersion((String)"00010_409702ba_4735_4645_8f14_09537cc0b2c8.metadata.json")).hasMessageMatching("Invalid metadata file name:.*");
        Assertions.assertThatThrownBy(() -> IcebergUtil.parseVersion((String)"v10_metadata_json")).hasMessageMatching("Invalid metadata file name:.*");
        Assertions.assertThatThrownBy(() -> IcebergUtil.parseVersion((String)"v1..gz.metadata.json")).hasMessageMatching("Invalid metadata file name:.*");
        Assertions.assertThatThrownBy(() -> IcebergUtil.parseVersion((String)"v1.metadata.json.gz.")).hasMessageMatching("Invalid metadata file name:.*");
        Assertions.assertThatThrownBy(() -> IcebergUtil.parseVersion((String)"00003_409702ba-4735-4645-8f14-09537cc0b2c8.metadata.json")).hasMessageMatching("Invalid metadata file name:.*");
        Assertions.assertThatThrownBy(() -> IcebergUtil.parseVersion((String)"-00010-409702ba-4735-4645-8f14-09537cc0b2c8.metadata.json")).hasMessageMatching("Invalid metadata file name:.*");
        Assertions.assertThatThrownBy(() -> IcebergUtil.parseVersion((String)"v-10.metadata.json")).hasMessageMatching("Invalid metadata file name:.*");
    }

    @Test
    public void testGetProjectedColumns() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"value", (Type)Types.StringType.get()), Types.NestedField.required((int)4, (String)"list", (Type)Types.ListType.ofRequired((int)5, (Type)Types.StringType.get())), Types.NestedField.required((int)6, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)7, (String)"value", (Type)Types.StringType.get())}))}))});
        Assertions.assertThat((List)IcebergUtil.getProjectedColumns((Schema)schema, (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER)).extracting(new Function[]{IcebergColumnHandle::getId, IcebergColumnHandle::getName, column -> column.getBaseColumn().getId(), IcebergColumnHandle::getPath}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{1, "id", 1, ImmutableList.of()}), Tuple.tuple((Object[])new Object[]{2, "nested", 2, ImmutableList.of()}), Tuple.tuple((Object[])new Object[]{3, "value", 2, ImmutableList.of((Object)3)}), Tuple.tuple((Object[])new Object[]{4, "list", 2, ImmutableList.of((Object)4)}), Tuple.tuple((Object[])new Object[]{5, "element", 2, ImmutableList.of((Object)4, (Object)5)}), Tuple.tuple((Object[])new Object[]{6, "nested", 2, ImmutableList.of((Object)6)}), Tuple.tuple((Object[])new Object[]{7, "value", 2, ImmutableList.of((Object)6, (Object)7)})});
        Assertions.assertThat((List)IcebergUtil.getProjectedColumns((Schema)schema, (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (Set)ImmutableSet.of((Object)1))).extracting(new Function[]{IcebergColumnHandle::getId, IcebergColumnHandle::getName, column -> column.getBaseColumn().getId(), IcebergColumnHandle::getPath}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{1, "id", 1, ImmutableList.of()})});
        Assertions.assertThat((List)IcebergUtil.getProjectedColumns((Schema)schema, (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (Set)ImmutableSet.of((Object)2))).extracting(new Function[]{IcebergColumnHandle::getId, IcebergColumnHandle::getName, column -> column.getBaseColumn().getId(), IcebergColumnHandle::getPath}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{2, "nested", 2, ImmutableList.of()})});
        Assertions.assertThat((List)IcebergUtil.getProjectedColumns((Schema)schema, (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (Set)ImmutableSet.of((Object)3))).extracting(new Function[]{IcebergColumnHandle::getId, IcebergColumnHandle::getName, column -> column.getBaseColumn().getId(), IcebergColumnHandle::getPath}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{3, "value", 2, ImmutableList.of((Object)3)})});
        Assertions.assertThat((List)IcebergUtil.getProjectedColumns((Schema)schema, (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (Set)ImmutableSet.of((Object)4))).extracting(new Function[]{IcebergColumnHandle::getId, IcebergColumnHandle::getName, column -> column.getBaseColumn().getId(), IcebergColumnHandle::getPath}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{4, "list", 2, ImmutableList.of((Object)4)})});
        Assertions.assertThat((List)IcebergUtil.getProjectedColumns((Schema)schema, (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (Set)ImmutableSet.of((Object)5))).extracting(new Function[]{IcebergColumnHandle::getId, IcebergColumnHandle::getName, column -> column.getBaseColumn().getId(), IcebergColumnHandle::getPath}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{5, "element", 2, ImmutableList.of((Object)4, (Object)5)})});
        Assertions.assertThat((List)IcebergUtil.getProjectedColumns((Schema)schema, (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (Set)ImmutableSet.of((Object)6))).extracting(new Function[]{IcebergColumnHandle::getId, IcebergColumnHandle::getName, column -> column.getBaseColumn().getId(), IcebergColumnHandle::getPath}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{6, "nested", 2, ImmutableList.of((Object)6)})});
        Assertions.assertThat((List)IcebergUtil.getProjectedColumns((Schema)schema, (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (Set)ImmutableSet.of((Object)7))).extracting(new Function[]{IcebergColumnHandle::getId, IcebergColumnHandle::getName, column -> column.getBaseColumn().getId(), IcebergColumnHandle::getPath}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{7, "value", 2, ImmutableList.of((Object)6, (Object)7)})});
        Assertions.assertThat((List)IcebergUtil.getProjectedColumns((Schema)schema, (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (Set)ImmutableSet.of((Object)3, (Object)7))).extracting(new Function[]{IcebergColumnHandle::getId, IcebergColumnHandle::getName, column -> column.getBaseColumn().getId(), IcebergColumnHandle::getPath}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{3, "value", 2, ImmutableList.of((Object)3)}), Tuple.tuple((Object[])new Object[]{7, "value", 2, ImmutableList.of((Object)6, (Object)7)})});
        Assertions.assertThat((List)IcebergUtil.getProjectedColumns((Schema)schema, (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (Set)ImmutableSet.of((Object)1, (Object)4, (Object)5))).extracting(new Function[]{IcebergColumnHandle::getId, IcebergColumnHandle::getName, column -> column.getBaseColumn().getId(), IcebergColumnHandle::getPath}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{1, "id", 1, ImmutableList.of()}), Tuple.tuple((Object[])new Object[]{4, "list", 2, ImmutableList.of((Object)4)}), Tuple.tuple((Object[])new Object[]{5, "element", 2, ImmutableList.of((Object)4, (Object)5)})});
    }
}

