/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.Session;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.Column;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveType;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.Storage;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.TableStatisticsReader;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.plugin.iceberg.util.EqualityDeleteUtils;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.DoubleRange;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.TypeManager;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.testing.sql.TestTable;
import io.trino.tpch.TpchTable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIcebergV2
extends AbstractTestQueryFramework {
    private HiveMetastore metastore;
    private TrinoFileSystemFactory fileSystemFactory;
    private TrinoCatalog catalog;

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = IcebergQueryRunner.builder().setInitialTables(TpchTable.NATION).build();
        this.metastore = IcebergTestUtils.getHiveMetastore((QueryRunner)queryRunner);
        this.fileSystemFactory = IcebergTestUtils.getFileSystemFactory((QueryRunner)queryRunner);
        this.catalog = IcebergTestUtils.getTrinoCatalog(this.metastore, this.fileSystemFactory, "iceberg");
        queryRunner.installPlugin((Plugin)new TestingHivePlugin(queryRunner.getCoordinator().getBaseDataDir().resolve("iceberg_data")));
        queryRunner.createCatalog("hive", "hive", (Map)ImmutableMap.builder().put((Object)"hive.security", (Object)"allow-all").buildOrThrow());
        return queryRunner;
    }

    @Test
    public void testSettingFormatVersion() {
        String tableName = "test_seting_format_version_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (format_version = 2) AS SELECT * FROM tpch.tiny.nation", 25L);
        Assertions.assertThat((int)this.loadTable(tableName).operations().current().formatVersion()).isEqualTo(2);
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (format_version = 1) AS SELECT * FROM tpch.tiny.nation", 25L);
        Assertions.assertThat((int)this.loadTable(tableName).operations().current().formatVersion()).isEqualTo(1);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDefaultFormatVersion() {
        String tableName = "test_default_format_version_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.nation", 25L);
        Assertions.assertThat((int)this.loadTable(tableName).operations().current().formatVersion()).isEqualTo(2);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testSetPropertiesObjectStoreLayoutEnabled() {
        try (TestTable table = this.newTrinoTable("test_object_store", "(x int) WITH (object_store_layout_enabled = false)");){
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).doesNotContain(new CharSequence[]{"object_store_layout_enabled"});
            Assertions.assertThat((Map)this.loadTable(table.getName()).properties()).doesNotContainKey((Object)"write.object-storage.enabled");
            this.assertUpdate("ALTER TABLE " + table.getName() + " SET PROPERTIES object_store_layout_enabled = true");
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).contains(new CharSequence[]{"object_store_layout_enabled = true"});
            Assertions.assertThat((Map)this.loadTable(table.getName()).properties()).containsEntry((Object)"write.object-storage.enabled", (Object)"true");
        }
    }

    @Test
    public void testSetPropertiesDataLocation() {
        try (TestTable table = this.newTrinoTable("test_data_location", "(x int)");){
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).doesNotContain(new CharSequence[]{"data_location ="});
            Assertions.assertThat((Map)this.loadTable(table.getName()).properties()).doesNotContainKey((Object)"write.data.path");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " SET PROPERTIES data_location = 'local:///data-location'", "Data location can only be set when object store layout is enabled");
            this.assertUpdate("ALTER TABLE " + table.getName() + " SET PROPERTIES object_store_layout_enabled = true, data_location = 'local:///data-location'");
            ((AbstractStringAssert)Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).contains(new CharSequence[]{"object_store_layout_enabled = true"})).contains(new CharSequence[]{"data_location = 'local:///data-location'"});
            ((MapAssert)Assertions.assertThat((Map)this.loadTable(table.getName()).properties()).containsEntry((Object)"write.object-storage.enabled", (Object)"true")).containsEntry((Object)"write.data.path", (Object)"local:///data-location");
        }
    }

    @Test
    public void testV2TableRead() {
        String tableName = "test_v2_table_read" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (format_version = 1) AS SELECT * FROM tpch.tiny.nation", 25L);
        this.updateTableToV2(tableName);
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation");
    }

    @Test
    public void testV2TableWithPositionDelete() throws Exception {
        String tableName = "test_v2_row_delete" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.nation", 25L);
        BaseTable icebergTable = this.loadTable(tableName);
        String dataFilePath = (String)this.computeActual("SELECT file_path FROM \"" + tableName + "$files\" LIMIT 1").getOnlyValue();
        ForwardingFileIo fileIo = new ForwardingFileIo(this.fileSystemFactory.create(IcebergTestUtils.SESSION));
        PositionDeleteWriter writer = Parquet.writeDeletes((OutputFile)fileIo.newOutputFile("local:///delete_file_" + String.valueOf(UUID.randomUUID()))).createWriterFunc(GenericParquetWriter::create).forTable((Table)icebergTable).overwrite().rowSchema(icebergTable.schema()).withSpec(PartitionSpec.unpartitioned()).buildPositionWriter();
        PositionDelete positionDelete = PositionDelete.create();
        PositionDelete record = positionDelete.set((CharSequence)dataFilePath, 0L, (Object)GenericRecord.create((Schema)icebergTable.schema()));
        try (PositionDeleteWriter ignored = writer;){
            writer.write(record);
        }
        icebergTable.newRowDelta().addDeletes(writer.toDeleteFile()).commit();
        this.assertQuery("SELECT count(*) FROM " + tableName, "VALUES 24");
    }

    @Test
    public void testV2TableWithEqualityDelete() throws Exception {
        String tableName = "test_v2_equality_delete" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.nation", 25L);
        BaseTable icebergTable = this.loadTable(tableName);
        this.writeEqualityDeleteToNationTable((Table)icebergTable, Optional.of(icebergTable.spec()), Optional.of(new PartitionData((Object[])new Long[]{1L})));
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation WHERE regionkey != 1");
        this.assertQuery("SELECT nationkey, comment FROM " + tableName, "SELECT nationkey, comment FROM nation WHERE regionkey != 1");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM tpch.tiny.nation", 25L);
        this.writeEqualityDeleteToNationTable((Table)icebergTable, Optional.of(icebergTable.spec()), Optional.of(new PartitionData((Object[])new Long[]{2L})), (Map<String, Object>)ImmutableMap.of((Object)"regionkey", (Object)2L));
        this.assertQuery("SELECT count(*) FROM \"" + tableName + "$files\" WHERE content = " + FileContent.EQUALITY_DELETES.id(), "VALUES 2");
    }

    @Test
    public void testV2TableWithEqualityDeleteDifferentColumnOrder() throws Exception {
        String tableName = "test_v2_equality_delete_different_order" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.nation", 25L);
        BaseTable icebergTable = this.loadTable(tableName);
        this.writeEqualityDeleteToNationTable((Table)icebergTable, Optional.of(icebergTable.spec()), Optional.empty(), (Map<String, Object>)ImmutableMap.of((Object)"regionkey", (Object)1L, (Object)"name", (Object)"ARGENTINA"));
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation WHERE name != 'ARGENTINA'");
        this.assertQuery("SELECT nationkey, comment FROM " + tableName, "SELECT nationkey, comment FROM nation WHERE name != 'ARGENTINA'");
    }

    @Test
    public void testV2TableWithEqualityDeleteWhenColumnIsNested() throws Exception {
        String tableName = "test_v2_equality_delete_column_nested" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT regionkey, ARRAY[1,2] array_column, MAP(ARRAY[1], ARRAY[2]) map_column, CAST(ROW(1, 2e0) AS ROW(x BIGINT, y DOUBLE)) row_column FROM tpch.tiny.nation", 25L);
        BaseTable icebergTable = this.loadTable(tableName);
        this.writeEqualityDeleteToNationTable((Table)icebergTable, Optional.of(icebergTable.spec()), Optional.of(new PartitionData((Object[])new Long[]{1L})));
        this.assertQuery("SELECT array_column[1], map_column[1], row_column.x FROM " + tableName, "SELECT 1, 2, 1 FROM nation WHERE regionkey != 1");
    }

    @Test
    public void testParquetMissingFieldId() throws Exception {
        String hiveTableName = "test_hive_parquet" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + "(names ARRAY(varchar)) WITH (format = 'PARQUET')");
        this.assertUpdate("INSERT INTO hive.tpch." + hiveTableName + " VALUES ARRAY['Alice', 'Bob'], ARRAY['Carol', 'Dave'], ARRAY['Eve', 'Frank']", 3L);
        String location = ((io.trino.metastore.Table)this.metastore.getTable("tpch", hiveTableName).orElseThrow()).getStorage().getLocation();
        FileIterator files = this.fileSystemFactory.create(IcebergTestUtils.SESSION).listFiles(Location.of((String)location));
        ImmutableList.Builder fileEntries = ImmutableList.builder();
        while (files.hasNext()) {
            FileEntry file = files.next();
            if (file.location().path().contains(".trinoSchema") || file.location().path().contains(".trinoPermissions")) continue;
            fileEntries.add((Object)file);
        }
        FileEntry parquetFile = (FileEntry)Iterables.getOnlyElement((Iterable)fileEntries.build());
        String icebergTableName = "test_iceberg_parquet" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + icebergTableName + "(names ARRAY(varchar))");
        BaseTable icebergTable = this.loadTable(icebergTableName);
        icebergTable.newAppend().appendFile(DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(parquetFile.location().toString()).withFileSizeInBytes(parquetFile.length()).withRecordCount(3L).withFormat(FileFormat.PARQUET).build()).commit();
        icebergTable.updateProperties().set("schema.name-mapping.default", "[{\"field-id\":1,\"names\":[\"names\"]}]").commit();
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES ARRAY['Alice', 'Bob'], ARRAY['Carol', 'Dave'], ARRAY['Eve', 'Frank']");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE " + icebergTableName);
    }

    @Test
    public void testOptimizingV2TableRemovesEqualityDeletesWhenWholeTableIsScanned() throws Exception {
        String tableName = "test_optimize_table_cleans_equality_delete_file_when_whole_table_is_scanned" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (LIKE nation) WITH (partitioning = ARRAY['regionkey'])");
        for (int nationKey = 0; nationKey < 25; ++nationKey) {
            this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM tpch.tiny.nation WHERE nationkey = " + nationKey, 1L);
        }
        BaseTable icebergTable = this.loadTable(tableName);
        Assertions.assertThat((Map)icebergTable.currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"0");
        this.writeEqualityDeleteToNationTable((Table)icebergTable, Optional.of(icebergTable.spec()), Optional.of(new PartitionData((Object[])new Long[]{1L})));
        List<String> initialActiveFiles = this.getActiveFiles(tableName);
        this.assertUpdate("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation WHERE regionkey != 1");
        this.assertQuery("SELECT nationkey, comment FROM " + tableName, "SELECT nationkey, comment FROM nation WHERE regionkey != 1");
        Assertions.assertThat((Map)this.loadTable(tableName).currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"0");
        List<String> updatedFiles = this.getActiveFiles(tableName);
        Assertions.assertThat(updatedFiles).doesNotContain((Object[])initialActiveFiles.toArray(new String[0]));
    }

    @Test
    public void testOptimizingV2TableDoesntRemoveEqualityDeletesWhenOnlyPartOfTheTableIsOptimized() throws Exception {
        String tableName = "test_optimize_table_with_equality_delete_file_for_different_partition_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (LIKE nation) WITH (partitioning = ARRAY['regionkey'])");
        for (int nationKey = 0; nationKey < 25; ++nationKey) {
            this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM tpch.tiny.nation WHERE nationkey = " + nationKey, 1L);
        }
        BaseTable icebergTable = this.loadTable(tableName);
        Assertions.assertThat((Map)icebergTable.currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"0");
        List<String> initialActiveFiles = this.getActiveFiles(tableName);
        this.writeEqualityDeleteToNationTable((Table)icebergTable, Optional.of(icebergTable.spec()), Optional.of(new PartitionData((Object[])new Long[]{1L})));
        this.assertUpdate("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE WHERE regionkey != 1");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation WHERE regionkey != 1");
        this.assertQuery("SELECT nationkey, comment FROM " + tableName, "SELECT nationkey, comment FROM nation WHERE regionkey != 1");
        Assertions.assertThat((Map)this.loadTable(tableName).currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"1");
        List<String> updatedFiles = this.getActiveFiles(tableName);
        Assertions.assertThat(updatedFiles).doesNotContain((Object[])((String[])initialActiveFiles.stream().filter(path -> !path.contains("regionkey=1")).toArray(String[]::new)));
    }

    @Test
    public void testSelectivelyOptimizingLeavesEqualityDeletes() throws Exception {
        String tableName = "test_selectively_optimizing_leaves_eq_deletes_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (partitioning = ARRAY['nationkey']) AS SELECT * FROM tpch.tiny.nation", 25L);
        BaseTable icebergTable = this.loadTable(tableName);
        this.writeEqualityDeleteToNationTable((Table)icebergTable, Optional.of(icebergTable.spec()), Optional.of(new PartitionData((Object[])new Long[]{1L})));
        this.assertUpdate("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE WHERE nationkey < 5");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation WHERE regionkey != 1 OR nationkey != 1");
        Assertions.assertThat((Map)this.loadTable(tableName).currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"1");
    }

    @Test
    public void testOptimizePopulateSplitOffsets() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("task_min_writer_count", "1").build();
        try (TestTable table = this.newTrinoTable("test_optimize_split_offsets", "AS SELECT * FROM tpch.tiny.nation");){
            this.assertUpdate(session, "ALTER TABLE " + table.getName() + " EXECUTE optimize");
            Assertions.assertThat((Iterable)this.computeActual("SELECT split_offsets FROM \"" + table.getName() + "$files\"")).isEqualTo((Object)MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)ImmutableList.of((Object)new ArrayType((io.trino.spi.type.Type)BigintType.BIGINT))).row(new Object[]{ImmutableList.of((Object)4L)}).build());
        }
    }

    @Test
    public void testMultipleEqualityDeletes() throws Exception {
        String tableName = "test_multiple_equality_deletes_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.nation", 25L);
        BaseTable icebergTable = this.loadTable(tableName);
        Assertions.assertThat((Map)icebergTable.currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"0");
        for (int i = 1; i < 3; ++i) {
            this.writeEqualityDeleteToNationTable((Table)icebergTable, Optional.empty(), Optional.empty(), (Map<String, Object>)ImmutableMap.of((Object)"regionkey", (Object)Integer.toUnsignedLong(i)));
        }
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation WHERE  (regionkey != 1L AND regionkey != 2L)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testEqualityDeleteAppliesOnlyToCorrectDataVersion() throws Exception {
        String tableName = "test_multiple_equality_deletes_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.nation", 25L);
        BaseTable icebergTable = this.loadTable(tableName);
        Assertions.assertThat((String)((String)icebergTable.currentSnapshot().summary().get("total-equality-deletes"))).isEqualTo("0");
        for (int i = 1; i < 3; ++i) {
            this.writeEqualityDeleteToNationTable((Table)icebergTable, Optional.empty(), Optional.empty(), (Map<String, Object>)ImmutableMap.of((Object)"regionkey", (Object)Integer.toUnsignedLong(i)));
        }
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation WHERE  (regionkey != 1L AND regionkey != 2L)");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM tpch.tiny.nation WHERE regionkey = 1", 5L);
        this.writeEqualityDeleteToNationTable((Table)icebergTable, Optional.empty(), Optional.empty(), (Map<String, Object>)ImmutableMap.of((Object)"regionkey", (Object)Integer.toUnsignedLong(3)));
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation WHERE (regionkey != 2L AND regionkey != 3L)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testMultipleEqualityDeletesWithEquivalentSchemas() throws Exception {
        String tableName = "test_multiple_equality_deletes_equivalent_schemas_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.nation", 25L);
        BaseTable icebergTable = this.loadTable(tableName);
        Assertions.assertThat((Map)icebergTable.currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"0");
        Schema deleteRowSchema = new Schema((List)ImmutableList.of((Object)"regionkey", (Object)"name").stream().map(arg_0 -> TestIcebergV2.lambda$testMultipleEqualityDeletesWithEquivalentSchemas$0((Table)icebergTable, arg_0)).collect(ImmutableList.toImmutableList()));
        List equalityFieldIds = (List)ImmutableList.of((Object)"regionkey", (Object)"name").stream().map(name -> deleteRowSchema.findField(name).fieldId()).collect(ImmutableList.toImmutableList());
        this.writeEqualityDeleteToNationTableWithDeleteColumns((Table)icebergTable, Optional.empty(), Optional.empty(), (Map<String, Object>)ImmutableMap.of((Object)"regionkey", (Object)1L, (Object)"name", (Object)"BRAZIL"), deleteRowSchema, equalityFieldIds);
        Schema equivalentDeleteRowSchema = new Schema((List)ImmutableList.of((Object)"name", (Object)"regionkey").stream().map(arg_0 -> TestIcebergV2.lambda$testMultipleEqualityDeletesWithEquivalentSchemas$2((Table)icebergTable, arg_0)).collect(ImmutableList.toImmutableList()));
        this.writeEqualityDeleteToNationTableWithDeleteColumns((Table)icebergTable, Optional.empty(), Optional.empty(), (Map<String, Object>)ImmutableMap.of((Object)"name", (Object)"INDIA", (Object)"regionkey", (Object)2L), equivalentDeleteRowSchema, equalityFieldIds);
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation WHERE NOT ((regionkey = 1 AND name = 'BRAZIL') OR (regionkey = 2 AND name = 'INDIA'))");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testMultipleEqualityDeletesWithDifferentSchemas() throws Exception {
        String tableName = "test_multiple_equality_deletes_different_schemas_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.nation", 25L);
        BaseTable icebergTable = this.loadTable(tableName);
        Assertions.assertThat((Map)icebergTable.currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"0");
        this.writeEqualityDeleteToNationTableWithDeleteColumns((Table)icebergTable, Optional.empty(), Optional.empty(), (Map<String, Object>)ImmutableMap.of((Object)"regionkey", (Object)1L, (Object)"name", (Object)"BRAZIL"), Optional.of(ImmutableList.of((Object)"regionkey", (Object)"name")));
        this.writeEqualityDeleteToNationTableWithDeleteColumns((Table)icebergTable, Optional.empty(), Optional.empty(), (Map<String, Object>)ImmutableMap.of((Object)"name", (Object)"ALGERIA"), Optional.of(ImmutableList.of((Object)"name")));
        this.writeEqualityDeleteToNationTableWithDeleteColumns((Table)icebergTable, Optional.empty(), Optional.empty(), (Map<String, Object>)ImmutableMap.of((Object)"regionkey", (Object)2L), Optional.of(ImmutableList.of((Object)"regionkey")));
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation WHERE NOT ((regionkey = 1 AND name = 'BRAZIL') OR regionkey = 2 OR name = 'ALGERIA')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testEqualityDeletesAcrossPartitions() throws Exception {
        String tableName = "test_equality_deletes_across_partitions_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (partitioning = ARRAY['partition']) AS SELECT 'part_1' as partition, * FROM tpch.tiny.nation", 25L);
        this.assertUpdate("INSERT INTO " + tableName + " SELECT 'part_2' as partition, * FROM tpch.tiny.nation", 25L);
        BaseTable icebergTable = this.loadTable(tableName);
        PartitionData partitionData1 = PartitionData.fromJson((String)"{\"partitionValues\":[\"part_1\"]}", (Type[])new Type[]{Types.StringType.get()});
        PartitionData partitionData2 = PartitionData.fromJson((String)"{\"partitionValues\":[\"part_2\"]}", (Type[])new Type[]{Types.StringType.get()});
        this.writeEqualityDeleteToNationTableWithDeleteColumns((Table)icebergTable, Optional.of(icebergTable.spec()), Optional.of(partitionData1), (Map<String, Object>)ImmutableMap.of((Object)"regionkey", (Object)1L), Optional.of(ImmutableList.of((Object)"regionkey")));
        this.writeEqualityDeleteToNationTableWithDeleteColumns((Table)icebergTable, Optional.of(icebergTable.spec()), Optional.of(partitionData2), (Map<String, Object>)ImmutableMap.of((Object)"regionkey", (Object)2L), Optional.of(ImmutableList.of((Object)"regionkey")));
        this.assertQuery("SELECT * FROM " + tableName, "SELECT 'part_1', * FROM nation WHERE regionkey <> 1 UNION ALL select 'part_2', * FROM NATION where regionkey <> 2");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testMultipleEqualityDeletesWithNestedFields() throws Exception {
        String tableName = "test_multiple_equality_deletes_nested_fields_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " ( id BIGINT, root ROW(nested BIGINT, nested_other BIGINT))");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, row(10, 100))", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, row(20, 200))", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, row(20, 200))", 1L);
        BaseTable icebergTable = this.loadTable(tableName);
        Assertions.assertThat((Map)icebergTable.currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"0");
        ImmutableList deleteFileColumns = ImmutableList.of((Object)"root.nested");
        Schema deleteRowSchema = icebergTable.schema().select((Collection)deleteFileColumns);
        List equalityFieldIds = (List)ImmutableList.of((Object)"root.nested").stream().map(name -> deleteRowSchema.findField(name).fieldId()).collect(ImmutableList.toImmutableList());
        Types.StructType nestedStructType = (Types.StructType)deleteRowSchema.findField("root").type();
        GenericRecord nestedStruct = GenericRecord.create((Types.StructType)nestedStructType);
        nestedStruct.setField("nested", (Object)20L);
        for (int i = 1; i < 3; ++i) {
            this.writeEqualityDeleteToNationTableWithDeleteColumns((Table)icebergTable, Optional.empty(), Optional.empty(), (Map<String, Object>)ImmutableMap.of((Object)"root", (Object)nestedStruct), deleteRowSchema, equalityFieldIds);
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (BIGINT '1', CAST(row(10, 100) AS ROW(nested BIGINT, nested_other BIGINT)))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + tableName))).matches("VALUES BIGINT '1'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testOptimizingWholeTableRemovesEqualityDeletes() throws Exception {
        String tableName = "test_optimizing_whole_table_removes_eq_deletes_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (partitioning = ARRAY['nationkey']) AS SELECT * FROM tpch.tiny.nation", 25L);
        BaseTable icebergTable = this.loadTable(tableName);
        this.writeEqualityDeleteToNationTable((Table)icebergTable, Optional.of(icebergTable.spec()), Optional.of(new PartitionData((Object[])new Long[]{1L})));
        this.assertUpdate("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation WHERE regionkey != 1 OR nationkey != 1");
        Assertions.assertThat((Map)this.loadTable(tableName).currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"0");
    }

    @Test
    public void testOptimizingV2TableWithEmptyPartitionSpec() throws Exception {
        String tableName = "test_optimize_table_with_global_equality_delete_file_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.nation", 25L);
        BaseTable icebergTable = this.loadTable(tableName);
        Assertions.assertThat((Map)icebergTable.currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"0");
        this.writeEqualityDeleteToNationTable((Table)icebergTable);
        List<String> initialActiveFiles = this.getActiveFiles(tableName);
        this.assertUpdate("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation WHERE regionkey != 1");
        this.assertQuery("SELECT nationkey, comment FROM " + tableName, "SELECT nationkey, comment FROM nation WHERE regionkey != 1");
        Assertions.assertThat((Map)this.loadTable(tableName).currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"0");
        List<String> updatedFiles = this.getActiveFiles(tableName);
        Assertions.assertThat(updatedFiles).doesNotContain((Object[])initialActiveFiles.toArray(new String[0]));
    }

    @Test
    public void testOptimizingPartitionsOfV2TableWithGlobalEqualityDeleteFile() throws Exception {
        String tableName = "test_optimize_partitioned_table_with_global_equality_delete_file_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (LIKE nation) WITH (partitioning = ARRAY['regionkey'])");
        for (int nationKey = 0; nationKey < 25; ++nationKey) {
            this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM tpch.tiny.nation WHERE nationkey = " + nationKey, 1L);
        }
        BaseTable icebergTable = this.loadTable(tableName);
        Assertions.assertThat((Map)icebergTable.currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"0");
        this.writeEqualityDeleteToNationTable((Table)icebergTable, Optional.of(icebergTable.spec()), Optional.of(new PartitionData((Object[])new Long[]{1L})));
        List<String> initialActiveFiles = this.getActiveFiles(tableName);
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation WHERE regionkey != 1");
        this.assertUpdate("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE WHERE regionkey != 1");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation WHERE regionkey != 1");
        this.assertQuery("SELECT nationkey, comment FROM " + tableName, "SELECT nationkey, comment FROM nation WHERE regionkey != 1");
        Assertions.assertThat((Map)this.loadTable(tableName).currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"1");
        List<String> updatedFiles = this.getActiveFiles(tableName);
        Assertions.assertThat(updatedFiles).doesNotContain((Object[])((String[])initialActiveFiles.stream().filter(path -> !path.contains("regionkey=1")).toArray(String[]::new)));
    }

    @Test
    public void testOptimizingWholeTableRemovesDeleteFiles() throws Exception {
        try (TestTable testTable = this.newTrinoTable("test_optimize_removes_obsolete_delete_files_", "AS SELECT * FROM tpch.tiny.nation");){
            this.assertUpdate("DELETE FROM " + testTable.getName() + " WHERE regionkey % 2 = 0", 15L);
            BaseTable icebergTable = this.loadTable(testTable.getName());
            this.writeEqualityDeleteToNationTable((Table)icebergTable, Optional.of(icebergTable.spec()), Optional.of(new PartitionData((Object[])new Long[]{1L})));
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + testTable.getName()))).matches("SELECT * FROM nation WHERE regionkey != 1 AND regionkey % 2 = 1");
            this.assertQuery("SELECT count(*) FROM \"" + testTable.getName() + "$files\" WHERE content = " + FileContent.POSITION_DELETES.id(), "VALUES 1");
            this.assertQuery("SELECT count(*) FROM \"" + testTable.getName() + "$files\" WHERE content = " + FileContent.EQUALITY_DELETES.id(), "VALUES 1");
            this.assertQuerySucceeds("ALTER TABLE " + testTable.getName() + " EXECUTE OPTIMIZE");
            this.assertQuery("SELECT count(*) FROM \"" + testTable.getName() + "$files\" WHERE content = " + FileContent.POSITION_DELETES.id(), "VALUES 0");
            this.assertQuery("SELECT count(*) FROM \"" + testTable.getName() + "$files\" WHERE content = " + FileContent.EQUALITY_DELETES.id(), "VALUES 0");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + testTable.getName()))).matches("SELECT * FROM nation WHERE regionkey != 1 AND regionkey % 2 = 1");
        }
    }

    @Test
    public void testUpgradeTableToV2FromTrino() {
        String tableName = "test_upgrade_table_to_v2_from_trino_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (format_version = 1) AS SELECT * FROM tpch.tiny.nation", 25L);
        Assertions.assertThat((int)this.loadTable(tableName).operations().current().formatVersion()).isEqualTo(1);
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES format_version = 2");
        Assertions.assertThat((int)this.loadTable(tableName).operations().current().formatVersion()).isEqualTo(2);
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation");
    }

    @Test
    public void testDowngradingV2TableToV1Fails() {
        String tableName = "test_downgrading_v2_table_to_v1_fails_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (format_version = 2) AS SELECT * FROM tpch.tiny.nation", 25L);
        Assertions.assertThat((int)this.loadTable(tableName).operations().current().formatVersion()).isEqualTo(2);
        ((TrinoExceptionAssert)((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("ALTER TABLE " + tableName + " SET PROPERTIES format_version = 1"))).failure().hasMessage("Failed to set new property values")).rootCause().hasMessage("Cannot downgrade v2 table to v1");
    }

    @Test
    public void testUpgradingToInvalidVersionFails() {
        String tableName = "test_upgrading_to_invalid_version_fails_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (format_version = 2) AS SELECT * FROM tpch.tiny.nation", 25L);
        Assertions.assertThat((int)this.loadTable(tableName).operations().current().formatVersion()).isEqualTo(2);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("ALTER TABLE " + tableName + " SET PROPERTIES format_version = 42"))).failure().hasMessage("line 1:79: Unable to set catalog 'iceberg' table property 'format_version' to [42]: format_version must be between 1 and 2");
    }

    @Test
    public void testUpdatingAllTableProperties() {
        String tableName = "test_updating_all_table_properties_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (format_version = 1, format = 'ORC') AS SELECT * FROM tpch.tiny.nation", 25L);
        BaseTable table = this.loadTable(tableName);
        Assertions.assertThat((int)table.operations().current().formatVersion()).isEqualTo(1);
        Assertions.assertThat((boolean)((String)table.properties().get("write.format.default")).equalsIgnoreCase("ORC")).isTrue();
        Assertions.assertThat((boolean)table.spec().isUnpartitioned()).isTrue();
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES format_version = 2, partitioning = ARRAY['regionkey'], format = 'PARQUET', sorted_by = ARRAY['comment']");
        table = this.loadTable(tableName);
        Assertions.assertThat((int)table.operations().current().formatVersion()).isEqualTo(2);
        Assertions.assertThat((boolean)((String)table.properties().get("write.format.default")).equalsIgnoreCase("PARQUET")).isTrue();
        Assertions.assertThat((boolean)table.spec().isPartitioned()).isTrue();
        List partitionFields = table.spec().fields();
        Assertions.assertThat((List)partitionFields).hasSize(1);
        Assertions.assertThat((String)((PartitionField)partitionFields.get(0)).name()).isEqualTo("regionkey");
        Assertions.assertThat((boolean)((PartitionField)partitionFields.get(0)).transform().isIdentity()).isTrue();
        Assertions.assertThat((boolean)table.sortOrder().isSorted()).isTrue();
        List sortFields = table.sortOrder().fields();
        Assertions.assertThat((List)sortFields).hasSize(1);
        Assertions.assertThat((int)((SortField)Iterables.getOnlyElement((Iterable)sortFields)).sourceId()).isEqualTo(table.schema().findField("comment").fieldId());
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation");
    }

    @Test
    public void testUnsettingAllTableProperties() {
        String tableName = "test_unsetting_all_table_properties_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (format_version = 1, format = 'PARQUET', partitioning = ARRAY['regionkey'], sorted_by = ARRAY['comment']) AS SELECT * FROM tpch.tiny.nation", 25L);
        BaseTable table = this.loadTable(tableName);
        Assertions.assertThat((int)table.operations().current().formatVersion()).isEqualTo(1);
        Assertions.assertThat((boolean)((String)table.properties().get("write.format.default")).equalsIgnoreCase("PARQUET")).isTrue();
        Assertions.assertThat((boolean)table.spec().isPartitioned()).isTrue();
        List partitionFields = table.spec().fields();
        Assertions.assertThat((List)partitionFields).hasSize(1);
        Assertions.assertThat((String)((PartitionField)partitionFields.get(0)).name()).isEqualTo("regionkey");
        Assertions.assertThat((boolean)((PartitionField)partitionFields.get(0)).transform().isIdentity()).isTrue();
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES format_version = DEFAULT, format = DEFAULT, partitioning = DEFAULT, sorted_by = DEFAULT");
        table = this.loadTable(tableName);
        Assertions.assertThat((int)table.operations().current().formatVersion()).isEqualTo(2);
        Assertions.assertThat((boolean)((String)table.properties().get("write.format.default")).equalsIgnoreCase("PARQUET")).isTrue();
        Assertions.assertThat((boolean)table.spec().isUnpartitioned()).isTrue();
        Assertions.assertThat((boolean)table.sortOrder().isUnsorted()).isTrue();
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation");
    }

    @Test
    public void testDeletingEntireFile() {
        String tableName = "test_deleting_entire_file_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.nation WITH NO DATA", 0L);
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM tpch.tiny.nation WHERE regionkey = 1", "SELECT count(*) FROM nation WHERE regionkey = 1");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM tpch.tiny.nation WHERE regionkey != 1", "SELECT count(*) FROM nation WHERE regionkey != 1");
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(2);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE regionkey <= 2", "SELECT count(*) FROM nation WHERE regionkey <= 2");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation WHERE regionkey > 2");
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(2);
    }

    @Test
    public void testDeletingEntireFileFromPartitionedTable() {
        String tableName = "test_deleting_entire_file_from_partitioned_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a INT, b INT) WITH (partitioning = ARRAY['a'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 1), (1, 3), (1, 5), (2, 1), (2, 3), (2, 5)", 6L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 2), (1, 4), (1, 6), (2, 2), (2, 4), (2, 6)", 6L);
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(4);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE b % 2 = 0", 6L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 1), (1, 3), (1, 5), (2, 1), (2, 3), (2, 5)");
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(4);
    }

    @Test
    public void testDeletingEntireFileWithNonTupleDomainConstraint() {
        String tableName = "test_deleting_entire_file_with_non_tuple_domain_constraint" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.nation WITH NO DATA", 0L);
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM tpch.tiny.nation WHERE regionkey = 1", "SELECT count(*) FROM nation WHERE regionkey = 1");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM tpch.tiny.nation WHERE regionkey != 1", "SELECT count(*) FROM nation WHERE regionkey != 1");
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(2);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE regionkey % 2 = 1", "SELECT count(*) FROM nation WHERE regionkey % 2 = 1");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation WHERE regionkey % 2 = 0");
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(2);
    }

    @Test
    public void testDeletingEntireFileWithMultipleSplits() {
        String tableName = "test_deleting_entire_file_with_multiple_splits" + TestingNames.randomNameSuffix();
        this.assertUpdate(Session.builder((Session)this.getSession()).setCatalogSessionProperty("iceberg", "orc_writer_max_stripe_rows", "5").build(), "CREATE TABLE " + tableName + " WITH (format = 'ORC') AS SELECT * FROM tpch.tiny.nation", 25L);
        this.loadTable(tableName).updateProperties().set("read.split.target-size", "100").commit();
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(1);
        long initialSnapshotId = (Long)this.computeScalar("SELECT snapshot_id FROM \"" + tableName + "$snapshots\" ORDER BY committed_at DESC FETCH FIRST 1 ROW WITH TIES");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE regionkey < 10", 25L);
        long parentSnapshotId = (Long)this.computeScalar("SELECT parent_id FROM \"" + tableName + "$snapshots\" ORDER BY committed_at DESC FETCH FIRST 1 ROW WITH TIES");
        Assertions.assertThat((long)initialSnapshotId).isEqualTo(parentSnapshotId);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).returnsEmptyResult();
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(1);
    }

    @Test
    public void testMultipleDeletes() {
        String tableName = "test_multiple_deletes_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.nation", 25L);
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(1);
        long initialSnapshotId = (Long)this.computeScalar("SELECT snapshot_id FROM \"" + tableName + "$snapshots\" ORDER BY committed_at DESC FETCH FIRST 1 ROW WITH TIES");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE regionkey % 2 = 1", "SELECT count(*) FROM nation WHERE regionkey % 2 = 1");
        long parentSnapshotId = (Long)this.computeScalar("SELECT parent_id FROM \"" + tableName + "$snapshots\" ORDER BY committed_at DESC FETCH FIRST 1 ROW WITH TIES");
        Assertions.assertThat((long)initialSnapshotId).isEqualTo(parentSnapshotId);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE regionkey % 2 = 0", "SELECT count(*) FROM nation WHERE regionkey % 2 = 0");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).returnsEmptyResult();
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(1);
    }

    @Test
    public void testDeletingEntirePartitionedTable() {
        String tableName = "test_deleting_entire_partitioned_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (partitioning = ARRAY['regionkey']) AS SELECT * FROM tpch.tiny.nation", 25L);
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(5);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE regionkey < 10", "SELECT count(*) FROM nation WHERE regionkey < 10");
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).isEmpty();
        this.assertUpdate("DELETE FROM " + tableName + " WHERE regionkey < 10");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).returnsEmptyResult();
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).isEmpty();
    }

    @Test
    public void testFilesTable() throws Exception {
        String tableName = "test_files_table_" + TestingNames.randomNameSuffix();
        String tableLocation = "local:///" + tableName;
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (location = '" + tableLocation + "', format_version = 2) AS SELECT * FROM tpch.tiny.nation", 25L);
        BaseTable table = this.loadTable(tableName);
        Metrics metrics = new Metrics(Long.valueOf(10L), (Map)ImmutableMap.of((Object)1, (Object)2L, (Object)2, (Object)3L), (Map)ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)3L, (Object)3, (Object)2L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)2L), (Map)ImmutableMap.of((Object)4, (Object)1L), (Map)ImmutableMap.of((Object)1, (Object)ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, 0L)), (Map)ImmutableMap.of((Object)1, (Object)ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, 4L)));
        DataFile dataFile = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withFormat(FileFormat.ORC).withPath(tableLocation + "/data/test_files_table.orc").withFileSizeInBytes(1234L).withMetrics(metrics).withSplitOffsets((List)ImmutableList.of((Object)4L)).withEncryptionKeyMetadata(ByteBuffer.wrap("Trino".getBytes(StandardCharsets.UTF_8))).build();
        table.newAppend().appendFile(dataFile).commit();
        this.writeEqualityDeleteToNationTable((Table)table);
        this.assertQuery("SELECT content, file_format, record_count, CAST(column_sizes AS JSON), CAST(value_counts AS JSON), CAST(null_value_counts AS JSON), CAST(nan_value_counts AS JSON), CAST(lower_bounds AS JSON), CAST(upper_bounds AS JSON), key_metadata, split_offsets, equality_ids FROM \"" + tableName + "$files\"", "       VALUES\n               (0,\n                'PARQUET',\n                25L,\n                JSON '{\"1\":137,\"2\":216,\"3\":91,\"4\":801}',\n                JSON '{\"1\":25,\"2\":25,\"3\":25,\"4\":25}',\n                jSON '{\"1\":0,\"2\":0,\"3\":0,\"4\":0}',\n                jSON '{}',\n                JSON '{\"1\":\"0\",\"2\":\"ALGERIA\",\"3\":\"0\",\"4\":\" haggle. careful\"}',\n                JSON '{\"1\":\"24\",\"2\":\"VIETNAM\",\"3\":\"4\",\"4\":\"y final packaget\"}',\n                null,\n                ARRAY[4L],\n                null),\n               (0,\n                'ORC',\n                10L,\n                JSON '{\"1\":2,\"2\":3}',\n                JSON '{\"1\":5,\"2\":3,\"3\":2}',\n                JSON '{\"1\":0,\"2\":2}',\n                JSON '{\"4\":1}',\n                JSON '{\"1\":\"0\"}',\n                JSON '{\"1\":\"4\"}',\n                X'54 72 69 6e 6f',\n                ARRAY[4L],\n                null),\n                (2,\n                'PARQUET',\n                1L,\n                JSON '{\"3\":49}',\n                JSON '{\"3\":1}',\n                JSON '{\"3\":0}',\n                JSON '{}',\n                JSON '{\"3\":\"1\"}',\n                JSON '{\"3\":\"1\"}',\n                null,\n                ARRAY[4],\n                ARRAY[3])\n");
    }

    @Test
    public void testStatsFilePruning() {
        try (TestTable testTable = this.newTrinoTable("test_stats_file_pruning_", "(a INT, b INT) WITH (partitioning = ARRAY['b'])");){
            this.assertUpdate("INSERT INTO " + testTable.getName() + " VALUES (1, 10), (10, 10)", 2L);
            this.assertUpdate("INSERT INTO " + testTable.getName() + " VALUES (200, 10), (300, 20)", 2L);
            Optional<Long> snapshotId = Optional.of(Long.valueOf((Long)this.computeScalar("SELECT snapshot_id FROM \"" + testTable.getName() + "$snapshots\" ORDER BY committed_at DESC FETCH FIRST 1 ROW WITH TIES")));
            TestingTypeManager typeManager = new TestingTypeManager();
            BaseTable table = this.loadTable(testTable.getName());
            TableStatistics withNoFilter = TableStatisticsReader.makeTableStatistics((TypeManager)typeManager, (Table)table, snapshotId, (TupleDomain)TupleDomain.all(), (TupleDomain)TupleDomain.all(), (Set)ImmutableSet.of(), (boolean)true, (ExecutorService)MoreExecutors.newDirectExecutorService(), (TrinoFileSystem)this.fileSystemFactory.create(IcebergTestUtils.SESSION));
            Assertions.assertThat((double)withNoFilter.getRowCount().getValue()).isEqualTo(4.0);
            TableStatistics withPartitionFilter = TableStatisticsReader.makeTableStatistics((TypeManager)typeManager, (Table)table, snapshotId, (TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new IcebergColumnHandle(ColumnIdentity.primitiveColumnIdentity((int)2, (String)"b"), (io.trino.spi.type.Type)IntegerType.INTEGER, (List)ImmutableList.of(), (io.trino.spi.type.Type)IntegerType.INTEGER, true, Optional.empty()), (Object)Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)10L))), (TupleDomain)TupleDomain.all(), (Set)ImmutableSet.of(), (boolean)true, (ExecutorService)MoreExecutors.newDirectExecutorService(), (TrinoFileSystem)this.fileSystemFactory.create(IcebergTestUtils.SESSION));
            Assertions.assertThat((double)withPartitionFilter.getRowCount().getValue()).isEqualTo(3.0);
            IcebergColumnHandle column = new IcebergColumnHandle(ColumnIdentity.primitiveColumnIdentity((int)1, (String)"a"), (io.trino.spi.type.Type)IntegerType.INTEGER, (List)ImmutableList.of(), (io.trino.spi.type.Type)IntegerType.INTEGER, true, Optional.empty());
            TableStatistics withUnenforcedFilter = TableStatisticsReader.makeTableStatistics((TypeManager)typeManager, (Table)table, snapshotId, (TupleDomain)TupleDomain.all(), (TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)100L), (Range[])new Range[0]), (boolean)true))), (Set)ImmutableSet.of((Object)column), (boolean)true, (ExecutorService)MoreExecutors.newDirectExecutorService(), (TrinoFileSystem)this.fileSystemFactory.create(IcebergTestUtils.SESSION));
            Assertions.assertThat((double)withUnenforcedFilter.getRowCount().getValue()).isEqualTo(2.0);
        }
    }

    @Test
    public void testColumnStatsPruning() {
        try (TestTable testTable = this.newTrinoTable("test_column_stats_pruning_", "(a INT, b INT) WITH (partitioning = ARRAY['b'])");){
            this.assertUpdate("INSERT INTO " + testTable.getName() + " VALUES (1, 10), (10, 10)", 2L);
            this.assertUpdate("INSERT INTO " + testTable.getName() + " VALUES (200, 10), (300, 20)", 2L);
            Optional<Long> snapshotId = Optional.of(Long.valueOf((Long)this.computeScalar("SELECT snapshot_id FROM \"" + testTable.getName() + "$snapshots\" ORDER BY committed_at DESC FETCH FIRST 1 ROW WITH TIES")));
            TestingTypeManager typeManager = new TestingTypeManager();
            BaseTable table = this.loadTable(testTable.getName());
            TableStatistics withNoProjectedColumns = TableStatisticsReader.makeTableStatistics((TypeManager)typeManager, (Table)table, snapshotId, (TupleDomain)TupleDomain.all(), (TupleDomain)TupleDomain.all(), (Set)ImmutableSet.of(), (boolean)true, (ExecutorService)MoreExecutors.newDirectExecutorService(), (TrinoFileSystem)this.fileSystemFactory.create(IcebergTestUtils.SESSION));
            Assertions.assertThat((double)withNoProjectedColumns.getRowCount().getValue()).isEqualTo(4.0);
            Assertions.assertThat((Map)withNoProjectedColumns.getColumnStatistics()).isEmpty();
            IcebergColumnHandle column = new IcebergColumnHandle(ColumnIdentity.primitiveColumnIdentity((int)1, (String)"a"), (io.trino.spi.type.Type)IntegerType.INTEGER, (List)ImmutableList.of(), (io.trino.spi.type.Type)IntegerType.INTEGER, true, Optional.empty());
            TableStatistics withProjectedColumns = TableStatisticsReader.makeTableStatistics((TypeManager)typeManager, (Table)table, snapshotId, (TupleDomain)TupleDomain.all(), (TupleDomain)TupleDomain.all(), (Set)ImmutableSet.of((Object)column), (boolean)true, (ExecutorService)MoreExecutors.newDirectExecutorService(), (TrinoFileSystem)this.fileSystemFactory.create(IcebergTestUtils.SESSION));
            Assertions.assertThat((double)withProjectedColumns.getRowCount().getValue()).isEqualTo(4.0);
            Assertions.assertThat((Map)withProjectedColumns.getColumnStatistics()).containsOnlyKeys((Object[])new ColumnHandle[]{column});
            Assertions.assertThat((Object)((ColumnStatistics)withProjectedColumns.getColumnStatistics().get(column))).isEqualTo((Object)ColumnStatistics.builder().setNullsFraction(Estimate.zero()).setDistinctValuesCount(Estimate.of((double)4.0)).setRange(new DoubleRange(1.0, 300.0)).build());
            TableStatistics withPartitionFilterAndProjectedColumn = TableStatisticsReader.makeTableStatistics((TypeManager)typeManager, (Table)table, snapshotId, (TupleDomain)TupleDomain.all(), (TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new IcebergColumnHandle(ColumnIdentity.primitiveColumnIdentity((int)2, (String)"b"), (io.trino.spi.type.Type)IntegerType.INTEGER, (List)ImmutableList.of(), (io.trino.spi.type.Type)IntegerType.INTEGER, true, Optional.empty()), (Object)Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)10L))), (Set)ImmutableSet.of((Object)column), (boolean)true, (ExecutorService)MoreExecutors.newDirectExecutorService(), (TrinoFileSystem)this.fileSystemFactory.create(IcebergTestUtils.SESSION));
            Assertions.assertThat((double)withPartitionFilterAndProjectedColumn.getRowCount().getValue()).isEqualTo(3.0);
            Assertions.assertThat((Map)withPartitionFilterAndProjectedColumn.getColumnStatistics()).containsOnlyKeys((Object[])new ColumnHandle[]{column});
            Assertions.assertThat((Object)((ColumnStatistics)withPartitionFilterAndProjectedColumn.getColumnStatistics().get(column))).isEqualTo((Object)ColumnStatistics.builder().setNullsFraction(Estimate.zero()).setDistinctValuesCount(Estimate.of((double)4.0)).setRange(new DoubleRange(1.0, 200.0)).build());
        }
    }

    @Test
    public void testInt96TimestampWithTimeZone() {
        this.assertUpdate("CREATE TABLE hive.tpch.test_timestamptz_base (t timestamp) WITH (format = 'PARQUET')");
        this.assertUpdate("INSERT INTO hive.tpch.test_timestamptz_base (t) VALUES (timestamp '2022-07-26 12:13')", 1L);
        String tableLocation = ((io.trino.metastore.Table)this.metastore.getTable("tpch", "test_timestamptz_base").orElseThrow()).getStorage().getLocation();
        this.metastore.createTable(new io.trino.metastore.Table("tpch", "test_timestamptz", Optional.of("hive"), "EXTERNAL_TABLE", new Storage(HiveStorageFormat.PARQUET.toStorageFormat(), Optional.of(tableLocation), Optional.empty(), false, (Map)ImmutableMap.of()), List.of(new Column("t", HiveType.HIVE_TIMESTAMPLOCALTZ, Optional.empty(), Map.of())), List.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty(), OptionalLong.empty()), PrincipalPrivileges.fromHivePrivilegeInfos((Set)ImmutableSet.of()));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM hive.tpch.test_timestamptz"))).matches("VALUES TIMESTAMP '2022-07-26 17:13:00.000 UTC'");
        String path = (String)this.computeScalar("SELECT \"$path\" FROM hive.tpch.test_timestamptz_base");
        long size = (Long)this.computeScalar("SELECT \"$file_size\" FROM hive.tpch.test_timestamptz_base");
        this.assertUpdate("CREATE TABLE iceberg.tpch.test_timestamptz_migrated(t TIMESTAMP(6) WITH TIME ZONE)");
        BaseTable table = this.loadTable("test_timestamptz_migrated");
        table.updateProperties().set("schema.name-mapping.default", NameMappingParser.toJson((NameMapping)MappingUtil.create((Schema)table.schema()))).commit();
        table.newAppend().appendFile(DataFiles.builder((PartitionSpec)table.spec()).withPath(path).withFormat(FileFormat.PARQUET).withFileSizeInBytes(size).withRecordCount(1L).build()).commit();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM iceberg.tpch.test_timestamptz_migrated"))).matches("VALUES TIMESTAMP '2022-07-26 17:13:00.000000 UTC'");
        this.assertUpdate("DROP TABLE hive.tpch.test_timestamptz_base");
        this.assertUpdate("DROP TABLE hive.tpch.test_timestamptz");
        this.assertUpdate("DROP TABLE iceberg.tpch.test_timestamptz_migrated");
    }

    @Test
    public void testSnapshotReferenceSystemTable() {
        String tableName = "test_snapshot_reference_system_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (partitioning = ARRAY['regionkey']) AS SELECT * FROM tpch.tiny.nation", 25L);
        BaseTable icebergTable = this.loadTable(tableName);
        long snapshotId1 = icebergTable.currentSnapshot().snapshotId();
        icebergTable.manageSnapshots().createTag("test-tag", snapshotId1).setMaxRefAgeMs("test-tag", 1L).commit();
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM tpch.tiny.nation LIMIT 5", 5L);
        icebergTable.refresh();
        long snapshotId2 = icebergTable.currentSnapshot().snapshotId();
        icebergTable.manageSnapshots().createBranch("test-branch", snapshotId2).setMaxSnapshotAgeMs("test-branch", 1L).commit();
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM tpch.tiny.nation LIMIT 5", 5L);
        icebergTable.refresh();
        long snapshotId3 = icebergTable.currentSnapshot().snapshotId();
        icebergTable.manageSnapshots().createBranch("test-branch2", snapshotId3).setMinSnapshotsToKeep("test-branch2", 1).commit();
        this.assertQuery("SHOW COLUMNS FROM \"" + tableName + "$refs\"", "VALUES ('name', 'varchar', '', ''),('type', 'varchar', '', ''),('snapshot_id', 'bigint', '', ''),('max_reference_age_in_ms', 'bigint', '', ''),('min_snapshots_to_keep', 'integer', '', ''),('max_snapshot_age_in_ms', 'bigint', '', '')");
        this.assertQuery("SELECT * FROM \"" + tableName + "$refs\"", "VALUES ('test-tag', 'TAG', " + snapshotId1 + ", 1, null, null),('test-branch', 'BRANCH', " + snapshotId2 + ", null, null, 1),('test-branch2', 'BRANCH', " + snapshotId3 + ", null, 1, null),('main', 'BRANCH', " + snapshotId3 + ", null, null, null)");
    }

    @Test
    public void testReadingSnapshotReference() {
        String tableName = "test_reading_snapshot_reference" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (partitioning = ARRAY['regionkey']) AS SELECT * FROM tpch.tiny.nation", 25L);
        BaseTable icebergTable = this.loadTable(tableName);
        long refSnapshotId = icebergTable.currentSnapshot().snapshotId();
        icebergTable.manageSnapshots().createTag("test-tag", refSnapshotId).createBranch("test-branch", refSnapshotId).commit();
        this.assertQuery("SELECT * FROM \"" + tableName + "$refs\"", "VALUES ('test-tag', 'TAG', " + refSnapshotId + ", null, null, null),('test-branch', 'BRANCH', " + refSnapshotId + ", null, null, null),('main', 'BRANCH', " + refSnapshotId + ", null, null, null)");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM tpch.tiny.nation LIMIT 5", 5L);
        this.assertQuery("SELECT * FROM " + tableName + " FOR VERSION AS OF " + refSnapshotId, "SELECT * FROM nation");
        this.assertQuery("SELECT * FROM " + tableName + " FOR VERSION AS OF 'test-tag'", "SELECT * FROM nation");
        this.assertQuery("SELECT * FROM " + tableName + " FOR VERSION AS OF 'test-branch'", "SELECT * FROM nation");
        this.assertQueryFails("SELECT * FROM " + tableName + " FOR VERSION AS OF 'test-wrong-ref'", ".*?Cannot find snapshot with reference name: test-wrong-ref");
        this.assertQueryFails("SELECT * FROM " + tableName + " FOR VERSION AS OF 'TEST-TAG'", ".*?Cannot find snapshot with reference name: TEST-TAG");
    }

    @Test
    public void testNestedFieldPartitioning() {
        String tableName = "test_nested_field_partitioning_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id INT, district ROW(name VARCHAR), state ROW(name VARCHAR)) WITH (partitioning = ARRAY['\"state.name\"'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW('Patna'), ROW('BH')), (2, ROW('Patna'), ROW('BH')), (3, ROW('Bengaluru'), ROW('KA')), (4, ROW('Bengaluru'), ROW('KA'))", 4L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (5, ROW('Patna'), ROW('BH')), (6, ROW('Patna'), ROW('BH')), (7, ROW('Bengaluru'), ROW('KA')), (8, ROW('Bengaluru'), ROW('KA'))", 4L);
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(4);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE district.name = 'Bengaluru'", 4L);
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(4);
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES partitioning = ARRAY['\"state.name\"', '\"district.name\"']");
        BaseTable icebergTable = this.loadTable(tableName);
        Assertions.assertThat(icebergTable.spec().fields().stream().map(PartitionField::name).toList()).containsExactlyInAnyOrder((Object[])new String[]{"state.name", "district.name"});
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (9, ROW('Patna'), ROW('BH')), (10, ROW('Bengaluru'), ROW('BH')), (11, ROW('Bengaluru'), ROW('KA')), (12, ROW('Bengaluru'), ROW('KA'))", 4L);
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(7);
        this.assertQuery("SELECT id, district.name, state.name FROM " + tableName, "VALUES (1, 'Patna', 'BH'), (2, 'Patna', 'BH'), (5, 'Patna', 'BH'), (6, 'Patna', 'BH'), (9, 'Patna', 'BH'), (10, 'Bengaluru', 'BH'), (11, 'Bengaluru', 'KA'), (12, 'Bengaluru', 'KA')");
        this.assertUpdate("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(3);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testHighlyNestedFieldPartitioning() {
        String tableName = "test_highly_nested_field_partitioning_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id INT, country ROW(name VARCHAR, state ROW(name VARCHAR, district ROW(name VARCHAR)))) WITH (partitioning = ARRAY['\"country.state.district.name\"'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW('India', ROW('BH', ROW('Patna')))), (2, ROW('India', ROW('BH', ROW('Patna')))), (3, ROW('India', ROW('KA', ROW('Bengaluru')))), (4, ROW('India', ROW('KA', ROW('Bengaluru'))))", 4L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (5, ROW('India', ROW('BH', ROW('Patna')))), (6, ROW('India', ROW('BH', ROW('Patna')))), (7, ROW('India', ROW('KA', ROW('Bengaluru')))), (8, ROW('India', ROW('KA', ROW('Bengaluru'))))", 4L);
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(4);
        this.assertQuery("SELECT partition.\"country.state.district.name\" FROM \"" + tableName + "$partitions\"", "VALUES 'Patna', 'Bengaluru'");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE country.state.district.name = 'Bengaluru'", 4L);
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(2);
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES partitioning = ARRAY['\"country.state.district.name\"', '\"country.state.name\"']");
        BaseTable icebergTable = this.loadTable(tableName);
        Assertions.assertThat(icebergTable.spec().fields().stream().map(PartitionField::name).toList()).containsExactlyInAnyOrder((Object[])new String[]{"country.state.district.name", "country.state.name"});
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (9, ROW('India', ROW('BH', ROW('Patna')))), (10, ROW('India', ROW('BH', ROW('Bengaluru')))), (11, ROW('India', ROW('KA', ROW('Bengaluru')))), (12, ROW('India', ROW('KA', ROW('Bengaluru'))))", 4L);
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(5);
        this.assertQuery("SELECT id, country.name, country.state.name, country.state.district.name FROM " + tableName, "VALUES (1, 'India', 'BH', 'Patna'), (2, 'India', 'BH', 'Patna'), (5, 'India', 'BH', 'Patna'), (6, 'India', 'BH', 'Patna'), (9, 'India', 'BH', 'Patna'), (10, 'India', 'BH', 'Bengaluru'), (11, 'India', 'KA', 'Bengaluru'), (12, 'India', 'KA', 'Bengaluru')");
        this.assertUpdate("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(3);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testHighlyNestedFieldPartitioningWithTruncateTransform() {
        String tableName = "test_highly_nested_field_partitioning_with_transform_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id INT, country ROW(name VARCHAR, state ROW(name VARCHAR, district ROW(name VARCHAR)))) WITH (partitioning = ARRAY['truncate(\"country.state.district.name\", 5)'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW('India', ROW('BH', ROW('Patna')))), (2, ROW('India', ROW('BH', ROW('Patna_Truncate')))), (3, ROW('India', ROW('DL', ROW('Delhi')))), (4, ROW('India', ROW('DL', ROW('Delhi_Truncate'))))", 4L);
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(2);
        List files = this.computeActual("SELECT file_path, record_count FROM \"" + tableName + "$files\"").getMaterializedRows();
        List partitionedFiles = (List)files.stream().filter(file -> ((String)file.getField(0)).contains("country.state.district.name_trunc=")).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((List)partitionedFiles).hasSize(2);
        Assertions.assertThat((long)partitionedFiles.stream().mapToLong(row -> (Long)row.getField(1)).sum()).isEqualTo(4L);
        this.assertQuery("SELECT id, country.state.district.name, country.state.name, country.name FROM " + tableName, "VALUES (1, 'Patna', 'BH', 'India'), (2, 'Patna_Truncate', 'BH', 'India'), (3, 'Delhi', 'DL', 'India'), (4, 'Delhi_Truncate', 'DL', 'India')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testHighlyNestedFieldPartitioningWithBucketTransform() {
        String tableName = "test_highly_nested_field_partitioning_with_transform_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id INT, country ROW(name VARCHAR, state ROW(name VARCHAR, district ROW(name VARCHAR)))) WITH (partitioning = ARRAY['bucket(\"country.state.district.name\", 2)'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW('India', ROW('BH', ROW('Patna')))), (2, ROW('India', ROW('MH', ROW('Mumbai')))), (3, ROW('India', ROW('DL', ROW('Delhi')))), (4, ROW('India', ROW('KA', ROW('Bengaluru'))))", 4L);
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(2);
        List files = this.computeActual("SELECT file_path, record_count FROM \"" + tableName + "$files\"").getMaterializedRows();
        List partitionedFiles = (List)files.stream().filter(file -> ((String)file.getField(0)).contains("country.state.district.name_bucket=")).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((List)partitionedFiles).hasSize(2);
        Assertions.assertThat((long)partitionedFiles.stream().mapToLong(row -> (Long)row.getField(1)).sum()).isEqualTo(4L);
        this.assertQuery("SELECT id, country.state.district.name, country.state.name, country.name FROM " + tableName, "VALUES (1, 'Patna', 'BH', 'India'), (2, 'Mumbai', 'MH', 'India'), (3, 'Delhi', 'DL', 'India'), (4, 'Bengaluru', 'KA', 'India')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testHighlyNestedFieldPartitioningWithTimestampTransform() {
        this.testHighlyNestedFieldPartitioningWithTimestampTransform("ARRAY['year(\"grandparent.parent.ts\")']", ".*?(grandparent\\.parent\\.ts_year=.*/).*", (Set<String>)ImmutableSet.of((Object)"grandparent.parent.ts_year=2021/", (Object)"grandparent.parent.ts_year=2022/", (Object)"grandparent.parent.ts_year=2023/"));
        this.testHighlyNestedFieldPartitioningWithTimestampTransform("ARRAY['month(\"grandparent.parent.ts\")']", ".*?(grandparent\\.parent\\.ts_month=.*/).*", (Set<String>)ImmutableSet.of((Object)"grandparent.parent.ts_month=2021-01/", (Object)"grandparent.parent.ts_month=2022-02/", (Object)"grandparent.parent.ts_month=2023-03/"));
        this.testHighlyNestedFieldPartitioningWithTimestampTransform("ARRAY['day(\"grandparent.parent.ts\")']", ".*?(grandparent\\.parent\\.ts_day=.*/).*", (Set<String>)ImmutableSet.of((Object)"grandparent.parent.ts_day=2021-01-01/", (Object)"grandparent.parent.ts_day=2022-02-02/", (Object)"grandparent.parent.ts_day=2023-03-03/"));
        this.testHighlyNestedFieldPartitioningWithTimestampTransform("ARRAY['hour(\"grandparent.parent.ts\")']", ".*?(grandparent\\.parent\\.ts_hour=.*/).*", (Set<String>)ImmutableSet.of((Object)"grandparent.parent.ts_hour=2021-01-01-01/", (Object)"grandparent.parent.ts_hour=2022-02-02-02/", (Object)"grandparent.parent.ts_hour=2023-03-03-03/"));
    }

    @Test
    void testMapValueSchemaChange() {
        this.testMapValueSchemaChange("PARQUET", "map(array[1], array[NULL])");
        this.testMapValueSchemaChange("ORC", "map(array[1], array[row(NULL)])");
        this.testMapValueSchemaChange("AVRO", "map(array[1], array[row(NULL)])");
    }

    private void testMapValueSchemaChange(String format, String expectedValue) {
        try (TestTable table = this.newTrinoTable("test_map_value_schema_change", "WITH (format = '" + format + "') AS SELECT CAST(map(array[1], array[row(2)]) AS map(integer, row(field integer))) col");){
            BaseTable icebergTable = this.loadTable(table.getName());
            icebergTable.updateSchema().addColumn("col.value", "new_field", (Type)Types.IntegerType.get()).deleteColumn("col.value.field").commit();
            ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).as("Format: %s", new Object[]{format})).matches("SELECT CAST(" + expectedValue + " AS map(integer, row(new_field integer)))");
        }
    }

    @Test
    public void testUpdateAfterEqualityDelete() throws Exception {
        String tableName = "test_update_after_equality_delete_" + TestingNames.randomNameSuffix();
        for (String format : ImmutableList.of((Object)"PARQUET", (Object)"ORC", (Object)"AVRO")) {
            this.assertUpdate("CREATE TABLE " + tableName + " WITH (format = '" + format + "') AS SELECT * FROM tpch.tiny.nation", 25L);
            BaseTable icebergTable = this.loadTable(tableName);
            Assertions.assertThat((Map)icebergTable.currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"0");
            this.writeEqualityDeleteToNationTable((Table)icebergTable);
            Assertions.assertThat((Map)icebergTable.currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"1");
            this.assertUpdate("UPDATE " + tableName + " SET comment = 'test'", 20L);
            this.assertQuery("SELECT nationkey, comment FROM " + tableName, "SELECT nationkey, 'test' FROM nation WHERE regionkey != 1");
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    @Test
    @Disabled
    void testEnvironmentContext() {
        try (TestTable table = this.newTrinoTable("test_environment_context", "(x int)");){
            BaseTable icebergTable = this.loadTable(table.getName());
            Assertions.assertThat((Map)icebergTable.currentSnapshot().summary()).contains(new Map.Entry[]{Map.entry("engine-name", "trino"), Map.entry("engine-version", "testversion")});
        }
    }

    @Test
    public void testMetadataDeleteAfterCommitEnabled() throws IOException {
        int metadataPreviousVersionCount = 5;
        String tableName = "test_metadata_delete_after_commit_enabled" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(_bigint BIGINT, _varchar VARCHAR)");
        BaseTable icebergTable = this.loadTable(tableName);
        String location = icebergTable.location();
        icebergTable.updateProperties().set("write.metadata.delete-after-commit.enabled", "true").set("write.metadata.previous-versions-max", String.valueOf(metadataPreviousVersionCount)).commit();
        TrinoFileSystem trinoFileSystem = this.fileSystemFactory.create(IcebergTestUtils.SESSION);
        Map<String, Long> historyMetadataFiles = IcebergTestUtils.getMetadataFileAndUpdatedMillis(trinoFileSystem, location);
        for (int i = 0; i < 10; ++i) {
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 'a')", 1L);
            Map<String, Long> metadataFiles = IcebergTestUtils.getMetadataFileAndUpdatedMillis(trinoFileSystem, location);
            historyMetadataFiles.putAll(metadataFiles);
            Assertions.assertThat((int)metadataFiles.size()).isLessThanOrEqualTo(1 + metadataPreviousVersionCount);
            Set expectMetadataFiles = historyMetadataFiles.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(metadataPreviousVersionCount + 1).map(Map.Entry::getKey).collect(Collectors.toSet());
            Assertions.assertThat(metadataFiles.keySet()).containsAll(expectMetadataFiles);
        }
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    void testAnalyzeNoSnapshot() {
        String table = "test_analyze_no_snapshot" + TestingNames.randomNameSuffix();
        SchemaTableName schemaTableName = new SchemaTableName("tpch", table);
        this.catalog.newCreateTableTransaction(IcebergTestUtils.SESSION, schemaTableName, new Schema(new Types.NestedField[]{Types.NestedField.of((int)1, (boolean)true, (String)"x", (Type)Types.LongType.get())}), PartitionSpec.unpartitioned(), SortOrder.unsorted(), Optional.ofNullable(this.catalog.defaultTableLocation(IcebergTestUtils.SESSION, schemaTableName)), (Map)ImmutableMap.of()).commitTransaction();
        String expectedStats = "VALUES\n('x', 0e0, 0e0, 1e0, NULL, NULL, NULL),\n(NULL, NULL, NULL, NULL, 0e0, NULL, NULL)\n";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR " + table))).skippingTypesCheck().matches(expectedStats);
        this.assertUpdate("ANALYZE " + table);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR " + table))).skippingTypesCheck().matches(expectedStats);
        this.catalog.dropTable(IcebergTestUtils.SESSION, schemaTableName);
    }

    private void testHighlyNestedFieldPartitioningWithTimestampTransform(String partitioning, String partitionDirectoryRegex, Set<String> expectedPartitionDirectories) {
        String tableName = "test_highly_nested_field_partitioning_with_timestamp_transform_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id INTEGER, grandparent ROW(parent ROW(ts TIMESTAMP(6), a INT), b INT)) WITH (partitioning = " + partitioning + ")");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW(ROW(TIMESTAMP '2021-01-01 01:01:01.111111', 1), 1)), (2, ROW(ROW(TIMESTAMP '2022-02-02 02:02:02.222222', 2), 2)), (3, ROW(ROW(TIMESTAMP '2023-03-03 03:03:03.333333', 3), 3)), (4, ROW(ROW(TIMESTAMP '2022-02-02 02:04:04.444444', 4), 4))", 4L);
        Assertions.assertThat((Iterable)this.loadTable(tableName).newScan().planFiles()).hasSize(3);
        Set partitionedDirectories = (Set)this.computeActual("SELECT file_path FROM \"" + tableName + "$files\"").getMaterializedRows().stream().map(entry -> this.extractPartitionFolder((String)entry.getField(0), partitionDirectoryRegex)).flatMap(Optional::stream).collect(ImmutableSet.toImmutableSet());
        Assertions.assertThat((Collection)partitionedDirectories).isEqualTo(expectedPartitionDirectories);
        this.assertQuery("SELECT id, grandparent.parent.ts, grandparent.parent.a, grandparent.b FROM " + tableName, "VALUES (1, '2021-01-01 01:01:01.111111', 1, 1), (2, '2022-02-02 02:02:02.222222', 2, 2), (3, '2023-03-03 03:03:03.333333', 3, 3), (4, '2022-02-02 02:04:04.444444', 4, 4)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private Optional<String> extractPartitionFolder(String file, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(file);
        if (matcher.matches()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    private void writeEqualityDeleteToNationTable(Table icebergTable) throws Exception {
        this.writeEqualityDeleteToNationTable(icebergTable, Optional.empty(), Optional.empty());
    }

    private void writeEqualityDeleteToNationTable(Table icebergTable, Optional<PartitionSpec> partitionSpec, Optional<PartitionData> partitionData) throws Exception {
        this.writeEqualityDeleteToNationTable(icebergTable, partitionSpec, partitionData, (Map<String, Object>)ImmutableMap.of((Object)"regionkey", (Object)1L));
    }

    private void writeEqualityDeleteToNationTable(Table icebergTable, Optional<PartitionSpec> partitionSpec, Optional<PartitionData> partitionData, Map<String, Object> overwriteValues) throws Exception {
        this.writeEqualityDeleteToNationTableWithDeleteColumns(icebergTable, partitionSpec, partitionData, overwriteValues, Optional.empty());
    }

    private void writeEqualityDeleteToNationTableWithDeleteColumns(Table icebergTable, Optional<PartitionSpec> partitionSpec, Optional<PartitionData> partitionData, Map<String, Object> overwriteValues, Optional<List<String>> deleteFileColumns) throws Exception {
        EqualityDeleteUtils.writeEqualityDeleteForTable(icebergTable, this.fileSystemFactory, partitionSpec, partitionData, overwriteValues, deleteFileColumns);
    }

    private void writeEqualityDeleteToNationTableWithDeleteColumns(Table icebergTable, Optional<PartitionSpec> partitionSpec, Optional<PartitionData> partitionData, Map<String, Object> overwriteValues, Schema deleteRowSchema, List<Integer> equalityDeleteFieldIds) throws Exception {
        EqualityDeleteUtils.writeEqualityDeleteForTableWithSchema(icebergTable, this.fileSystemFactory, partitionSpec, partitionData, deleteRowSchema, equalityDeleteFieldIds, overwriteValues);
    }

    private Table updateTableToV2(String tableName) {
        BaseTable table = this.loadTable(tableName);
        TableOperations operations = table.operations();
        TableMetadata currentMetadata = operations.current();
        Preconditions.checkArgument((currentMetadata.formatVersion() != 2 ? 1 : 0) != 0, (String)"Format version is already 2: '%s'", (Object)tableName);
        operations.commit(currentMetadata, currentMetadata.upgradeToFormatVersion(2));
        return table;
    }

    private BaseTable loadTable(String tableName) {
        return IcebergTestUtils.loadTable(tableName, this.metastore, this.fileSystemFactory, "hive", "tpch");
    }

    private List<String> getActiveFiles(String tableName) {
        return (List)this.computeActual(String.format("SELECT file_path FROM \"%s$files\" WHERE content = %d", tableName, FileContent.DATA.id())).getOnlyColumn().map(String.class::cast).collect(ImmutableList.toImmutableList());
    }

    private static /* synthetic */ Types.NestedField lambda$testMultipleEqualityDeletesWithEquivalentSchemas$2(Table icebergTable, String name) {
        return icebergTable.schema().findField(name);
    }

    private static /* synthetic */ Types.NestedField lambda$testMultipleEqualityDeletesWithEquivalentSchemas$0(Table icebergTable, String name) {
        return icebergTable.schema().findField(name);
    }
}

