/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.Session;
import io.trino.metastore.Database;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.plugin.iceberg.IcebergConnector;
import io.trino.plugin.iceberg.TestingIcebergPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Constant;
import io.trino.sql.planner.assertions.BasePushdownPlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;

public class TestMetadataQueryOptimization
extends BasePushdownPlanTest {
    private static final String ICEBERG_CATALOG = "iceberg";
    private static final String SCHEMA_NAME = "test_schema";
    private File baseDir;

    protected PlanTester createPlanTester() {
        Session session = TestingSession.testSessionBuilder().setCatalog(ICEBERG_CATALOG).setSchema(SCHEMA_NAME).setSystemProperty("task_max_writer_count", "1").build();
        try {
            this.baseDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        PlanTester planTester = PlanTester.create((Session)session);
        planTester.installPlugin((Plugin)new TestingIcebergPlugin(this.baseDir.toPath()));
        planTester.createCatalog(ICEBERG_CATALOG, ICEBERG_CATALOG, (Map)ImmutableMap.of());
        HiveMetastore metastore = ((HiveMetastoreFactory)((IcebergConnector)planTester.getConnector(ICEBERG_CATALOG)).getInjector().getInstance(HiveMetastoreFactory.class)).createMetastore(Optional.empty());
        Database database = Database.builder().setDatabaseName(SCHEMA_NAME).setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).build();
        metastore.createDatabase(database);
        return planTester;
    }

    @Test
    public void testOptimization() {
        String testTable = "test_metadata_optimization";
        this.getPlanTester().executeStatement(String.format("CREATE TABLE %s (a, b, c) WITH (PARTITIONING = ARRAY['b', 'c']) AS VALUES (5, 6, 7), (8, 9, 10)", testTable));
        Session session = Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("optimize_metadata_queries", "true").build();
        this.assertPlan(String.format("SELECT DISTINCT b, c FROM %s ORDER BY b", testTable), session, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((List)ImmutableList.of((Object)"b", (Object)"c"), (List)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)9L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)10L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)7L))))}));
        this.assertPlan(String.format("SELECT DISTINCT b, c FROM %s LIMIT 10", testTable), session, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((List)ImmutableList.of((Object)"b", (Object)"c"), (List)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)9L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)10L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)7L))))}));
        this.assertPlan(String.format("SELECT DISTINCT b, c FROM %s WHERE b > 7", testTable), session, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((List)ImmutableList.of((Object)"b", (Object)"c"), (List)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)9L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)10L))))}));
        this.assertPlan(String.format("SELECT DISTINCT b, c FROM %s WHERE b > 7 AND c < 8", testTable), session, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((List)ImmutableList.of((Object)"b", (Object)"c"), (List)ImmutableList.of())}));
    }

    @Test
    public void testOptimizationOnPartitionWithMultipleFiles() {
        String testTable = "test_metadata_optimization_on_partition_with_multiple_files";
        this.getPlanTester().executeStatement(String.format("CREATE TABLE %s (a, b, c) WITH (PARTITIONING = ARRAY['b', 'c']) AS VALUES (1, 8, 9), (2, 8, 9)", testTable));
        Session session = Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("optimize_metadata_queries", "true").build();
        this.getPlanTester().executeStatement(String.format("INSERT INTO %s VALUES (3, 8, 9)", testTable));
        this.assertPlan(String.format("SELECT DISTINCT b, c FROM %s ORDER BY b", testTable), session, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((List)ImmutableList.of((Object)"b", (Object)"c"), (List)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)8L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)9L))))}));
    }

    @Test
    public void testOptimizationWithNullPartitions() {
        String testTable = "test_metadata_optimization_with_null_partitions";
        this.getPlanTester().executeStatement(String.format("CREATE TABLE %s (a, b, c) WITH (PARTITIONING = ARRAY['b', 'c'])AS VALUES (5, 6, CAST(NULL AS INTEGER)), (8, 9, CAST(NULL AS INTEGER))", testTable));
        Session session = Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("optimize_metadata_queries", "true").build();
        this.assertPlan(String.format("SELECT DISTINCT b, c FROM %s ORDER BY b", testTable), session, PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.values((List)ImmutableList.of((Object)"b", (Object)"c"), (List)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Object)new Constant((Type)IntegerType.INTEGER, null)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)9L), (Object)new Constant((Type)IntegerType.INTEGER, null))))}));
    }

    @AfterAll
    public void cleanup() throws Exception {
        if (this.baseDir != null) {
            MoreFiles.deleteRecursively((Path)this.baseDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }
}

