/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.json.ObjectMapperProvider;
import io.trino.plugin.iceberg.MetricsWrapper;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.Metrics;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMetricsWrapper {
    private static final JsonCodec<MetricsWrapper> CODEC = JsonCodec.jsonCodec(MetricsWrapper.class);

    @Test
    public void testRoundTrip() {
        Long recordCount = 123L;
        ImmutableMap columnSizes = ImmutableMap.of((Object)3, (Object)321L, (Object)5, (Object)543L);
        ImmutableMap valueCounts = ImmutableMap.of((Object)7, (Object)765L, (Object)9, (Object)987L);
        ImmutableMap nullValueCounts = ImmutableMap.of((Object)2, (Object)234L, (Object)4, (Object)456L);
        ImmutableMap nanValueCounts = ImmutableMap.of((Object)1, (Object)2L, (Object)3, (Object)4L);
        ImmutableMap lowerBounds = ImmutableMap.of((Object)13, (Object)ByteBuffer.wrap(new byte[]{0, 8, 9}));
        ImmutableMap upperBounds = ImmutableMap.of((Object)17, (Object)ByteBuffer.wrap(new byte[]{5, 4, 0}));
        Metrics expected = new Metrics(recordCount, (Map)columnSizes, (Map)valueCounts, (Map)nullValueCounts, (Map)nanValueCounts, (Map)lowerBounds, (Map)upperBounds);
        Metrics actual = ((MetricsWrapper)CODEC.fromJson(CODEC.toJson((Object)new MetricsWrapper(expected)))).metrics();
        Assertions.assertThat((Long)actual.recordCount()).isEqualTo((Object)recordCount);
        Assertions.assertThat((Map)actual.columnSizes()).isEqualTo((Object)columnSizes);
        Assertions.assertThat((Map)actual.valueCounts()).isEqualTo((Object)valueCounts);
        Assertions.assertThat((Map)actual.nullValueCounts()).isEqualTo((Object)nullValueCounts);
        Assertions.assertThat((Map)actual.nanValueCounts()).isEqualTo((Object)nanValueCounts);
        Assertions.assertThat((Map)actual.lowerBounds()).isEqualTo((Object)lowerBounds);
        Assertions.assertThat((Map)actual.upperBounds()).isEqualTo((Object)upperBounds);
    }

    @Test
    public void testAllPropertiesHandled() {
        Set<String> properties = TestMetricsWrapper.getJsonProperties(MetricsWrapper.class);
        for (Method method : Metrics.class.getMethods()) {
            if (!method.getDeclaringClass().equals(Method.class)) continue;
            Assertions.assertThat(properties).contains((Object[])new String[]{method.getName()});
        }
    }

    private static Set<String> getJsonProperties(Type type) {
        ObjectMapper mapper = new ObjectMapperProvider().get();
        return (Set)mapper.getSerializationConfig().introspect(mapper.getTypeFactory().constructType(type)).findProperties().stream().map(BeanPropertyDefinition::getName).collect(ImmutableSet.toImmutableSet());
    }
}

