/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergPageSourceProvider;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestParquetPredicates {
    @Test
    public void testParquetTupleDomainStructWithPrimitiveColumnPredicate() {
        RowType baseType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"b", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"c", (io.trino.spi.type.Type)IntegerType.INTEGER)});
        ColumnIdentity fieldA = new ColumnIdentity(1, "a", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        ColumnIdentity fieldB = new ColumnIdentity(2, "b", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        ColumnIdentity fieldC = new ColumnIdentity(3, "c", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        MessageType fileSchema = new MessageType("iceberg_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "row_field", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a").withId(1), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "b").withId(2), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "c").withId(3)})});
        IcebergColumnHandle projectedColumn = new IcebergColumnHandle(new ColumnIdentity(5, "row_field", ColumnIdentity.TypeCategory.STRUCT, (List)ImmutableList.of((Object)fieldA, (Object)fieldB, (Object)fieldC)), (io.trino.spi.type.Type)baseType, (List)ImmutableList.of((Object)2), (io.trino.spi.type.Type)IntegerType.INTEGER, false, Optional.empty());
        Domain predicateDomain = Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)123L);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)projectedColumn, (Object)predicateDomain));
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain calculatedTupleDomain = IcebergPageSourceProvider.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)tupleDomain);
        Assertions.assertThat((Map)((Map)calculatedTupleDomain.getDomains().orElseThrow())).hasSize(1);
        ColumnDescriptor selectedColumnDescriptor = (ColumnDescriptor)descriptorsByPath.get(ImmutableList.of((Object)"row_field", (Object)"b"));
        Assertions.assertThat((Object)((Domain)((Map)calculatedTupleDomain.getDomains().orElseThrow()).get(selectedColumnDescriptor))).isEqualTo((Object)predicateDomain);
    }

    @Test
    public void testParquetTupleDomainStructWithPrimitiveColumnDifferentIdPredicate() {
        RowType baseType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"b", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"c", (io.trino.spi.type.Type)IntegerType.INTEGER)});
        ColumnIdentity fieldA = new ColumnIdentity(1, "a", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        ColumnIdentity fieldB = new ColumnIdentity(2, "b", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        ColumnIdentity fieldC = new ColumnIdentity(4, "c", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        MessageType fileSchema = new MessageType("iceberg_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "row_field", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a").withId(1), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "b").withId(2), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "c").withId(3)}).withId(5)});
        IcebergColumnHandle projectedColumn = new IcebergColumnHandle(new ColumnIdentity(5, "row_field", ColumnIdentity.TypeCategory.STRUCT, (List)ImmutableList.of((Object)fieldA, (Object)fieldB, (Object)fieldC)), (io.trino.spi.type.Type)baseType, (List)ImmutableList.of((Object)4), (io.trino.spi.type.Type)IntegerType.INTEGER, false, Optional.empty());
        Domain predicateDomain = Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)123L);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)projectedColumn, (Object)predicateDomain));
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain calculatedTupleDomain = IcebergPageSourceProvider.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)tupleDomain);
        Assertions.assertThat((boolean)calculatedTupleDomain.isAll()).isTrue();
    }

    @Test
    public void testParquetTupleDomainStructWithComplexColumnPredicate() {
        RowType nestedType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"c1", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"c2", (io.trino.spi.type.Type)IntegerType.INTEGER)});
        RowType baseType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"b", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"c", (io.trino.spi.type.Type)nestedType)});
        ColumnIdentity fieldC11 = new ColumnIdentity(1, "c1", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        ColumnIdentity fieldC12 = new ColumnIdentity(2, "c2", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        ColumnIdentity fieldA = new ColumnIdentity(3, "a", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        ColumnIdentity fieldB = new ColumnIdentity(4, "b", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        ColumnIdentity fieldC = new ColumnIdentity(5, "c", ColumnIdentity.TypeCategory.STRUCT, (List)ImmutableList.of((Object)fieldC11, (Object)fieldC12));
        MessageType fileSchema = new MessageType("iceberg_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "row_field", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a").withId(3), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "b").withId(4), new GroupType(Type.Repetition.OPTIONAL, "c", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "c1").withId(1), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "c2").withId(2)}).withId(5)})});
        IcebergColumnHandle projectedColumn = new IcebergColumnHandle(new ColumnIdentity(6, "row_field", ColumnIdentity.TypeCategory.STRUCT, (List)ImmutableList.of((Object)fieldA, (Object)fieldB, (Object)fieldC)), (io.trino.spi.type.Type)baseType, (List)ImmutableList.of((Object)5), (io.trino.spi.type.Type)nestedType, false, Optional.empty());
        Domain predicateDomain = Domain.onlyNull((io.trino.spi.type.Type)nestedType);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)projectedColumn, (Object)predicateDomain));
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain calculatedTupleDomain = IcebergPageSourceProvider.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)tupleDomain);
        Assertions.assertThat((boolean)calculatedTupleDomain.isAll()).isTrue();
    }

    @Test
    public void testParquetTupleDomainStructWithMissingPrimitiveColumn() {
        RowType baseType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"b", (io.trino.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"missing", (io.trino.spi.type.Type)IntegerType.INTEGER)});
        ColumnIdentity fieldA = new ColumnIdentity(1, "a", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        ColumnIdentity fieldB = new ColumnIdentity(2, "b", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        ColumnIdentity fieldC = new ColumnIdentity(3, "missing", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        MessageType fileSchema = new MessageType("iceberg_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "row_field", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a").withId(1), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "b").withId(2)})});
        IcebergColumnHandle projectedColumn = new IcebergColumnHandle(new ColumnIdentity(5, "row_field", ColumnIdentity.TypeCategory.STRUCT, (List)ImmutableList.of((Object)fieldA, (Object)fieldB, (Object)fieldC)), (io.trino.spi.type.Type)baseType, (List)ImmutableList.of((Object)3), (io.trino.spi.type.Type)IntegerType.INTEGER, false, Optional.empty());
        Domain predicateDomain = Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)123L);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)projectedColumn, (Object)predicateDomain));
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain calculatedTupleDomain = IcebergPageSourceProvider.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)tupleDomain);
        Assertions.assertThat((boolean)calculatedTupleDomain.isAll()).isTrue();
    }
}

