/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.plugin.iceberg.PartitionFields;
import java.util.List;
import java.util.function.Consumer;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPartitionFields {
    @Test
    public void testParse() {
        TestPartitionFields.assertParse("order_key", TestPartitionFields.partitionSpec(builder -> builder.identity("order_key")));
        TestPartitionFields.assertParse("comment", TestPartitionFields.partitionSpec(builder -> builder.identity("comment")));
        TestPartitionFields.assertParse("COMMENT", TestPartitionFields.partitionSpec(builder -> builder.identity("comment")), "comment");
        TestPartitionFields.assertParse("year(ts)", TestPartitionFields.partitionSpec(builder -> builder.year("ts")));
        TestPartitionFields.assertParse("month(ts)", TestPartitionFields.partitionSpec(builder -> builder.month("ts")));
        TestPartitionFields.assertParse("day(ts)", TestPartitionFields.partitionSpec(builder -> builder.day("ts")));
        TestPartitionFields.assertParse("hour(ts)", TestPartitionFields.partitionSpec(builder -> builder.hour("ts")));
        TestPartitionFields.assertParse("bucket(order_key, 42)", TestPartitionFields.partitionSpec(builder -> builder.bucket("order_key", 42)));
        TestPartitionFields.assertParse("truncate(comment, 13)", TestPartitionFields.partitionSpec(builder -> builder.truncate("comment", 13)));
        TestPartitionFields.assertParse("truncate(order_key, 88)", TestPartitionFields.partitionSpec(builder -> builder.truncate("order_key", 88)));
        TestPartitionFields.assertParse("void(order_key)", TestPartitionFields.partitionSpec(builder -> builder.alwaysNull("order_key")));
        TestPartitionFields.assertParse("YEAR(ts)", TestPartitionFields.partitionSpec(builder -> builder.year("ts")), "year(ts)");
        TestPartitionFields.assertParse("MONtH(ts)", TestPartitionFields.partitionSpec(builder -> builder.month("ts")), "month(ts)");
        TestPartitionFields.assertParse("DaY(ts)", TestPartitionFields.partitionSpec(builder -> builder.day("ts")), "day(ts)");
        TestPartitionFields.assertParse("HoUR(ts)", TestPartitionFields.partitionSpec(builder -> builder.hour("ts")), "hour(ts)");
        TestPartitionFields.assertParse("BuCKET(order_key, 42)", TestPartitionFields.partitionSpec(builder -> builder.bucket("order_key", 42)), "bucket(order_key, 42)");
        TestPartitionFields.assertParse("TRuncate(comment, 13)", TestPartitionFields.partitionSpec(builder -> builder.truncate("comment", 13)), "truncate(comment, 13)");
        TestPartitionFields.assertParse("TRUNCATE(order_key, 88)", TestPartitionFields.partitionSpec(builder -> builder.truncate("order_key", 88)), "truncate(order_key, 88)");
        TestPartitionFields.assertParse("VOId(order_key)", TestPartitionFields.partitionSpec(builder -> builder.alwaysNull("order_key")), "void(order_key)");
        TestPartitionFields.assertParse("\"quoted field\"", TestPartitionFields.partitionSpec(builder -> builder.identity("quoted field")));
        TestPartitionFields.assertParse("\"\"\"another\"\" \"\"quoted\"\" \"\"field\"\"\"", TestPartitionFields.partitionSpec(builder -> builder.identity("\"another\" \"quoted\" \"field\"")));
        TestPartitionFields.assertParse("year(\"quoted ts\")", TestPartitionFields.partitionSpec(builder -> builder.year("quoted ts")));
        TestPartitionFields.assertParse("month(\"quoted ts\")", TestPartitionFields.partitionSpec(builder -> builder.month("quoted ts")));
        TestPartitionFields.assertParse("day(\"quoted ts\")", TestPartitionFields.partitionSpec(builder -> builder.day("quoted ts")));
        TestPartitionFields.assertParse("hour(\"quoted ts\")", TestPartitionFields.partitionSpec(builder -> builder.hour("quoted ts")));
        TestPartitionFields.assertParse("bucket(\"quoted field\", 42)", TestPartitionFields.partitionSpec(builder -> builder.bucket("quoted field", 42)));
        TestPartitionFields.assertParse("truncate(\"quoted field\", 13)", TestPartitionFields.partitionSpec(builder -> builder.truncate("quoted field", 13)));
        TestPartitionFields.assertParse("void(\"quoted field\")", TestPartitionFields.partitionSpec(builder -> builder.alwaysNull("quoted field")));
        TestPartitionFields.assertParse("truncate(\"\"\"another\"\" \"\"quoted\"\" \"\"field\"\"\", 13)", TestPartitionFields.partitionSpec(builder -> builder.truncate("\"another\" \"quoted\" \"field\"", 13)));
        TestPartitionFields.assertParse("void(\"\"\"another\"\" \"\"quoted\"\" \"\"field\"\"\")", TestPartitionFields.partitionSpec(builder -> builder.alwaysNull("\"another\" \"quoted\" \"field\"")));
        TestPartitionFields.assertParse("\"nested.value\"", TestPartitionFields.partitionSpec(builder -> builder.identity("nested.value")));
        TestPartitionFields.assertParse("year(\"nested.ts\")", TestPartitionFields.partitionSpec(builder -> builder.year("nested.ts")));
        TestPartitionFields.assertParse("month(\"nested.ts\")", TestPartitionFields.partitionSpec(builder -> builder.month("nested.ts")));
        TestPartitionFields.assertParse("day(\"nested.ts\")", TestPartitionFields.partitionSpec(builder -> builder.day("nested.ts")));
        TestPartitionFields.assertParse("hour(\"nested.nested.ts\")", TestPartitionFields.partitionSpec(builder -> builder.hour("nested.nested.ts")));
        TestPartitionFields.assertParse("truncate(\"nested.nested.value\", 13)", TestPartitionFields.partitionSpec(builder -> builder.truncate("nested.nested.value", 13)));
        TestPartitionFields.assertParse("bucket(\"nested.nested.value\", 42)", TestPartitionFields.partitionSpec(builder -> builder.bucket("nested.nested.value", 42)));
        TestPartitionFields.assertParse("void(\"nested.nested.value\")", TestPartitionFields.partitionSpec(builder -> builder.alwaysNull("nested.nested.value")));
        TestPartitionFields.assertParse("\"MixedTs\"", TestPartitionFields.partitionSpec(builder -> builder.identity("MixedTs")));
        TestPartitionFields.assertParse("\"MixedNested.MixedValue\"", TestPartitionFields.partitionSpec(builder -> builder.identity("MixedNested.MixedValue")));
        TestPartitionFields.assertParse("year(\"MixedTs\")", TestPartitionFields.partitionSpec(builder -> builder.year("MixedTs")));
        TestPartitionFields.assertParse("month(\"MixedTs\")", TestPartitionFields.partitionSpec(builder -> builder.month("MixedTs")));
        TestPartitionFields.assertParse("day(\"MixedTs\")", TestPartitionFields.partitionSpec(builder -> builder.day("MixedTs")));
        TestPartitionFields.assertParse("hour(\"MixedTs\")", TestPartitionFields.partitionSpec(builder -> builder.hour("MixedTs")));
        TestPartitionFields.assertParse("bucket(\"MixedTs\", 42)", TestPartitionFields.partitionSpec(builder -> builder.bucket("MixedTs", 42)));
        TestPartitionFields.assertParse("truncate(\"MixedString\", 13)", TestPartitionFields.partitionSpec(builder -> builder.truncate("MixedString", 13)));
        TestPartitionFields.assertParse("void(\"MixedString\")", TestPartitionFields.partitionSpec(builder -> builder.alwaysNull("MixedString")));
        TestPartitionFields.assertInvalid("bucket()", "Invalid partition field declaration: bucket()");
        TestPartitionFields.assertInvalid(".nested", "Invalid partition field declaration: .nested");
        TestPartitionFields.assertInvalid("abc", "Cannot find source column: abc");
        TestPartitionFields.assertInvalid("notes", "Cannot partition by non-primitive source field: list<string>");
        TestPartitionFields.assertInvalid("bucket(price, 42)", "Invalid source type double for transform: bucket[42]");
        TestPartitionFields.assertInvalid("bucket(notes, 88)", "Cannot partition by non-primitive source field: list<string>");
        TestPartitionFields.assertInvalid("truncate(ts, 13)", "Invalid source type timestamp for transform: truncate[13]");
        TestPartitionFields.assertInvalid("year(order_key)", "Invalid source type long for transform: year");
        TestPartitionFields.assertInvalid("\"test\"", "Cannot find source column: test");
        TestPartitionFields.assertInvalid("\"test with space\"", "Cannot find source column: test with space");
        TestPartitionFields.assertInvalid("\"test \"with space\"", "Invalid partition field declaration: \"test \"with space\"");
        TestPartitionFields.assertInvalid("\"test \"\"\"with space\"", "Invalid partition field declaration: \"test \"\"\"with space\"");
        TestPartitionFields.assertInvalid("ABC", "Cannot find source column: abc");
        TestPartitionFields.assertInvalid("\"ABC\"", "Cannot find source column: ABC");
        TestPartitionFields.assertInvalid("year(ABC)", "Cannot find source column: abc");
        TestPartitionFields.assertInvalid("bucket(\"ABC\", 12)", "Cannot find source column: ABC");
        TestPartitionFields.assertInvalid("\"nested.list\"", "Cannot partition by non-primitive source field: list<string>");
    }

    @Test
    public void testConflicts() {
        TestPartitionFields.assertParseName(List.of("col", "col_year"), (Type)Types.TimestampType.withZone(), List.of("year(col)"), List.of("col_year_2"));
        TestPartitionFields.assertParseName(List.of("col", "col_month"), (Type)Types.TimestampType.withZone(), List.of("month(col)"), List.of("col_month_2"));
        TestPartitionFields.assertParseName(List.of("col", "col_day"), (Type)Types.TimestampType.withZone(), List.of("day(col)"), List.of("col_day_2"));
        TestPartitionFields.assertParseName(List.of("col", "col_hour"), (Type)Types.TimestampType.withZone(), List.of("hour(col)"), List.of("col_hour_2"));
        TestPartitionFields.assertParseName(List.of("col", "col_bucket"), (Type)Types.TimestampType.withZone(), List.of("bucket(col,10)"), List.of("col_bucket_2"));
        TestPartitionFields.assertParseName(List.of("col", "col_trunc"), (Type)Types.StringType.get(), List.of("truncate(col,10)"), List.of("col_trunc_2"));
        TestPartitionFields.assertParseName(List.of("col", "col_null"), (Type)Types.TimestampType.withZone(), List.of("void(col)"), List.of("col_null_2"));
        TestPartitionFields.assertParseName(List.of("col", "col_year", "col_year_2"), (Type)Types.TimestampType.withZone(), List.of("year(col)"), List.of("col_year_3"));
        TestPartitionFields.assertParseName(List.of("col", "col_year", "col_year_3"), (Type)Types.TimestampType.withZone(), List.of("year(col)"), List.of("col_year_2"));
        TestPartitionFields.assertParseName(List.of("col", "col_year", "col_year_2"), (Type)Types.TimestampType.withZone(), List.of("year(col)", "col_year_2"), List.of("col_year_3", "col_year_2"));
    }

    private static void assertParseName(List<String> columnNames, Type type, List<String> partitions, List<String> expected) {
        ImmutableList.Builder columns = ImmutableList.builderWithExpectedSize((int)columnNames.size());
        int i = 1;
        for (String name : columnNames) {
            columns.add((Object)Types.NestedField.required((int)i++, (String)name, (Type)type));
        }
        PartitionSpec spec = PartitionFields.parsePartitionFields((Schema)new Schema((List)columns.build()), partitions);
        Assertions.assertThat((List)spec.fields()).extracting(PartitionField::name).containsExactlyElementsOf(expected);
    }

    private static void assertParse(String value, PartitionSpec expected, String canonicalRepresentation) {
        Assertions.assertThat((List)expected.fields()).hasSize(1);
        Assertions.assertThat((Object)TestPartitionFields.parseField(value)).isEqualTo((Object)expected);
        Assertions.assertThat((String)((String)Iterables.getOnlyElement((Iterable)PartitionFields.toPartitionFields((PartitionSpec)expected)))).isEqualTo(canonicalRepresentation);
    }

    private static void assertParse(String value, PartitionSpec expected) {
        TestPartitionFields.assertParse(value, expected, value);
    }

    private static void assertInvalid(String value, String message) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestPartitionFields.parseField(value)).isInstanceOfAny(new Class[]{IllegalArgumentException.class, UnsupportedOperationException.class, ValidationException.class})).hasMessage(message);
    }

    private static PartitionSpec parseField(String value) {
        return TestPartitionFields.partitionSpec(builder -> PartitionFields.parsePartitionField((PartitionSpec.Builder)builder, (String)value, (String)""));
    }

    private static PartitionSpec partitionSpec(Consumer<PartitionSpec.Builder> consumer) {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"order_key", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"ts", (Type)Types.TimestampType.withoutZone()), Types.NestedField.required((int)3, (String)"price", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)4, (String)"comment", (Type)Types.StringType.get()), Types.NestedField.optional((int)5, (String)"notes", (Type)Types.ListType.ofRequired((int)6, (Type)Types.StringType.get())), Types.NestedField.optional((int)7, (String)"quoted field", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"quoted ts", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)9, (String)"\"another\" \"quoted\" \"field\"", (Type)Types.StringType.get()), Types.NestedField.required((int)10, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"value", (Type)Types.StringType.get()), Types.NestedField.required((int)13, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)14, (String)"list", (Type)Types.ListType.ofRequired((int)15, (Type)Types.StringType.get())), Types.NestedField.required((int)16, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)"value", (Type)Types.StringType.get()), Types.NestedField.required((int)18, (String)"ts", (Type)Types.TimestampType.withZone())}))})), Types.NestedField.required((int)19, (String)"MixedTs", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)20, (String)"MixedString", (Type)Types.StringType.get()), Types.NestedField.required((int)21, (String)"MixedNested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)22, (String)"MixedValue", (Type)Types.StringType.get())}))});
        PartitionSpec.Builder builder = PartitionSpec.builderFor((Schema)schema);
        consumer.accept(builder);
        return builder.build();
    }
}

