/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.plugin.iceberg.PartitionTransforms;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPartitionTransforms {
    private static final Types.DateType ICEBERG_DATE = Types.DateType.get();
    private static final Types.TimestampType ICEBERG_TIMESTAMP = Types.TimestampType.withoutZone();

    @Test
    public void testToStringMatchesSpecification() {
        Assertions.assertThat((String)Transforms.identity().toString()).isEqualTo("identity");
        Assertions.assertThat((String)Transforms.bucket((int)13).bind((Type)Types.StringType.get()).toString()).isEqualTo("bucket[13]");
        Assertions.assertThat((String)Transforms.truncate((int)19).bind((Type)Types.StringType.get()).toString()).isEqualTo("truncate[19]");
        Assertions.assertThat((String)Transforms.year().toString()).isEqualTo("year");
        Assertions.assertThat((String)Transforms.month().toString()).isEqualTo("month");
        Assertions.assertThat((String)Transforms.day().toString()).isEqualTo("day");
        Assertions.assertThat((String)Transforms.hour().toString()).isEqualTo("hour");
    }

    @Test
    public void testEpochTransforms() {
        long start = LocalDateTime.of(1965, 10, 1, 0, 0, 0).toEpochSecond(ZoneOffset.UTC);
        long end = LocalDateTime.of(1974, 3, 1, 0, 0, 0).toEpochSecond(ZoneOffset.UTC);
        for (long epochSecond = start; epochSecond <= end; epochSecond += 1800L) {
            LocalDateTime time = LocalDateTime.ofEpochSecond(epochSecond, 0, ZoneOffset.UTC);
            long epochMilli = TimeUnit.SECONDS.toMillis(epochSecond);
            int actualYear = Math.toIntExact(PartitionTransforms.epochYear((long)epochMilli));
            int actualMonth = Math.toIntExact(PartitionTransforms.epochMonth((long)epochMilli));
            int actualDay = Math.toIntExact(PartitionTransforms.epochDay((long)epochMilli));
            int actualHour = Math.toIntExact(PartitionTransforms.epochHour((long)epochMilli));
            if (time.toLocalTime().equals(LocalTime.MIDNIGHT)) {
                int epochDay = Math.toIntExact(time.toLocalDate().toEpochDay());
                ((AbstractIntegerAssert)Assertions.assertThat((int)actualYear).describedAs(time.toString(), new Object[0])).isEqualTo(((Integer)Transforms.year().bind((Type)ICEBERG_DATE).apply((Object)epochDay)).intValue());
                ((AbstractIntegerAssert)Assertions.assertThat((int)actualMonth).describedAs(time.toString(), new Object[0])).isEqualTo(((Integer)Transforms.month().bind((Type)ICEBERG_DATE).apply((Object)epochDay)).intValue());
                ((AbstractIntegerAssert)Assertions.assertThat((int)actualDay).describedAs(time.toString(), new Object[0])).isEqualTo(((Integer)Transforms.day().bind((Type)ICEBERG_DATE).apply((Object)epochDay)).intValue());
            }
            long epochMicro = TimeUnit.SECONDS.toMicros(epochSecond);
            ((AbstractIntegerAssert)Assertions.assertThat((int)actualYear).describedAs(time.toString(), new Object[0])).isEqualTo(((Integer)Transforms.year().bind((Type)ICEBERG_TIMESTAMP).apply((Object)epochMicro)).intValue());
            ((AbstractIntegerAssert)Assertions.assertThat((int)actualMonth).describedAs(time.toString(), new Object[0])).isEqualTo(((Integer)Transforms.month().bind((Type)ICEBERG_TIMESTAMP).apply((Object)epochMicro)).intValue());
            ((AbstractIntegerAssert)Assertions.assertThat((int)actualDay).describedAs(time.toString(), new Object[0])).isEqualTo(((Integer)Transforms.day().bind((Type)ICEBERG_TIMESTAMP).apply((Object)epochMicro)).intValue());
            ((AbstractIntegerAssert)Assertions.assertThat((int)actualHour).describedAs(time.toString(), new Object[0])).isEqualTo(((Integer)Transforms.hour().bind((Type)ICEBERG_TIMESTAMP).apply((Object)epochMicro)).intValue());
        }
    }
}

