/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.iceberg.BaseSharedMetastoreTest;
import io.trino.plugin.iceberg.IcebergPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tpch.TpchTable;
import java.nio.file.Path;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestSharedHiveMetastore
extends BaseSharedMetastoreTest {
    private static final String HIVE_CATALOG = "hive";
    private Path dataDirectory;

    protected QueryRunner createQueryRunner() throws Exception {
        Session icebergSession = TestingSession.testSessionBuilder().setCatalog("iceberg").setSchema(this.tpchSchema).build();
        Session hiveSession = TestingSession.testSessionBuilder().setCatalog(HIVE_CATALOG).setSchema(this.tpchSchema).build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)icebergSession).build();
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog("tpch", "tpch");
        this.dataDirectory = queryRunner.getCoordinator().getBaseDataDir().resolve("iceberg_data");
        this.dataDirectory.toFile().deleteOnExit();
        queryRunner.installPlugin((Plugin)new IcebergPlugin());
        queryRunner.createCatalog("iceberg", "iceberg", (Map)ImmutableMap.of((Object)"iceberg.catalog.type", (Object)"TESTING_FILE_METASTORE", (Object)"hive.metastore.catalog.dir", (Object)this.dataDirectory.toString(), (Object)"fs.hadoop.enabled", (Object)"true"));
        queryRunner.createCatalog("iceberg_with_redirections", "iceberg", (Map)ImmutableMap.of((Object)"iceberg.catalog.type", (Object)"TESTING_FILE_METASTORE", (Object)"hive.metastore.catalog.dir", (Object)this.dataDirectory.toString(), (Object)"iceberg.hive-catalog-name", (Object)HIVE_CATALOG, (Object)"fs.hadoop.enabled", (Object)"true"));
        queryRunner.installPlugin((Plugin)new TestingHivePlugin(this.dataDirectory));
        queryRunner.createCatalog(HIVE_CATALOG, HIVE_CATALOG);
        queryRunner.createCatalog("hive_with_redirections", HIVE_CATALOG, (Map)ImmutableMap.of((Object)"hive.iceberg-catalog-name", (Object)"iceberg"));
        queryRunner.execute("CREATE SCHEMA " + this.tpchSchema);
        QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", (Session)icebergSession, (Iterable)ImmutableList.of((Object)TpchTable.NATION));
        QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", (Session)hiveSession, (Iterable)ImmutableList.of((Object)TpchTable.REGION));
        queryRunner.execute("CREATE SCHEMA " + this.testSchema);
        return queryRunner;
    }

    @AfterAll
    public void cleanup() {
        this.assertQuerySucceeds("DROP TABLE IF EXISTS hive." + this.tpchSchema + ".region");
        this.assertQuerySucceeds("DROP TABLE IF EXISTS iceberg." + this.tpchSchema + ".nation");
        this.assertQuerySucceeds("DROP SCHEMA IF EXISTS hive." + this.tpchSchema);
        this.assertQuerySucceeds("DROP SCHEMA IF EXISTS hive." + this.testSchema);
    }

    @Override
    protected String getExpectedHiveCreateSchema(String catalogName) {
        return "CREATE SCHEMA %s.%s\nWITH (\n   location = 'local:///%s'\n)".formatted(catalogName, this.tpchSchema, this.tpchSchema);
    }

    @Override
    protected String getExpectedIcebergCreateSchema(String catalogName) {
        String expectedIcebergCreateSchema = "CREATE SCHEMA %s.%s\nAUTHORIZATION USER user\nWITH (\n   location = '%s/%s'\n)";
        return String.format(expectedIcebergCreateSchema, catalogName, this.tpchSchema, this.dataDirectory, this.tpchSchema);
    }
}

