/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.hive.containers.Hive3MinioDataLake;
import io.trino.plugin.hive.containers.HiveMinioDataLake;
import io.trino.plugin.iceberg.BaseSharedMetastoreTest;
import io.trino.plugin.iceberg.IcebergPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import io.trino.tpch.TpchTable;
import java.nio.file.Path;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestSharedHiveThriftMetastore
extends BaseSharedMetastoreTest {
    private static final String HIVE_CATALOG = "hive";
    private String bucketName;

    protected QueryRunner createQueryRunner() throws Exception {
        this.bucketName = "test-iceberg-shared-metastore" + TestingNames.randomNameSuffix();
        HiveMinioDataLake hiveMinioDataLake = (HiveMinioDataLake)this.closeAfterClass((AutoCloseable)new Hive3MinioDataLake(this.bucketName));
        hiveMinioDataLake.start();
        Session icebergSession = TestingSession.testSessionBuilder().setCatalog("iceberg").setSchema(this.tpchSchema).build();
        Session hiveSession = TestingSession.testSessionBuilder().setCatalog(HIVE_CATALOG).setSchema(this.tpchSchema).build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)icebergSession).build();
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog("tpch", "tpch");
        Path dataDirectory = queryRunner.getCoordinator().getBaseDataDir().resolve("iceberg_data");
        dataDirectory.toFile().deleteOnExit();
        queryRunner.installPlugin((Plugin)new IcebergPlugin());
        queryRunner.createCatalog("iceberg", "iceberg", (Map)ImmutableMap.builder().put((Object)"iceberg.catalog.type", (Object)"HIVE_METASTORE").put((Object)"hive.metastore.uri", (Object)hiveMinioDataLake.getHiveHadoop().getHiveMetastoreEndpoint().toString()).put((Object)"hive.metastore.thrift.client.read-timeout", (Object)"1m").put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)hiveMinioDataLake.getMinio().getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").put((Object)"s3.streaming.part-size", (Object)"5MB").put((Object)"s3.max-connections", (Object)"2").put((Object)"iceberg.register-table-procedure.enabled", (Object)"true").put((Object)"iceberg.writer-sort-buffer-size", (Object)"1MB").buildOrThrow());
        queryRunner.createCatalog("iceberg_with_redirections", "iceberg", (Map)ImmutableMap.builder().put((Object)"iceberg.catalog.type", (Object)"HIVE_METASTORE").put((Object)"hive.metastore.uri", (Object)hiveMinioDataLake.getHiveHadoop().getHiveMetastoreEndpoint().toString()).put((Object)"hive.metastore.thrift.client.read-timeout", (Object)"1m").put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)hiveMinioDataLake.getMinio().getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").put((Object)"s3.streaming.part-size", (Object)"5MB").put((Object)"s3.max-connections", (Object)"2").put((Object)"iceberg.register-table-procedure.enabled", (Object)"true").put((Object)"iceberg.writer-sort-buffer-size", (Object)"1MB").put((Object)"iceberg.hive-catalog-name", (Object)HIVE_CATALOG).buildOrThrow());
        queryRunner.installPlugin((Plugin)new TestingHivePlugin(dataDirectory));
        ImmutableMap hiveProperties = ImmutableMap.builder().put((Object)"hive.metastore", (Object)"thrift").put((Object)"hive.metastore.uri", (Object)hiveMinioDataLake.getHiveHadoop().getHiveMetastoreEndpoint().toString()).put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)hiveMinioDataLake.getMinio().getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").put((Object)"s3.streaming.part-size", (Object)"5MB").put((Object)"hive.max-partitions-per-scan", (Object)"1000").put((Object)"hive.max-partitions-for-eager-load", (Object)"1000").put((Object)"hive.security", (Object)"allow-all").buildOrThrow();
        queryRunner.createCatalog(HIVE_CATALOG, HIVE_CATALOG, (Map)hiveProperties);
        queryRunner.createCatalog("hive_with_redirections", HIVE_CATALOG, (Map)ImmutableMap.builder().putAll((Map)hiveProperties).put((Object)"hive.iceberg-catalog-name", (Object)"iceberg").buildOrThrow());
        queryRunner.execute("CREATE SCHEMA " + this.tpchSchema + " WITH (location = 's3://" + this.bucketName + "/" + this.tpchSchema + "')");
        QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", (Session)icebergSession, (Iterable)ImmutableList.of((Object)TpchTable.NATION));
        QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", (Session)hiveSession, (Iterable)ImmutableList.of((Object)TpchTable.REGION));
        queryRunner.execute("CREATE SCHEMA " + this.testSchema + " WITH (location = 's3://" + this.bucketName + "/" + this.testSchema + "')");
        return queryRunner;
    }

    @AfterAll
    public void cleanup() {
        this.assertQuerySucceeds("DROP TABLE IF EXISTS hive." + this.tpchSchema + ".region");
        this.assertQuerySucceeds("DROP TABLE IF EXISTS iceberg." + this.tpchSchema + ".nation");
        this.assertQuerySucceeds("DROP SCHEMA IF EXISTS hive." + this.tpchSchema);
        this.assertQuerySucceeds("DROP SCHEMA IF EXISTS hive." + this.testSchema);
    }

    @Override
    protected String getExpectedHiveCreateSchema(String catalogName) {
        return "CREATE SCHEMA %s.%s\nWITH (\n   location = 's3://%s/%s'\n)".formatted(catalogName, this.tpchSchema, this.bucketName, this.tpchSchema);
    }

    @Override
    protected String getExpectedIcebergCreateSchema(String catalogName) {
        String expectedIcebergCreateSchema = "CREATE SCHEMA %s.%s\nAUTHORIZATION USER user\nWITH (\n   location = 's3://%s/%s'\n)";
        return String.format(expectedIcebergCreateSchema, catalogName, this.tpchSchema, this.bucketName, this.tpchSchema);
    }
}

