/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.SortFieldUtils;
import java.util.List;
import java.util.function.Consumer;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.SortOrderBuilder;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;

public class TestSortFieldUtils {
    @Test
    public void testParse() {
        TestSortFieldUtils.assertParse("order_key", TestSortFieldUtils.sortOrder(builder -> builder.asc("order_key")));
        TestSortFieldUtils.assertParse("order_key ASC", TestSortFieldUtils.sortOrder(builder -> builder.asc("order_key")));
        TestSortFieldUtils.assertParse("order_key ASC NULLS FIRST", TestSortFieldUtils.sortOrder(builder -> builder.asc("order_key")));
        TestSortFieldUtils.assertParse("order_key ASC NULLS FIRST", TestSortFieldUtils.sortOrder(builder -> builder.asc("order_key", NullOrder.NULLS_FIRST)));
        TestSortFieldUtils.assertParse("order_key ASC NULLS LAST", TestSortFieldUtils.sortOrder(builder -> builder.asc("order_key", NullOrder.NULLS_LAST)));
        TestSortFieldUtils.assertParse("order_key DESC", TestSortFieldUtils.sortOrder(builder -> builder.desc("order_key")));
        TestSortFieldUtils.assertParse("order_key DESC NULLS FIRST", TestSortFieldUtils.sortOrder(builder -> builder.desc("order_key", NullOrder.NULLS_FIRST)));
        TestSortFieldUtils.assertParse("order_key DESC NULLS LAST", TestSortFieldUtils.sortOrder(builder -> builder.desc("order_key", NullOrder.NULLS_LAST)));
        TestSortFieldUtils.assertParse("order_key DESC NULLS LAST", TestSortFieldUtils.sortOrder(builder -> builder.desc("order_key")));
        TestSortFieldUtils.assertParse("order_key asc nulls last", TestSortFieldUtils.sortOrder(builder -> builder.asc("order_key", NullOrder.NULLS_LAST)));
        TestSortFieldUtils.assertParse("order_key desc nulls first", TestSortFieldUtils.sortOrder(builder -> builder.desc("order_key", NullOrder.NULLS_FIRST)));
        TestSortFieldUtils.assertParse("\"order_key\" asc nulls last", TestSortFieldUtils.sortOrder(builder -> builder.asc("order_key", NullOrder.NULLS_LAST)));
        TestSortFieldUtils.assertParse("\"order_key\" desc nulls first", TestSortFieldUtils.sortOrder(builder -> builder.desc("order_key", NullOrder.NULLS_FIRST)));
        TestSortFieldUtils.assertParse("ORDER_KEY ASC NULLS LAST", TestSortFieldUtils.sortOrder(builder -> builder.asc("order_key", NullOrder.NULLS_LAST)));
        TestSortFieldUtils.assertParse("ORDER_KEY DESC NULLS FIRST", TestSortFieldUtils.sortOrder(builder -> builder.desc("order_key", NullOrder.NULLS_FIRST)));
        TestSortFieldUtils.assertDoesNotParse("\"ORDER_KEY\" ASC NULLS LAST", "Cannot find field 'ORDER_KEY' .*");
        TestSortFieldUtils.assertDoesNotParse("\"ORDER_KEY\" DESC NULLS FIRST", "Cannot find field 'ORDER_KEY' .*");
        TestSortFieldUtils.assertParse("\"MixedCase\" ASC NULLS LAST", TestSortFieldUtils.sortOrder(builder -> builder.asc("MixedCase", NullOrder.NULLS_LAST)));
        TestSortFieldUtils.assertParse("\"MixedCase\" DESC NULLS FIRST", TestSortFieldUtils.sortOrder(builder -> builder.desc("MixedCase", NullOrder.NULLS_FIRST)));
        TestSortFieldUtils.assertParse("OrDER_keY Asc NullS LAst", TestSortFieldUtils.sortOrder(builder -> builder.asc("order_key", NullOrder.NULLS_LAST)));
        TestSortFieldUtils.assertParse("OrDER_keY Desc NullS FIrsT", TestSortFieldUtils.sortOrder(builder -> builder.desc("order_key", NullOrder.NULLS_FIRST)));
        TestSortFieldUtils.assertDoesNotParse("\"OrDER_keY\" Asc NullS LAst", "Cannot find field 'OrDER_keY' .*");
        TestSortFieldUtils.assertDoesNotParse("\"OrDER_keY\" Desc NullS FIrsT", "Cannot find field 'OrDER_keY' .*");
        TestSortFieldUtils.assertParse("comment", TestSortFieldUtils.sortOrder(builder -> builder.asc("comment")));
        TestSortFieldUtils.assertParse("\"comment\"", TestSortFieldUtils.sortOrder(builder -> builder.asc("comment")));
        TestSortFieldUtils.assertParse("\"quoted field\"", TestSortFieldUtils.sortOrder(builder -> builder.asc("quoted field")));
        TestSortFieldUtils.assertParse("\"\"\"another\"\" \"\"quoted\"\" \"\"field\"\"\"", TestSortFieldUtils.sortOrder(builder -> builder.asc("\"another\" \"quoted\" \"field\"")));
        TestSortFieldUtils.assertParse("\"\"\"another\"\" \"\"quoted\"\" \"\"field\"\"\" ASC    NULLS   FIRST  ", TestSortFieldUtils.sortOrder(builder -> builder.asc("\"another\" \"quoted\" \"field\"")));
        TestSortFieldUtils.assertParse("\"\"\"another\"\" \"\"quoted\"\" \"\"field\"\"\" ASC    NULLS   LAST    ", TestSortFieldUtils.sortOrder(builder -> builder.asc("\"another\" \"quoted\" \"field\"", NullOrder.NULLS_LAST)));
        TestSortFieldUtils.assertParse("\"\"\"another\"\" \"\"quoted\"\" \"\"field\"\"\" DESC NULLS FIRST", TestSortFieldUtils.sortOrder(builder -> builder.desc("\"another\" \"quoted\" \"field\"", NullOrder.NULLS_FIRST)));
        TestSortFieldUtils.assertParse(" comment   ", TestSortFieldUtils.sortOrder(builder -> builder.asc("comment")));
        TestSortFieldUtils.assertParse("comment ASC", TestSortFieldUtils.sortOrder(builder -> builder.asc("comment")));
        TestSortFieldUtils.assertParse("  comment    ASC  ", TestSortFieldUtils.sortOrder(builder -> builder.asc("comment")));
        TestSortFieldUtils.assertParse("comment ASC NULLS FIRST", TestSortFieldUtils.sortOrder(builder -> builder.asc("comment")));
        TestSortFieldUtils.assertParse("  comment    ASC     NULLS     FIRST    ", TestSortFieldUtils.sortOrder(builder -> builder.asc("comment")));
        TestSortFieldUtils.assertParse("comment ASC NULLS FIRST", TestSortFieldUtils.sortOrder(builder -> builder.asc("comment", NullOrder.NULLS_FIRST)));
        TestSortFieldUtils.assertParse("     comment   ASC       NULLS       FIRST    ", TestSortFieldUtils.sortOrder(builder -> builder.asc("comment", NullOrder.NULLS_FIRST)));
        TestSortFieldUtils.assertParse("comment ASC NULLS FIRST", TestSortFieldUtils.sortOrder(builder -> builder.asc("comment", NullOrder.NULLS_FIRST)));
        TestSortFieldUtils.assertParse("    comment     ASC    NULLS   FIRST      ", TestSortFieldUtils.sortOrder(builder -> builder.asc("comment", NullOrder.NULLS_FIRST)));
        TestSortFieldUtils.assertParse("comment ASC NULLS LAST", TestSortFieldUtils.sortOrder(builder -> builder.asc("comment", NullOrder.NULLS_LAST)));
        TestSortFieldUtils.assertParse("  comment   ASC    NULLS     LAST    ", TestSortFieldUtils.sortOrder(builder -> builder.asc("comment", NullOrder.NULLS_LAST)));
        TestSortFieldUtils.assertParse("comment DESC", TestSortFieldUtils.sortOrder(builder -> builder.desc("comment")));
        TestSortFieldUtils.assertParse("  comment   DESC  ", TestSortFieldUtils.sortOrder(builder -> builder.desc("comment")));
        TestSortFieldUtils.assertParse("comment DESC NULLS FIRST", TestSortFieldUtils.sortOrder(builder -> builder.desc("comment", NullOrder.NULLS_FIRST)));
        TestSortFieldUtils.assertParse("  comment     DESC  NULLS   FIRST ", TestSortFieldUtils.sortOrder(builder -> builder.desc("comment", NullOrder.NULLS_FIRST)));
        TestSortFieldUtils.assertParse("comment DESC NULLS LAST", TestSortFieldUtils.sortOrder(builder -> builder.desc("comment", NullOrder.NULLS_LAST)));
        TestSortFieldUtils.assertParse("  comment   DESC    NULLS   LAST   ", TestSortFieldUtils.sortOrder(builder -> builder.desc("comment", NullOrder.NULLS_LAST)));
        TestSortFieldUtils.assertParse("comment DESC NULLS LAST", TestSortFieldUtils.sortOrder(builder -> builder.desc("comment")));
        TestSortFieldUtils.assertParse("    comment     DESC   NULLS    LAST   ", TestSortFieldUtils.sortOrder(builder -> builder.desc("comment")));
        TestSortFieldUtils.assertDoesNotParse("bucket(comment, 3)");
        TestSortFieldUtils.assertDoesNotParse("truncate(comment, 3)");
        TestSortFieldUtils.assertDoesNotParse("year(comment)");
        TestSortFieldUtils.assertDoesNotParse("month(comment)");
        TestSortFieldUtils.assertDoesNotParse("day(comment)");
        TestSortFieldUtils.assertDoesNotParse("hour(comment)");
        TestSortFieldUtils.assertDoesNotParse("bucket(comment, 3) ASC");
        TestSortFieldUtils.assertDoesNotParse("bucket(comment, 3) ASC NULLS LAST");
    }

    private static void assertParse(@Language(value="SQL") String value, SortOrder expected) {
        Assertions.assertThat((List)expected.fields()).hasSize(1);
        Assertions.assertThat((Object)TestSortFieldUtils.parseField(value)).isEqualTo((Object)expected);
    }

    private static void assertDoesNotParse(@Language(value="SQL") String value) {
        TestSortFieldUtils.assertDoesNotParse(value, "\\QUnable to parse sort field: [%s]".formatted(value));
    }

    private static void assertDoesNotParse(@Language(value="SQL") String value, @Language(value="RegExp") String expectedMessage) {
        Assertions.assertThatThrownBy(() -> TestSortFieldUtils.parseField(value)).hasMessageMatching(expectedMessage);
    }

    private static SortOrder parseField(String value) {
        return TestSortFieldUtils.sortOrder(builder -> SortFieldUtils.parseSortFields((SortOrderBuilder)builder, (List)ImmutableList.of((Object)value)));
    }

    private static SortOrder sortOrder(Consumer<SortOrder.Builder> consumer) {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"order_key", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"ts", (Type)Types.TimestampType.withoutZone()), Types.NestedField.required((int)3, (String)"price", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)4, (String)"comment", (Type)Types.StringType.get()), Types.NestedField.optional((int)5, (String)"notes", (Type)Types.ListType.ofRequired((int)6, (Type)Types.StringType.get())), Types.NestedField.optional((int)7, (String)"quoted field", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"quoted ts", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)9, (String)"\"another\" \"quoted\" \"field\"", (Type)Types.StringType.get()), Types.NestedField.optional((int)10, (String)"MixedCase", (Type)Types.StringType.get())});
        SortOrder.Builder builder = SortOrder.builderFor((Schema)schema);
        consumer.accept(builder);
        return builder.build();
    }
}

