/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.MapBinder;
import io.airlift.configuration.ConfigBinder;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.local.LocalFileSystemFactory;
import io.trino.plugin.hive.metastore.file.FileHiveMetastoreConfig;
import io.trino.plugin.iceberg.IcebergConnectorFactory;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TestingIcebergConnectorFactory
implements ConnectorFactory {
    private final Optional<Module> icebergCatalogModule;
    private final Module module;

    public TestingIcebergConnectorFactory(Path localFileSystemRootPath) {
        this(localFileSystemRootPath, Optional.empty());
    }

    @Deprecated
    public TestingIcebergConnectorFactory(Path localFileSystemRootPath, Optional<Module> icebergCatalogModule) {
        boolean ignored = localFileSystemRootPath.toFile().mkdirs();
        this.icebergCatalogModule = Objects.requireNonNull(icebergCatalogModule, "icebergCatalogModule is null");
        this.module = binder -> {
            MapBinder.newMapBinder((Binder)binder, String.class, TrinoFileSystemFactory.class).addBinding((Object)"local").toInstance((Object)new LocalFileSystemFactory(localFileSystemRootPath));
            ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(FileHiveMetastoreConfig.class, config -> config.setCatalogDirectory("local:///"));
        };
    }

    public String getName() {
        return "iceberg";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        if (!config.containsKey("iceberg.catalog.type")) {
            config = ImmutableMap.builder().putAll(config).put((Object)"iceberg.catalog.type", (Object)"TESTING_FILE_METASTORE").buildOrThrow();
        }
        return IcebergConnectorFactory.createConnector((String)catalogName, (Map)config, (ConnectorContext)context, (Module)this.module, this.icebergCatalogModule);
    }
}

