/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import io.trino.plugin.iceberg.IcebergPlugin;
import io.trino.plugin.iceberg.TestingIcebergConnectorFactory;
import io.trino.spi.connector.ConnectorFactory;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

public class TestingIcebergPlugin
extends IcebergPlugin {
    private final Path localFileSystemRootPath;
    private final Optional<Module> icebergCatalogModule;

    public TestingIcebergPlugin(Path localFileSystemRootPath) {
        this(localFileSystemRootPath, Optional.empty());
    }

    @Deprecated
    public TestingIcebergPlugin(Path localFileSystemRootPath, Optional<Module> icebergCatalogModule) {
        this.localFileSystemRootPath = Objects.requireNonNull(localFileSystemRootPath, "localFileSystemRootPath is null");
        this.icebergCatalogModule = Objects.requireNonNull(icebergCatalogModule, "icebergCatalogModule is null");
    }

    public Iterable<ConnectorFactory> getConnectorFactories() {
        ImmutableList connectorFactories = ImmutableList.copyOf((Iterable)super.getConnectorFactories());
        Verify.verify((connectorFactories.size() == 1 ? 1 : 0) != 0, (String)"Unexpected connector factories: %s", (Object)connectorFactories);
        return ImmutableList.of((Object)new TestingIcebergConnectorFactory(this.localFileSystemRootPath, this.icebergCatalogModule));
    }
}

