/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.trino.metastore.TableInfo;
import io.trino.plugin.base.util.AutoCloseableCloser;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergMetadata;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.TableStatisticsWriter;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingNames;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public abstract class BaseTrinoCatalogTest {
    private static final Logger LOG = Logger.get(BaseTrinoCatalogTest.class);
    protected static final ConnectorSession SESSION = TestingConnectorSession.builder().setPropertyMetadata(new IcebergSessionProperties(new IcebergConfig(), new OrcReaderConfig(), new OrcWriterConfig(), new ParquetReaderConfig(), new ParquetWriterConfig()).getSessionProperties()).build();

    protected abstract TrinoCatalog createTrinoCatalog(boolean var1) throws IOException;

    protected Map<String, Object> defaultNamespaceProperties(String newNamespaceName) {
        return ImmutableMap.of();
    }

    @Test
    public void testCreateNamespaceWithLocation() throws Exception {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        String namespace = "test_create_namespace_with_location_" + TestingNames.randomNameSuffix();
        ImmutableMap namespaceProperties = new HashMap(this.defaultNamespaceProperties(namespace));
        String namespaceLocation = (String)namespaceProperties.computeIfAbsent((String)"location", string -> "local:///a/path/");
        namespaceProperties = ImmutableMap.copyOf(namespaceProperties);
        catalog.createNamespace(SESSION, namespace, (Map)namespaceProperties, new TrinoPrincipal(PrincipalType.USER, SESSION.getUser()));
        Assertions.assertThat((List)catalog.listNamespaces(SESSION)).contains((Object[])new String[]{namespace});
        Assertions.assertThat((Map)catalog.loadNamespaceMetadata(SESSION, namespace)).isEqualTo((Object)namespaceProperties);
        Assertions.assertThat((String)catalog.defaultTableLocation(SESSION, new SchemaTableName(namespace, "table"))).isEqualTo(namespaceLocation.replaceAll("/$", "") + "/table");
        catalog.dropNamespace(SESSION, namespace);
        Assertions.assertThat((List)catalog.listNamespaces(SESSION)).doesNotContain((Object[])new String[]{namespace});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonLowercaseNamespace() throws Exception {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        String namespace = "testNonLowercaseNamespace" + TestingNames.randomNameSuffix();
        String schema = namespace.toLowerCase(Locale.ENGLISH);
        catalog.createNamespace(SESSION, namespace, this.defaultNamespaceProperties(namespace), new TrinoPrincipal(PrincipalType.USER, SESSION.getUser()));
        try {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.namespaceExists(SESSION, namespace)).as("catalog.namespaceExists(namespace)", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.namespaceExists(SESSION, schema)).as("catalog.namespaceExists(schema)", new Object[0])).isTrue();
            ((ListAssert)((ListAssert)Assertions.assertThat((List)catalog.listNamespaces(SESSION)).as("catalog.listNamespaces", new Object[0])).doesNotContain((Object[])new String[]{namespace})).contains((Object[])new String[]{schema});
            IcebergMetadata icebergMetadata = new IcebergMetadata(TestingPlannerContext.PLANNER_CONTEXT.getTypeManager(), CatalogHandle.fromId((String)"iceberg:NORMAL:v12345"), JsonCodec.jsonCodec(CommitTaskData.class), catalog, (connectorIdentity, fileIoProperties) -> {
                throw new UnsupportedOperationException();
            }, new TableStatisticsWriter(new NodeVersion("test-version")), Optional.empty(), false, string -> false, (ExecutorService)MoreExecutors.newDirectExecutorService(), MoreExecutors.directExecutor(), (ExecutorService)MoreExecutors.newDirectExecutorService());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)icebergMetadata.schemaExists(SESSION, namespace)).as("icebergMetadata.schemaExists(namespace)", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)icebergMetadata.schemaExists(SESSION, schema)).as("icebergMetadata.schemaExists(schema)", new Object[0])).isTrue();
            ((ListAssert)((ListAssert)Assertions.assertThat((List)icebergMetadata.listSchemaNames(SESSION)).as("icebergMetadata.listSchemaNames", new Object[0])).doesNotContain((Object[])new String[]{namespace})).contains((Object[])new String[]{schema});
        }
        finally {
            catalog.dropNamespace(SESSION, namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTable() throws Exception {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        String namespace = "test_create_table_" + TestingNames.randomNameSuffix();
        String table = "tableName";
        SchemaTableName schemaTableName = new SchemaTableName(namespace, table);
        Map<String, String> tableProperties = Map.of("test_key", "test_value");
        try {
            catalog.createNamespace(SESSION, namespace, this.defaultNamespaceProperties(namespace), new TrinoPrincipal(PrincipalType.USER, SESSION.getUser()));
            String tableLocation = this.arbitraryTableLocation(catalog, SESSION, schemaTableName);
            catalog.newCreateTableTransaction(SESSION, schemaTableName, new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"col1", (Type)Types.LongType.get())}), PartitionSpec.unpartitioned(), SortOrder.unsorted(), Optional.of(tableLocation), tableProperties).commitTransaction();
            Assertions.assertThat((List)catalog.listTables(SESSION, Optional.of(namespace))).contains((Object[])new TableInfo[]{new TableInfo(schemaTableName, TableInfo.ExtendedRelationType.TABLE)});
            Assertions.assertThat((List)catalog.listTables(SESSION, Optional.empty())).contains((Object[])new TableInfo[]{new TableInfo(schemaTableName, TableInfo.ExtendedRelationType.TABLE)});
            BaseTable icebergTable = catalog.loadTable(SESSION, schemaTableName);
            Assertions.assertThat((String)icebergTable.name()).isEqualTo(IcebergUtil.quotedTableName((SchemaTableName)schemaTableName));
            Assertions.assertThat((List)icebergTable.schema().columns()).hasSize(1);
            Assertions.assertThat((String)((Types.NestedField)icebergTable.schema().columns().get(0)).name()).isEqualTo("col1");
            Assertions.assertThat((Object)((Types.NestedField)icebergTable.schema().columns().get(0)).type()).isEqualTo((Object)Types.LongType.get());
            Assertions.assertThat((String)icebergTable.location()).isEqualTo(tableLocation);
            Assertions.assertThat((boolean)icebergTable.sortOrder().isUnsorted()).isEqualTo(true);
            Assertions.assertThat((Map)icebergTable.properties()).containsAllEntriesOf(tableProperties);
            catalog.dropTable(SESSION, schemaTableName);
            Assertions.assertThat(catalog.listTables(SESSION, Optional.empty()).stream().map(TableInfo::tableName).toList()).doesNotContain((Object[])new SchemaTableName[]{schemaTableName});
        }
        catch (Throwable throwable) {
            try {
                catalog.dropNamespace(SESSION, namespace);
            }
            catch (Exception e) {
                LOG.warn("Failed to clean up namespace: %s", new Object[]{namespace});
            }
            throw throwable;
        }
        try {
            catalog.dropNamespace(SESSION, namespace);
        }
        catch (Exception e) {
            LOG.warn("Failed to clean up namespace: %s", new Object[]{namespace});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateWithSortTable() throws Exception {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        String namespace = "test_create_sort_table_" + TestingNames.randomNameSuffix();
        String table = "tableName";
        SchemaTableName schemaTableName = new SchemaTableName(namespace, table);
        try {
            catalog.createNamespace(SESSION, namespace, this.defaultNamespaceProperties(namespace), new TrinoPrincipal(PrincipalType.USER, SESSION.getUser()));
            Schema tableSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"col1", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"col2", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"col3", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)4, (String)"col4", (Type)Types.StringType.get())});
            SortOrder sortOrder = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)tableSchema).asc("col1")).desc("col2", NullOrder.NULLS_FIRST)).desc("col3")).desc((Term)Expressions.year((String)"col3"), NullOrder.NULLS_LAST).desc((Term)Expressions.month((String)"col3"), NullOrder.NULLS_FIRST).asc((Term)Expressions.day((String)"col3"), NullOrder.NULLS_FIRST).asc((Term)Expressions.hour((String)"col3"), NullOrder.NULLS_FIRST).desc((Term)Expressions.bucket((String)"col2", (int)10), NullOrder.NULLS_FIRST).desc((Term)Expressions.truncate((String)"col4", (int)5), NullOrder.NULLS_FIRST).build();
            String tableLocation = this.arbitraryTableLocation(catalog, SESSION, schemaTableName);
            catalog.newCreateTableTransaction(SESSION, schemaTableName, tableSchema, PartitionSpec.unpartitioned(), sortOrder, Optional.of(tableLocation), (Map)ImmutableMap.of()).commitTransaction();
            Assertions.assertThat((List)catalog.listTables(SESSION, Optional.of(namespace))).contains((Object[])new TableInfo[]{new TableInfo(schemaTableName, TableInfo.ExtendedRelationType.TABLE)});
            Assertions.assertThat((List)catalog.listTables(SESSION, Optional.empty())).contains((Object[])new TableInfo[]{new TableInfo(schemaTableName, TableInfo.ExtendedRelationType.TABLE)});
            BaseTable icebergTable = catalog.loadTable(SESSION, schemaTableName);
            Assertions.assertThat((String)icebergTable.name()).isEqualTo(IcebergUtil.quotedTableName((SchemaTableName)schemaTableName));
            Assertions.assertThat((List)icebergTable.schema().columns()).hasSize(4);
            Assertions.assertThat((String)((Types.NestedField)icebergTable.schema().columns().get(0)).name()).isEqualTo("col1");
            Assertions.assertThat((Object)((Types.NestedField)icebergTable.schema().columns().get(0)).type()).isEqualTo((Object)Types.LongType.get());
            Assertions.assertThat((String)((Types.NestedField)icebergTable.schema().columns().get(1)).name()).isEqualTo("col2");
            Assertions.assertThat((Object)((Types.NestedField)icebergTable.schema().columns().get(1)).type()).isEqualTo((Object)Types.StringType.get());
            Assertions.assertThat((String)icebergTable.location()).isEqualTo(tableLocation);
            Assertions.assertThat((String)((Types.NestedField)icebergTable.schema().columns().get(2)).name()).isEqualTo("col3");
            Assertions.assertThat((Object)((Types.NestedField)icebergTable.schema().columns().get(2)).type()).isEqualTo((Object)Types.TimestampType.withZone());
            Assertions.assertThat((String)((Types.NestedField)icebergTable.schema().columns().get(3)).name()).isEqualTo("col4");
            Assertions.assertThat((Object)((Types.NestedField)icebergTable.schema().columns().get(3)).type()).isEqualTo((Object)Types.StringType.get());
            Assertions.assertThat((String)icebergTable.location()).isEqualTo(tableLocation);
            Assertions.assertThat((Object)icebergTable.sortOrder()).isEqualTo((Object)sortOrder);
            catalog.dropTable(SESSION, schemaTableName);
        }
        catch (Throwable throwable) {
            try {
                if (!catalog.listTables(SESSION, Optional.of(schemaTableName.getSchemaName())).isEmpty()) {
                    catalog.dropTable(SESSION, schemaTableName);
                }
                catalog.dropNamespace(SESSION, namespace);
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to clean up namespace: %s", new Object[]{namespace});
            }
            throw throwable;
        }
        try {
            if (!catalog.listTables(SESSION, Optional.of(schemaTableName.getSchemaName())).isEmpty()) {
                catalog.dropTable(SESSION, schemaTableName);
            }
            catalog.dropNamespace(SESSION, namespace);
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to clean up namespace: %s", new Object[]{namespace});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameTable() throws Exception {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        String namespace = "test_rename_table_" + TestingNames.randomNameSuffix();
        String targetNamespace = "test_rename_table_" + TestingNames.randomNameSuffix();
        String table = "tableName";
        SchemaTableName sourceSchemaTableName = new SchemaTableName(namespace, table);
        try {
            catalog.createNamespace(SESSION, namespace, this.defaultNamespaceProperties(namespace), new TrinoPrincipal(PrincipalType.USER, SESSION.getUser()));
            catalog.createNamespace(SESSION, targetNamespace, this.defaultNamespaceProperties(targetNamespace), new TrinoPrincipal(PrincipalType.USER, SESSION.getUser()));
            catalog.newCreateTableTransaction(SESSION, sourceSchemaTableName, new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"col1", (Type)Types.LongType.get())}), PartitionSpec.unpartitioned(), SortOrder.unsorted(), Optional.of(this.arbitraryTableLocation(catalog, SESSION, sourceSchemaTableName)), (Map)ImmutableMap.of()).commitTransaction();
            Assertions.assertThat((List)catalog.listTables(SESSION, Optional.of(namespace))).contains((Object[])new TableInfo[]{new TableInfo(sourceSchemaTableName, TableInfo.ExtendedRelationType.TABLE)});
            SchemaTableName targetSchemaTableName = new SchemaTableName(sourceSchemaTableName.getSchemaName(), "newTableName");
            catalog.renameTable(SESSION, sourceSchemaTableName, targetSchemaTableName);
            Assertions.assertThat(catalog.listTables(SESSION, Optional.empty()).stream().map(TableInfo::tableName).toList()).doesNotContain((Object[])new SchemaTableName[]{sourceSchemaTableName});
            Assertions.assertThat((List)catalog.listTables(SESSION, Optional.of(namespace))).contains((Object[])new TableInfo[]{new TableInfo(targetSchemaTableName, TableInfo.ExtendedRelationType.TABLE)});
            sourceSchemaTableName = targetSchemaTableName;
            targetSchemaTableName = new SchemaTableName(targetNamespace, sourceSchemaTableName.getTableName());
            catalog.renameTable(SESSION, sourceSchemaTableName, targetSchemaTableName);
            Assertions.assertThat(catalog.listTables(SESSION, Optional.of(namespace)).stream().map(TableInfo::tableName).toList()).doesNotContain((Object[])new SchemaTableName[]{sourceSchemaTableName});
            Assertions.assertThat((List)catalog.listTables(SESSION, Optional.of(targetNamespace))).contains((Object[])new TableInfo[]{new TableInfo(targetSchemaTableName, TableInfo.ExtendedRelationType.TABLE)});
            catalog.dropTable(SESSION, targetSchemaTableName);
        }
        catch (Throwable throwable) {
            try {
                catalog.dropNamespace(SESSION, namespace);
                catalog.dropNamespace(SESSION, targetNamespace);
            }
            catch (Exception e) {
                LOG.warn("Failed to clean up namespaces: %s, %s", new Object[]{namespace, targetNamespace});
            }
            throw throwable;
        }
        try {
            catalog.dropNamespace(SESSION, namespace);
            catalog.dropNamespace(SESSION, targetNamespace);
        }
        catch (Exception e) {
            LOG.warn("Failed to clean up namespaces: %s, %s", new Object[]{namespace, targetNamespace});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUseUniqueTableLocations() throws Exception {
        TrinoCatalog catalog = this.createTrinoCatalog(true);
        String namespace = "test_unique_table_locations_" + TestingNames.randomNameSuffix();
        String table = "tableName";
        SchemaTableName schemaTableName = new SchemaTableName(namespace, table);
        HashMap<String, Object> namespaceProperties = new HashMap<String, Object>(this.defaultNamespaceProperties(namespace));
        String namespaceLocation = (String)namespaceProperties.computeIfAbsent("location", string -> "local:///iceberg_catalog_test_rename_table_" + String.valueOf(UUID.randomUUID()));
        catalog.createNamespace(SESSION, namespace, namespaceProperties, new TrinoPrincipal(PrincipalType.USER, SESSION.getUser()));
        try {
            String location1 = catalog.defaultTableLocation(SESSION, schemaTableName);
            String location2 = catalog.defaultTableLocation(SESSION, schemaTableName);
            Assertions.assertThat((String)location1).isNotEqualTo((Object)location2);
            Assertions.assertThat((String)location1).startsWith((CharSequence)(namespaceLocation + "/"));
            Assertions.assertThat((String)location2).startsWith((CharSequence)(namespaceLocation + "/"));
        }
        catch (Throwable throwable) {
            try {
                catalog.dropNamespace(SESSION, namespace);
            }
            catch (Exception e) {
                LOG.warn("Failed to clean up namespace: %s", new Object[]{namespace});
            }
            throw throwable;
        }
        try {
            catalog.dropNamespace(SESSION, namespace);
        }
        catch (Exception e) {
            LOG.warn("Failed to clean up namespace: %s", new Object[]{namespace});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testView() throws IOException {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        Path tmpDirectory = Files.createTempDirectory("iceberg_catalog_test_create_view_", new FileAttribute[0]);
        tmpDirectory.toFile().deleteOnExit();
        String namespace = "test_create_view_" + TestingNames.randomNameSuffix();
        String viewName = "viewName";
        String renamedViewName = "renamedViewName";
        SchemaTableName schemaTableName = new SchemaTableName(namespace, viewName);
        SchemaTableName renamedSchemaTableName = new SchemaTableName(namespace, renamedViewName);
        ConnectorViewDefinition viewDefinition = new ConnectorViewDefinition("SELECT name FROM local.tiny.nation", Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("name", VarcharType.createUnboundedVarcharType().getTypeId(), Optional.empty())), Optional.empty(), Optional.of(SESSION.getUser()), false, (List)ImmutableList.of());
        try {
            catalog.createNamespace(SESSION, namespace, this.defaultNamespaceProperties(namespace), new TrinoPrincipal(PrincipalType.USER, SESSION.getUser()));
            catalog.createView(SESSION, schemaTableName, viewDefinition, false);
            Assertions.assertThat(catalog.listTables(SESSION, Optional.of(namespace)).stream()).contains((Object[])new TableInfo[]{new TableInfo(schemaTableName, this.getViewType())});
            Map views = catalog.getViews(SESSION, Optional.of(schemaTableName.getSchemaName()));
            Assertions.assertThat((Map)views).hasSize(1);
            this.assertViewDefinition((ConnectorViewDefinition)views.get(schemaTableName), viewDefinition);
            this.assertViewDefinition((ConnectorViewDefinition)catalog.getView(SESSION, schemaTableName).orElseThrow(), viewDefinition);
            catalog.renameView(SESSION, schemaTableName, renamedSchemaTableName);
            Assertions.assertThat(catalog.listTables(SESSION, Optional.of(namespace)).stream().map(TableInfo::tableName).toList()).doesNotContain((Object[])new SchemaTableName[]{schemaTableName});
            views = catalog.getViews(SESSION, Optional.of(schemaTableName.getSchemaName()));
            Assertions.assertThat((Map)views).hasSize(1);
            this.assertViewDefinition((ConnectorViewDefinition)views.get(renamedSchemaTableName), viewDefinition);
            this.assertViewDefinition((ConnectorViewDefinition)catalog.getView(SESSION, renamedSchemaTableName).orElseThrow(), viewDefinition);
            Assertions.assertThat((Optional)catalog.getView(SESSION, schemaTableName)).isEmpty();
            catalog.dropView(SESSION, renamedSchemaTableName);
            Assertions.assertThat(catalog.listTables(SESSION, Optional.empty()).stream().map(TableInfo::tableName).toList()).doesNotContain((Object[])new SchemaTableName[]{renamedSchemaTableName});
        }
        catch (Throwable throwable) {
            try {
                catalog.dropNamespace(SESSION, namespace);
            }
            catch (Exception e) {
                LOG.warn("Failed to clean up namespace: %s", new Object[]{namespace});
            }
            throw throwable;
        }
        try {
            catalog.dropNamespace(SESSION, namespace);
        }
        catch (Exception e) {
            LOG.warn("Failed to clean up namespace: %s", new Object[]{namespace});
        }
    }

    protected TableInfo.ExtendedRelationType getViewType() {
        return TableInfo.ExtendedRelationType.TRINO_VIEW;
    }

    @Test
    public void testListTables() throws Exception {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        TrinoPrincipal principal = new TrinoPrincipal(PrincipalType.USER, SESSION.getUser());
        try (AutoCloseableCloser closer = AutoCloseableCloser.create();){
            String ns1 = "ns1" + TestingNames.randomNameSuffix();
            String ns2 = "ns2" + TestingNames.randomNameSuffix();
            catalog.createNamespace(SESSION, ns1, this.defaultNamespaceProperties(ns1), principal);
            closer.register(() -> catalog.dropNamespace(SESSION, ns1));
            catalog.createNamespace(SESSION, ns2, this.defaultNamespaceProperties(ns2), principal);
            closer.register(() -> catalog.dropNamespace(SESSION, ns2));
            SchemaTableName table1 = new SchemaTableName(ns1, "t1");
            SchemaTableName table2 = new SchemaTableName(ns2, "t2");
            catalog.newCreateTableTransaction(SESSION, table1, new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"col1", (Type)Types.LongType.get())}), PartitionSpec.unpartitioned(), SortOrder.unsorted(), Optional.of(this.arbitraryTableLocation(catalog, SESSION, table1)), (Map)ImmutableMap.of()).commitTransaction();
            closer.register(() -> catalog.dropTable(SESSION, table1));
            catalog.newCreateTableTransaction(SESSION, table2, new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"col1", (Type)Types.LongType.get())}), PartitionSpec.unpartitioned(), SortOrder.unsorted(), Optional.of(this.arbitraryTableLocation(catalog, SESSION, table2)), (Map)ImmutableMap.of()).commitTransaction();
            closer.register(() -> catalog.dropTable(SESSION, table2));
            ImmutableList.Builder allTables = ImmutableList.builder().add((Object)new TableInfo(table1, TableInfo.ExtendedRelationType.TABLE)).add((Object)new TableInfo(table2, TableInfo.ExtendedRelationType.TABLE));
            ImmutableList.Builder icebergTables = ImmutableList.builder().add((Object)table1).add((Object)table2);
            SchemaTableName view = new SchemaTableName(ns2, "view");
            try {
                catalog.createView(SESSION, view, new ConnectorViewDefinition("SELECT name FROM local.tiny.nation", Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("name", VarcharType.createUnboundedVarcharType().getTypeId(), Optional.empty())), Optional.empty(), Optional.of(SESSION.getUser()), false, (List)ImmutableList.of()), false);
                closer.register(() -> catalog.dropView(SESSION, view));
                allTables.add((Object)new TableInfo(view, this.getViewType()));
            }
            catch (TrinoException e) {
                Assertions.assertThat((Object)e.getErrorCode()).isEqualTo((Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode());
            }
            try {
                SchemaTableName materializedView = new SchemaTableName(ns2, "mv");
                this.createMaterializedView(SESSION, catalog, materializedView, BaseTrinoCatalogTest.someMaterializedView(), (Map<String, Object>)ImmutableMap.of((Object)"format", (Object)IcebergFileFormat.PARQUET, (Object)"format_version", (Object)1), false, false);
                closer.register(() -> catalog.dropMaterializedView(SESSION, materializedView));
                allTables.add((Object)new TableInfo(materializedView, TableInfo.ExtendedRelationType.TRINO_MATERIALIZED_VIEW));
            }
            catch (TrinoException e) {
                Assertions.assertThat((Object)e.getErrorCode()).isEqualTo((Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode());
            }
            this.createExternalIcebergTable(catalog, ns2, closer).ifPresent(table -> {
                allTables.add((Object)new TableInfo(table, TableInfo.ExtendedRelationType.TABLE));
                icebergTables.add(table);
            });
            this.createExternalNonIcebergTable(catalog, ns2, closer).ifPresent(table -> allTables.add((Object)new TableInfo(table, TableInfo.ExtendedRelationType.TABLE)));
            Assertions.assertThat((List)catalog.listTables(SESSION, Optional.empty())).containsAll((Iterable)allTables.build());
            Assertions.assertThat((List)catalog.listIcebergTables(SESSION, Optional.empty())).containsAll((Iterable)icebergTables.build());
            Assertions.assertThat((List)catalog.listTables(SESSION, Optional.of(ns1))).containsExactly((Object[])new TableInfo[]{new TableInfo(table1, TableInfo.ExtendedRelationType.TABLE)});
            Assertions.assertThat((List)catalog.listIcebergTables(SESSION, Optional.of(ns1))).containsExactly((Object[])new SchemaTableName[]{table1});
            Assertions.assertThat((List)catalog.listTables(SESSION, Optional.of("non_existing"))).isEmpty();
            Assertions.assertThat((List)catalog.listIcebergTables(SESSION, Optional.of("non_existing"))).isEmpty();
        }
    }

    protected void createMaterializedView(ConnectorSession session, TrinoCatalog catalog, SchemaTableName materializedView, ConnectorMaterializedViewDefinition materializedViewDefinition, Map<String, Object> properties, boolean replace, boolean ignoreExisting) {
        catalog.createMaterializedView(session, materializedView, materializedViewDefinition, properties, replace, ignoreExisting);
    }

    protected Optional<SchemaTableName> createExternalIcebergTable(TrinoCatalog catalog, String namespace, AutoCloseableCloser closer) throws Exception {
        return Optional.empty();
    }

    protected Optional<SchemaTableName> createExternalNonIcebergTable(TrinoCatalog catalog, String namespace, AutoCloseableCloser closer) throws Exception {
        return Optional.empty();
    }

    protected void assertViewDefinition(ConnectorViewDefinition actualView, ConnectorViewDefinition expectedView) {
        Assertions.assertThat((String)actualView.getOriginalSql()).isEqualTo(expectedView.getOriginalSql());
        Assertions.assertThat((Optional)actualView.getCatalog()).isEqualTo((Object)expectedView.getCatalog());
        Assertions.assertThat((Optional)actualView.getSchema()).isEqualTo((Object)expectedView.getSchema());
        Assertions.assertThat((List)actualView.getColumns()).hasSize(expectedView.getColumns().size());
        for (int i = 0; i < actualView.getColumns().size(); ++i) {
            this.assertViewColumnDefinition((ConnectorViewDefinition.ViewColumn)actualView.getColumns().get(i), (ConnectorViewDefinition.ViewColumn)expectedView.getColumns().get(i));
        }
        Assertions.assertThat((Optional)actualView.getOwner()).isEqualTo((Object)expectedView.getOwner());
        Assertions.assertThat((boolean)actualView.isRunAsInvoker()).isEqualTo(expectedView.isRunAsInvoker());
    }

    protected String arbitraryTableLocation(TrinoCatalog catalog, ConnectorSession session, SchemaTableName schemaTableName) throws Exception {
        try {
            return catalog.defaultTableLocation(session, schemaTableName);
        }
        catch (TrinoException e) {
            if (!e.getErrorCode().equals((Object)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR.toErrorCode())) {
                throw e;
            }
            Path tmpDirectory = Files.createTempDirectory("iceberg_catalog_test_arbitrary_location", new FileAttribute[0]);
            tmpDirectory.toFile().deleteOnExit();
            return tmpDirectory.toString();
        }
    }

    private void assertViewColumnDefinition(ConnectorViewDefinition.ViewColumn actualViewColumn, ConnectorViewDefinition.ViewColumn expectedViewColumn) {
        Assertions.assertThat((String)actualViewColumn.getName()).isEqualTo(expectedViewColumn.getName());
        Assertions.assertThat((Object)actualViewColumn.getType()).isEqualTo((Object)expectedViewColumn.getType());
    }

    private static ConnectorMaterializedViewDefinition someMaterializedView() {
        return new ConnectorMaterializedViewDefinition("select 1", Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorMaterializedViewDefinition.Column("test", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of(Duration.ZERO), Optional.empty(), Optional.of("owner"), (List)ImmutableList.of());
    }
}

