/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.file;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.local.LocalFileSystemFactory;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.hive.metastore.file.TestingFileHiveMetastore;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.catalog.file.FileMetastoreTableOperations;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.junit.jupiter.api.Test;

public class TestAbstractIcebergTableOperations {
    @Test
    public void testS3ErrorReporting() throws IOException {
        Path tempDir = Files.createTempDirectory("test_s3_error_reporting", new FileAttribute[0]);
        File metastoreDir = tempDir.resolve("iceberg_data").toFile();
        metastoreDir.mkdirs();
        LocalFileSystemFactory fileSystemFactory = new LocalFileSystemFactory(metastoreDir.toPath());
        FileHiveMetastore metastore = TestingFileHiveMetastore.createTestingFileHiveMetastore((TrinoFileSystemFactory)fileSystemFactory, (Location)Location.of((String)"local:///"));
        FileMetastoreTableOperations fileMetastoreTableOperations = new FileMetastoreTableOperations(this, (FileIO)new ForwardingFileIo(fileSystemFactory.create(TestingConnectorSession.SESSION)){

            public InputFile newInputFile(String path) {
                throw new UncheckedIOException(new IOException());
            }
        }, CachingHiveMetastore.createPerTransactionCache((HiveMetastore)metastore, (long)1000L), TestingConnectorSession.SESSION, "test-database", "test-table", Optional.of("test-owner"), Optional.empty()){

            protected String getRefreshedLocation(boolean invalidateCaches) {
                return "local:///0.metadata.json";
            }
        };
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> ((FileMetastoreTableOperations)fileMetastoreTableOperations).refresh()).hasErrorCode(new ErrorCodeSupplier[]{IcebergErrorCode.ICEBERG_INVALID_METADATA});
    }
}

