/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.file;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.Session;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.local.LocalFileSystemFactory;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.Table;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.metastore.HiveMetastoreConfig;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.hive.metastore.file.FileHiveMetastoreConfig;
import io.trino.plugin.iceberg.TestingIcebergPlugin;
import io.trino.plugin.iceberg.catalog.file.TestingIcebergFileMetastoreCatalogModule;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestIcebergFileMetastoreCreateTableFailure
extends AbstractTestQueryFramework {
    private static final String ICEBERG_CATALOG = "iceberg";
    private static final String SCHEMA_NAME = "test_schema";
    private Path dataDirectory;
    private HiveMetastore metastore;
    private final AtomicReference<RuntimeException> testException = new AtomicReference();

    protected DistributedQueryRunner createQueryRunner() throws Exception {
        this.dataDirectory = Files.createTempDirectory("test_iceberg_create_table_failure", new FileAttribute[0]);
        this.metastore = new FileHiveMetastore(new NodeVersion("testversion"), (TrinoFileSystemFactory)new LocalFileSystemFactory(Path.of(this.dataDirectory.toString(), new String[0])), new HiveMetastoreConfig().isHideDeltaLakeTables(), new FileHiveMetastoreConfig().setCatalogDirectory("local://")){

            public synchronized void createTable(Table table, PrincipalPrivileges principalPrivileges) {
                if (TestIcebergFileMetastoreCreateTableFailure.this.testException.get() != null) {
                    throw TestIcebergFileMetastoreCreateTableFailure.this.testException.get();
                }
            }
        };
        Session session = TestingSession.testSessionBuilder().setCatalog(ICEBERG_CATALOG).setSchema(SCHEMA_NAME).build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).build();
        queryRunner.installPlugin((Plugin)new TestingIcebergPlugin(Path.of(this.dataDirectory.toString(), new String[0]), Optional.of(new TestingIcebergFileMetastoreCatalogModule(this.metastore))));
        queryRunner.createCatalog(ICEBERG_CATALOG, ICEBERG_CATALOG);
        queryRunner.execute("CREATE SCHEMA test_schema");
        return queryRunner;
    }

    @AfterAll
    public void cleanup() throws Exception {
        if (this.metastore != null) {
            this.metastore.dropDatabase(SCHEMA_NAME, true);
        }
        if (this.dataDirectory != null) {
            MoreFiles.deleteRecursively((Path)this.dataDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }

    @Test
    public void testCreateTableFailureMetadataCleanedUp() {
        this.testException.set((RuntimeException)new SchemaNotFoundException("simulated_test_schema"));
        String tableName = "test_create_failure_" + TestingNames.randomNameSuffix();
        String tableLocation = "local:///" + tableName;
        String createTableSql = "CREATE TABLE " + tableName + " (a varchar) WITH (location = '" + tableLocation + "')";
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(createTableSql)).hasMessageContaining("Schema simulated_test_schema not found");
        Path metadataDirectory = this.dataDirectory.resolve(tableName, new String[]{"metadata"});
        ((AbstractPathAssert)Assertions.assertThat((Path)metadataDirectory).as("Metadata file should not exist", new Object[0])).isEmptyDirectory();
        this.testException.set(null);
        this.getQueryRunner().execute(createTableSql);
        ((AbstractPathAssert)Assertions.assertThat((Path)metadataDirectory).as("Metadata file should not exist", new Object[0])).isNotEmptyDirectory();
    }
}

