/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.file;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.log.Logger;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.local.LocalFileSystemFactory;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.TrinoViewHiveMetastore;
import io.trino.plugin.hive.metastore.file.TestingFileHiveMetastore;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.catalog.BaseTrinoCatalogTest;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.file.FileMetastoreTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.hms.TrinoHiveCatalog;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.TypeManager;
import io.trino.testing.TestingNames;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestTrinoHiveCatalogWithFileMetastore
extends BaseTrinoCatalogTest {
    private static final Logger log = Logger.get(TestTrinoHiveCatalogWithFileMetastore.class);
    private Path tempDir;
    private TrinoFileSystemFactory fileSystemFactory;
    private HiveMetastore metastore;

    @BeforeAll
    public void setUp() throws Exception {
        this.tempDir = Files.createTempDirectory("test_trino_hive_catalog", new FileAttribute[0]);
        File metastoreDir = this.tempDir.resolve("iceberg_data").toFile();
        metastoreDir.mkdirs();
        this.fileSystemFactory = new LocalFileSystemFactory(metastoreDir.toPath());
        this.metastore = TestingFileHiveMetastore.createTestingFileHiveMetastore((TrinoFileSystemFactory)this.fileSystemFactory, (Location)Location.of((String)"local:///"));
    }

    @AfterAll
    public void tearDown() throws IOException {
        MoreFiles.deleteRecursively((Path)this.tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Override
    protected TrinoCatalog createTrinoCatalog(boolean useUniqueTableLocations) {
        CachingHiveMetastore cachingHiveMetastore = CachingHiveMetastore.createPerTransactionCache((HiveMetastore)this.metastore, (long)1000L);
        return new TrinoHiveCatalog(new CatalogName("catalog"), cachingHiveMetastore, new TrinoViewHiveMetastore((HiveMetastore)cachingHiveMetastore, false, "trino-version", "test"), this.fileSystemFactory, (TypeManager)new TestingTypeManager(), (IcebergTableOperationsProvider)new FileMetastoreTableOperationsProvider(this.fileSystemFactory), useUniqueTableLocations, false, false, new IcebergConfig().isHideMaterializedViewStorageTable(), MoreExecutors.directExecutor());
    }

    @Test
    @Disabled
    public void testDropMaterializedView() {
        this.testDropMaterializedView(false);
    }

    @Test
    public void testDropMaterializedViewWithUniqueTableLocation() {
        this.testDropMaterializedView(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDropMaterializedView(boolean useUniqueTableLocations) {
        TrinoCatalog catalog = this.createTrinoCatalog(useUniqueTableLocations);
        String namespace = "test_create_mv_" + TestingNames.randomNameSuffix();
        String materializedViewName = "materialized_view_name";
        try {
            catalog.createNamespace(SESSION, namespace, this.defaultNamespaceProperties(namespace), new TrinoPrincipal(PrincipalType.USER, SESSION.getUser()));
            catalog.createMaterializedView(SESSION, new SchemaTableName(namespace, materializedViewName), new ConnectorMaterializedViewDefinition("SELECT * FROM tpch.tiny.nation", Optional.empty(), Optional.of("catalog_name"), Optional.of("schema_name"), (List)ImmutableList.of((Object)new ConnectorMaterializedViewDefinition.Column("col1", IntegerType.INTEGER.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of()), (Map)ImmutableMap.of((Object)"format", (Object)IcebergFileFormat.PARQUET, (Object)"format_version", (Object)1), false, false);
            catalog.dropMaterializedView(SESSION, new SchemaTableName(namespace, materializedViewName));
        }
        catch (Throwable throwable) {
            try {
                catalog.dropNamespace(SESSION, namespace);
            }
            catch (Exception e) {
                log.warn("Failed to clean up namespace: %s", new Object[]{namespace});
            }
            throw throwable;
        }
        try {
            catalog.dropNamespace(SESSION, namespace);
        }
        catch (Exception e) {
            log.warn("Failed to clean up namespace: %s", new Object[]{namespace});
        }
    }

    @Override
    @Test
    public void testListTables() {
        Assertions.assertThatThrownBy(() -> super.testListTables()).hasMessageMatching("Table 'ns2.*.mv' not found");
    }
}

