/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.file;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.units.Duration;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.RawHiveMetastoreFactory;
import io.trino.metastore.cache.CachingHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.CachingHiveMetastoreModule;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.file.FileMetastoreTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.hms.TrinoHiveCatalogFactory;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class TestingIcebergFileMetastoreCatalogModule
extends AbstractConfigurationAwareModule {
    private final HiveMetastore metastore;

    public TestingIcebergFileMetastoreCatalogModule(HiveMetastore metastore) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    protected void setup(Binder binder) {
        binder.bind(HiveMetastoreFactory.class).annotatedWith(RawHiveMetastoreFactory.class).toInstance((Object)HiveMetastoreFactory.ofInstance((HiveMetastore)this.metastore));
        this.install((Module)new CachingHiveMetastoreModule());
        binder.bind(IcebergTableOperationsProvider.class).to(FileMetastoreTableOperationsProvider.class).in(Scopes.SINGLETON);
        binder.bind(TrinoCatalogFactory.class).to(TrinoHiveCatalogFactory.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(CachingHiveMetastoreConfig.class, config -> config.setStatsCacheTtl(new Duration(0.0, TimeUnit.SECONDS)));
    }
}

