/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import io.airlift.log.Logger;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.trino.Session;
import io.trino.filesystem.tracing.FileSystemAttributes;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreMethod;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.iceberg.IcebergConnector;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.SchemaInitializer;
import io.trino.plugin.iceberg.TableType;
import io.trino.plugin.iceberg.util.FileOperationUtils;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestIcebergGlueCatalogAccessOperations
extends AbstractTestQueryFramework {
    private static final Logger log = Logger.get(TestIcebergGlueCatalogAccessOperations.class);
    private static final int MAX_PREFIXES_COUNT = 5;
    private final String testSchema = "test_schema_" + TestingNames.randomNameSuffix();
    private GlueMetastoreStats glueStats;

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = ((IcebergQueryRunner.Builder)IcebergQueryRunner.builder(this.testSchema).addCoordinatorProperty("optimizer.experimental-max-prefetched-information-schema-prefixes", Integer.toString(5))).addIcebergProperty("iceberg.catalog.type", "glue").addIcebergProperty("hive.metastore.glue.default-warehouse-dir", "local:///glue").setSchemaInitializer(SchemaInitializer.builder().withSchemaName(this.testSchema).build()).build();
        this.glueStats = (GlueMetastoreStats)((IcebergConnector)queryRunner.getCoordinator().getConnector("iceberg")).getInjector().getInstance(GlueMetastoreStats.class);
        return queryRunner;
    }

    @AfterAll
    public void cleanUpSchema() {
        this.getQueryRunner().execute("DROP SCHEMA " + this.testSchema);
    }

    @Test
    public void testUse() {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String schema = (String)this.getSession().getSchema().orElseThrow();
        Session session = Session.builder((Session)this.getSession()).setCatalog(Optional.empty()).setSchema(Optional.empty()).build();
        this.assertGlueMetastoreApiInvocations(session, "USE %s.%s".formatted(catalog, schema), (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_DATABASE).build());
    }

    @Test
    public void testCreateTable() {
        try {
            this.assertGlueMetastoreApiInvocations("CREATE TABLE test_create (id VARCHAR, age INT)", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.CREATE_TABLE).addCopies((Object)GlueMetastoreMethod.GET_DATABASE, 2).add((Object)GlueMetastoreMethod.GET_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_create");
        }
    }

    @Test
    public void testCreateTableAsSelect() {
        try {
            this.assertGlueMetastoreApiInvocations(TestIcebergGlueCatalogAccessOperations.withStatsOnWrite(this.getSession(), false), "CREATE TABLE test_ctas AS SELECT 1 AS age", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)GlueMetastoreMethod.GET_DATABASE, 2).add((Object)GlueMetastoreMethod.CREATE_TABLE).add((Object)GlueMetastoreMethod.GET_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_ctas");
        }
        try {
            this.assertGlueMetastoreApiInvocations(TestIcebergGlueCatalogAccessOperations.withStatsOnWrite(this.getSession(), true), "CREATE TABLE test_ctas_with_stats AS SELECT 1 AS age", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)GlueMetastoreMethod.GET_DATABASE, 2).add((Object)GlueMetastoreMethod.CREATE_TABLE).addCopies((Object)GlueMetastoreMethod.GET_TABLE, 5).add((Object)GlueMetastoreMethod.UPDATE_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_ctas_with_stats");
        }
    }

    @Test
    public void testSelect() {
        try {
            this.assertUpdate("CREATE TABLE test_select_from (id VARCHAR, age INT)");
            this.assertGlueMetastoreApiInvocations("SELECT * FROM test_select_from", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_from");
        }
    }

    @Test
    public void testSelectWithFilter() {
        try {
            this.assertUpdate("CREATE TABLE test_select_from_where AS SELECT 2 as age", 1L);
            this.assertGlueMetastoreApiInvocations("SELECT * FROM test_select_from_where WHERE age = 2", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_from_where");
        }
    }

    @Test
    public void testSelectFromView() {
        try {
            this.assertUpdate("CREATE TABLE test_select_view_table (id VARCHAR, age INT)");
            this.assertUpdate("CREATE VIEW test_select_view_view AS SELECT id, age FROM test_select_view_table");
            this.assertGlueMetastoreApiInvocations("SELECT * FROM test_select_view_view", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)GlueMetastoreMethod.GET_TABLE, 2).build());
        }
        finally {
            this.getQueryRunner().execute("DROP VIEW IF EXISTS test_select_view_view");
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_view_table");
        }
    }

    @Test
    public void testSelectFromViewWithFilter() {
        try {
            this.assertUpdate("CREATE TABLE test_select_view_where_table AS SELECT 2 as age", 1L);
            this.assertUpdate("CREATE VIEW test_select_view_where_view AS SELECT age FROM test_select_view_where_table");
            this.assertGlueMetastoreApiInvocations("SELECT * FROM test_select_view_where_view WHERE age = 2", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)GlueMetastoreMethod.GET_TABLE, 2).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_view_where_table");
            this.getQueryRunner().execute("DROP VIEW IF EXISTS test_select_view_where_view");
        }
    }

    @Test
    public void testSelectFromMaterializedView() {
        try {
            this.assertUpdate("CREATE TABLE test_select_mview_table (id VARCHAR, age INT)");
            this.assertUpdate("CREATE MATERIALIZED VIEW test_select_mview_view AS SELECT id, age FROM test_select_mview_table");
            this.assertGlueMetastoreApiInvocations("SELECT * FROM test_select_mview_view", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)GlueMetastoreMethod.GET_TABLE, 2).build());
        }
        finally {
            this.getQueryRunner().execute("DROP MATERIALIZED VIEW IF EXISTS test_select_mview_view");
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_mview_table");
        }
    }

    @Test
    public void testSelectFromMaterializedViewWithFilter() {
        try {
            this.assertUpdate("CREATE TABLE test_select_mview_where_table AS SELECT 2 as age", 1L);
            this.assertUpdate("CREATE MATERIALIZED VIEW test_select_mview_where_view AS SELECT age FROM test_select_mview_where_table");
            this.assertGlueMetastoreApiInvocations("SELECT * FROM test_select_mview_where_view WHERE age = 2", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)GlueMetastoreMethod.GET_TABLE, 2).build());
        }
        finally {
            this.getQueryRunner().execute("DROP MATERIALIZED VIEW IF EXISTS test_select_mview_where_view");
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_mview_where_table");
        }
    }

    @Test
    public void testRefreshMaterializedView() {
        try {
            this.assertUpdate("CREATE TABLE test_refresh_mview_table (id VARCHAR, age INT)");
            this.assertUpdate("CREATE MATERIALIZED VIEW test_refresh_mview_view AS SELECT id, age FROM test_refresh_mview_table");
            this.assertGlueMetastoreApiInvocations("REFRESH MATERIALIZED VIEW test_refresh_mview_view", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)GlueMetastoreMethod.GET_TABLE, 4).add((Object)GlueMetastoreMethod.UPDATE_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP MATERIALIZED VIEW IF EXISTS test_refresh_mview_view");
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_refresh_mview_table");
        }
    }

    @Test
    public void testMaterializedViewMetadata() {
        try {
            this.assertUpdate("CREATE TABLE test_mview_metadata_table (id VARCHAR, age INT)");
            this.assertUpdate("CREATE MATERIALIZED VIEW test_mview_metadata_view AS SELECT id, age FROM test_mview_metadata_table");
            this.assertGlueMetastoreApiInvocations("SELECT * FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLES).add((Object)GlueMetastoreMethod.GET_TABLE).build());
            this.assertGlueMetastoreApiInvocations("SELECT * FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA AND name = 'test_mview_metadata_view'", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
            this.assertGlueMetastoreApiInvocations("SELECT name FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLES).build());
            this.assertGlueMetastoreApiInvocations("SELECT table_name, IF(mv.name IS NOT NULL, 'MATERIALIZED VIEW', table_type) AS table_type\nFROM information_schema.tables t\nJOIN system.metadata.materialized_views mv ON t.table_schema = mv.schema_name AND t.table_name = mv.name\nWHERE t.table_schema = CURRENT_SCHEMA AND mv.catalog_name = CURRENT_CATALOG\n", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)GlueMetastoreMethod.GET_TABLES, 2).build());
        }
        finally {
            this.getQueryRunner().execute("DROP MATERIALIZED VIEW IF EXISTS test_mview_metadata_view");
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_mview_metadata_table");
        }
    }

    @Test
    public void testJoin() {
        try {
            this.assertUpdate("CREATE TABLE test_join_t1 AS SELECT 2 as age, 'id1' AS id", 1L);
            this.assertUpdate("CREATE TABLE test_join_t2 AS SELECT 'name1' as name, 'id1' AS id", 1L);
            this.assertGlueMetastoreApiInvocations("SELECT name, age FROM test_join_t1 JOIN test_join_t2 ON test_join_t2.id = test_join_t1.id", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)GlueMetastoreMethod.GET_TABLE, 2).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_join_t1");
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_join_t2");
        }
    }

    @Test
    public void testSelfJoin() {
        try {
            this.assertUpdate("CREATE TABLE test_self_join_table AS SELECT 2 as age, 0 parent, 3 AS id", 1L);
            this.assertGlueMetastoreApiInvocations("SELECT child.age, parent.age FROM test_self_join_table child JOIN test_self_join_table parent ON child.parent = parent.id", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_self_join_table");
        }
    }

    @Test
    public void testExplainSelect() {
        try {
            this.assertUpdate("CREATE TABLE test_explain AS SELECT 2 as age", 1L);
            this.assertGlueMetastoreApiInvocations("EXPLAIN SELECT * FROM test_explain", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_explain");
        }
    }

    @Test
    public void testShowStatsForTable() {
        try {
            this.assertUpdate("CREATE TABLE test_show_stats AS SELECT 2 as age", 1L);
            this.assertGlueMetastoreApiInvocations("SHOW STATS FOR test_show_stats", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_show_stats");
        }
    }

    @Test
    public void testShowStatsForTableWithFilter() {
        try {
            this.assertUpdate("CREATE TABLE test_show_stats_with_filter AS SELECT 2 as age", 1L);
            this.assertGlueMetastoreApiInvocations("SHOW STATS FOR (SELECT * FROM test_show_stats_with_filter where age >= 2)", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_show_stats_with_filter");
        }
    }

    @Test
    public void testSelectSystemTable() {
        try {
            this.assertUpdate("CREATE TABLE test_select_snapshots AS SELECT 2 AS age", 1L);
            this.assertGlueMetastoreApiInvocations("SELECT * FROM \"test_select_snapshots$history\"", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
            this.assertGlueMetastoreApiInvocations("SELECT * FROM \"test_select_snapshots$metadata_log_entries\"", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
            this.assertGlueMetastoreApiInvocations("SELECT * FROM \"test_select_snapshots$snapshots\"", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
            this.assertGlueMetastoreApiInvocations("SELECT * FROM \"test_select_snapshots$all_manifests\"", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
            this.assertGlueMetastoreApiInvocations("SELECT * FROM \"test_select_snapshots$manifests\"", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
            this.assertGlueMetastoreApiInvocations("SELECT * FROM \"test_select_snapshots$partitions\"", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
            this.assertGlueMetastoreApiInvocations("SELECT * FROM \"test_select_snapshots$files\"", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
            this.assertGlueMetastoreApiInvocations("SELECT * FROM \"test_select_snapshots$all_entries\"", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
            this.assertGlueMetastoreApiInvocations("SELECT * FROM \"test_select_snapshots$entries\"", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
            this.assertGlueMetastoreApiInvocations("SELECT * FROM \"test_select_snapshots$properties\"", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
            this.assertGlueMetastoreApiInvocations("SELECT * FROM \"test_select_snapshots$refs\"", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build());
            this.assertQueryFails("SELECT * FROM \"test_select_snapshots$materialized_view_storage\"", "Table '" + this.testSchema + ".test_select_snapshots\\$materialized_view_storage' not found");
            Assertions.assertThat((Object[])TableType.values()).containsExactly((Object[])new TableType[]{TableType.DATA, TableType.HISTORY, TableType.METADATA_LOG_ENTRIES, TableType.SNAPSHOTS, TableType.ALL_MANIFESTS, TableType.MANIFESTS, TableType.PARTITIONS, TableType.FILES, TableType.ALL_ENTRIES, TableType.ENTRIES, TableType.PROPERTIES, TableType.REFS, TableType.MATERIALIZED_VIEW_STORAGE});
        }
        finally {
            this.getQueryRunner().execute("DROP TABLE IF EXISTS test_select_snapshots");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInformationSchemaTableAndColumns() {
        String schemaName = "test_i_s_columns_schema" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        try {
            Session session = Session.builder((Session)this.getSession()).setSchema(schemaName).build();
            int tablesCreated = 0;
            try {
                for (int tables : List.of(Integer.valueOf(2), Integer.valueOf(5), Integer.valueOf(7))) {
                    log.info("testInformationSchemaColumns: Testing with %s tables", new Object[]{tables});
                    Preconditions.checkState((tablesCreated < tables ? 1 : 0) != 0);
                    for (int i = tablesCreated; i < tables; ++i) {
                        ++tablesCreated;
                        this.assertUpdate(session, "CREATE TABLE test_select_i_s_columns" + i + "(id varchar, age integer)");
                        this.assertUpdate(session, "INSERT INTO test_select_i_s_columns" + i + " VALUES ('abc', 11)", 1L);
                        this.assertUpdate(session, "INSERT INTO test_select_i_s_columns" + i + " VALUES ('xyz', 12)", 1L);
                        this.assertUpdate(session, "CREATE TABLE test_other_select_i_s_columns" + i + "(id varchar, age integer)");
                    }
                    this.assertInvocations(session, "SELECT * FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name LIKE 'test_select_i_s_columns%'", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLES).build(), (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.of());
                }
                this.assertInvocations(session, "SELECT * FROM information_schema.tables WHERE table_schema = CURRENT_SCHEMA", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLES).build(), (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.of());
                this.assertInvocations(session, "SELECT * FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name = 'test_select_i_s_columns0'", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build(), (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newInput")).build());
                this.assertInvocations(session, "DESCRIBE test_select_i_s_columns1", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_DATABASE).add((Object)GlueMetastoreMethod.GET_TABLE).build(), (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newInput")).build());
            }
            finally {
                for (int i = 0; i < tablesCreated; ++i) {
                    this.assertUpdate(session, "DROP TABLE IF EXISTS test_select_i_s_columns" + i);
                    this.assertUpdate(session, "DROP TABLE IF EXISTS test_other_select_i_s_columns" + i);
                }
            }
        }
        finally {
            this.assertUpdate("DROP SCHEMA " + schemaName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSystemMetadataTableComments() {
        String schemaName = "test_s_m_table_comments" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        try {
            Session session = Session.builder((Session)this.getSession()).setSchema(schemaName).build();
            int tablesCreated = 0;
            try {
                for (int tables : List.of(Integer.valueOf(2), Integer.valueOf(5), Integer.valueOf(7))) {
                    log.info("testSystemMetadataTableComments: Testing with %s tables", new Object[]{tables});
                    Preconditions.checkState((tablesCreated < tables ? 1 : 0) != 0);
                    for (int i = tablesCreated; i < tables; ++i) {
                        ++tablesCreated;
                        this.assertUpdate(session, "CREATE TABLE test_select_s_m_t_comments" + i + "(id varchar, age integer)");
                        this.assertUpdate(session, "INSERT INTO test_select_s_m_t_comments" + i + " VALUES ('abc', 11)", 1L);
                        this.assertUpdate(session, "INSERT INTO test_select_s_m_t_comments" + i + " VALUES ('xyz', 12)", 1L);
                        this.assertUpdate(session, "CREATE TABLE test_other_select_s_m_t_comments" + i + "(id varchar, age integer)");
                    }
                    this.assertInvocations(session, "SELECT * FROM system.metadata.table_comments WHERE schema_name = CURRENT_SCHEMA AND table_name LIKE 'test_select_s_m_t_comments%'", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLES).build(), (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.of());
                }
                this.assertInvocations(session, "SELECT * FROM system.metadata.table_comments WHERE schema_name = CURRENT_SCHEMA AND table_name = 'test_select_s_m_t_comments0'", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_TABLE).build(), (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newInput")).build());
            }
            finally {
                for (int i = 0; i < tablesCreated; ++i) {
                    this.assertUpdate(session, "DROP TABLE IF EXISTS test_select_s_m_t_comments" + i);
                    this.assertUpdate(session, "DROP TABLE IF EXISTS test_other_select_s_m_t_comments" + i);
                }
            }
        }
        finally {
            this.assertUpdate("DROP SCHEMA " + schemaName);
        }
    }

    @Test
    public void testShowTables() {
        this.assertGlueMetastoreApiInvocations("SHOW TABLES", (Multiset<GlueMetastoreMethod>)ImmutableMultiset.builder().add((Object)GlueMetastoreMethod.GET_DATABASE).add((Object)GlueMetastoreMethod.GET_TABLES).build());
    }

    private void assertGlueMetastoreApiInvocations(@Language(value="SQL") String query, Multiset<GlueMetastoreMethod> expectedInvocations) {
        this.assertGlueMetastoreApiInvocations(this.getSession(), query, expectedInvocations);
    }

    private void assertGlueMetastoreApiInvocations(Session session, @Language(value="SQL") String query, Multiset<GlueMetastoreMethod> expectedInvocations) {
        this.assertInvocations(session, query, expectedInvocations, Optional.empty());
    }

    private void assertInvocations(Session session, @Language(value="SQL") String query, Multiset<GlueMetastoreMethod> expectedGlueInvocations, Multiset<FileOperationUtils.FileOperation> expectedFileOperations) {
        this.assertInvocations(session, query, expectedGlueInvocations, Optional.of(expectedFileOperations));
    }

    private void assertInvocations(Session session, @Language(value="SQL") String query, Multiset<GlueMetastoreMethod> expectedGlueInvocations, Optional<Multiset<FileOperationUtils.FileOperation>> expectedFileOperations) {
        Map countsBefore = (Map)Arrays.stream(GlueMetastoreMethod.values()).collect(ImmutableMap.toImmutableMap(Function.identity(), method -> method.getInvocationCount(this.glueStats)));
        this.getQueryRunner().execute(session, query);
        List spans = this.getQueryRunner().getSpans();
        Map countsAfter = (Map)Arrays.stream(GlueMetastoreMethod.values()).collect(ImmutableMap.toImmutableMap(Function.identity(), method -> method.getInvocationCount(this.glueStats)));
        Multiset<FileOperationUtils.FileOperation> fileOperations = this.getFileOperations(spans);
        Multiset actualGlueInvocations = (Multiset)Arrays.stream(GlueMetastoreMethod.values()).collect(ImmutableMultiset.toImmutableMultiset(Function.identity(), method -> Objects.requireNonNull((Integer)countsAfter.get(method)) - Objects.requireNonNull((Integer)countsBefore.get(method))));
        MultisetAssertions.assertMultisetsEqual((Multiset)actualGlueInvocations, expectedGlueInvocations);
        expectedFileOperations.ifPresent(expected -> MultisetAssertions.assertMultisetsEqual((Multiset)fileOperations, (Multiset)expected));
    }

    private Multiset<FileOperationUtils.FileOperation> getFileOperations(List<SpanData> spans) {
        return (Multiset)spans.stream().filter(span -> span.getName().startsWith("InputFile.")).map(span -> new FileOperationUtils.FileOperation(FileOperationUtils.FileType.fromFilePath((String)span.getAttributes().get(FileSystemAttributes.FILE_LOCATION)), span.getName())).collect(Collectors.toCollection(HashMultiset::create));
    }

    private static Session withStatsOnWrite(Session session, boolean enabled) {
        String catalog = (String)session.getCatalog().orElseThrow();
        return Session.builder((Session)session).setCatalogSessionProperty(catalog, "collect_extended_statistics_on_write", Boolean.toString(enabled)).build();
    }
}

