/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.hdfs.DynamicHdfsConfiguration;
import io.trino.hdfs.HdfsConfig;
import io.trino.hdfs.HdfsConfiguration;
import io.trino.hdfs.HdfsConfigurationInitializer;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hdfs.TrinoHdfsFileSystemStats;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.hdfs.authentication.NoHdfsAuthentication;
import io.trino.plugin.hive.metastore.glue.GlueConverter;
import io.trino.plugin.iceberg.BaseIcebergConnectorSmokeTest;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.SchemaInitializer;
import io.trino.testing.QueryRunner;
import io.trino.testing.SystemEnvironmentUtils;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingNames;
import io.trino.testing.sql.TestTable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iceberg.FileFormat;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.S3Object;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIcebergGlueCatalogConnectorSmokeTest
extends BaseIcebergConnectorSmokeTest {
    private final String bucketName = SystemEnvironmentUtils.requireEnv((String)"S3_BUCKET");
    private final String schemaName = "test_iceberg_smoke_" + TestingNames.randomNameSuffix();
    private final GlueClient glueClient = GlueClient.create();
    private final TrinoFileSystemFactory fileSystemFactory;

    public TestIcebergGlueCatalogConnectorSmokeTest() {
        super(FileFormat.PARQUET);
        HdfsConfigurationInitializer initializer = new HdfsConfigurationInitializer(new HdfsConfig(), (Set)ImmutableSet.of());
        DynamicHdfsConfiguration hdfsConfiguration = new DynamicHdfsConfiguration(initializer, (Set)ImmutableSet.of());
        this.fileSystemFactory = new HdfsFileSystemFactory(new HdfsEnvironment((HdfsConfiguration)hdfsConfiguration, new HdfsConfig(), (HdfsAuthentication)new NoHdfsAuthentication()), new TrinoHdfsFileSystemStats());
    }

    protected QueryRunner createQueryRunner() throws Exception {
        return IcebergQueryRunner.builder().setIcebergProperties((Map<String, String>)ImmutableMap.of((Object)"iceberg.file-format", (Object)this.format.name(), (Object)"iceberg.catalog.type", (Object)"glue", (Object)"hive.metastore.glue.default-warehouse-dir", (Object)this.schemaPath(), (Object)"iceberg.register-table-procedure.enabled", (Object)"true", (Object)"iceberg.writer-sort-buffer-size", (Object)"1MB", (Object)"iceberg.allowed-extra-properties", (Object)"write.metadata.delete-after-commit.enabled,write.metadata.previous-versions-max")).setSchemaInitializer(SchemaInitializer.builder().withClonedTpchTables(REQUIRED_TPCH_TABLES).withSchemaName(this.schemaName).build()).build();
    }

    @AfterAll
    public void cleanup() {
        this.computeActual("SHOW TABLES").getMaterializedRows().forEach(table -> this.getQueryRunner().execute("DROP TABLE " + String.valueOf(table.getField(0))));
        this.getQueryRunner().execute("DROP SCHEMA IF EXISTS " + this.schemaName);
        this.deleteDirectory(this.schemaPath());
    }

    @Override
    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE region"))).matches((CharSequence)String.format("\\QCREATE TABLE iceberg.%1$s.region (\n   regionkey bigint,\n   name varchar,\n   comment varchar\n)\nWITH (\n   format = 'PARQUET',\n   format_version = 2,\n   location = '%2$s/%1$s.db/region-\\E.*\\Q',\n   max_commit_retry = 4\n)\\E", this.schemaName, this.schemaPath()));
    }

    @Test
    public void testRenameSchema() {
        Assertions.assertThatThrownBy(() -> super.testRenameSchema()).hasStackTraceContaining("renameNamespace is not supported for Iceberg Glue catalogs");
    }

    @Test
    void testGlueTableLocation() {
        try (TestTable table = this.newTrinoTable("test_table_location", "AS SELECT 1 x");){
            String initialLocation = TestIcebergGlueCatalogConnectorSmokeTest.getStorageDescriptor(this.getGlueTable(table.getName())).location();
            Assertions.assertThat((String)TestIcebergGlueCatalogConnectorSmokeTest.getStorageDescriptor(this.getGlueTable(table.getName())).location()).startsWith((CharSequence)"%s/%s.db/%s".formatted(this.schemaPath(), this.schemaName, table.getName()));
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 2", 1L);
            Table glueTable = this.getGlueTable(table.getName());
            Assertions.assertThat((String)TestIcebergGlueCatalogConnectorSmokeTest.getStorageDescriptor(glueTable).location()).isEqualTo(initialLocation);
            String newTableLocation = initialLocation + "_new";
            this.updateTableLocation(glueTable, newTableLocation);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 3", 1L);
            Assertions.assertThat((String)TestIcebergGlueCatalogConnectorSmokeTest.getStorageDescriptor(this.getGlueTable(table.getName())).location()).isEqualTo(newTableLocation);
            this.assertUpdate("CALL system.unregister_table(CURRENT_SCHEMA, '" + table.getName() + "')");
            this.assertUpdate("CALL system.register_table(CURRENT_SCHEMA, '" + table.getName() + "', '" + initialLocation + "')");
            Assertions.assertThat((String)TestIcebergGlueCatalogConnectorSmokeTest.getStorageDescriptor(this.getGlueTable(table.getName())).location()).isEqualTo(initialLocation);
        }
    }

    private Table getGlueTable(String tableName) {
        return this.glueClient.getTable(x -> x.databaseName(this.schemaName).name(tableName)).table();
    }

    private void updateTableLocation(Table table, String newLocation) {
        this.glueClient.updateTable(update -> update.databaseName(this.schemaName).tableInput(input -> input.name(table.name()).tableType(GlueConverter.getTableTypeNullable((Table)table)).storageDescriptor((StorageDescriptor)TestIcebergGlueCatalogConnectorSmokeTest.getStorageDescriptor(table).toBuilder().location(newLocation).build()).parameters(table.parameters())));
    }

    @Override
    protected void dropTableFromMetastore(String tableName) {
        this.glueClient.deleteTable(x -> x.databaseName(this.schemaName).name(tableName));
        Assertions.assertThatThrownBy(() -> this.getGlueTable(tableName)).isInstanceOf(EntityNotFoundException.class);
    }

    @Override
    protected String getMetadataLocation(String tableName) {
        return (String)this.getGlueTable(tableName).parameters().get("metadata_location");
    }

    @Override
    protected void deleteDirectory(String location) {
        try (S3Client s3 = S3Client.create();){
            ListObjectsV2Request listObjectsRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucketName).prefix(location).build();
            s3.listObjectsV2Paginator(listObjectsRequest).stream().forEach(listObjectsResponse -> {
                List keys = (List)listObjectsResponse.contents().stream().map(S3Object::key).collect(ImmutableList.toImmutableList());
                if (!keys.isEmpty()) {
                    DeleteObjectsRequest deleteObjectsRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(this.bucketName).delete(builder -> builder.objects(keys.stream().map(key -> (ObjectIdentifier)ObjectIdentifier.builder().key(key).build()).toList()).quiet(Boolean.valueOf(true))).build();
                    s3.deleteObjects(deleteObjectsRequest);
                }
            });
            Assertions.assertThat((List)s3.listObjects((ListObjectsRequest)ListObjectsRequest.builder().bucket(this.bucketName).prefix(location).build()).contents()).isEmpty();
        }
    }

    @Override
    protected boolean isFileSorted(Location path, String sortColumnName) {
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(TestingConnectorSession.SESSION);
        return IcebergTestUtils.checkParquetFileSorting(fileSystem.newInputFile(path), sortColumnName);
    }

    @Override
    protected String schemaPath() {
        return String.format("s3://%s/%s", this.bucketName, this.schemaName);
    }

    @Override
    protected boolean locationExists(String location) {
        try (S3Client s3 = S3Client.create();){
            ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucketName).prefix(location).maxKeys(Integer.valueOf(1)).build();
            boolean bl = !s3.listObjectsV2(request).contents().isEmpty();
            return bl;
        }
    }

    private static StorageDescriptor getStorageDescriptor(Table table) {
        return Objects.requireNonNull(table.storageDescriptor());
    }
}

