/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.iceberg.BaseIcebergMaterializedViewTest;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.SchemaInitializer;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.tpch.TpchTable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.AfterAll;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetTablesResponse;
import software.amazon.awssdk.services.glue.model.Table;

public class TestIcebergGlueCatalogMaterializedView
extends BaseIcebergMaterializedViewTest {
    private final String schemaName = "test_iceberg_materialized_view_" + TestingNames.randomNameSuffix();
    private File schemaDirectory;

    protected QueryRunner createQueryRunner() throws Exception {
        this.schemaDirectory = Files.createTempDirectory("test_iceberg", new FileAttribute[0]).toFile();
        this.schemaDirectory.deleteOnExit();
        DistributedQueryRunner queryRunner = IcebergQueryRunner.builder().setIcebergProperties((Map<String, String>)ImmutableMap.of((Object)"iceberg.catalog.type", (Object)"glue", (Object)"hive.metastore.glue.default-warehouse-dir", (Object)this.schemaDirectory.getAbsolutePath(), (Object)"fs.hadoop.enabled", (Object)"true")).setSchemaInitializer(SchemaInitializer.builder().withClonedTpchTables((Iterable<TpchTable<?>>)ImmutableList.of()).withSchemaName(this.schemaName).build()).build();
        try {
            queryRunner.createCatalog("iceberg_legacy_mv", "iceberg", Map.of("iceberg.catalog.type", "glue", "hive.metastore.glue.default-warehouse-dir", this.schemaDirectory.getAbsolutePath(), "iceberg.materialized-views.hide-storage-table", "false", "fs.hadoop.enabled", "true"));
            queryRunner.installPlugin((Plugin)TestIcebergGlueCatalogMaterializedView.createMockConnectorPlugin());
            queryRunner.createCatalog("mock", "mock");
            return queryRunner;
        }
        catch (Throwable e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
    }

    @Override
    protected String getSchemaDirectory() {
        return new File(this.schemaDirectory, this.schemaName + ".db").getPath();
    }

    @Override
    protected String getStorageMetadataLocation(String materializedViewName) {
        return (String)GlueClient.create().getTable(x -> x.databaseName(this.schemaName).name(materializedViewName)).table().parameters().get("metadata_location");
    }

    @AfterAll
    public void cleanup() {
        TestIcebergGlueCatalogMaterializedView.cleanUpSchema(this.schemaName);
    }

    private static void cleanUpSchema(String schema) {
        GlueClient glueClient = GlueClient.create();
        Set tableNames = (Set)glueClient.getTablesPaginator(x -> x.databaseName(schema)).stream().map(GetTablesResponse::tableList).flatMap(Collection::stream).map(Table::name).collect(ImmutableSet.toImmutableSet());
        glueClient.batchDeleteTable(x -> x.databaseName(schema).tablesToDelete((Collection)tableNames));
        glueClient.deleteDatabase(x -> x.name(schema));
    }
}

