/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.SchemaInitializer;
import io.trino.plugin.iceberg.catalog.glue.GlueIcebergUtil;
import io.trino.plugin.iceberg.catalog.glue.IcebergGlueCatalogConfig;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.type.TypeManager;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingNames;
import io.trino.testing.sql.TestTable;
import io.trino.type.InternalTypeManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetTableVersionsResponse;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.model.TableInput;
import software.amazon.awssdk.services.glue.model.TableVersion;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIcebergGlueCatalogSkipArchive
extends AbstractTestQueryFramework {
    private final String schemaName = "test_iceberg_skip_archive_" + TestingNames.randomNameSuffix();
    private GlueClient glueClient;

    protected QueryRunner createQueryRunner() throws Exception {
        this.glueClient = GlueClient.create();
        File schemaDirectory = Files.createTempDirectory("test_iceberg", new FileAttribute[0]).toFile();
        schemaDirectory.deleteOnExit();
        return IcebergQueryRunner.builder().setIcebergProperties((Map<String, String>)ImmutableMap.builder().put((Object)"iceberg.catalog.type", (Object)"glue").put((Object)"hive.metastore.glue.default-warehouse-dir", (Object)schemaDirectory.getAbsolutePath()).buildOrThrow()).setSchemaInitializer(SchemaInitializer.builder().withSchemaName(this.schemaName).build()).build();
    }

    @AfterAll
    public void cleanup() {
        this.assertUpdate("DROP SCHEMA IF EXISTS " + this.schemaName);
    }

    @Test
    public void testSkipArchive() {
        try (TestTable table = this.newTrinoTable("test_skip_archive", "(col int)");){
            List<TableVersion> tableVersionsBeforeInsert = this.getTableVersions(this.schemaName, table.getName());
            Assertions.assertThat(tableVersionsBeforeInsert).hasSize(1);
            String versionIdBeforeInsert = ((TableVersion)Iterables.getOnlyElement(tableVersionsBeforeInsert)).versionId();
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 1", 1L);
            List<TableVersion> tableVersionsAfterInsert = this.getTableVersions(this.schemaName, table.getName());
            Assertions.assertThat(tableVersionsAfterInsert).hasSize(1);
            String versionIdAfterInsert = ((TableVersion)Iterables.getOnlyElement(tableVersionsAfterInsert)).versionId();
            Assertions.assertThat((String)versionIdBeforeInsert).isNotEqualTo((Object)versionIdAfterInsert);
        }
    }

    @Test
    public void testNotRemoveExistingArchive() {
        try (TestTable table = this.newTrinoTable("test_remove_archive", "(col int)");){
            List<TableVersion> tableVersionsBeforeInsert = this.getTableVersions(this.schemaName, table.getName());
            Assertions.assertThat(tableVersionsBeforeInsert).hasSize(1);
            TableVersion initialVersion = (TableVersion)Iterables.getOnlyElement(tableVersionsBeforeInsert);
            Table glueTable = this.glueClient.getTable(builder -> builder.databaseName(this.schemaName).name(table.getName())).table();
            HashMap tableParameters = new HashMap(glueTable.parameters());
            String metadataLocation = (String)tableParameters.remove("metadata_location");
            ForwardingFileIo io = new ForwardingFileIo(IcebergTestUtils.getFileSystemFactory((QueryRunner)this.getDistributedQueryRunner()).create(TestingConnectorSession.SESSION));
            TableMetadata metadata = TableMetadataParser.read((FileIO)io, (InputFile)io.newInputFile(metadataLocation));
            boolean cacheTableMetadata = new IcebergGlueCatalogConfig().isCacheTableMetadata();
            TableInput tableInput = GlueIcebergUtil.getTableInput((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (String)table.getName(), Optional.empty(), (TableMetadata)metadata, (String)metadata.location(), (String)metadataLocation, tableParameters, (boolean)cacheTableMetadata);
            this.glueClient.updateTable(builder -> builder.databaseName(this.schemaName).tableInput(tableInput));
            Assertions.assertThat(this.getTableVersions(this.schemaName, table.getName())).hasSize(2);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 1", 1L);
            List<TableVersion> tableVersionsAfterInsert = this.getTableVersions(this.schemaName, table.getName());
            ((ListAssert)Assertions.assertThat(tableVersionsAfterInsert).hasSize(2)).contains((Object[])new TableVersion[]{initialVersion});
        }
    }

    private List<TableVersion> getTableVersions(String databaseName, String tableName) {
        return this.glueClient.getTableVersionsPaginator(x -> x.databaseName(databaseName).tableName(tableName)).stream().map(GetTableVersionsResponse::tableVersions).flatMap(Collection::stream).toList();
    }
}

