/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.ProvidesIntoSet;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.execution.Failure;
import io.trino.metastore.Database;
import io.trino.plugin.hive.metastore.glue.ForGlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.TestingGlueHiveMetastore;
import io.trino.plugin.iceberg.TestingIcebergPlugin;
import io.trino.plugin.iceberg.catalog.IcebergCatalogModule;
import io.trino.spi.Plugin;
import io.trino.spi.security.PrincipalType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryFailedException;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.glue.model.UpdateTableRequest;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIcebergGlueTableOperationsInsertFailure
extends AbstractTestQueryFramework {
    private static final Logger LOG = Logger.get(TestIcebergGlueTableOperationsInsertFailure.class);
    private static final String ICEBERG_CATALOG = "iceberg";
    private final String schemaName = "test_iceberg_glue_" + TestingNames.randomNameSuffix();
    private GlueHiveMetastore glueHiveMetastore;

    protected QueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().setCatalog(ICEBERG_CATALOG).setSchema(this.schemaName).build();
        StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(session);
        Path dataDirectory = Files.createTempDirectory("iceberg_data", new FileAttribute[0]);
        dataDirectory.toFile().deleteOnExit();
        queryRunner.installPlugin((Plugin)new TestingIcebergPlugin(dataDirectory, Optional.of(new TestingGlueCatalogModule())));
        queryRunner.createCatalog(ICEBERG_CATALOG, ICEBERG_CATALOG, (Map)ImmutableMap.builder().put((Object)"iceberg.catalog.type", (Object)"glue").put((Object)"fs.hadoop.enabled", (Object)"true").buildOrThrow());
        TestIcebergGlueTableOperationsInsertFailure testIcebergGlueTableOperationsInsertFailure = this;
        this.glueHiveMetastore = TestingGlueHiveMetastore.createTestingGlueHiveMetastore((Path)dataDirectory, x$0 -> testIcebergGlueTableOperationsInsertFailure.closeAfterClass((AutoCloseable)x$0));
        Database database = Database.builder().setDatabaseName(this.schemaName).setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).setLocation(Optional.of(dataDirectory.toString())).build();
        this.glueHiveMetastore.createDatabase(database);
        return queryRunner;
    }

    @AfterAll
    public void cleanup() {
        try {
            if (this.glueHiveMetastore != null) {
                this.glueHiveMetastore.dropDatabase(this.schemaName, false);
                this.glueHiveMetastore.shutdown();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Failed to clean up Glue database: %s", new Object[]{this.schemaName});
        }
    }

    @Test
    public void testInsertFailureDoesNotCorruptTheTableMetadata() {
        String tableName = "test_insert_failure" + TestingNames.randomNameSuffix();
        this.getQueryRunner().execute(String.format("CREATE TABLE %s (a_varchar) AS VALUES ('Trino')", tableName));
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES 'rocks'")).satisfies(new ThrowingConsumer[]{throwable -> {
            Assertions.assertThat((Throwable)throwable).isInstanceOf(QueryFailedException.class);
            Assertions.assertThat((Throwable)throwable.getCause()).isInstanceOf(Failure.class);
            Failure failure = (Failure)throwable.getCause();
            Assertions.assertThat((String)failure.getMessage()).contains(new CharSequence[]{"Test-simulated Glue timeout exception"});
            Assertions.assertThat((String)failure.getFailureInfo().getType()).isEqualTo("io.trino.spi.TrinoException");
        }});
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 'Trino', 'rocks'");
    }

    private static class TestingGlueCatalogModule
    extends AbstractConfigurationAwareModule {
        private TestingGlueCatalogModule() {
        }

        protected void setup(Binder binder) {
            this.install((Module)new IcebergCatalogModule());
        }

        @ProvidesIntoSet
        @ForGlueHiveMetastore
        public ExecutionInterceptor createExecutionInterceptor() {
            return new ExecutionInterceptor(this){

                public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
                    if (context.request() instanceof UpdateTableRequest) {
                        throw new RuntimeException("Test-simulated Glue timeout exception");
                    }
                }
            };
        }
    }
}

