/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.base.util.UncheckedCloseable;
import io.trino.plugin.hive.BaseS3AndGlueMetastoreTest;
import io.trino.plugin.hive.metastore.glue.TestingGlueHiveMetastore;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.SchemaInitializer;
import io.trino.testing.QueryRunner;
import io.trino.testing.SystemEnvironmentUtils;
import io.trino.testing.TestingNames;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIcebergS3AndGlueMetastoreTest
extends BaseS3AndGlueMetastoreTest {
    public TestIcebergS3AndGlueMetastoreTest() {
        super("partitioning", "location", SystemEnvironmentUtils.requireEnv((String)"S3_BUCKET"));
    }

    protected QueryRunner createQueryRunner() throws Exception {
        TestIcebergS3AndGlueMetastoreTest testIcebergS3AndGlueMetastoreTest = this;
        this.metastore = TestingGlueHiveMetastore.createTestingGlueHiveMetastore((URI)URI.create(this.schemaPath()), x$0 -> testIcebergS3AndGlueMetastoreTest.closeAfterClass((AutoCloseable)x$0));
        return IcebergQueryRunner.builder().setIcebergProperties((Map<String, String>)ImmutableMap.builder().put((Object)"iceberg.catalog.type", (Object)"glue").put((Object)"hive.metastore.glue.default-warehouse-dir", (Object)this.schemaPath()).put((Object)"fs.native-s3.enabled", (Object)"true").buildOrThrow()).setSchemaInitializer(SchemaInitializer.builder().withSchemaName(this.schemaName).withSchemaProperties(Map.of("location", "'" + this.schemaPath() + "'")).build()).build();
    }

    protected void validateDataFiles(String partitionColumn, String tableName, String location) {
        this.getActiveFiles(tableName).forEach(dataFile -> {
            Object locationDirectory = location.endsWith("/") ? location : location + "/";
            Object partitionPart = partitionColumn.isEmpty() ? "" : partitionColumn + "=[a-z0-9]+/";
            Assertions.assertThat((String)dataFile).matches((CharSequence)("^" + Pattern.quote((String)locationDirectory) + "data/" + (String)partitionPart + "[a-zA-Z0-9_-]+.(orc|parquet)$"));
            this.verifyPathExist((String)dataFile);
        });
    }

    protected void validateMetadataFiles(String location) {
        this.getAllMetadataDataFilesFromTableDirectory(location).forEach(metadataFile -> {
            Object locationDirectory = location.endsWith("/") ? location : location + "/";
            Assertions.assertThat((String)metadataFile).matches((CharSequence)("^" + Pattern.quote((String)locationDirectory) + "metadata/[a-zA-Z0-9_-]+.(avro|metadata.json|stats)$"));
            this.verifyPathExist((String)metadataFile);
        });
    }

    protected String validateTableLocation(String tableName, String expectedLocation) {
        if (expectedLocation.endsWith("/")) {
            expectedLocation = expectedLocation.replaceFirst("/+$", "");
        }
        String actualTableLocation = this.getTableLocation(tableName);
        Assertions.assertThat((String)actualTableLocation).isEqualTo(expectedLocation);
        return actualTableLocation;
    }

    private Set<String> getAllMetadataDataFilesFromTableDirectory(String tableLocation) {
        return this.getTableFiles(tableLocation).stream().filter(path -> path.contains("/metadata")).collect(Collectors.toUnmodifiableSet());
    }

    protected Set<String> getAllDataFilesFromTableDirectory(String tableLocation) {
        return this.getTableFiles(tableLocation).stream().filter(path -> path.contains("/data")).collect(Collectors.toUnmodifiableSet());
    }

    @Test
    public void testAnalyzeWithProvidedTableLocation() {
        for (BaseS3AndGlueMetastoreTest.LocationPattern locationPattern : BaseS3AndGlueMetastoreTest.LocationPattern.values()) {
            this.testAnalyzeWithProvidedTableLocation(false, locationPattern);
            this.testAnalyzeWithProvidedTableLocation(true, locationPattern);
        }
    }

    private void testAnalyzeWithProvidedTableLocation(boolean partitioned, BaseS3AndGlueMetastoreTest.LocationPattern locationPattern) {
        String tableName = "test_analyze_" + TestingNames.randomNameSuffix();
        String location = locationPattern.locationForTable(this.bucketName, this.schemaName, tableName);
        String partitionQueryPart = partitioned ? ",partitioning = ARRAY['col_str']" : "";
        this.assertUpdate("CREATE TABLE " + tableName + "(col_str, col_int)WITH (location = '" + location + "'" + partitionQueryPart + ") AS VALUES ('str1', 1), ('str2', 2), ('str3', 3)", 3L);
        try (UncheckedCloseable ignored = this.onClose("DROP TABLE " + tableName);){
            this.assertUpdate("INSERT INTO " + tableName + " VALUES ('str4', 4)", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('str2', 2), ('str3', 3), ('str4', 4)");
            String expectedStatistics = "VALUES\n('col_str', %s, 4.0, 0.0, null, null, null),\n('col_int', null, 4.0, 0.0, null, 1, 4),\n(null, null, null, null, 4.0, null, null)".formatted(partitioned ? "432.0" : "243.0");
            this.assertQuery("SHOW STATS FOR " + tableName, expectedStatistics);
            this.assertUpdate("ALTER TABLE " + tableName + " EXECUTE DROP_EXTENDED_STATS");
            this.assertUpdate("ANALYZE " + tableName);
            this.assertQuery("SHOW STATS FOR " + tableName, expectedStatistics);
        }
    }
}

