/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.TestingGlueHiveMetastore;
import io.trino.plugin.iceberg.BaseSharedMetastoreTest;
import io.trino.plugin.iceberg.IcebergPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tpch.TpchTable;
import java.nio.file.Path;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestSharedGlueMetastore
extends BaseSharedMetastoreTest {
    private static final Logger LOG = Logger.get(TestSharedGlueMetastore.class);
    private static final String HIVE_CATALOG = "hive";
    private Path dataDirectory;
    private GlueHiveMetastore glueMetastore;

    protected QueryRunner createQueryRunner() throws Exception {
        Session icebergSession = TestingSession.testSessionBuilder().setCatalog("iceberg").setSchema(this.tpchSchema).build();
        Session hiveSession = TestingSession.testSessionBuilder().setCatalog(HIVE_CATALOG).setSchema(this.tpchSchema).build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)icebergSession).build();
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog("tpch", "tpch");
        this.dataDirectory = queryRunner.getCoordinator().getBaseDataDir().resolve("iceberg_data");
        this.dataDirectory.toFile().deleteOnExit();
        queryRunner.installPlugin((Plugin)new IcebergPlugin());
        queryRunner.createCatalog("iceberg", "iceberg", (Map)ImmutableMap.of((Object)"iceberg.catalog.type", (Object)"glue", (Object)"hive.metastore.glue.default-warehouse-dir", (Object)this.dataDirectory.toString(), (Object)"fs.hadoop.enabled", (Object)"true"));
        queryRunner.createCatalog("iceberg_with_redirections", "iceberg", (Map)ImmutableMap.of((Object)"iceberg.catalog.type", (Object)"glue", (Object)"hive.metastore.glue.default-warehouse-dir", (Object)this.dataDirectory.toString(), (Object)"iceberg.hive-catalog-name", (Object)HIVE_CATALOG, (Object)"fs.hadoop.enabled", (Object)"true"));
        TestSharedGlueMetastore testSharedGlueMetastore = this;
        this.glueMetastore = TestingGlueHiveMetastore.createTestingGlueHiveMetastore((Path)this.dataDirectory, x$0 -> testSharedGlueMetastore.closeAfterClass((AutoCloseable)x$0));
        queryRunner.installPlugin((Plugin)new TestingHivePlugin(queryRunner.getCoordinator().getBaseDataDir().resolve("hive_data"), (HiveMetastore)this.glueMetastore));
        queryRunner.createCatalog(HIVE_CATALOG, HIVE_CATALOG, (Map)ImmutableMap.of((Object)"fs.hadoop.enabled", (Object)"true"));
        queryRunner.createCatalog("hive_with_redirections", HIVE_CATALOG, (Map)ImmutableMap.of((Object)"hive.iceberg-catalog-name", (Object)"iceberg", (Object)"fs.hadoop.enabled", (Object)"true"));
        queryRunner.execute("CREATE SCHEMA " + this.tpchSchema + " WITH (location = '" + String.valueOf(this.dataDirectory.toUri()) + "')");
        QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", (Session)icebergSession, (Iterable)ImmutableList.of((Object)TpchTable.NATION));
        QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", (Session)hiveSession, (Iterable)ImmutableList.of((Object)TpchTable.REGION));
        queryRunner.execute("CREATE SCHEMA " + this.testSchema + " WITH (location = '" + String.valueOf(this.dataDirectory.toUri()) + "')");
        return queryRunner;
    }

    @AfterAll
    public void cleanup() {
        try {
            if (this.glueMetastore != null) {
                this.glueMetastore.dropDatabase(this.tpchSchema, false);
                this.glueMetastore.dropDatabase(this.testSchema, false);
                this.glueMetastore.shutdown();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Failed to clean up Glue database: %s or %s", new Object[]{this.tpchSchema, this.testSchema});
        }
    }

    @Override
    protected String getExpectedHiveCreateSchema(String catalogName) {
        String expectedHiveCreateSchema = "CREATE SCHEMA %s.%s\nWITH (\n   location = '%s'\n)";
        return String.format(expectedHiveCreateSchema, catalogName, this.tpchSchema, this.dataDirectory.toUri());
    }

    @Override
    protected String getExpectedIcebergCreateSchema(String catalogName) {
        String expectedIcebergCreateSchema = "CREATE SCHEMA %s.%s\nWITH (\n   location = '%s'\n)";
        return String.format(expectedIcebergCreateSchema, catalogName, this.tpchSchema, this.dataDirectory.toUri());
    }
}

